/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.LayoutRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.common.R;
import com.facebook.login.LoginClient;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0014J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H\u0002J\"\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J&\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010-\u001a\u00020\u001bH\u0016J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u001bH\u0016J\b\u00102\u001a\u00020\u001bH\u0016J\u0010\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020'H\u0016J\b\u00105\u001a\u00020\u001bH\u0014J\b\u00106\u001a\u00020\u001bH\u0014J\b\u00107\u001a\u00020\u001bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/facebook/login/LoginFragment;", "Landroidx/fragment/app/Fragment;", "()V", "callingPackage", "", "<set-?>", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "launcher", "getLauncher", "()Landroidx/activity/result/ActivityResultLauncher;", "layoutResId", "", "getLayoutResId", "()I", "Lcom/facebook/login/LoginClient;", "loginClient", "getLoginClient", "()Lcom/facebook/login/LoginClient;", "progressBar", "Landroid/view/View;", "request", "Lcom/facebook/login/LoginClient$Request;", "createLoginClient", "getLoginMethodHandlerCallback", "Lkotlin/Function1;", "Landroidx/activity/result/ActivityResult;", "", "activity", "Landroidx/fragment/app/FragmentActivity;", "hideSpinner", "initializeCallingPackage", "Landroid/app/Activity;", "onActivityResult", "requestCode", "resultCode", "data", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroy", "onLoginClientCompleted", "outcome", "Lcom/facebook/login/LoginClient$Result;", "onPause", "onResume", "onSaveInstanceState", "outState", "onSpinnerHidden", "onSpinnerShown", "showSpinner", "Companion", "facebook-common_release"})
public class LoginFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String callingPackage;
    @Nullable
    private LoginClient.Request request;
    private LoginClient loginClient;
    private ActivityResultLauncher<Intent> launcher;
    private View progressBar;
    @NotNull
    public static final String RESULT_KEY = "com.facebook.LoginFragment:Result";
    @NotNull
    public static final String REQUEST_KEY = "com.facebook.LoginFragment:Request";
    @NotNull
    public static final String EXTRA_REQUEST = "request";
    @NotNull
    private static final String TAG = "LoginFragment";
    @NotNull
    private static final String NULL_CALLING_PKG_ERROR_MSG = "Cannot call LoginFragment with a null calling package. This can occur if the launchMode of the caller is singleInstance.";
    @NotNull
    private static final String SAVED_LOGIN_CLIENT = "loginClient";

    @NotNull
    public final LoginClient getLoginClient() {
        LoginClient loginClient = this.loginClient;
        if (loginClient != null) {
            return loginClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)SAVED_LOGIN_CLIENT);
        throw null;
    }

    @NotNull
    public final ActivityResultLauncher<Intent> getLauncher() {
        ActivityResultLauncher<Intent> activityResultLauncher = this.launcher;
        if (activityResultLauncher != null) {
            return activityResultLauncher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"launcher");
        throw null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        Bundle bundle;
        FragmentActivity fragmentActivity;
        LoginClient loginClient;
        LoginClient restoredLoginClient;
        super.onCreate(savedInstanceState);
        Bundle bundle2 = savedInstanceState;
        LoginClient loginClient2 = restoredLoginClient = bundle2 == null ? null : (LoginClient)bundle2.getParcelable(SAVED_LOGIN_CLIENT);
        if (restoredLoginClient != null) {
            restoredLoginClient.setFragment(this);
            loginClient = restoredLoginClient;
        } else {
            loginClient = this.createLoginClient();
        }
        this.loginClient = loginClient;
        this.getLoginClient().setOnCompletedListener(arg_0 -> LoginFragment.onCreate$lambda-0(this, arg_0));
        FragmentActivity fragmentActivity2 = this.getActivity();
        if (fragmentActivity2 == null) {
            return;
        }
        FragmentActivity activity = fragmentActivity = fragmentActivity2;
        this.initializeCallingPackage((Activity)activity);
        Intent intent = activity.getIntent();
        if (intent != null && (bundle = intent.getBundleExtra(REQUEST_KEY)) != null) {
            this.request = (LoginClient.Request)bundle.getParcelable(EXTRA_REQUEST);
        }
        Function1<ActivityResult, Unit> function1 = this.getLoginMethodHandlerCallback(activity);
        fragmentActivity2 = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> LoginFragment.onCreate$lambda-1(function1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity2, (String)"registerForActivityResult(\n            ActivityResultContracts.StartActivityForResult(),\n            getLoginMethodHandlerCallback(activity))");
        this.launcher = fragmentActivity2;
    }

    private final Function1<ActivityResult, Unit> getLoginMethodHandlerCallback(FragmentActivity activity) {
        return (Function1)new Function1<ActivityResult, Unit>(this, activity){
            final /* synthetic */ LoginFragment this$0;
            final /* synthetic */ FragmentActivity $activity;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
                super(1);
            }

            public final void invoke(@NotNull ActivityResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (result.getResultCode() == -1) {
                    this.this$0.getLoginClient().onActivityResult(LoginClient.Companion.getLoginRequestCode(), result.getResultCode(), result.getData());
                } else {
                    this.$activity.finish();
                }
            }
        };
    }

    @NotNull
    protected LoginClient createLoginClient() {
        return new LoginClient(this);
    }

    public void onDestroy() {
        this.getLoginClient().cancelCurrentHandler();
        super.onDestroy();
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        View view = inflater.inflate(this.getLayoutResId(), container, false);
        View view2 = view.findViewById(R.id.com_facebook_login_fragment_progress_bar);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById<View>(R.id.com_facebook_login_fragment_progress_bar)");
        this.progressBar = view2;
        this.getLoginClient().setBackgroundProcessingListener(new LoginClient.BackgroundProcessingListener(this){
            final /* synthetic */ LoginFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBackgroundProcessingStarted() {
                LoginFragment.access$showSpinner(this.this$0);
            }

            public void onBackgroundProcessingStopped() {
                LoginFragment.access$hideSpinner(this.this$0);
            }
        });
        return view;
    }

    @LayoutRes
    protected int getLayoutResId() {
        return R.layout.com_facebook_login_fragment;
    }

    private final void onLoginClientCompleted(LoginClient.Result outcome) {
        this.request = null;
        int resultCode = outcome.code == LoginClient.Result.Code.CANCEL ? 0 : -1;
        Bundle bundle = new Bundle();
        bundle.putParcelable(RESULT_KEY, (Parcelable)outcome);
        Intent resultIntent = new Intent();
        resultIntent.putExtras(bundle);
        FragmentActivity hostActivity = this.getActivity();
        if (this.isAdded() && hostActivity != null) {
            hostActivity.setResult(resultCode, resultIntent);
            hostActivity.finish();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.callingPackage == null) {
            Log.e((String)TAG, (String)NULL_CALLING_PKG_ERROR_MSG);
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity != null) {
                fragmentActivity.finish();
            }
            return;
        }
        this.getLoginClient().startOrContinueAuth(this.request);
    }

    public void onPause() {
        View progressBar;
        super.onPause();
        View view = this.getView();
        View view2 = progressBar = view == null ? null : view.findViewById(R.id.com_facebook_login_fragment_progress_bar);
        if (progressBar != null) {
            progressBar.setVisibility(8);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.getLoginClient().onActivityResult(requestCode, resultCode, data);
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putParcelable(SAVED_LOGIN_CLIENT, (Parcelable)this.getLoginClient());
    }

    private final void showSpinner() {
        View view = this.progressBar;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            throw null;
        }
        view.setVisibility(0);
        this.onSpinnerShown();
    }

    private final void hideSpinner() {
        View view = this.progressBar;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            throw null;
        }
        view.setVisibility(8);
        this.onSpinnerHidden();
    }

    protected void onSpinnerShown() {
    }

    protected void onSpinnerHidden() {
    }

    private final void initializeCallingPackage(Activity activity) {
        ComponentName componentName;
        ComponentName componentName2 = activity.getCallingActivity();
        if (componentName2 == null) {
            return;
        }
        ComponentName componentName3 = componentName = componentName2;
        this.callingPackage = componentName3.getPackageName();
    }

    private static final void onCreate$lambda-0(LoginFragment this$0, LoginClient.Result outcome) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        this$0.onLoginClientCompleted(outcome);
    }

    private static final void onCreate$lambda-1(Function1 $tmp0, ActivityResult p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ void access$showSpinner(LoginFragment $this) {
        $this.showSpinner();
    }

    public static final /* synthetic */ void access$hideSpinner(LoginFragment $this) {
        $this.hideSpinner();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/login/LoginFragment$Companion;", "", "()V", "EXTRA_REQUEST", "", "NULL_CALLING_PKG_ERROR_MSG", "REQUEST_KEY", "RESULT_KEY", "SAVED_LOGIN_CLIENT", "TAG", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

