/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.facebook.internal.Utility;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;
import java.util.Set;

public class CameraEffectTextures
implements ShareModel {
    private final Bundle textures;
    public static final Parcelable.Creator<CameraEffectTextures> CREATOR = new Parcelable.Creator<CameraEffectTextures>(){

        public CameraEffectTextures createFromParcel(Parcel in) {
            return new CameraEffectTextures(in);
        }

        public CameraEffectTextures[] newArray(int size) {
            return new CameraEffectTextures[size];
        }
    };

    private CameraEffectTextures(Builder builder) {
        this.textures = builder.textures;
    }

    CameraEffectTextures(Parcel in) {
        this.textures = in.readBundle(this.getClass().getClassLoader());
    }

    @Nullable
    public Bitmap getTextureBitmap(String key) {
        Object value = this.textures.get(key);
        if (value instanceof Bitmap) {
            return (Bitmap)value;
        }
        return null;
    }

    @Nullable
    public Uri getTextureUri(String key) {
        Object value = this.textures.get(key);
        if (value instanceof Uri) {
            return (Uri)value;
        }
        return null;
    }

    @Nullable
    public Object get(String key) {
        return this.textures.get(key);
    }

    public Set<String> keySet() {
        return this.textures.keySet();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeBundle(this.textures);
    }

    public static class Builder
    implements ShareModelBuilder<CameraEffectTextures, Builder> {
        private Bundle textures = new Bundle();

        public Builder putTexture(String key, Bitmap texture) {
            return this.putParcelableTexture(key, (Parcelable)texture);
        }

        public Builder putTexture(String key, Uri textureUrl) {
            return this.putParcelableTexture(key, (Parcelable)textureUrl);
        }

        private Builder putParcelableTexture(String key, Parcelable parcelableTexture) {
            if (!Utility.isNullOrEmpty((String)key) && parcelableTexture != null) {
                this.textures.putParcelable(key, parcelableTexture);
            }
            return this;
        }

        @Override
        public Builder readFrom(CameraEffectTextures model) {
            if (model != null) {
                this.textures.putAll(model.textures);
            }
            return this;
        }

        @Override
        public Builder readFrom(Parcel parcel) {
            return this.readFrom((CameraEffectTextures)parcel.readParcelable(CameraEffectTextures.class.getClassLoader()));
        }

        @Override
        public CameraEffectTextures build() {
            return new CameraEffectTextures(this);
        }
    }
}

