/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.internal.FacebookWebFallbackDialog;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;

public class FacebookDialogFragment
extends DialogFragment {
    private Dialog dialog;
    public static final String TAG = "FacebookDialogFragment";

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.dialog == null) {
            WebDialog webDialog;
            FragmentActivity activity = this.getActivity();
            Intent intent = activity.getIntent();
            Bundle params = NativeProtocol.getMethodArgumentsFromIntent((Intent)intent);
            boolean isWebFallback = params.getBoolean("is_fallback", false);
            if (!isWebFallback) {
                String actionName = params.getString("action");
                Bundle webParams = params.getBundle("params");
                if (Utility.isNullOrEmpty((String)actionName)) {
                    Utility.logd((String)TAG, (String)"Cannot start a WebDialog with an empty/missing 'actionName'");
                    activity.finish();
                    return;
                }
                webDialog = new WebDialog.Builder((Context)activity, actionName, webParams).setOnCompleteListener(new WebDialog.OnCompleteListener(){

                    @Override
                    public void onComplete(Bundle values, FacebookException error) {
                        FacebookDialogFragment.this.onCompleteWebDialog(values, error);
                    }
                }).build();
            } else {
                String url = params.getString("url");
                if (Utility.isNullOrEmpty((String)url)) {
                    Utility.logd((String)TAG, (String)"Cannot start a fallback WebDialog with an empty/missing 'url'");
                    activity.finish();
                    return;
                }
                String redirectUrl = String.format("fb%s://bridge/", FacebookSdk.getApplicationId());
                webDialog = FacebookWebFallbackDialog.newInstance((Context)activity, url, redirectUrl);
                webDialog.setOnCompleteListener(new WebDialog.OnCompleteListener(){

                    @Override
                    public void onComplete(Bundle values, FacebookException error) {
                        FacebookDialogFragment.this.onCompleteWebFallbackDialog(values);
                    }
                });
            }
            this.dialog = webDialog;
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (this.dialog == null) {
            this.onCompleteWebDialog(null, null);
            this.setShowsDialog(false);
        }
        return this.dialog;
    }

    public void onResume() {
        super.onResume();
        if (this.dialog instanceof WebDialog) {
            ((WebDialog)this.dialog).resize();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.dialog instanceof WebDialog && this.isResumed()) {
            ((WebDialog)this.dialog).resize();
        }
    }

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    private void onCompleteWebDialog(Bundle values, FacebookException error) {
        FragmentActivity fragmentActivity = this.getActivity();
        Intent resultIntent = NativeProtocol.createProtocolResultIntent((Intent)fragmentActivity.getIntent(), (Bundle)values, (FacebookException)error);
        int resultCode = error == null ? -1 : 0;
        fragmentActivity.setResult(resultCode, resultIntent);
        fragmentActivity.finish();
    }

    private void onCompleteWebFallbackDialog(Bundle values) {
        FragmentActivity fragmentActivity = this.getActivity();
        Intent resultIntent = new Intent();
        resultIntent.putExtras(values == null ? new Bundle() : values);
        fragmentActivity.setResult(-1, resultIntent);
        fragmentActivity.finish();
    }
}

