/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.applinks;

import android.net.Uri;
import android.os.Bundle;
import bolts.AppLink;
import bolts.AppLinkResolver;
import bolts.Continuation;
import bolts.Task;
import com.facebook.AccessToken;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookAppLinkResolver
implements AppLinkResolver {
    private static final String APP_LINK_KEY = "app_links";
    private static final String APP_LINK_ANDROID_TARGET_KEY = "android";
    private static final String APP_LINK_WEB_TARGET_KEY = "web";
    private static final String APP_LINK_TARGET_PACKAGE_KEY = "package";
    private static final String APP_LINK_TARGET_CLASS_KEY = "class";
    private static final String APP_LINK_TARGET_APP_NAME_KEY = "app_name";
    private static final String APP_LINK_TARGET_URL_KEY = "url";
    private static final String APP_LINK_TARGET_SHOULD_FALLBACK_KEY = "should_fallback";
    private final HashMap<Uri, AppLink> cachedAppLinks = new HashMap();

    /*
     * WARNING - void declaration
     */
    public Task<AppLink> getAppLinkFromUrlInBackground(Uri uri) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            void uri2;
            ArrayList<Uri> uris = new ArrayList<Uri>();
            uris.add((Uri)uri2);
            Task<Map<Uri, AppLink>> resolveTask = this.getAppLinkFromUrlsInBackground(uris);
            return resolveTask.onSuccess((Continuation)new Continuation<Map<Uri, AppLink>, AppLink>((Uri)uri2){
                final /* synthetic */ Uri val$uri;
                {
                    this.val$uri = uri;
                }

                public AppLink then(Task<Map<Uri, AppLink>> resolveUrisTask) throws Exception {
                    return (AppLink)((Map)resolveUrisTask.getResult()).get(this.val$uri);
                }
            });
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Task<Map<Uri, AppLink>> getAppLinkFromUrlsInBackground(List<Uri> list) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            void uris;
            final HashMap<Uri, AppLink> appLinkResults = new HashMap<Uri, AppLink>();
            final HashSet<Uri> urisToRequest = new HashSet<Uri>();
            StringBuilder graphRequestFields = new StringBuilder();
            for (Uri uri : uris) {
                AppLink appLink;
                HashMap<Uri, AppLink> hashMap = this.cachedAppLinks;
                synchronized (hashMap) {
                    appLink = this.cachedAppLinks.get(uri);
                }
                if (appLink != null) {
                    appLinkResults.put(uri, appLink);
                    continue;
                }
                if (!urisToRequest.isEmpty()) {
                    graphRequestFields.append(',');
                }
                graphRequestFields.append(uri.toString());
                urisToRequest.add(uri);
            }
            if (urisToRequest.isEmpty()) {
                return Task.forResult(appLinkResults);
            }
            final Task.TaskCompletionSource taskCompletionSource = Task.create();
            Bundle appLinkRequestParameters = new Bundle();
            appLinkRequestParameters.putString("ids", graphRequestFields.toString());
            appLinkRequestParameters.putString("fields", String.format("%s.fields(%s,%s)", APP_LINK_KEY, APP_LINK_ANDROID_TARGET_KEY, APP_LINK_WEB_TARGET_KEY));
            GraphRequest appLinkRequest = new GraphRequest(AccessToken.getCurrentAccessToken(), "", appLinkRequestParameters, null, new GraphRequest.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void onCompleted(GraphResponse graphResponse) {
                    if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                        return;
                    }
                    try {
                        void response;
                        FacebookRequestError error = response.getError();
                        if (error != null) {
                            taskCompletionSource.setError((Exception)((Object)error.getException()));
                            return;
                        }
                        JSONObject responseJson = response.getJSONObject();
                        if (responseJson == null) {
                            taskCompletionSource.setResult((Object)appLinkResults);
                            return;
                        }
                        for (Uri uri : urisToRequest) {
                            String uriString = uri.toString();
                            if (!responseJson.has(uriString)) continue;
                            try {
                                JSONObject urlData = responseJson.getJSONObject(uri.toString());
                                JSONObject appLinkData = urlData.getJSONObject(FacebookAppLinkResolver.APP_LINK_KEY);
                                JSONArray rawTargets = appLinkData.getJSONArray(FacebookAppLinkResolver.APP_LINK_ANDROID_TARGET_KEY);
                                int targetsCount = rawTargets.length();
                                ArrayList<AppLink.Target> targets = new ArrayList<AppLink.Target>(targetsCount);
                                for (int i = 0; i < targetsCount; ++i) {
                                    AppLink.Target target = FacebookAppLinkResolver.access$000(rawTargets.getJSONObject(i));
                                    if (target == null) continue;
                                    targets.add(target);
                                }
                                Uri webFallbackUrl = FacebookAppLinkResolver.access$100(uri, appLinkData);
                                AppLink appLink = new AppLink(uri, targets, webFallbackUrl);
                                appLinkResults.put(uri, appLink);
                                HashMap hashMap = FacebookAppLinkResolver.access$200(FacebookAppLinkResolver.this);
                                synchronized (hashMap) {
                                    FacebookAppLinkResolver.access$200(FacebookAppLinkResolver.this).put(uri, appLink);
                                }
                            }
                            catch (JSONException e) {
                            }
                        }
                        taskCompletionSource.setResult((Object)appLinkResults);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                        return;
                    }
                }
            });
            appLinkRequest.executeAsync();
            return taskCompletionSource.getTask();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    private static AppLink.Target getAndroidTargetFromJson(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return null;
        }
        try {
            JSONObject targetJson;
            String packageName = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_PACKAGE_KEY, null);
            if (packageName == null) {
                return null;
            }
            String className = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_CLASS_KEY, null);
            String appName = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_APP_NAME_KEY, null);
            String targetUrlString = FacebookAppLinkResolver.tryGetStringFromJson(targetJson, APP_LINK_TARGET_URL_KEY, null);
            Uri targetUri = null;
            if (targetUrlString != null) {
                targetUri = Uri.parse((String)targetUrlString);
            }
            return new AppLink.Target(packageName, className, targetUri, appName);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Uri getWebFallbackUriFromJson(Uri uri, JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return null;
        }
        try {
            Uri sourceUrl;
            try {
                void urlData;
                JSONObject webTarget = urlData.getJSONObject(APP_LINK_WEB_TARGET_KEY);
                boolean shouldFallback = FacebookAppLinkResolver.tryGetBooleanFromJson(webTarget, APP_LINK_TARGET_SHOULD_FALLBACK_KEY, true);
                if (!shouldFallback) {
                    return null;
                }
                String webTargetUrlString = FacebookAppLinkResolver.tryGetStringFromJson(webTarget, APP_LINK_TARGET_URL_KEY, null);
                Uri webUri = null;
                if (webTargetUrlString != null) {
                    webUri = Uri.parse((String)webTargetUrlString);
                }
                return webUri != null ? webUri : sourceUrl;
            }
            catch (JSONException e) {
                return sourceUrl;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String tryGetStringFromJson(JSONObject jSONObject, String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return null;
        }
        try {
            try {
                void propertyName;
                JSONObject json;
                return json.getString((String)propertyName);
            }
            catch (JSONException e) {
                void defaultValue;
                return defaultValue;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean tryGetBooleanFromJson(JSONObject jSONObject, String string, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return false;
        }
        try {
            try {
                void propertyName;
                JSONObject json;
                return json.getBoolean((String)propertyName);
            }
            catch (JSONException e) {
                void defaultValue;
                return (boolean)defaultValue;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return false;
        }
    }

    static /* synthetic */ AppLink.Target access$000(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return null;
        }
        try {
            JSONObject x0;
            return FacebookAppLinkResolver.getAndroidTargetFromJson(x0);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Uri access$100(Uri uri, JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return null;
        }
        try {
            void x1;
            Uri x0;
            return FacebookAppLinkResolver.getWebFallbackUriFromJson(x0, (JSONObject)x1);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return null;
        }
    }

    static /* synthetic */ HashMap access$200(FacebookAppLinkResolver facebookAppLinkResolver) {
        if (CrashShieldHandler.isObjectCrashing(FacebookAppLinkResolver.class)) {
            return null;
        }
        try {
            FacebookAppLinkResolver x0;
            return x0.cachedAppLinks;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, FacebookAppLinkResolver.class);
            return null;
        }
    }
}

