/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import bolts.AppLinks;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.FacebookTimeSpentData;
import com.facebook.internal.AppEventsLoggerUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppEventsLogger {
    private static final String TAG = AppEventsLogger.class.getCanonicalName();
    private static final int NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 100;
    private static final int FLUSH_PERIOD_IN_SECONDS = 15;
    private static final int APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS = 86400;
    private static final int FLUSH_APP_SESSION_INFO_IN_SECONDS = 30;
    public static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    private static final String SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT = "_fbSourceApplicationHasBeenSet";
    private final String contextName;
    private final AccessTokenAppIdPair accessTokenAppId;
    private static Map<AccessTokenAppIdPair, SessionEventsState> stateMap = new ConcurrentHashMap<AccessTokenAppIdPair, SessionEventsState>();
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    private static FlushBehavior flushBehavior;
    private static boolean requestInFlight;
    private static Context applicationContext;
    private static Object staticLock;
    private static String anonymousAppDeviceGUID;
    private static String sourceApplication;
    private static boolean isOpenedByApplink;
    public static final String ACTION_APP_EVENTS_FLUSHED = "com.facebook.sdk.APP_EVENTS_FLUSHED";
    public static final String APP_EVENTS_EXTRA_NUM_EVENTS_FLUSHED = "com.facebook.sdk.APP_EVENTS_NUM_EVENTS_FLUSHED";
    public static final String APP_EVENTS_EXTRA_FLUSH_RESULT = "com.facebook.sdk.APP_EVENTS_FLUSH_RESULT";

    public static void activateApp(Context context) {
        FacebookSdk.sdkInitialize(context);
        AppEventsLogger.activateApp(context, Utility.getMetadataApplicationId(context));
    }

    public static void activateApp(Context context, String applicationId) {
        if (context == null || applicationId == null) {
            throw new IllegalArgumentException("Both context and applicationId must be non-null");
        }
        if (context instanceof Activity) {
            AppEventsLogger.setSourceApplication((Activity)context);
        } else {
            AppEventsLogger.resetSourceApplication();
            Log.d((String)AppEventsLogger.class.getName(), (String)"To set source application the context of activateApp must be an instance of Activity");
        }
        FacebookSdk.publishInstallAsync(context, applicationId);
        final AppEventsLogger logger = new AppEventsLogger(context, applicationId, null);
        final long eventTime = System.currentTimeMillis();
        final String sourceApplicationInfo = AppEventsLogger.getSourceApplication();
        backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                logger.logAppSessionResumeEvent(eventTime, sourceApplicationInfo);
            }
        });
    }

    public static void deactivateApp(Context context) {
        AppEventsLogger.deactivateApp(context, Utility.getMetadataApplicationId(context));
    }

    public static void deactivateApp(Context context, String applicationId) {
        if (context == null || applicationId == null) {
            throw new IllegalArgumentException("Both context and applicationId must be non-null");
        }
        AppEventsLogger.resetSourceApplication();
        final AppEventsLogger logger = new AppEventsLogger(context, applicationId, null);
        final long eventTime = System.currentTimeMillis();
        backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                logger.logAppSessionSuspendEvent(eventTime);
            }
        });
    }

    private void logAppSessionResumeEvent(long eventTime, String sourceApplicationInfo) {
        PersistedAppSessionInfo.onResume(applicationContext, this.accessTokenAppId, this, eventTime, sourceApplicationInfo);
    }

    private void logAppSessionSuspendEvent(long eventTime) {
        PersistedAppSessionInfo.onSuspend(applicationContext, this.accessTokenAppId, this, eventTime);
    }

    public static AppEventsLogger newLogger(Context context) {
        return new AppEventsLogger(context, null, null);
    }

    public static AppEventsLogger newLogger(Context context, AccessToken accessToken) {
        return new AppEventsLogger(context, null, accessToken);
    }

    public static AppEventsLogger newLogger(Context context, String applicationId, AccessToken accessToken) {
        return new AppEventsLogger(context, applicationId, accessToken);
    }

    public static AppEventsLogger newLogger(Context context, String applicationId) {
        return new AppEventsLogger(context, applicationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlushBehavior getFlushBehavior() {
        Object object = staticLock;
        synchronized (object) {
            return flushBehavior;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFlushBehavior(FlushBehavior flushBehavior) {
        Object object = staticLock;
        synchronized (object) {
            AppEventsLogger.flushBehavior = flushBehavior;
        }
    }

    public void logEvent(String eventName) {
        this.logEvent(eventName, null);
    }

    public void logEvent(String eventName, double valueToSum) {
        this.logEvent(eventName, valueToSum, null);
    }

    public void logEvent(String eventName, Bundle parameters) {
        this.logEvent(eventName, null, parameters, false);
    }

    public void logEvent(String eventName, double valueToSum, Bundle parameters) {
        this.logEvent(eventName, valueToSum, parameters, false);
    }

    public void logPurchase(BigDecimal purchaseAmount, Currency currency) {
        this.logPurchase(purchaseAmount, currency, null);
    }

    public void logPurchase(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (purchaseAmount == null) {
            AppEventsLogger.notifyDeveloperError("purchaseAmount cannot be null");
            return;
        }
        if (currency == null) {
            AppEventsLogger.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("fb_currency", currency.getCurrencyCode());
        this.logEvent("fb_mobile_purchase", purchaseAmount.doubleValue(), parameters);
        AppEventsLogger.eagerFlush();
    }

    public void flush() {
        AppEventsLogger.flush(FlushReason.EXPLICIT);
    }

    public static void onContextStop() {
        PersistedEvents.persistEvents(applicationContext, stateMap);
    }

    public boolean isValidForAccessToken(AccessToken accessToken) {
        AccessTokenAppIdPair other = new AccessTokenAppIdPair(accessToken);
        return this.accessTokenAppId.equals(other);
    }

    public void logSdkEvent(String eventName, Double valueToSum, Bundle parameters) {
        this.logEvent(eventName, valueToSum, parameters, true);
    }

    public String getApplicationId() {
        return this.accessTokenAppId.getApplicationId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppEventsLogger(Context context, String applicationId, AccessToken accessToken) {
        Validate.notNull(context, "context");
        this.contextName = Utility.getActivityName(context);
        if (accessToken == null) {
            accessToken = AccessToken.getCurrentAccessToken();
        }
        if (accessToken != null && (applicationId == null || applicationId.equals(accessToken.getApplicationId()))) {
            this.accessTokenAppId = new AccessTokenAppIdPair(accessToken);
        } else {
            if (applicationId == null) {
                applicationId = Utility.getMetadataApplicationId(context);
            }
            this.accessTokenAppId = new AccessTokenAppIdPair(null, applicationId);
        }
        Object object = staticLock;
        synchronized (object) {
            if (applicationContext == null) {
                applicationContext = context.getApplicationContext();
            }
        }
        AppEventsLogger.initializeTimersIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeTimersIfNeeded() {
        Object object = staticLock;
        synchronized (object) {
            if (backgroundExecutor != null) {
                return;
            }
            backgroundExecutor = new ScheduledThreadPoolExecutor(1);
        }
        Runnable flushRunnable = new Runnable(){

            @Override
            public void run() {
                if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY) {
                    AppEventsLogger.flushAndWait(FlushReason.TIMER);
                }
            }
        };
        backgroundExecutor.scheduleAtFixedRate(flushRunnable, 0L, 15L, TimeUnit.SECONDS);
        Runnable attributionRecheckRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet<String> applicationIds = new HashSet<String>();
                Iterator iterator = staticLock;
                synchronized (iterator) {
                    for (AccessTokenAppIdPair accessTokenAppId : stateMap.keySet()) {
                        applicationIds.add(accessTokenAppId.getApplicationId());
                    }
                }
                for (String applicationId : applicationIds) {
                    Utility.queryAppSettings(applicationId, true);
                }
            }
        };
        backgroundExecutor.scheduleAtFixedRate(attributionRecheckRunnable, 0L, 86400L, TimeUnit.SECONDS);
    }

    private void logEvent(String eventName, Double valueToSum, Bundle parameters, boolean isImplicitlyLogged) {
        AppEvent event = new AppEvent(this.contextName, eventName, valueToSum, parameters, isImplicitlyLogged);
        AppEventsLogger.logEvent(applicationContext, event, this.accessTokenAppId);
    }

    private static void logEvent(final Context context, final AppEvent event, final AccessTokenAppIdPair accessTokenAppId) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SessionEventsState state = AppEventsLogger.getSessionEventsState(context, accessTokenAppId);
                state.addEvent(event);
                AppEventsLogger.flushIfNecessary();
            }
        });
    }

    static void eagerFlush() {
        if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY) {
            AppEventsLogger.flush(FlushReason.EAGER_FLUSHING_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushIfNecessary() {
        Object object = staticLock;
        synchronized (object) {
            if (AppEventsLogger.getFlushBehavior() != FlushBehavior.EXPLICIT_ONLY && AppEventsLogger.getAccumulatedEventCount() > 100) {
                AppEventsLogger.flush(FlushReason.EVENT_THRESHOLD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAccumulatedEventCount() {
        Object object = staticLock;
        synchronized (object) {
            int result = 0;
            for (SessionEventsState state : stateMap.values()) {
                result += state.getAccumulatedEventCount();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionEventsState getSessionEventsState(Context context, AccessTokenAppIdPair accessTokenAppId) {
        SessionEventsState state = stateMap.get(accessTokenAppId);
        AttributionIdentifiers attributionIdentifiers = null;
        if (state == null) {
            attributionIdentifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
        }
        Object object = staticLock;
        synchronized (object) {
            state = stateMap.get(accessTokenAppId);
            if (state == null) {
                state = new SessionEventsState(attributionIdentifiers, context.getPackageName(), AppEventsLogger.getAnonymousAppDeviceGUID(context));
                stateMap.put(accessTokenAppId, state);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionEventsState getSessionEventsState(AccessTokenAppIdPair accessTokenAppId) {
        Object object = staticLock;
        synchronized (object) {
            return stateMap.get(accessTokenAppId);
        }
    }

    private static void flush(final FlushReason reason) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AppEventsLogger.flushAndWait(reason);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushAndWait(FlushReason reason) {
        HashSet<AccessTokenAppIdPair> keysToFlush;
        Object object = staticLock;
        synchronized (object) {
            if (requestInFlight) {
                return;
            }
            requestInFlight = true;
            keysToFlush = new HashSet<AccessTokenAppIdPair>(stateMap.keySet());
        }
        AppEventsLogger.accumulatePersistedEvents();
        FlushStatistics flushResults = null;
        try {
            flushResults = AppEventsLogger.buildAndExecuteRequests(reason, keysToFlush);
        }
        catch (Exception e) {
            Utility.logd(TAG, "Caught unexpected exception while flushing: ", e);
        }
        Object e = staticLock;
        synchronized (e) {
            requestInFlight = false;
        }
        if (flushResults != null) {
            Intent intent = new Intent(ACTION_APP_EVENTS_FLUSHED);
            intent.putExtra(APP_EVENTS_EXTRA_NUM_EVENTS_FLUSHED, flushResults.numEvents);
            intent.putExtra(APP_EVENTS_EXTRA_FLUSH_RESULT, (Serializable)((Object)flushResults.result));
            LocalBroadcastManager.getInstance((Context)applicationContext).sendBroadcast(intent);
        }
    }

    private static FlushStatistics buildAndExecuteRequests(FlushReason reason, Set<AccessTokenAppIdPair> keysToFlush) {
        FlushStatistics flushResults = new FlushStatistics();
        boolean limitEventUsage = FacebookSdk.getLimitEventAndDataUsage(applicationContext);
        ArrayList<GraphRequest> requestsToExecute = new ArrayList<GraphRequest>();
        for (AccessTokenAppIdPair accessTokenAppId : keysToFlush) {
            GraphRequest request;
            SessionEventsState sessionEventsState = AppEventsLogger.getSessionEventsState(accessTokenAppId);
            if (sessionEventsState == null || (request = AppEventsLogger.buildRequestForSession(accessTokenAppId, sessionEventsState, limitEventUsage, flushResults)) == null) continue;
            requestsToExecute.add(request);
        }
        if (requestsToExecute.size() > 0) {
            Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Flushing %d events due to %s.", flushResults.numEvents, reason.toString());
            for (GraphRequest request : requestsToExecute) {
                request.executeAndWait();
            }
            return flushResults;
        }
        return null;
    }

    private static GraphRequest buildRequestForSession(final AccessTokenAppIdPair accessTokenAppId, final SessionEventsState sessionEventsState, boolean limitEventUsage, final FlushStatistics flushState) {
        String applicationId = accessTokenAppId.getApplicationId();
        Utility.FetchedAppSettings fetchedAppSettings = Utility.queryAppSettings(applicationId, false);
        final GraphRequest postRequest = GraphRequest.newPostRequest(null, String.format("%s/activities", applicationId), null, null);
        Bundle requestParameters = postRequest.getParameters();
        if (requestParameters == null) {
            requestParameters = new Bundle();
        }
        requestParameters.putString("access_token", accessTokenAppId.getAccessTokenString());
        postRequest.setParameters(requestParameters);
        if (fetchedAppSettings == null) {
            return null;
        }
        int numEvents = sessionEventsState.populateRequest(postRequest, fetchedAppSettings.supportsImplicitLogging(), limitEventUsage);
        if (numEvents == 0) {
            return null;
        }
        flushState.numEvents += numEvents;
        postRequest.setCallback(new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                AppEventsLogger.handleResponse(accessTokenAppId, postRequest, response, sessionEventsState, flushState);
            }
        });
        return postRequest;
    }

    private static void handleResponse(AccessTokenAppIdPair accessTokenAppId, GraphRequest request, GraphResponse response, SessionEventsState sessionEventsState, FlushStatistics flushState) {
        FacebookRequestError error = response.getError();
        String resultDescription = "Success";
        FlushResult flushResult = FlushResult.SUCCESS;
        if (error != null) {
            int NO_CONNECTIVITY_ERROR_CODE = -1;
            if (error.getErrorCode() == -1) {
                resultDescription = "Failed: No Connectivity";
                flushResult = FlushResult.NO_CONNECTIVITY;
            } else {
                resultDescription = String.format("Failed:\n  Response: %s\n  Error %s", response.toString(), error.toString());
                flushResult = FlushResult.SERVER_ERROR;
            }
        }
        if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.APP_EVENTS)) {
            String prettyPrintedEvents;
            String eventsJsonString = (String)request.getTag();
            try {
                JSONArray jsonArray = new JSONArray(eventsJsonString);
                prettyPrintedEvents = jsonArray.toString(2);
            }
            catch (JSONException exc) {
                prettyPrintedEvents = "<Can't encode events for debug logging>";
            }
            Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Flush completed\nParams: %s\n  Result: %s\n  Events JSON: %s", request.getGraphObject().toString(), resultDescription, prettyPrintedEvents);
        }
        sessionEventsState.clearInFlightAndStats(error != null);
        if (flushResult == FlushResult.NO_CONNECTIVITY) {
            PersistedEvents.persistEvents(applicationContext, accessTokenAppId, sessionEventsState);
        }
        if (flushResult != FlushResult.SUCCESS && flushState.result != FlushResult.NO_CONNECTIVITY) {
            flushState.result = flushResult;
        }
    }

    private static int accumulatePersistedEvents() {
        PersistedEvents persistedEvents = PersistedEvents.readAndClearStore(applicationContext);
        int result = 0;
        for (AccessTokenAppIdPair accessTokenAppId : persistedEvents.keySet()) {
            SessionEventsState sessionEventsState = AppEventsLogger.getSessionEventsState(applicationContext, accessTokenAppId);
            List<AppEvent> events = persistedEvents.getEvents(accessTokenAppId);
            sessionEventsState.accumulatePersistedEvents(events);
            result += events.size();
        }
        return result;
    }

    private static void notifyDeveloperError(String message) {
        Logger.log(LoggingBehavior.DEVELOPER_ERRORS, "AppEvents", message);
    }

    private static void setSourceApplication(Activity activity) {
        String applinkReferrerPackage;
        Intent openIntent;
        ComponentName callingApplication = activity.getCallingActivity();
        if (callingApplication != null) {
            String callingApplicationPackage = callingApplication.getPackageName();
            if (callingApplicationPackage.equals(activity.getPackageName())) {
                AppEventsLogger.resetSourceApplication();
                return;
            }
            sourceApplication = callingApplicationPackage;
        }
        if ((openIntent = activity.getIntent()) == null || openIntent.getBooleanExtra(SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, false)) {
            AppEventsLogger.resetSourceApplication();
            return;
        }
        Bundle applinkData = AppLinks.getAppLinkData((Intent)openIntent);
        if (applinkData == null) {
            AppEventsLogger.resetSourceApplication();
            return;
        }
        isOpenedByApplink = true;
        Bundle applinkReferrerData = applinkData.getBundle("referer_app_link");
        if (applinkReferrerData == null) {
            sourceApplication = null;
            return;
        }
        sourceApplication = applinkReferrerPackage = applinkReferrerData.getString("package");
        openIntent.putExtra(SOURCE_APPLICATION_HAS_BEEN_SET_BY_THIS_INTENT, true);
    }

    static void setSourceApplication(String applicationPackage, boolean openByAppLink) {
        sourceApplication = applicationPackage;
        isOpenedByApplink = openByAppLink;
    }

    static String getSourceApplication() {
        String openType = "Unclassified";
        if (isOpenedByApplink) {
            openType = "Applink";
        }
        if (sourceApplication != null) {
            return openType + "(" + sourceApplication + ")";
        }
        return openType;
    }

    static void resetSourceApplication() {
        sourceApplication = null;
        isOpenedByApplink = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAnonymousAppDeviceGUID(Context context) {
        if (anonymousAppDeviceGUID == null) {
            Object object = staticLock;
            synchronized (object) {
                SharedPreferences preferences;
                if (anonymousAppDeviceGUID == null && (anonymousAppDeviceGUID = (preferences = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0)).getString("anonymousAppDeviceGUID", null)) == null) {
                    anonymousAppDeviceGUID = "XZ" + UUID.randomUUID().toString();
                    context.getSharedPreferences(APP_EVENT_PREFERENCES, 0).edit().putString("anonymousAppDeviceGUID", anonymousAppDeviceGUID).apply();
                }
            }
        }
        return anonymousAppDeviceGUID;
    }

    static {
        flushBehavior = FlushBehavior.AUTO;
        staticLock = new Object();
    }

    static class PersistedEvents {
        static final String PERSISTED_EVENTS_FILENAME = "AppEventsLogger.persistedevents";
        private static Object staticLock = new Object();
        private Context context;
        private HashMap<AccessTokenAppIdPair, List<AppEvent>> persistedEvents = new HashMap();

        private PersistedEvents(Context context) {
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PersistedEvents readAndClearStore(Context context) {
            Object object = staticLock;
            synchronized (object) {
                PersistedEvents persistedEvents = new PersistedEvents(context);
                persistedEvents.readAndClearStore();
                return persistedEvents;
            }
        }

        public static void persistEvents(Context context, AccessTokenAppIdPair accessTokenAppId, SessionEventsState eventsToPersist) {
            HashMap<AccessTokenAppIdPair, SessionEventsState> map = new HashMap<AccessTokenAppIdPair, SessionEventsState>();
            map.put(accessTokenAppId, eventsToPersist);
            PersistedEvents.persistEvents(context, map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void persistEvents(Context context, Map<AccessTokenAppIdPair, SessionEventsState> eventsToPersist) {
            Object object = staticLock;
            synchronized (object) {
                PersistedEvents persistedEvents = PersistedEvents.readAndClearStore(context);
                for (Map.Entry<AccessTokenAppIdPair, SessionEventsState> entry : eventsToPersist.entrySet()) {
                    List<AppEvent> events = entry.getValue().getEventsToPersist();
                    if (events.size() == 0) continue;
                    persistedEvents.addEvents(entry.getKey(), events);
                }
                persistedEvents.write();
            }
        }

        public Set<AccessTokenAppIdPair> keySet() {
            return this.persistedEvents.keySet();
        }

        public List<AppEvent> getEvents(AccessTokenAppIdPair accessTokenAppId) {
            return this.persistedEvents.get(accessTokenAppId);
        }

        private void write() {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(this.context.openFileOutput(PERSISTED_EVENTS_FILENAME, 0)));
                oos.writeObject(this.persistedEvents);
            }
            catch (Exception e) {
                try {
                    Log.d((String)TAG, (String)("Got unexpected exception: " + e.toString()));
                }
                catch (Throwable throwable) {
                    Utility.closeQuietly(oos);
                    throw throwable;
                }
                Utility.closeQuietly(oos);
            }
            Utility.closeQuietly(oos);
        }

        private void readAndClearStore() {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new BufferedInputStream(this.context.openFileInput(PERSISTED_EVENTS_FILENAME)));
                HashMap obj = (HashMap)ois.readObject();
                this.context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                this.persistedEvents = obj;
            }
            catch (FileNotFoundException obj) {
                Utility.closeQuietly(ois);
            }
            catch (Exception e) {
                try {
                    Log.d((String)TAG, (String)("Got unexpected exception: " + e.toString()));
                }
                catch (Throwable throwable) {
                    Utility.closeQuietly(ois);
                    throw throwable;
                }
                Utility.closeQuietly(ois);
            }
            Utility.closeQuietly(ois);
        }

        public void addEvents(AccessTokenAppIdPair accessTokenAppId, List<AppEvent> eventsToPersist) {
            if (!this.persistedEvents.containsKey(accessTokenAppId)) {
                this.persistedEvents.put(accessTokenAppId, new ArrayList());
            }
            this.persistedEvents.get(accessTokenAppId).addAll(eventsToPersist);
        }
    }

    static class PersistedAppSessionInfo {
        private static final String PERSISTED_SESSION_INFO_FILENAME = "AppEventsLogger.persistedsessioninfo";
        private static final Object staticLock = new Object();
        private static boolean hasChanges = false;
        private static boolean isLoaded = false;
        private static Map<AccessTokenAppIdPair, FacebookTimeSpentData> appSessionInfoMap;
        private static final Runnable appSessionInfoFlushRunnable;

        PersistedAppSessionInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void restoreAppSessionInformation(Context context) {
            ObjectInputStream ois = null;
            Object object = staticLock;
            synchronized (object) {
                if (!isLoaded) {
                    try {
                        ois = new ObjectInputStream(context.openFileInput(PERSISTED_SESSION_INFO_FILENAME));
                        appSessionInfoMap = (HashMap)ois.readObject();
                        Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "App session info loaded");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Utility.closeQuietly(ois);
                        context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                        if (appSessionInfoMap == null) {
                            appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                        }
                        isLoaded = true;
                        hasChanges = false;
                    }
                    catch (Exception e) {
                        try {
                            Log.d((String)TAG, (String)("Got unexpected exception: " + e.toString()));
                        }
                        catch (Throwable throwable) {
                            Utility.closeQuietly(ois);
                            context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                            if (appSessionInfoMap == null) {
                                appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                            }
                            isLoaded = true;
                            hasChanges = false;
                            throw throwable;
                        }
                        Utility.closeQuietly(ois);
                        context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                        if (appSessionInfoMap == null) {
                            appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                        }
                        isLoaded = true;
                        hasChanges = false;
                    }
                    Utility.closeQuietly(ois);
                    context.deleteFile(PERSISTED_SESSION_INFO_FILENAME);
                    if (appSessionInfoMap == null) {
                        appSessionInfoMap = new HashMap<AccessTokenAppIdPair, FacebookTimeSpentData>();
                    }
                    isLoaded = true;
                    hasChanges = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void saveAppSessionInformation(Context context) {
            ObjectOutputStream oos = null;
            Object object = staticLock;
            synchronized (object) {
                if (hasChanges) {
                    try {
                        oos = new ObjectOutputStream(new BufferedOutputStream(context.openFileOutput(PERSISTED_SESSION_INFO_FILENAME, 0)));
                        oos.writeObject(appSessionInfoMap);
                        hasChanges = false;
                        Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "App session info saved");
                    }
                    catch (Exception e) {
                        try {
                            Log.d((String)TAG, (String)("Got unexpected exception: " + e.toString()));
                        }
                        catch (Throwable throwable) {
                            Utility.closeQuietly(oos);
                            throw throwable;
                        }
                        Utility.closeQuietly(oos);
                    }
                    Utility.closeQuietly(oos);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void onResume(Context context, AccessTokenAppIdPair accessTokenAppId, AppEventsLogger logger, long eventTime, String sourceApplicationInfo) {
            Object object = staticLock;
            synchronized (object) {
                FacebookTimeSpentData timeSpentData = PersistedAppSessionInfo.getTimeSpentData(context, accessTokenAppId);
                timeSpentData.onResume(logger, eventTime, sourceApplicationInfo);
                PersistedAppSessionInfo.onTimeSpentDataUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void onSuspend(Context context, AccessTokenAppIdPair accessTokenAppId, AppEventsLogger logger, long eventTime) {
            Object object = staticLock;
            synchronized (object) {
                FacebookTimeSpentData timeSpentData = PersistedAppSessionInfo.getTimeSpentData(context, accessTokenAppId);
                timeSpentData.onSuspend(logger, eventTime);
                PersistedAppSessionInfo.onTimeSpentDataUpdate();
            }
        }

        private static FacebookTimeSpentData getTimeSpentData(Context context, AccessTokenAppIdPair accessTokenAppId) {
            PersistedAppSessionInfo.restoreAppSessionInformation(context);
            FacebookTimeSpentData result = null;
            result = appSessionInfoMap.get(accessTokenAppId);
            if (result == null) {
                result = new FacebookTimeSpentData();
                appSessionInfoMap.put(accessTokenAppId, result);
            }
            return result;
        }

        private static void onTimeSpentDataUpdate() {
            if (!hasChanges) {
                hasChanges = true;
                backgroundExecutor.schedule(appSessionInfoFlushRunnable, 30L, TimeUnit.SECONDS);
            }
        }

        static {
            appSessionInfoFlushRunnable = new Runnable(){

                @Override
                public void run() {
                    PersistedAppSessionInfo.saveAppSessionInformation(applicationContext);
                }
            };
        }
    }

    static class AppEvent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private JSONObject jsonObject;
        private boolean isImplicit;
        private static final HashSet<String> validatedIdentifiers = new HashSet();
        private String name;

        public AppEvent(String contextName, String eventName, Double valueToSum, Bundle parameters, boolean isImplicitlyLogged) {
            try {
                this.validateIdentifier(eventName);
                this.name = eventName;
                this.isImplicit = isImplicitlyLogged;
                this.jsonObject = new JSONObject();
                this.jsonObject.put("_eventName", (Object)eventName);
                this.jsonObject.put("_logTime", System.currentTimeMillis() / 1000L);
                this.jsonObject.put("_ui", (Object)contextName);
                if (valueToSum != null) {
                    this.jsonObject.put("_valueToSum", valueToSum.doubleValue());
                }
                if (this.isImplicit) {
                    this.jsonObject.put("_implicitlyLogged", (Object)"1");
                }
                if (parameters != null) {
                    for (String key : parameters.keySet()) {
                        this.validateIdentifier(key);
                        Object value = parameters.get(key);
                        if (!(value instanceof String) && !(value instanceof Number)) {
                            throw new FacebookException(String.format("Parameter value '%s' for key '%s' should be a string or a numeric type.", value, key));
                        }
                        this.jsonObject.put(key, (Object)value.toString());
                    }
                }
                if (!this.isImplicit) {
                    Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Created app event '%s'", this.jsonObject.toString());
                }
            }
            catch (JSONException jsonException) {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "JSON encoding for app event failed: '%s'", jsonException.toString());
                this.jsonObject = null;
            }
            catch (FacebookException e) {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Invalid app event name or parameter:", e.toString());
                this.jsonObject = null;
            }
        }

        public String getName() {
            return this.name;
        }

        private AppEvent(String jsonString, boolean isImplicit) throws JSONException {
            this.jsonObject = new JSONObject(jsonString);
            this.isImplicit = isImplicit;
        }

        public boolean getIsImplicit() {
            return this.isImplicit;
        }

        public JSONObject getJSONObject() {
            return this.jsonObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateIdentifier(String identifier) throws FacebookException {
            String regex = "^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$";
            int MAX_IDENTIFIER_LENGTH = 40;
            if (identifier == null || identifier.length() == 0 || identifier.length() > 40) {
                if (identifier == null) {
                    identifier = "<None Provided>";
                }
                throw new FacebookException(String.format(Locale.ROOT, "Identifier '%s' must be less than %d characters", identifier, 40));
            }
            boolean alreadyValidated = false;
            HashSet<String> hashSet = validatedIdentifiers;
            synchronized (hashSet) {
                alreadyValidated = validatedIdentifiers.contains(identifier);
            }
            if (!alreadyValidated) {
                if (identifier.matches("^[0-9a-zA-Z_]+[0-9a-zA-Z _-]*$")) {
                    hashSet = validatedIdentifiers;
                    synchronized (hashSet) {
                        validatedIdentifiers.add(identifier);
                    }
                } else {
                    throw new FacebookException(String.format("Skipping event named '%s' due to illegal name - must be under 40 chars and alphanumeric, _, - or space, and not start with a space or hyphen.", identifier));
                }
            }
        }

        private Object writeReplace() {
            return new SerializationProxyV1(this.jsonObject.toString(), this.isImplicit);
        }

        public String toString() {
            return String.format("\"%s\", implicit: %b, json: %s", this.jsonObject.optString("_eventName"), this.isImplicit, this.jsonObject.toString());
        }

        private static class SerializationProxyV1
        implements Serializable {
            private static final long serialVersionUID = -2488473066578201069L;
            private final String jsonString;
            private final boolean isImplicit;

            private SerializationProxyV1(String jsonString, boolean isImplicit) {
                this.jsonString = jsonString;
                this.isImplicit = isImplicit;
            }

            private Object readResolve() throws JSONException {
                return new AppEvent(this.jsonString, this.isImplicit);
            }
        }
    }

    static class SessionEventsState {
        private List<AppEvent> accumulatedEvents = new ArrayList<AppEvent>();
        private List<AppEvent> inFlightEvents = new ArrayList<AppEvent>();
        private int numSkippedEventsDueToFullBuffer;
        private AttributionIdentifiers attributionIdentifiers;
        private String packageName;
        private String anonymousAppDeviceGUID;
        public static final String EVENT_COUNT_KEY = "event_count";
        public static final String ENCODED_EVENTS_KEY = "encoded_events";
        public static final String NUM_SKIPPED_KEY = "num_skipped";
        private final int MAX_ACCUMULATED_LOG_EVENTS = 1000;

        public SessionEventsState(AttributionIdentifiers identifiers, String packageName, String anonymousGUID) {
            this.attributionIdentifiers = identifiers;
            this.packageName = packageName;
            this.anonymousAppDeviceGUID = anonymousGUID;
        }

        public synchronized void addEvent(AppEvent event) {
            if (this.accumulatedEvents.size() + this.inFlightEvents.size() >= 1000) {
                ++this.numSkippedEventsDueToFullBuffer;
            } else {
                this.accumulatedEvents.add(event);
            }
        }

        public synchronized int getAccumulatedEventCount() {
            return this.accumulatedEvents.size();
        }

        public synchronized void clearInFlightAndStats(boolean moveToAccumulated) {
            if (moveToAccumulated) {
                this.accumulatedEvents.addAll(this.inFlightEvents);
            }
            this.inFlightEvents.clear();
            this.numSkippedEventsDueToFullBuffer = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int populateRequest(GraphRequest request, boolean includeImplicitEvents, boolean limitEventUsage) {
            JSONArray jsonArray;
            int numSkipped;
            SessionEventsState sessionEventsState = this;
            synchronized (sessionEventsState) {
                numSkipped = this.numSkippedEventsDueToFullBuffer;
                this.inFlightEvents.addAll(this.accumulatedEvents);
                this.accumulatedEvents.clear();
                jsonArray = new JSONArray();
                for (AppEvent event : this.inFlightEvents) {
                    if (!includeImplicitEvents && event.getIsImplicit()) continue;
                    jsonArray.put((Object)event.getJSONObject());
                }
                if (jsonArray.length() == 0) {
                    return 0;
                }
            }
            this.populateRequest(request, numSkipped, jsonArray, limitEventUsage);
            return jsonArray.length();
        }

        public synchronized List<AppEvent> getEventsToPersist() {
            List<AppEvent> result = this.accumulatedEvents;
            this.accumulatedEvents = new ArrayList<AppEvent>();
            return result;
        }

        public synchronized void accumulatePersistedEvents(List<AppEvent> events) {
            this.accumulatedEvents.addAll(events);
        }

        private void populateRequest(GraphRequest request, int numSkipped, JSONArray events, boolean limitEventUsage) {
            String jsonString;
            JSONObject publishParams = null;
            try {
                publishParams = AppEventsLoggerUtility.getJSONObjectForGraphAPICall(AppEventsLoggerUtility.GraphAPIActivityType.CUSTOM_APP_EVENTS, this.attributionIdentifiers, this.anonymousAppDeviceGUID, limitEventUsage, applicationContext);
                if (this.numSkippedEventsDueToFullBuffer > 0) {
                    publishParams.put("num_skipped_events", numSkipped);
                }
            }
            catch (JSONException e) {
                publishParams = new JSONObject();
            }
            request.setGraphObject(publishParams);
            Bundle requestParameters = request.getParameters();
            if (requestParameters == null) {
                requestParameters = new Bundle();
            }
            if ((jsonString = events.toString()) != null) {
                requestParameters.putByteArray("custom_events_file", this.getStringAsByteArray(jsonString));
                request.setTag(jsonString);
            }
            request.setParameters(requestParameters);
        }

        private byte[] getStringAsByteArray(String jsonString) {
            byte[] jsonUtf8 = null;
            try {
                jsonUtf8 = jsonString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Utility.logd("Encoding exception: ", e);
            }
            return jsonUtf8;
        }
    }

    private static class FlushStatistics {
        public int numEvents = 0;
        public FlushResult result = FlushResult.SUCCESS;

        private FlushStatistics() {
        }
    }

    private static enum FlushResult {
        SUCCESS,
        SERVER_ERROR,
        NO_CONNECTIVITY,
        UNKNOWN_ERROR;

    }

    private static enum FlushReason {
        EXPLICIT,
        TIMER,
        SESSION_CHANGE,
        PERSISTED_EVENTS,
        EVENT_THRESHOLD,
        EAGER_FLUSHING_EVENT;

    }

    private static class AccessTokenAppIdPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String accessTokenString;
        private final String applicationId;

        AccessTokenAppIdPair(AccessToken accessToken) {
            this(accessToken.getToken(), FacebookSdk.getApplicationId());
        }

        AccessTokenAppIdPair(String accessTokenString, String applicationId) {
            this.accessTokenString = Utility.isNullOrEmpty(accessTokenString) ? null : accessTokenString;
            this.applicationId = applicationId;
        }

        String getAccessTokenString() {
            return this.accessTokenString;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        public int hashCode() {
            return (this.accessTokenString == null ? 0 : this.accessTokenString.hashCode()) ^ (this.applicationId == null ? 0 : this.applicationId.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof AccessTokenAppIdPair)) {
                return false;
            }
            AccessTokenAppIdPair p = (AccessTokenAppIdPair)o;
            return Utility.areObjectsEqual(p.accessTokenString, this.accessTokenString) && Utility.areObjectsEqual(p.applicationId, this.applicationId);
        }

        private Object writeReplace() {
            return new SerializationProxyV1(this.accessTokenString, this.applicationId);
        }

        private static class SerializationProxyV1
        implements Serializable {
            private static final long serialVersionUID = -2488473066578201069L;
            private final String accessTokenString;
            private final String appId;

            private SerializationProxyV1(String accessTokenString, String appId) {
                this.accessTokenString = accessTokenString;
                this.appId = appId;
            }

            private Object readResolve() {
                return new AccessTokenAppIdPair(this.accessTokenString, this.appId);
            }
        }
    }

    public static enum FlushBehavior {
        AUTO,
        EXPLICIT_ONLY;

    }
}

