/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.Locale;

class WebViewLoginMethodHandler
extends LoginMethodHandler {
    private static final String WEB_VIEW_AUTH_HANDLER_STORE = "com.facebook.login.AuthorizationClient.WebViewAuthHandler.TOKEN_STORE_KEY";
    private static final String WEB_VIEW_AUTH_HANDLER_TOKEN_KEY = "TOKEN";
    private WebDialog loginDialog;
    private String e2e;
    public static final Parcelable.Creator<WebViewLoginMethodHandler> CREATOR = new Parcelable.Creator(){

        public WebViewLoginMethodHandler createFromParcel(Parcel source) {
            return new WebViewLoginMethodHandler(source);
        }

        public WebViewLoginMethodHandler[] newArray(int size) {
            return new WebViewLoginMethodHandler[size];
        }
    };

    WebViewLoginMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    String getNameForLogging() {
        return "web_view";
    }

    @Override
    boolean needsInternetPermission() {
        return true;
    }

    @Override
    void cancel() {
        if (this.loginDialog != null) {
            this.loginDialog.cancel();
            this.loginDialog = null;
        }
    }

    @Override
    boolean tryAuthorize(final LoginClient.Request request) {
        String previousTokenString;
        Bundle parameters = new Bundle();
        if (!Utility.isNullOrEmpty(request.getPermissions())) {
            String scope = TextUtils.join((CharSequence)",", request.getPermissions());
            parameters.putString("scope", scope);
            this.addLoggingExtra("scope", scope);
        }
        DefaultAudience audience = request.getDefaultAudience();
        parameters.putString("default_audience", audience.getNativeProtocolAudience());
        AccessToken previousToken = AccessToken.getCurrentAccessToken();
        String string2 = previousTokenString = previousToken != null ? previousToken.getToken() : null;
        if (previousTokenString != null && previousTokenString.equals(this.loadCookieToken())) {
            parameters.putString("access_token", previousTokenString);
            this.addLoggingExtra("access_token", "1");
        } else {
            Utility.clearFacebookCookies((Context)this.loginClient.getActivity());
            this.addLoggingExtra("access_token", "0");
        }
        WebDialog.OnCompleteListener listener = new WebDialog.OnCompleteListener(){

            @Override
            public void onComplete(Bundle values, FacebookException error) {
                WebViewLoginMethodHandler.this.onWebDialogComplete(request, values, error);
            }
        };
        this.e2e = LoginClient.getE2E();
        this.addLoggingExtra("e2e", this.e2e);
        FragmentActivity fragmentActivity = this.loginClient.getActivity();
        WebDialog.Builder builder = new AuthDialogBuilder((Context)fragmentActivity, request.getApplicationId(), parameters).setE2E(this.e2e).setIsRerequest(request.isRerequest()).setOnCompleteListener(listener).setTheme(FacebookSdk.getWebDialogTheme());
        this.loginDialog = builder.build();
        FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
        dialogFragment.setRetainInstance(true);
        dialogFragment.setDialog(this.loginDialog);
        dialogFragment.show(fragmentActivity.getSupportFragmentManager(), "FacebookDialogFragment");
        return true;
    }

    void onWebDialogComplete(LoginClient.Request request, Bundle values, FacebookException error) {
        LoginClient.Result outcome;
        if (values != null) {
            if (values.containsKey("e2e")) {
                this.e2e = values.getString("e2e");
            }
            try {
                AccessToken token = WebViewLoginMethodHandler.createAccessTokenFromWebBundle(request.getPermissions(), values, AccessTokenSource.WEB_VIEW, request.getApplicationId());
                outcome = LoginClient.Result.createTokenResult(this.loginClient.getPendingRequest(), token);
                CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)this.loginClient.getActivity());
                syncManager.sync();
                this.saveCookieToken(token.getToken());
            }
            catch (FacebookException ex) {
                outcome = LoginClient.Result.createErrorResult(this.loginClient.getPendingRequest(), null, ex.getMessage());
            }
        } else if (error instanceof FacebookOperationCanceledException) {
            outcome = LoginClient.Result.createCancelResult(this.loginClient.getPendingRequest(), "User canceled log in.");
        } else {
            this.e2e = null;
            String errorCode = null;
            String errorMessage = error.getMessage();
            if (error instanceof FacebookServiceException) {
                FacebookRequestError requestError = ((FacebookServiceException)error).getRequestError();
                errorCode = String.format(Locale.ROOT, "%d", requestError.getErrorCode());
                errorMessage = requestError.toString();
            }
            outcome = LoginClient.Result.createErrorResult(this.loginClient.getPendingRequest(), null, errorMessage, errorCode);
        }
        if (!Utility.isNullOrEmpty(this.e2e)) {
            this.logWebLoginCompleted(this.e2e);
        }
        this.loginClient.completeAndValidate(outcome);
    }

    private void saveCookieToken(String token) {
        FragmentActivity context = this.loginClient.getActivity();
        context.getSharedPreferences(WEB_VIEW_AUTH_HANDLER_STORE, 0).edit().putString(WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, token).apply();
    }

    private String loadCookieToken() {
        FragmentActivity context = this.loginClient.getActivity();
        SharedPreferences sharedPreferences = context.getSharedPreferences(WEB_VIEW_AUTH_HANDLER_STORE, 0);
        return sharedPreferences.getString(WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, "");
    }

    WebViewLoginMethodHandler(Parcel source) {
        super(source);
        this.e2e = source.readString();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.e2e);
    }

    static class AuthDialogBuilder
    extends WebDialog.Builder {
        private static final String OAUTH_DIALOG = "oauth";
        static final String REDIRECT_URI = "fbconnect://success";
        private String e2e;
        private boolean isRerequest;

        public AuthDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, OAUTH_DIALOG, parameters);
        }

        public AuthDialogBuilder setE2E(String e2e) {
            this.e2e = e2e;
            return this;
        }

        public AuthDialogBuilder setIsRerequest(boolean isRerequest) {
            this.isRerequest = isRerequest;
            return this;
        }

        @Override
        public WebDialog build() {
            Bundle parameters = this.getParameters();
            parameters.putString("redirect_uri", REDIRECT_URI);
            parameters.putString("client_id", this.getApplicationId());
            parameters.putString("e2e", this.e2e);
            parameters.putString("response_type", "token,signed_request");
            parameters.putString("return_scopes", "true");
            if (this.isRerequest) {
                parameters.putString("auth_type", "rerequest");
            }
            return new WebDialog(this.getContext(), OAUTH_DIALOG, parameters, this.getTheme(), this.getListener());
        }
    }
}

