/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventCollection;
import com.facebook.appevents.PersistedEvents;
import com.facebook.appevents.SessionEventsState;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

class AppEventStore {
    private static final String TAG = AppEventStore.class.getName();
    private static final String PERSISTED_EVENTS_FILENAME = "AppEventsLogger.persistedevents";

    AppEventStore() {
    }

    public static synchronized void persistEvents(AccessTokenAppIdPair accessTokenAppIdPair, SessionEventsState appEvents) {
        AppEventUtility.assertIsNotMainThread();
        PersistedEvents persistedEvents = AppEventStore.readAndClearStore();
        if (persistedEvents.containsKey(accessTokenAppIdPair)) {
            persistedEvents.get(accessTokenAppIdPair).addAll(appEvents.getEventsToPersist());
        } else {
            persistedEvents.addEvents(accessTokenAppIdPair, appEvents.getEventsToPersist());
        }
        AppEventStore.saveEventsToDisk(persistedEvents);
    }

    public static synchronized void persistEvents(AppEventCollection eventsToPersist) {
        AppEventUtility.assertIsNotMainThread();
        PersistedEvents persistedEvents = AppEventStore.readAndClearStore();
        for (AccessTokenAppIdPair accessTokenAppIdPair : eventsToPersist.keySet()) {
            SessionEventsState sessionEventsState = eventsToPersist.get(accessTokenAppIdPair);
            persistedEvents.addEvents(accessTokenAppIdPair, sessionEventsState.getEventsToPersist());
        }
        AppEventStore.saveEventsToDisk(persistedEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized PersistedEvents readAndClearStore() {
        PersistedEvents persistedEvents;
        block14: {
            AppEventUtility.assertIsNotMainThread();
            MovedClassObjectInputStream ois = null;
            persistedEvents = null;
            Context context = FacebookSdk.getApplicationContext();
            try {
                FileInputStream is = context.openFileInput(PERSISTED_EVENTS_FILENAME);
                ois = new MovedClassObjectInputStream(new BufferedInputStream(is));
                persistedEvents = (PersistedEvents)ois.readObject();
                Utility.closeQuietly(ois);
            }
            catch (FileNotFoundException ex) {
                Utility.closeQuietly(ois);
                try {
                    context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                }
                catch (Exception ex2) {
                    Log.w((String)TAG, (String)"Got unexpected exception when removing events file: ", (Throwable)ex2);
                }
                break block14;
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Got unexpected exception while reading events: ", (Throwable)e);
                break block14;
            }
            try {
                context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
            }
            catch (Exception ex) {
                Log.w((String)TAG, (String)"Got unexpected exception when removing events file: ", (Throwable)ex);
            }
            break block14;
            finally {
                Utility.closeQuietly(ois);
                try {
                    context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                }
                catch (Exception ex) {
                    Log.w((String)TAG, (String)"Got unexpected exception when removing events file: ", (Throwable)ex);
                }
            }
        }
        if (persistedEvents != null) return persistedEvents;
        return new PersistedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveEventsToDisk(PersistedEvents eventsToPersist) {
        ObjectOutputStream oos = null;
        Context context = FacebookSdk.getApplicationContext();
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(context.openFileOutput(PERSISTED_EVENTS_FILENAME, 0)));
            oos.writeObject(eventsToPersist);
        }
        catch (Exception e) {
            try {
                Log.w((String)TAG, (String)"Got unexpected exception while persisting events: ", (Throwable)e);
                try {
                    context.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Utility.closeQuietly(oos);
                throw throwable;
            }
            Utility.closeQuietly(oos);
        }
        Utility.closeQuietly(oos);
    }

    private static class MovedClassObjectInputStream
    extends ObjectInputStream {
        private static final String ACCESS_TOKEN_APP_ID_PAIR_SERIALIZATION_PROXY_V1_CLASS_NAME = "com.facebook.appevents.AppEventsLogger$AccessTokenAppIdPair$SerializationProxyV1";
        private static final String APP_EVENT_SERIALIZATION_PROXY_V1_CLASS_NAME = "com.facebook.appevents.AppEventsLogger$AppEvent$SerializationProxyV1";

        public MovedClassObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
            if (resultClassDescriptor.getName().equals(ACCESS_TOKEN_APP_ID_PAIR_SERIALIZATION_PROXY_V1_CLASS_NAME)) {
                resultClassDescriptor = ObjectStreamClass.lookup(AccessTokenAppIdPair.SerializationProxyV1.class);
            } else if (resultClassDescriptor.getName().equals(APP_EVENT_SERIALIZATION_PROXY_V1_CLASS_NAME)) {
                resultClassDescriptor = ObjectStreamClass.lookup(AppEvent.SerializationProxyV1.class);
            }
            return resultClassDescriptor;
        }
    }
}

