/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookSdk;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;

public class LockOnGetVariable<T> {
    private T value;
    private CountDownLatch initLatch;

    public LockOnGetVariable(T value) {
        this.value = value;
    }

    public LockOnGetVariable(final Callable<T> callable) {
        this.initLatch = new CountDownLatch(1);
        FacebookSdk.getExecutor().execute(new FutureTask<Void>(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    LockOnGetVariable.this.value = callable.call();
                }
                finally {
                    LockOnGetVariable.this.initLatch.countDown();
                }
                return null;
            }
        }));
    }

    public T getValue() {
        this.waitOnInit();
        return this.value;
    }

    private void waitOnInit() {
        if (this.initLatch == null) {
            return;
        }
        try {
            this.initLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

