/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.FacebookActivity;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.R;
import com.facebook.internal.Utility;
import com.facebook.login.CustomTabLoginMethodHandler;
import com.facebook.login.LoginClient;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginFragment
extends Fragment {
    static final String RESULT_KEY = "com.facebook.LoginFragment:Result";
    static final String REQUEST_KEY = "com.facebook.LoginFragment:Request";
    static final String EXTRA_REQUEST = "request";
    private static final String TAG = "LoginFragment";
    private static final String NULL_CALLING_PKG_ERROR_MSG = "Cannot call LoginFragment with a null calling package. This can occur if the launchMode of the caller is singleInstance.";
    private static final String SAVED_LOGIN_CLIENT = "loginClient";
    private static final String SAVED_CHALLENGE = "challenge";
    private static final int CHALLENGE_LENGTH = 20;
    private String callingPackage;
    private LoginClient loginClient;
    private LoginClient.Request request;
    private boolean restarted;
    private String expectedChallenge;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean bl = this.restarted = savedInstanceState != null;
        if (savedInstanceState != null) {
            this.loginClient = (LoginClient)savedInstanceState.getParcelable(SAVED_LOGIN_CLIENT);
            this.loginClient.setFragment(this);
            this.expectedChallenge = savedInstanceState.getString(SAVED_CHALLENGE);
        } else {
            this.loginClient = new LoginClient(this);
            this.expectedChallenge = Utility.generateRandomString(20);
        }
        this.loginClient.setOnCompletedListener(new LoginClient.OnCompletedListener(){

            @Override
            public void onCompleted(LoginClient.Result outcome) {
                LoginFragment.this.onLoginClientCompleted(outcome);
            }
        });
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.initializeCallingPackage((Activity)activity);
        if (activity.getIntent() != null) {
            Intent intent = activity.getIntent();
            Bundle bundle = intent.getBundleExtra(REQUEST_KEY);
            this.request = (LoginClient.Request)bundle.getParcelable(EXTRA_REQUEST);
        }
    }

    public void onDestroy() {
        this.loginClient.cancelCurrentHandler();
        super.onDestroy();
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.com_facebook_login_fragment, container, false);
        this.loginClient.setBackgroundProcessingListener(new LoginClient.BackgroundProcessingListener(){

            @Override
            public void onBackgroundProcessingStarted() {
                view.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(0);
            }

            @Override
            public void onBackgroundProcessingStopped() {
                view.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
            }
        });
        return view;
    }

    private void onLoginClientCompleted(LoginClient.Result outcome) {
        this.request = null;
        int resultCode = outcome.code == LoginClient.Result.Code.CANCEL ? 0 : -1;
        Bundle bundle = new Bundle();
        bundle.putParcelable(RESULT_KEY, (Parcelable)outcome);
        Intent resultIntent = new Intent();
        resultIntent.putExtras(bundle);
        if (this.isAdded()) {
            this.getActivity().setResult(resultCode, resultIntent);
            this.getActivity().finish();
        }
    }

    public void onResume() {
        FragmentActivity activity;
        super.onResume();
        if (this.callingPackage == null) {
            Log.e((String)TAG, (String)NULL_CALLING_PKG_ERROR_MSG);
            this.getActivity().finish();
            return;
        }
        if (this.restarted && (activity = this.getActivity()) instanceof FacebookActivity && this.loginClient.getCurrentHandler() instanceof CustomTabLoginMethodHandler) {
            ((FacebookActivity)activity).sendResult(null, new FacebookOperationCanceledException());
        }
        this.restarted = true;
        this.loginClient.startOrContinueAuth(this.request);
    }

    public void onPause() {
        super.onPause();
        this.getActivity().findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.loginClient.onActivityResult(requestCode, resultCode, data);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(SAVED_LOGIN_CLIENT, (Parcelable)this.loginClient);
        outState.putString(SAVED_CHALLENGE, this.expectedChallenge);
    }

    private void initializeCallingPackage(Activity activity) {
        ComponentName componentName = activity.getCallingActivity();
        if (componentName == null) {
            return;
        }
        this.callingPackage = componentName.getPackageName();
    }

    public boolean validateChallengeParam(Bundle values) {
        try {
            String stateString = values.getString("state");
            if (stateString == null) {
                return false;
            }
            JSONObject state = new JSONObject(stateString);
            String challenge = state.getString("7_challenge");
            return challenge.equals(this.expectedChallenge);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public String getChallengeParam() {
        return this.expectedChallenge;
    }

    LoginClient getLoginClient() {
        return this.loginClient;
    }
}

