/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.facebook.AccessToken;
import com.facebook.AccessTokenManager;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.ProgressNoopOutputStream;
import com.facebook.ProgressOutputStream;
import com.facebook.RequestOutputStream;
import com.facebook.RequestProgress;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Logger;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.share.internal.OpenGraphJSONUtility;
import com.facebook.share.model.ShareOpenGraphObject;
import com.facebook.share.model.SharePhoto;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GraphRequest {
    public static final int MAXIMUM_BATCH_SIZE = 50;
    public static final String TAG = GraphRequest.class.getSimpleName();
    private static final String VIDEOS_SUFFIX = "/videos";
    private static final String ME = "me";
    private static final String MY_FRIENDS = "me/friends";
    private static final String MY_PHOTOS = "me/photos";
    private static final String SEARCH = "search";
    private static final String USER_AGENT_BASE = "FBAndroidSDK";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String FORMAT_PARAM = "format";
    private static final String FORMAT_JSON = "json";
    private static final String SDK_PARAM = "sdk";
    private static final String SDK_ANDROID = "android";
    private static final String ACCESS_TOKEN_PARAM = "access_token";
    private static final String BATCH_ENTRY_NAME_PARAM = "name";
    private static final String BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM = "omit_response_on_success";
    private static final String BATCH_ENTRY_DEPENDS_ON_PARAM = "depends_on";
    private static final String BATCH_APP_ID_PARAM = "batch_app_id";
    private static final String BATCH_RELATIVE_URL_PARAM = "relative_url";
    private static final String BATCH_BODY_PARAM = "body";
    private static final String BATCH_METHOD_PARAM = "method";
    private static final String BATCH_PARAM = "batch";
    private static final String ATTACHMENT_FILENAME_PREFIX = "file";
    private static final String ATTACHED_FILES_PARAM = "attached_files";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DEBUG_PARAM = "debug";
    private static final String DEBUG_SEVERITY_INFO = "info";
    private static final String DEBUG_SEVERITY_WARNING = "warning";
    private static final String DEBUG_KEY = "__debug__";
    private static final String DEBUG_MESSAGES_KEY = "messages";
    private static final String DEBUG_MESSAGE_KEY = "message";
    private static final String DEBUG_MESSAGE_TYPE_KEY = "type";
    private static final String DEBUG_MESSAGE_LINK_KEY = "link";
    private static final String PICTURE_PARAM = "picture";
    private static final String CAPTION_PARAM = "caption";
    public static final String FIELDS_PARAM = "fields";
    private static final String MIME_BOUNDARY = "3i2ndDfv2rTHiSisAbouNdArYfORhtTPEefj3q2f";
    private static final String GRAPH_PATH_FORMAT = "%s/%s";
    private static String defaultBatchApplicationId;
    private static Pattern versionPattern;
    private AccessToken accessToken;
    private HttpMethod httpMethod;
    private String graphPath;
    private JSONObject graphObject;
    private String batchEntryName;
    private String batchEntryDependsOn;
    private boolean batchEntryOmitResultOnSuccess = true;
    private Bundle parameters;
    private Callback callback;
    private String overriddenURL;
    private Object tag;
    private String version;
    private boolean skipClientToken = false;
    private static volatile String userAgent;

    public GraphRequest() {
        this(null, null, null, null, null);
    }

    public GraphRequest(AccessToken accessToken, String graphPath) {
        this(accessToken, graphPath, null, null, null);
    }

    public GraphRequest(AccessToken accessToken, String graphPath, Bundle parameters, HttpMethod httpMethod) {
        this(accessToken, graphPath, parameters, httpMethod, null);
    }

    public GraphRequest(AccessToken accessToken, String graphPath, Bundle parameters, HttpMethod httpMethod, Callback callback) {
        this(accessToken, graphPath, parameters, httpMethod, callback, null);
    }

    public GraphRequest(AccessToken accessToken, String graphPath, Bundle parameters, HttpMethod httpMethod, Callback callback, String version) {
        this.accessToken = accessToken;
        this.graphPath = graphPath;
        this.version = version;
        this.setCallback(callback);
        this.setHttpMethod(httpMethod);
        this.parameters = parameters != null ? new Bundle(parameters) : new Bundle();
        if (this.version == null) {
            this.version = ServerProtocol.getAPIVersion();
        }
    }

    GraphRequest(AccessToken accessToken, URL overriddenURL) {
        this.accessToken = accessToken;
        this.overriddenURL = overriddenURL.toString();
        this.setHttpMethod(HttpMethod.GET);
        this.parameters = new Bundle();
    }

    public static GraphRequest newDeleteObjectRequest(AccessToken accessToken, String id2, Callback callback) {
        return new GraphRequest(accessToken, id2, null, HttpMethod.DELETE, callback);
    }

    public static GraphRequest newMeRequest(AccessToken accessToken, final GraphJSONObjectCallback callback) {
        Callback wrapper = new Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                if (callback != null) {
                    callback.onCompleted(response.getJSONObject(), response);
                }
            }
        };
        return new GraphRequest(accessToken, ME, null, null, wrapper);
    }

    public static GraphRequest newPostRequest(AccessToken accessToken, String graphPath, JSONObject graphObject, Callback callback) {
        GraphRequest request = new GraphRequest(accessToken, graphPath, null, HttpMethod.POST, callback);
        request.setGraphObject(graphObject);
        return request;
    }

    public static GraphRequest newMyFriendsRequest(AccessToken accessToken, final GraphJSONArrayCallback callback) {
        Callback wrapper = new Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                if (callback != null) {
                    JSONObject result = response.getJSONObject();
                    JSONArray data = result != null ? result.optJSONArray("data") : null;
                    callback.onCompleted(data, response);
                }
            }
        };
        return new GraphRequest(accessToken, MY_FRIENDS, null, null, wrapper);
    }

    public static GraphRequest newGraphPathRequest(AccessToken accessToken, String graphPath, Callback callback) {
        return new GraphRequest(accessToken, graphPath, null, null, callback);
    }

    public static GraphRequest newPlacesSearchRequest(AccessToken accessToken, Location location, int radiusInMeters, int resultsLimit, String searchText, final GraphJSONArrayCallback callback) {
        if (location == null && Utility.isNullOrEmpty(searchText)) {
            throw new FacebookException("Either location or searchText must be specified.");
        }
        Bundle parameters = new Bundle(5);
        parameters.putString(DEBUG_MESSAGE_TYPE_KEY, "place");
        parameters.putInt("limit", resultsLimit);
        if (location != null) {
            parameters.putString("center", String.format(Locale.US, "%f,%f", location.getLatitude(), location.getLongitude()));
            parameters.putInt("distance", radiusInMeters);
        }
        if (!Utility.isNullOrEmpty(searchText)) {
            parameters.putString("q", searchText);
        }
        Callback wrapper = new Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                if (callback != null) {
                    JSONObject result = response.getJSONObject();
                    JSONArray data = result != null ? result.optJSONArray("data") : null;
                    callback.onCompleted(data, response);
                }
            }
        };
        return new GraphRequest(accessToken, SEARCH, parameters, HttpMethod.GET, wrapper);
    }

    public static GraphRequest newUploadPhotoRequest(AccessToken accessToken, String graphPath, Bitmap image, String caption, Bundle params, Callback callback) {
        graphPath = GraphRequest.getDefaultPhotoPathIfNull(graphPath);
        Bundle parameters = new Bundle();
        if (params != null) {
            parameters.putAll(params);
        }
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)image);
        if (caption != null && !caption.isEmpty()) {
            parameters.putString(CAPTION_PARAM, caption);
        }
        return new GraphRequest(accessToken, graphPath, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadPhotoRequest(AccessToken accessToken, String graphPath, File file, String caption, Bundle params, Callback callback) throws FileNotFoundException {
        graphPath = GraphRequest.getDefaultPhotoPathIfNull(graphPath);
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle();
        if (params != null) {
            parameters.putAll(params);
        }
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)descriptor);
        if (caption != null && !caption.isEmpty()) {
            parameters.putString(CAPTION_PARAM, caption);
        }
        return new GraphRequest(accessToken, graphPath, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newUploadPhotoRequest(AccessToken accessToken, String graphPath, Uri photoUri, String caption, Bundle params, Callback callback) throws FileNotFoundException {
        graphPath = GraphRequest.getDefaultPhotoPathIfNull(graphPath);
        if (Utility.isFileUri(photoUri)) {
            return GraphRequest.newUploadPhotoRequest(accessToken, graphPath, new File(photoUri.getPath()), caption, params, callback);
        }
        if (!Utility.isContentUri(photoUri)) {
            throw new FacebookException("The photo Uri must be either a file:// or content:// Uri");
        }
        Bundle parameters = new Bundle();
        if (params != null) {
            parameters.putAll(params);
        }
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)photoUri);
        return new GraphRequest(accessToken, graphPath, parameters, HttpMethod.POST, callback);
    }

    public static GraphRequest newCustomAudienceThirdPartyIdRequest(AccessToken accessToken, Context context, String applicationId, Callback callback) {
        if (applicationId == null && accessToken != null) {
            applicationId = accessToken.getApplicationId();
        }
        if (applicationId == null) {
            applicationId = Utility.getMetadataApplicationId(context);
        }
        if (applicationId == null) {
            throw new FacebookException("Facebook App ID cannot be determined");
        }
        String endpoint = applicationId + "/custom_audience_third_party_id";
        AttributionIdentifiers attributionIdentifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
        Bundle parameters = new Bundle();
        if (accessToken == null) {
            String udid;
            if (attributionIdentifiers == null) {
                throw new FacebookException("There is no access token and attribution identifiers could not be retrieved");
            }
            String string = udid = attributionIdentifiers.getAttributionId() != null ? attributionIdentifiers.getAttributionId() : attributionIdentifiers.getAndroidAdvertiserId();
            if (attributionIdentifiers.getAttributionId() != null) {
                parameters.putString("udid", udid);
            }
        }
        if (FacebookSdk.getLimitEventAndDataUsage(context) || attributionIdentifiers != null && attributionIdentifiers.isTrackingLimited()) {
            parameters.putString("limit_event_usage", "1");
        }
        return new GraphRequest(accessToken, endpoint, parameters, HttpMethod.GET, callback);
    }

    public static GraphRequest newCustomAudienceThirdPartyIdRequest(AccessToken accessToken, Context context, Callback callback) {
        return GraphRequest.newCustomAudienceThirdPartyIdRequest(accessToken, context, null, callback);
    }

    public final JSONObject getGraphObject() {
        return this.graphObject;
    }

    public final void setGraphObject(JSONObject graphObject) {
        this.graphObject = graphObject;
    }

    public final String getGraphPath() {
        return this.graphPath;
    }

    public final void setGraphPath(String graphPath) {
        this.graphPath = graphPath;
    }

    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final void setHttpMethod(HttpMethod httpMethod) {
        if (this.overriddenURL != null && httpMethod != HttpMethod.GET) {
            throw new FacebookException("Can't change HTTP method on request with overridden URL.");
        }
        this.httpMethod = httpMethod != null ? httpMethod : HttpMethod.GET;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final void setSkipClientToken(boolean skipClientToken) {
        this.skipClientToken = skipClientToken;
    }

    public final Bundle getParameters() {
        return this.parameters;
    }

    public final void setParameters(Bundle parameters) {
        this.parameters = parameters;
    }

    public final AccessToken getAccessToken() {
        return this.accessToken;
    }

    public final void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public final String getBatchEntryName() {
        return this.batchEntryName;
    }

    public final void setBatchEntryName(String batchEntryName) {
        this.batchEntryName = batchEntryName;
    }

    public final String getBatchEntryDependsOn() {
        return this.batchEntryDependsOn;
    }

    public final void setBatchEntryDependsOn(String batchEntryDependsOn) {
        this.batchEntryDependsOn = batchEntryDependsOn;
    }

    public final boolean getBatchEntryOmitResultOnSuccess() {
        return this.batchEntryOmitResultOnSuccess;
    }

    public final void setBatchEntryOmitResultOnSuccess(boolean batchEntryOmitResultOnSuccess) {
        this.batchEntryOmitResultOnSuccess = batchEntryOmitResultOnSuccess;
    }

    public static final String getDefaultBatchApplicationId() {
        return defaultBatchApplicationId;
    }

    public static final void setDefaultBatchApplicationId(String applicationId) {
        defaultBatchApplicationId = applicationId;
    }

    public final Callback getCallback() {
        return this.callback;
    }

    public final void setCallback(final Callback callback) {
        Callback wrapper;
        this.callback = FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_INFO) || FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_WARNING) ? (wrapper = new Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                JSONArray debugMessages;
                JSONObject responseObject = response.getJSONObject();
                JSONObject debug = responseObject != null ? responseObject.optJSONObject(GraphRequest.DEBUG_KEY) : null;
                JSONArray jSONArray = debugMessages = debug != null ? debug.optJSONArray(GraphRequest.DEBUG_MESSAGES_KEY) : null;
                if (debugMessages != null) {
                    for (int i = 0; i < debugMessages.length(); ++i) {
                        String debugMessageLink;
                        JSONObject debugMessageObject = debugMessages.optJSONObject(i);
                        String debugMessage = debugMessageObject != null ? debugMessageObject.optString(GraphRequest.DEBUG_MESSAGE_KEY) : null;
                        String debugMessageType = debugMessageObject != null ? debugMessageObject.optString(GraphRequest.DEBUG_MESSAGE_TYPE_KEY) : null;
                        String string = debugMessageLink = debugMessageObject != null ? debugMessageObject.optString(GraphRequest.DEBUG_MESSAGE_LINK_KEY) : null;
                        if (debugMessage == null || debugMessageType == null) continue;
                        LoggingBehavior behavior = LoggingBehavior.GRAPH_API_DEBUG_INFO;
                        if (debugMessageType.equals(GraphRequest.DEBUG_SEVERITY_WARNING)) {
                            behavior = LoggingBehavior.GRAPH_API_DEBUG_WARNING;
                        }
                        if (!Utility.isNullOrEmpty(debugMessageLink)) {
                            debugMessage = debugMessage + " Link: " + debugMessageLink;
                        }
                        Logger.log(behavior, TAG, debugMessage);
                    }
                }
                if (callback != null) {
                    callback.onCompleted(response);
                }
            }
        }) : callback;
    }

    public final void setTag(Object tag) {
        this.tag = tag;
    }

    public final Object getTag() {
        return this.tag;
    }

    public final GraphResponse executeAndWait() {
        return GraphRequest.executeAndWait(this);
    }

    public final GraphRequestAsyncTask executeAsync() {
        return GraphRequest.executeBatchAsync(this);
    }

    public static HttpURLConnection toHttpConnection(GraphRequest ... requests) {
        return GraphRequest.toHttpConnection(Arrays.asList(requests));
    }

    public static HttpURLConnection toHttpConnection(Collection<GraphRequest> requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        return GraphRequest.toHttpConnection(new GraphRequestBatch(requests));
    }

    public static HttpURLConnection toHttpConnection(GraphRequestBatch requests) {
        URL url;
        GraphRequest.validateFieldsParamForGetRequests(requests);
        try {
            if (requests.size() == 1) {
                GraphRequest request = requests.get(0);
                url = new URL(request.getUrlForSingleRequest());
            } else {
                url = new URL(ServerProtocol.getGraphUrlBase());
            }
        }
        catch (MalformedURLException e) {
            throw new FacebookException("could not construct URL for request", e);
        }
        HttpURLConnection connection = null;
        try {
            connection = GraphRequest.createConnection(url);
            GraphRequest.serializeToUrlConnection(requests, connection);
        }
        catch (IOException | JSONException e) {
            Utility.disconnectQuietly(connection);
            throw new FacebookException("could not construct request body", e);
        }
        return connection;
    }

    public static GraphResponse executeAndWait(GraphRequest request) {
        List<GraphResponse> responses = GraphRequest.executeBatchAndWait(request);
        if (responses == null || responses.size() != 1) {
            throw new FacebookException("invalid state: expected a single response");
        }
        return responses.get(0);
    }

    public static List<GraphResponse> executeBatchAndWait(GraphRequest ... requests) {
        Validate.notNull(requests, "requests");
        return GraphRequest.executeBatchAndWait(Arrays.asList(requests));
    }

    public static List<GraphResponse> executeBatchAndWait(Collection<GraphRequest> requests) {
        return GraphRequest.executeBatchAndWait(new GraphRequestBatch(requests));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GraphResponse> executeBatchAndWait(GraphRequestBatch requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        HttpURLConnection connection = null;
        try {
            List<GraphResponse> responses;
            try {
                connection = GraphRequest.toHttpConnection(requests);
            }
            catch (Exception ex) {
                List<GraphResponse> responses2 = GraphResponse.constructErrorResponses(requests.getRequests(), null, new FacebookException(ex));
                GraphRequest.runCallbacks(requests, responses2);
                List<GraphResponse> list = responses2;
                Utility.disconnectQuietly(connection);
                return list;
            }
            List<GraphResponse> list = responses = GraphRequest.executeConnectionAndWait(connection, requests);
            return list;
        }
        finally {
            Utility.disconnectQuietly(connection);
        }
    }

    public static GraphRequestAsyncTask executeBatchAsync(GraphRequest ... requests) {
        Validate.notNull(requests, "requests");
        return GraphRequest.executeBatchAsync(Arrays.asList(requests));
    }

    public static GraphRequestAsyncTask executeBatchAsync(Collection<GraphRequest> requests) {
        return GraphRequest.executeBatchAsync(new GraphRequestBatch(requests));
    }

    public static GraphRequestAsyncTask executeBatchAsync(GraphRequestBatch requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        GraphRequestAsyncTask asyncTask = new GraphRequestAsyncTask(requests);
        asyncTask.executeOnExecutor(FacebookSdk.getExecutor(), null);
        return asyncTask;
    }

    public static List<GraphResponse> executeConnectionAndWait(HttpURLConnection connection, Collection<GraphRequest> requests) {
        return GraphRequest.executeConnectionAndWait(connection, new GraphRequestBatch(requests));
    }

    public static List<GraphResponse> executeConnectionAndWait(HttpURLConnection connection, GraphRequestBatch requests) {
        List<GraphResponse> responses = GraphResponse.fromHttpConnection(connection, requests);
        Utility.disconnectQuietly(connection);
        int numRequests = requests.size();
        if (numRequests != responses.size()) {
            throw new FacebookException(String.format(Locale.US, "Received %d responses while expecting %d", responses.size(), numRequests));
        }
        GraphRequest.runCallbacks(requests, responses);
        AccessTokenManager.getInstance().extendAccessTokenIfNeeded();
        return responses;
    }

    public static GraphRequestAsyncTask executeConnectionAsync(HttpURLConnection connection, GraphRequestBatch requests) {
        return GraphRequest.executeConnectionAsync(null, connection, requests);
    }

    public static GraphRequestAsyncTask executeConnectionAsync(Handler callbackHandler, HttpURLConnection connection, GraphRequestBatch requests) {
        Validate.notNull(connection, "connection");
        GraphRequestAsyncTask asyncTask = new GraphRequestAsyncTask(connection, requests);
        requests.setCallbackHandler(callbackHandler);
        asyncTask.executeOnExecutor(FacebookSdk.getExecutor(), null);
        return asyncTask;
    }

    public String toString() {
        return "{Request: " + " accessToken: " + (this.accessToken == null ? "null" : this.accessToken) + ", graphPath: " + this.graphPath + ", graphObject: " + this.graphObject + ", httpMethod: " + (Object)((Object)this.httpMethod) + ", parameters: " + this.parameters + "}";
    }

    static void runCallbacks(final GraphRequestBatch requests, List<GraphResponse> responses) {
        int numRequests = requests.size();
        final ArrayList<Pair> callbacks = new ArrayList<Pair>();
        for (int i = 0; i < numRequests; ++i) {
            GraphRequest request = requests.get(i);
            if (request.callback == null) continue;
            callbacks.add(new Pair((Object)request.callback, (Object)responses.get(i)));
        }
        if (callbacks.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (Pair pair : callbacks) {
                        ((Callback)pair.first).onCompleted((GraphResponse)pair.second);
                    }
                    List<GraphRequestBatch.Callback> batchCallbacks = requests.getCallbacks();
                    for (GraphRequestBatch.Callback batchCallback : batchCallbacks) {
                        batchCallback.onBatchCompleted(requests);
                    }
                }
            };
            Handler callbackHandler = requests.getCallbackHandler();
            if (callbackHandler == null) {
                runnable.run();
            } else {
                callbackHandler.post(runnable);
            }
        }
    }

    private static String getDefaultPhotoPathIfNull(String graphPath) {
        return graphPath == null ? MY_PHOTOS : graphPath;
    }

    private static HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(USER_AGENT_HEADER, GraphRequest.getUserAgent());
        connection.setRequestProperty(ACCEPT_LANGUAGE_HEADER, Locale.getDefault().toString());
        connection.setChunkedStreamingMode(0);
        return connection;
    }

    private void addCommonParameters() {
        if (this.accessToken != null) {
            if (!this.parameters.containsKey(ACCESS_TOKEN_PARAM)) {
                String token = this.accessToken.getToken();
                Logger.registerAccessToken(token);
                this.parameters.putString(ACCESS_TOKEN_PARAM, token);
            }
        } else if (!this.skipClientToken && !this.parameters.containsKey(ACCESS_TOKEN_PARAM)) {
            String appID = FacebookSdk.getApplicationId();
            String clientToken = FacebookSdk.getClientToken();
            if (!Utility.isNullOrEmpty(appID) && !Utility.isNullOrEmpty(clientToken)) {
                String accessToken = appID + "|" + clientToken;
                this.parameters.putString(ACCESS_TOKEN_PARAM, accessToken);
            } else {
                Log.d((String)TAG, (String)"Warning: Request without access token missing application ID or client token.");
            }
        }
        this.parameters.putString(SDK_PARAM, SDK_ANDROID);
        this.parameters.putString(FORMAT_PARAM, FORMAT_JSON);
        if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_INFO)) {
            this.parameters.putString(DEBUG_PARAM, DEBUG_SEVERITY_INFO);
        } else if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.GRAPH_API_DEBUG_WARNING)) {
            this.parameters.putString(DEBUG_PARAM, DEBUG_SEVERITY_WARNING);
        }
    }

    private String appendParametersToBaseUrl(String baseUrl) {
        Uri.Builder uriBuilder = new Uri.Builder().encodedPath(baseUrl);
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (value == null) {
                value = "";
            }
            if (!GraphRequest.isSupportedParameterType(value)) {
                if (this.httpMethod != HttpMethod.GET) continue;
                throw new IllegalArgumentException(String.format(Locale.US, "Unsupported parameter type for GET request: %s", value.getClass().getSimpleName()));
            }
            value = GraphRequest.parameterToString(value);
            uriBuilder.appendQueryParameter(key, value.toString());
        }
        return uriBuilder.toString();
    }

    final String getUrlForBatchedRequest() {
        if (this.overriddenURL != null) {
            throw new FacebookException("Can't override URL for a batch request");
        }
        String baseUrl = this.getGraphPathWithVersion();
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl);
    }

    final String getUrlForSingleRequest() {
        if (this.overriddenURL != null) {
            return this.overriddenURL.toString();
        }
        String graphBaseUrlBase = this.getHttpMethod() == HttpMethod.POST && this.graphPath != null && this.graphPath.endsWith(VIDEOS_SUFFIX) ? ServerProtocol.getGraphVideoUrlBase() : ServerProtocol.getGraphUrlBase();
        String baseUrl = String.format(GRAPH_PATH_FORMAT, graphBaseUrlBase, this.getGraphPathWithVersion());
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl);
    }

    private String getGraphPathWithVersion() {
        Matcher matcher = versionPattern.matcher(this.graphPath);
        if (matcher.matches()) {
            return this.graphPath;
        }
        return String.format(GRAPH_PATH_FORMAT, this.version, this.graphPath);
    }

    private void serializeToBatch(JSONArray batch, Map<String, Attachment> attachments) throws JSONException, IOException {
        JSONObject batchEntry = new JSONObject();
        if (this.batchEntryName != null) {
            batchEntry.put(BATCH_ENTRY_NAME_PARAM, (Object)this.batchEntryName);
            batchEntry.put(BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM, this.batchEntryOmitResultOnSuccess);
        }
        if (this.batchEntryDependsOn != null) {
            batchEntry.put(BATCH_ENTRY_DEPENDS_ON_PARAM, (Object)this.batchEntryDependsOn);
        }
        String relativeURL = this.getUrlForBatchedRequest();
        batchEntry.put(BATCH_RELATIVE_URL_PARAM, (Object)relativeURL);
        batchEntry.put(BATCH_METHOD_PARAM, (Object)this.httpMethod);
        if (this.accessToken != null) {
            String token = this.accessToken.getToken();
            Logger.registerAccessToken(token);
        }
        ArrayList<String> attachmentNames = new ArrayList<String>();
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (!GraphRequest.isSupportedAttachmentType(value)) continue;
            String name = String.format(Locale.ROOT, "%s%d", ATTACHMENT_FILENAME_PREFIX, attachments.size());
            attachmentNames.add(name);
            attachments.put(name, new Attachment(this, value));
        }
        if (!attachmentNames.isEmpty()) {
            String attachmentNamesString = TextUtils.join((CharSequence)",", attachmentNames);
            batchEntry.put(ATTACHED_FILES_PARAM, (Object)attachmentNamesString);
        }
        if (this.graphObject != null) {
            final ArrayList keysAndValues = new ArrayList();
            GraphRequest.processGraphObject(this.graphObject, relativeURL, new KeyValueSerializer(){

                @Override
                public void writeString(String key, String value) throws IOException {
                    keysAndValues.add(String.format(Locale.US, "%s=%s", key, URLEncoder.encode(value, "UTF-8")));
                }
            });
            String bodyValue = TextUtils.join((CharSequence)"&", keysAndValues);
            batchEntry.put(BATCH_BODY_PARAM, (Object)bodyValue);
        }
        batch.put((Object)batchEntry);
    }

    private static boolean hasOnProgressCallbacks(GraphRequestBatch requests) {
        for (GraphRequestBatch.Callback callback : requests.getCallbacks()) {
            if (!(callback instanceof GraphRequestBatch.OnProgressCallback)) continue;
            return true;
        }
        for (GraphRequest request : requests) {
            if (!(request.getCallback() instanceof OnProgressCallback)) continue;
            return true;
        }
        return false;
    }

    private static void setConnectionContentType(HttpURLConnection connection, boolean shouldUseGzip) {
        if (shouldUseGzip) {
            connection.setRequestProperty(CONTENT_TYPE_HEADER, "application/x-www-form-urlencoded");
            connection.setRequestProperty(CONTENT_ENCODING_HEADER, "gzip");
        } else {
            connection.setRequestProperty(CONTENT_TYPE_HEADER, GraphRequest.getMimeContentType());
        }
    }

    private static boolean isGzipCompressible(GraphRequestBatch requests) {
        for (GraphRequest request : requests) {
            for (String key : request.parameters.keySet()) {
                Object value = request.parameters.get(key);
                if (!GraphRequest.isSupportedAttachmentType(value)) continue;
                return false;
            }
        }
        return true;
    }

    static final boolean shouldWarnOnMissingFieldsParam(GraphRequest request) {
        String[] versionParts;
        String version = request.getVersion();
        if (Utility.isNullOrEmpty(version)) {
            return true;
        }
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        return (versionParts = version.split("\\.")).length >= 2 && Integer.parseInt(versionParts[0]) > 2 || Integer.parseInt(versionParts[0]) >= 2 && Integer.parseInt(versionParts[1]) >= 4;
    }

    static final void validateFieldsParamForGetRequests(GraphRequestBatch requests) {
        for (GraphRequest request : requests) {
            Bundle params;
            if (!HttpMethod.GET.equals((Object)request.getHttpMethod()) || !GraphRequest.shouldWarnOnMissingFieldsParam(request) || (params = request.getParameters()).containsKey(FIELDS_PARAM) && !Utility.isNullOrEmpty(params.getString(FIELDS_PARAM))) continue;
            Logger.log(LoggingBehavior.DEVELOPER_ERRORS, 5, "Request", "starting with Graph API v2.4, GET requests for /%s should contain an explicit \"fields\" parameter.", request.getGraphPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void serializeToUrlConnection(GraphRequestBatch requests, HttpURLConnection connection) throws IOException, JSONException {
        boolean isPost;
        Logger logger = new Logger(LoggingBehavior.REQUESTS, "Request");
        int numRequests = requests.size();
        boolean shouldUseGzip = GraphRequest.isGzipCompressible(requests);
        HttpMethod connectionHttpMethod = numRequests == 1 ? requests.get((int)0).httpMethod : HttpMethod.POST;
        connection.setRequestMethod(connectionHttpMethod.name());
        GraphRequest.setConnectionContentType(connection, shouldUseGzip);
        URL url = connection.getURL();
        logger.append("Request:\n");
        logger.appendKeyValue("Id", requests.getId());
        logger.appendKeyValue("URL", url);
        logger.appendKeyValue("Method", connection.getRequestMethod());
        logger.appendKeyValue(USER_AGENT_HEADER, connection.getRequestProperty(USER_AGENT_HEADER));
        logger.appendKeyValue(CONTENT_TYPE_HEADER, connection.getRequestProperty(CONTENT_TYPE_HEADER));
        connection.setConnectTimeout(requests.getTimeout());
        connection.setReadTimeout(requests.getTimeout());
        boolean bl = isPost = connectionHttpMethod == HttpMethod.POST;
        if (!isPost) {
            logger.log();
            return;
        }
        connection.setDoOutput(true);
        try (FilterOutputStream outputStream = null;){
            outputStream = new BufferedOutputStream(connection.getOutputStream());
            if (shouldUseGzip) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            if (GraphRequest.hasOnProgressCallbacks(requests)) {
                ProgressNoopOutputStream countingStream = null;
                countingStream = new ProgressNoopOutputStream(requests.getCallbackHandler());
                GraphRequest.processRequest(requests, null, numRequests, url, countingStream, shouldUseGzip);
                int max = countingStream.getMaxProgress();
                Map<GraphRequest, RequestProgress> progressMap = countingStream.getProgressMap();
                outputStream = new ProgressOutputStream(outputStream, requests, progressMap, max);
            }
            GraphRequest.processRequest(requests, logger, numRequests, url, outputStream, shouldUseGzip);
        }
        logger.log();
    }

    private static void processRequest(GraphRequestBatch requests, Logger logger, int numRequests, URL url, OutputStream outputStream, boolean shouldUseGzip) throws IOException, JSONException {
        Serializer serializer = new Serializer(outputStream, logger, shouldUseGzip);
        if (numRequests == 1) {
            GraphRequest request = requests.get(0);
            HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
            for (String key : request.parameters.keySet()) {
                Object value = request.parameters.get(key);
                if (!GraphRequest.isSupportedAttachmentType(value)) continue;
                attachments.put(key, new Attachment(request, value));
            }
            if (logger != null) {
                logger.append("  Parameters:\n");
            }
            GraphRequest.serializeParameters(request.parameters, serializer, request);
            if (logger != null) {
                logger.append("  Attachments:\n");
            }
            GraphRequest.serializeAttachments(attachments, serializer);
            if (request.graphObject != null) {
                GraphRequest.processGraphObject(request.graphObject, url.getPath(), serializer);
            }
        } else {
            String batchAppID = GraphRequest.getBatchAppId(requests);
            if (Utility.isNullOrEmpty(batchAppID)) {
                throw new FacebookException("App ID was not specified at the request or Settings.");
            }
            serializer.writeString(BATCH_APP_ID_PARAM, batchAppID);
            HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
            GraphRequest.serializeRequestsAsJSON(serializer, requests, attachments);
            if (logger != null) {
                logger.append("  Attachments:\n");
            }
            GraphRequest.serializeAttachments(attachments, serializer);
        }
    }

    private static boolean isMeRequest(String path) {
        Matcher matcher = versionPattern.matcher(path);
        if (matcher.matches()) {
            path = matcher.group(1);
        }
        return path.startsWith("me/") || path.startsWith("/me/");
    }

    private static void processGraphObject(JSONObject graphObject, String path, KeyValueSerializer serializer) throws IOException {
        boolean isOGAction = false;
        if (GraphRequest.isMeRequest(path)) {
            int colonLocation = path.indexOf(":");
            int questionMarkLocation = path.indexOf("?");
            isOGAction = colonLocation > 3 && (questionMarkLocation == -1 || colonLocation < questionMarkLocation);
        }
        Iterator keyIterator = graphObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = graphObject.opt(key);
            boolean passByValue = isOGAction && key.equalsIgnoreCase("image");
            GraphRequest.processGraphObjectProperty(key, value, serializer, passByValue);
        }
    }

    public static GraphRequest createOpenGraphObject(ShareOpenGraphObject openGraphObject) throws FacebookException {
        String type = openGraphObject.getString(DEBUG_MESSAGE_TYPE_KEY);
        if (type == null) {
            type = openGraphObject.getString("og:type");
        }
        if (type == null) {
            throw new FacebookException("Open graph object type cannot be null");
        }
        try {
            JSONObject stagedObject = (JSONObject)OpenGraphJSONUtility.toJSONValue(openGraphObject, new OpenGraphJSONUtility.PhotoJSONProcessor(){

                @Override
                public JSONObject toJSONObject(SharePhoto photo) {
                    Uri photoUri = photo.getImageUrl();
                    JSONObject photoJSONObject = new JSONObject();
                    try {
                        photoJSONObject.put("url", (Object)photoUri.toString());
                    }
                    catch (Exception e) {
                        throw new FacebookException("Unable to attach images", e);
                    }
                    return photoJSONObject;
                }
            });
            String ogType = type;
            Bundle parameters = new Bundle();
            parameters.putString("object", stagedObject.toString());
            String graphPath = String.format(Locale.ROOT, GRAPH_PATH_FORMAT, ME, "objects/" + ogType);
            return new GraphRequest(AccessToken.getCurrentAccessToken(), graphPath, parameters, HttpMethod.POST);
        }
        catch (JSONException e) {
            throw new FacebookException(e.getMessage());
        }
    }

    private static void processGraphObjectProperty(String key, Object value, KeyValueSerializer serializer, boolean passByValue) throws IOException {
        Class<?> valueClass = value.getClass();
        if (JSONObject.class.isAssignableFrom(valueClass)) {
            JSONObject jsonObject = (JSONObject)value;
            if (passByValue) {
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String propertyName = (String)keys.next();
                    String subKey = String.format("%s[%s]", key, propertyName);
                    GraphRequest.processGraphObjectProperty(subKey, jsonObject.opt(propertyName), serializer, passByValue);
                }
            } else if (jsonObject.has("id")) {
                GraphRequest.processGraphObjectProperty(key, jsonObject.optString("id"), serializer, passByValue);
            } else if (jsonObject.has("url")) {
                GraphRequest.processGraphObjectProperty(key, jsonObject.optString("url"), serializer, passByValue);
            } else if (jsonObject.has("fbsdk:create_object")) {
                GraphRequest.processGraphObjectProperty(key, jsonObject.toString(), serializer, passByValue);
            }
        } else if (JSONArray.class.isAssignableFrom(valueClass)) {
            JSONArray jsonArray = (JSONArray)value;
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                String subKey = String.format(Locale.ROOT, "%s[%d]", key, i);
                GraphRequest.processGraphObjectProperty(subKey, jsonArray.opt(i), serializer, passByValue);
            }
        } else if (String.class.isAssignableFrom(valueClass) || Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
            serializer.writeString(key, value.toString());
        } else if (Date.class.isAssignableFrom(valueClass)) {
            Date date = (Date)value;
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            serializer.writeString(key, iso8601DateFormat.format(date));
        }
    }

    private static void serializeParameters(Bundle bundle, Serializer serializer, GraphRequest request) throws IOException {
        Set keys = bundle.keySet();
        for (String key : keys) {
            Object value = bundle.get(key);
            if (!GraphRequest.isSupportedParameterType(value)) continue;
            serializer.writeObject(key, value, request);
        }
    }

    private static void serializeAttachments(Map<String, Attachment> attachments, Serializer serializer) throws IOException {
        Set<String> keys = attachments.keySet();
        for (String key : keys) {
            Attachment attachment = attachments.get(key);
            if (!GraphRequest.isSupportedAttachmentType(attachment.getValue())) continue;
            serializer.writeObject(key, attachment.getValue(), attachment.getRequest());
        }
    }

    private static void serializeRequestsAsJSON(Serializer serializer, Collection<GraphRequest> requests, Map<String, Attachment> attachments) throws JSONException, IOException {
        JSONArray batch = new JSONArray();
        for (GraphRequest request : requests) {
            request.serializeToBatch(batch, attachments);
        }
        serializer.writeRequestsAsJson(BATCH_PARAM, batch, requests);
    }

    private static String getMimeContentType() {
        return String.format("multipart/form-data; boundary=%s", MIME_BOUNDARY);
    }

    private static String getUserAgent() {
        if (userAgent == null) {
            userAgent = String.format("%s.%s", USER_AGENT_BASE, "4.10.1");
            String customUserAgent = InternalSettings.getCustomUserAgent();
            if (!Utility.isNullOrEmpty(customUserAgent)) {
                userAgent = String.format(Locale.ROOT, GRAPH_PATH_FORMAT, userAgent, customUserAgent);
            }
        }
        return userAgent;
    }

    private static String getBatchAppId(GraphRequestBatch batch) {
        if (!Utility.isNullOrEmpty(batch.getBatchApplicationId())) {
            return batch.getBatchApplicationId();
        }
        for (GraphRequest request : batch) {
            String applicationId;
            AccessToken accessToken = request.accessToken;
            if (accessToken == null || (applicationId = accessToken.getApplicationId()) == null) continue;
            return applicationId;
        }
        if (!Utility.isNullOrEmpty(defaultBatchApplicationId)) {
            return defaultBatchApplicationId;
        }
        return FacebookSdk.getApplicationId();
    }

    private static boolean isSupportedAttachmentType(Object value) {
        return value instanceof Bitmap || value instanceof byte[] || value instanceof Uri || value instanceof ParcelFileDescriptor || value instanceof ParcelableResourceWithMimeType;
    }

    private static boolean isSupportedParameterType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date;
    }

    private static String parameterToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            return iso8601DateFormat.format(value);
        }
        throw new IllegalArgumentException("Unsupported parameter type.");
    }

    static {
        versionPattern = Pattern.compile("^/?v\\d+\\.\\d+/(.*)");
    }

    public static class ParcelableResourceWithMimeType<RESOURCE extends Parcelable>
    implements Parcelable {
        private final String mimeType;
        private final RESOURCE resource;
        public static final Parcelable.Creator<ParcelableResourceWithMimeType> CREATOR = new Parcelable.Creator<ParcelableResourceWithMimeType>(){

            public ParcelableResourceWithMimeType createFromParcel(Parcel in) {
                return new ParcelableResourceWithMimeType(in);
            }

            public ParcelableResourceWithMimeType[] newArray(int size) {
                return new ParcelableResourceWithMimeType[size];
            }
        };

        public String getMimeType() {
            return this.mimeType;
        }

        public RESOURCE getResource() {
            return this.resource;
        }

        public int describeContents() {
            return 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mimeType);
            out.writeParcelable(this.resource, flags);
        }

        public ParcelableResourceWithMimeType(RESOURCE resource, String mimeType) {
            this.mimeType = mimeType;
            this.resource = resource;
        }

        private ParcelableResourceWithMimeType(Parcel in) {
            this.mimeType = in.readString();
            this.resource = in.readParcelable(FacebookSdk.getApplicationContext().getClassLoader());
        }
    }

    public static interface GraphJSONObjectCallback {
        public void onCompleted(JSONObject var1, GraphResponse var2);
    }

    public static interface GraphJSONArrayCallback {
        public void onCompleted(JSONArray var1, GraphResponse var2);
    }

    public static interface OnProgressCallback
    extends Callback {
        public void onProgress(long var1, long var3);
    }

    public static interface Callback {
        public void onCompleted(GraphResponse var1);
    }

    private static class Serializer
    implements KeyValueSerializer {
        private final OutputStream outputStream;
        private final Logger logger;
        private boolean firstWrite = true;
        private boolean useUrlEncode = false;

        public Serializer(OutputStream outputStream, Logger logger, boolean useUrlEncode) {
            this.outputStream = outputStream;
            this.logger = logger;
            this.useUrlEncode = useUrlEncode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void writeObject(String key, Object value, GraphRequest request) throws IOException {
            if (this.outputStream instanceof RequestOutputStream) {
                ((RequestOutputStream)((Object)this.outputStream)).setCurrentRequest(request);
            }
            if (GraphRequest.isSupportedParameterType(value)) {
                this.writeString(key, GraphRequest.parameterToString(value));
                return;
            } else if (value instanceof Bitmap) {
                this.writeBitmap(key, (Bitmap)value);
                return;
            } else if (value instanceof byte[]) {
                this.writeBytes(key, (byte[])value);
                return;
            } else if (value instanceof Uri) {
                this.writeContentUri(key, (Uri)value, null);
                return;
            } else if (value instanceof ParcelFileDescriptor) {
                this.writeFile(key, (ParcelFileDescriptor)value, null);
                return;
            } else {
                if (!(value instanceof ParcelableResourceWithMimeType)) throw this.getInvalidTypeError();
                ParcelableResourceWithMimeType resourceWithMimeType = (ParcelableResourceWithMimeType)value;
                Object resource = resourceWithMimeType.getResource();
                String mimeType = resourceWithMimeType.getMimeType();
                if (resource instanceof ParcelFileDescriptor) {
                    this.writeFile(key, (ParcelFileDescriptor)resource, mimeType);
                    return;
                } else {
                    if (!(resource instanceof Uri)) throw this.getInvalidTypeError();
                    this.writeContentUri(key, (Uri)resource, mimeType);
                }
            }
        }

        private RuntimeException getInvalidTypeError() {
            return new IllegalArgumentException("value is not a supported type.");
        }

        public void writeRequestsAsJson(String key, JSONArray requestJsonArray, Collection<GraphRequest> requests) throws IOException, JSONException {
            if (!(this.outputStream instanceof RequestOutputStream)) {
                this.writeString(key, requestJsonArray.toString());
                return;
            }
            RequestOutputStream requestOutputStream = (RequestOutputStream)((Object)this.outputStream);
            this.writeContentDisposition(key, null, null);
            this.write("[", new Object[0]);
            int i = 0;
            for (GraphRequest request : requests) {
                JSONObject requestJson = requestJsonArray.getJSONObject(i);
                requestOutputStream.setCurrentRequest(request);
                if (i > 0) {
                    this.write(",%s", requestJson.toString());
                } else {
                    this.write("%s", requestJson.toString());
                }
                ++i;
            }
            this.write("]", new Object[0]);
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, requestJsonArray.toString());
            }
        }

        @Override
        public void writeString(String key, String value) throws IOException {
            this.writeContentDisposition(key, null, null);
            this.writeLine("%s", value);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, value);
            }
        }

        public void writeBitmap(String key, Bitmap bitmap) throws IOException {
            this.writeContentDisposition(key, key, "image/png");
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, "<Image>");
            }
        }

        public void writeBytes(String key, byte[] bytes) throws IOException {
            this.writeContentDisposition(key, key, "content/unknown");
            this.outputStream.write(bytes);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, String.format(Locale.ROOT, "<Data: %d>", bytes.length));
            }
        }

        public void writeContentUri(String key, Uri contentUri, String mimeType) throws IOException {
            if (mimeType == null) {
                mimeType = "content/unknown";
            }
            this.writeContentDisposition(key, key, mimeType);
            int totalBytes = 0;
            if (this.outputStream instanceof ProgressNoopOutputStream) {
                long contentSize = Utility.getContentSize(contentUri);
                ((ProgressNoopOutputStream)this.outputStream).addProgress(contentSize);
            } else {
                InputStream inputStream = FacebookSdk.getApplicationContext().getContentResolver().openInputStream(contentUri);
                totalBytes += Utility.copyAndCloseInputStream(inputStream, this.outputStream);
            }
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, String.format(Locale.ROOT, "<Data: %d>", totalBytes));
            }
        }

        public void writeFile(String key, ParcelFileDescriptor descriptor, String mimeType) throws IOException {
            if (mimeType == null) {
                mimeType = "content/unknown";
            }
            this.writeContentDisposition(key, key, mimeType);
            int totalBytes = 0;
            if (this.outputStream instanceof ProgressNoopOutputStream) {
                ((ProgressNoopOutputStream)this.outputStream).addProgress(descriptor.getStatSize());
            } else {
                ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(descriptor);
                totalBytes += Utility.copyAndCloseInputStream((InputStream)inputStream, this.outputStream);
            }
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, String.format(Locale.ROOT, "<Data: %d>", totalBytes));
            }
        }

        public void writeRecordBoundary() throws IOException {
            if (!this.useUrlEncode) {
                this.writeLine("--%s", GraphRequest.MIME_BOUNDARY);
            } else {
                this.outputStream.write("&".getBytes());
            }
        }

        public void writeContentDisposition(String name, String filename, String contentType) throws IOException {
            if (!this.useUrlEncode) {
                this.write("Content-Disposition: form-data; name=\"%s\"", name);
                if (filename != null) {
                    this.write("; filename=\"%s\"", filename);
                }
                this.writeLine("", new Object[0]);
                if (contentType != null) {
                    this.writeLine("%s: %s", GraphRequest.CONTENT_TYPE_HEADER, contentType);
                }
                this.writeLine("", new Object[0]);
            } else {
                this.outputStream.write(String.format("%s=", name).getBytes());
            }
        }

        public void write(String format, Object ... args) throws IOException {
            if (!this.useUrlEncode) {
                if (this.firstWrite) {
                    this.outputStream.write("--".getBytes());
                    this.outputStream.write(GraphRequest.MIME_BOUNDARY.getBytes());
                    this.outputStream.write("\r\n".getBytes());
                    this.firstWrite = false;
                }
                this.outputStream.write(String.format(format, args).getBytes());
            } else {
                this.outputStream.write(URLEncoder.encode(String.format(Locale.US, format, args), "UTF-8").getBytes());
            }
        }

        public void writeLine(String format, Object ... args) throws IOException {
            this.write(format, args);
            if (!this.useUrlEncode) {
                this.write("\r\n", new Object[0]);
            }
        }
    }

    private static interface KeyValueSerializer {
        public void writeString(String var1, String var2) throws IOException;
    }

    private static class Attachment {
        private final GraphRequest request;
        private final Object value;

        public Attachment(GraphRequest request, Object value) {
            this.request = request;
            this.value = value;
        }

        public GraphRequest getRequest() {
            return this.request;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

