/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;
import java.util.ArrayList;
import java.util.List;

public final class SharePhoto
implements ShareModel {
    private final Bitmap bitmap;
    private final Uri imageUrl;
    private final boolean userGenerated;
    public static final Parcelable.Creator<SharePhoto> CREATOR = new Parcelable.Creator<SharePhoto>(){

        public SharePhoto createFromParcel(Parcel in) {
            return new SharePhoto(in);
        }

        public SharePhoto[] newArray(int size) {
            return new SharePhoto[size];
        }
    };

    private SharePhoto(Builder builder) {
        this.bitmap = builder.bitmap;
        this.imageUrl = builder.imageUrl;
        this.userGenerated = builder.userGenerated;
    }

    SharePhoto(Parcel in) {
        this.bitmap = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.imageUrl = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.userGenerated = in.readByte() != 0;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Nullable
    public Uri getImageUrl() {
        return this.imageUrl;
    }

    public boolean getUserGenerated() {
        return this.userGenerated;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.bitmap, 0);
        out.writeParcelable((Parcelable)this.imageUrl, 0);
        out.writeByte((byte)(this.userGenerated ? 1 : 0));
    }

    public static final class Builder
    implements ShareModelBuilder<SharePhoto, Builder> {
        private Bitmap bitmap;
        private Uri imageUrl;
        private boolean userGenerated;

        public Builder setBitmap(@Nullable Bitmap bitmap) {
            this.bitmap = bitmap;
            return this;
        }

        public Builder setImageUrl(@Nullable Uri imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder setUserGenerated(boolean userGenerated) {
            this.userGenerated = userGenerated;
            return this;
        }

        Uri getImageUrl() {
            return this.imageUrl;
        }

        Bitmap getBitmap() {
            return this.bitmap;
        }

        @Override
        public SharePhoto build() {
            return new SharePhoto(this);
        }

        @Override
        public Builder readFrom(SharePhoto model) {
            if (model == null) {
                return this;
            }
            return this.setBitmap(model.getBitmap()).setImageUrl(model.getImageUrl()).setUserGenerated(model.getUserGenerated());
        }

        @Override
        public Builder readFrom(Parcel parcel) {
            return this.readFrom((SharePhoto)parcel.readParcelable(SharePhoto.class.getClassLoader()));
        }

        public static void writeListTo(Parcel out, List<SharePhoto> photos) {
            ArrayList<SharePhoto> list = new ArrayList<SharePhoto>();
            for (SharePhoto photo : photos) {
                list.add(photo);
            }
            out.writeTypedList(list);
        }

        public static List<SharePhoto> readListFrom(Parcel in) {
            ArrayList<SharePhoto> list = new ArrayList<SharePhoto>();
            in.readTypedList(list, CREATOR);
            return list;
        }
    }
}

