/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import com.facebook.FacebookCallback;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogFeature;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.share.internal.LikeContent;
import com.facebook.share.internal.LikeDialogFeature;
import java.util.ArrayList;
import java.util.List;

public class LikeDialog
extends FacebookDialogBase<LikeContent, Result> {
    private static final String TAG = "LikeDialog";
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.Like.toRequestCode();

    public static boolean canShowNativeDialog() {
        return Build.VERSION.SDK_INT >= 14 && DialogPresenter.canPresentNativeDialogWithFeature(LikeDialog.getFeature());
    }

    public static boolean canShowWebFallback() {
        return Build.VERSION.SDK_INT >= 14 && DialogPresenter.canPresentWebFallbackDialogWithFeature(LikeDialog.getFeature());
    }

    LikeDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    LikeDialog(Fragment fragment) {
        super(fragment, DEFAULT_REQUEST_CODE);
    }

    @Override
    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode());
    }

    @Override
    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        ArrayList<FacebookDialogBase.ModeHandler> handlers = new ArrayList<FacebookDialogBase.ModeHandler>();
        handlers.add(new NativeHandler());
        handlers.add(new WebFallbackHandler());
        return handlers;
    }

    @Override
    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, FacebookCallback<Result> callback) {
        throw new UnsupportedOperationException("registerCallback is not supported for LikeDialog");
    }

    private static DialogFeature getFeature() {
        return LikeDialogFeature.LIKE_DIALOG;
    }

    private static Bundle createParameters(LikeContent likeContent) {
        Bundle params = new Bundle();
        params.putString("object_id", likeContent.getObjectId());
        params.putString("object_type", likeContent.getObjectType().toString());
        return params;
    }

    private class WebFallbackHandler
    extends FacebookDialogBase.ModeHandler {
        private WebFallbackHandler() {
        }

        public boolean canShow(LikeContent content) {
            return content != null && LikeDialog.canShowWebFallback();
        }

        public AppCall createAppCall(LikeContent content) {
            AppCall appCall = LikeDialog.this.createBaseAppCall();
            DialogPresenter.setupAppCallForWebFallbackDialog(appCall, LikeDialog.createParameters(content), LikeDialog.getFeature());
            return appCall;
        }
    }

    private class NativeHandler
    extends FacebookDialogBase.ModeHandler {
        private NativeHandler() {
        }

        public boolean canShow(LikeContent content) {
            return content != null && LikeDialog.canShowNativeDialog();
        }

        public AppCall createAppCall(final LikeContent content) {
            AppCall appCall = LikeDialog.this.createBaseAppCall();
            DialogPresenter.setupAppCallForNativeDialog(appCall, new DialogPresenter.ParameterProvider(){

                @Override
                public Bundle getParameters() {
                    return LikeDialog.createParameters(content);
                }

                @Override
                public Bundle getLegacyParameters() {
                    Log.e((String)LikeDialog.TAG, (String)"Attempting to present the Like Dialog with an outdated Facebook app on the device");
                    return new Bundle();
                }
            }, LikeDialog.getFeature());
            return appCall;
        }
    }

    public static final class Result {
    }
}

