/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.facebook.AccessToken;
import com.facebook.AccessTokenTracker;
import com.facebook.CallbackManager;
import com.facebook.FacebookButtonBase;
import com.facebook.FacebookCallback;
import com.facebook.Profile;
import com.facebook.R;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.LoginAuthorizationType;
import com.facebook.internal.Utility;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.login.widget.ToolTipPopup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LoginButton
extends FacebookButtonBase {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
    private static final String TAG = LoginButton.class.getName();
    private boolean confirmLogout;
    private String loginText;
    private String logoutText;
    private LoginButtonProperties properties = new LoginButtonProperties();
    private String loginLogoutEventName = "fb_login_view_usage";
    private boolean nuxChecked;
    private ToolTipPopup.Style nuxStyle = ToolTipPopup.Style.BLUE;
    private ToolTipMode nuxMode = ToolTipMode.DEFAULT;
    private long nuxDisplayTime = 6000L;
    private ToolTipPopup nuxPopup;
    private AccessTokenTracker accessTokenTracker;
    private LoginManager loginManager;

    public LoginButton(Context context) {
        super(context, null, 0, 0, "fb_login_button_create", DEFAULT_REQUEST_CODE);
    }

    public LoginButton(Context context, AttributeSet attrs) {
        super(context, attrs, 0, 0, "fb_login_button_create", DEFAULT_REQUEST_CODE);
    }

    public LoginButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, 0, "fb_login_button_create", DEFAULT_REQUEST_CODE);
    }

    public void setDefaultAudience(DefaultAudience defaultAudience) {
        this.properties.setDefaultAudience(defaultAudience);
    }

    public DefaultAudience getDefaultAudience() {
        return this.properties.getDefaultAudience();
    }

    public void setReadPermissions(List<String> permissions) {
        this.properties.setReadPermissions(permissions);
    }

    public void setReadPermissions(String ... permissions) {
        this.properties.setReadPermissions(Arrays.asList(permissions));
    }

    public void setPublishPermissions(List<String> permissions) {
        this.properties.setPublishPermissions(permissions);
    }

    public void setPublishPermissions(String ... permissions) {
        this.properties.setPublishPermissions(Arrays.asList(permissions));
    }

    public void clearPermissions() {
        this.properties.clearPermissions();
    }

    public void setLoginBehavior(LoginBehavior loginBehavior) {
        this.properties.setLoginBehavior(loginBehavior);
    }

    public LoginBehavior getLoginBehavior() {
        return this.properties.getLoginBehavior();
    }

    public void setToolTipStyle(ToolTipPopup.Style nuxStyle) {
        this.nuxStyle = nuxStyle;
    }

    public void setToolTipMode(ToolTipMode nuxMode) {
        this.nuxMode = nuxMode;
    }

    public ToolTipMode getToolTipMode() {
        return this.nuxMode;
    }

    public void setToolTipDisplayTime(long displayTime) {
        this.nuxDisplayTime = displayTime;
    }

    public long getToolTipDisplayTime() {
        return this.nuxDisplayTime;
    }

    public void dismissToolTip() {
        if (this.nuxPopup != null) {
            this.nuxPopup.dismiss();
            this.nuxPopup = null;
        }
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<LoginResult> callback) {
        this.getLoginManager().registerCallback(callbackManager, callback);
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<LoginResult> callback, int requestCode) {
        this.setRequestCode(requestCode);
        this.registerCallback(callbackManager, callback);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.accessTokenTracker != null && !this.accessTokenTracker.isTracking()) {
            this.accessTokenTracker.startTracking();
            this.setButtonText();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.nuxChecked && this.nuxMode != ToolTipMode.NEVER_DISPLAY && !this.isInEditMode()) {
            this.nuxChecked = true;
            this.checkNuxSettings();
        }
    }

    private void showNuxPerSettings(Utility.FetchedAppSettings settings) {
        if (settings != null && settings.getNuxEnabled() && this.getVisibility() == 0) {
            String nuxString = settings.getNuxContent();
            this.displayNux(nuxString);
        }
    }

    private void displayNux(String nuxString) {
        this.nuxPopup = new ToolTipPopup(nuxString, (View)this);
        this.nuxPopup.setStyle(this.nuxStyle);
        this.nuxPopup.setNuxDisplayTime(this.nuxDisplayTime);
        this.nuxPopup.show();
    }

    private void checkNuxSettings() {
        if (this.nuxMode == ToolTipMode.DISPLAY_ALWAYS) {
            String nuxString = this.getResources().getString(R.string.com_facebook_tooltip_default);
            this.displayNux(nuxString);
        } else {
            final String appId = Utility.getMetadataApplicationId(this.getContext());
            AsyncTask<Void, Void, Utility.FetchedAppSettings> task = new AsyncTask<Void, Void, Utility.FetchedAppSettings>(){

                protected Utility.FetchedAppSettings doInBackground(Void ... params) {
                    Utility.FetchedAppSettings settings = Utility.queryAppSettings(appId, false);
                    return settings;
                }

                protected void onPostExecute(Utility.FetchedAppSettings result) {
                    LoginButton.this.showNuxPerSettings(result);
                }
            };
            task.execute((Object[])null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setButtonText();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.accessTokenTracker != null) {
            this.accessTokenTracker.stopTracking();
        }
        this.dismissToolTip();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.dismissToolTip();
        }
    }

    List<String> getPermissions() {
        return this.properties.getPermissions();
    }

    void setProperties(LoginButtonProperties properties) {
        this.properties = properties;
    }

    @Override
    protected void configureButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super.configureButton(context, attrs, defStyleAttr, defStyleRes);
        this.setInternalOnClickListener(new LoginClickListener());
        this.parseLoginButtonAttributes(context, attrs, defStyleAttr, defStyleRes);
        if (this.isInEditMode()) {
            this.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
            this.loginText = "Log in with Facebook";
        } else {
            this.accessTokenTracker = new AccessTokenTracker(){

                @Override
                protected void onCurrentAccessTokenChanged(AccessToken oldAccessToken, AccessToken currentAccessToken) {
                    LoginButton.this.setButtonText();
                }
            };
        }
        this.setButtonText();
    }

    @Override
    protected int getDefaultStyleResource() {
        return R.style.com_facebook_loginview_default_style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLoginButtonAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.com_facebook_login_view, defStyleAttr, defStyleRes);
        try {
            this.confirmLogout = a.getBoolean(R.styleable.com_facebook_login_view_confirm_logout, true);
            this.loginText = a.getString(R.styleable.com_facebook_login_view_login_text);
            this.logoutText = a.getString(R.styleable.com_facebook_login_view_logout_text);
        }
        finally {
            a.recycle();
        }
    }

    private void setButtonText() {
        Resources resources = this.getResources();
        if (AccessToken.getCurrentAccessToken() != null) {
            this.setText(this.logoutText != null ? this.logoutText : resources.getString(R.string.com_facebook_loginview_log_out_button));
        } else if (this.loginText != null) {
            this.setText(this.loginText);
        } else {
            String text = resources.getString(R.string.com_facebook_loginview_log_in_button_long);
            int width = this.getWidth();
            if (width != 0) {
                Paint p = new Paint();
                p.setTextSize(this.getTextSize());
                p.setTypeface(this.getTypeface());
                float textWidth = p.measureText(text);
                if (textWidth > (float)width) {
                    text = resources.getString(R.string.com_facebook_loginview_log_in_button);
                }
            }
            this.setText(text);
        }
    }

    LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = LoginManager.getInstance();
        }
        return this.loginManager;
    }

    void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        public void onClick(View v) {
            Context context = LoginButton.this.getContext();
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            if (accessToken != null) {
                if (LoginButton.this.confirmLogout) {
                    String logout = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_log_out_action);
                    String cancel = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_cancel_action);
                    Profile profile = Profile.getCurrentProfile();
                    String message = profile != null && profile.getName() != null ? String.format(LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_as), profile.getName()) : LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_using_facebook);
                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    builder.setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)logout, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            LoginButton.this.getLoginManager().logOut();
                        }
                    }).setNegativeButton((CharSequence)cancel, null);
                    builder.create().show();
                } else {
                    LoginButton.this.getLoginManager().logOut();
                }
            } else {
                LoginManager loginManager = LoginButton.this.getLoginManager();
                loginManager.setDefaultAudience(LoginButton.this.getDefaultAudience());
                loginManager.setLoginBehavior(LoginButton.this.getLoginBehavior());
                if (LoginAuthorizationType.PUBLISH.equals((Object)LoginButton.this.properties.authorizationType)) {
                    if (LoginButton.this.getFragment() != null) {
                        loginManager.logInWithPublishPermissions(LoginButton.this.getFragment(), (Collection<String>)LoginButton.this.properties.permissions);
                    } else {
                        loginManager.logInWithPublishPermissions(LoginButton.this.getActivity(), (Collection<String>)LoginButton.this.properties.permissions);
                    }
                } else if (LoginButton.this.getFragment() != null) {
                    loginManager.logInWithReadPermissions(LoginButton.this.getFragment(), (Collection<String>)LoginButton.this.properties.permissions);
                } else {
                    loginManager.logInWithReadPermissions(LoginButton.this.getActivity(), (Collection<String>)LoginButton.this.properties.permissions);
                }
            }
            AppEventsLogger logger = AppEventsLogger.newLogger(LoginButton.this.getContext());
            Bundle parameters = new Bundle();
            parameters.putInt("logging_in", accessToken != null ? 0 : 1);
            logger.logSdkEvent(LoginButton.this.loginLogoutEventName, null, parameters);
            LoginButton.this.callExternalOnClickListener(v);
        }
    }

    static class LoginButtonProperties {
        private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
        private List<String> permissions = Collections.emptyList();
        private LoginAuthorizationType authorizationType = null;
        private LoginBehavior loginBehavior = LoginBehavior.SSO_WITH_FALLBACK;

        LoginButtonProperties() {
        }

        public void setDefaultAudience(DefaultAudience defaultAudience) {
            this.defaultAudience = defaultAudience;
        }

        public DefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        public void setReadPermissions(List<String> permissions) {
            if (LoginAuthorizationType.PUBLISH.equals((Object)this.authorizationType)) {
                throw new UnsupportedOperationException("Cannot call setReadPermissions after setPublishPermissions has been called.");
            }
            if (this.validatePermissions(permissions, LoginAuthorizationType.READ)) {
                this.permissions = permissions;
                this.authorizationType = LoginAuthorizationType.READ;
            }
        }

        public void setPublishPermissions(List<String> permissions) {
            if (LoginAuthorizationType.READ.equals((Object)this.authorizationType)) {
                throw new UnsupportedOperationException("Cannot call setPublishPermissions after setReadPermissions has been called.");
            }
            if (this.validatePermissions(permissions, LoginAuthorizationType.PUBLISH)) {
                this.permissions = permissions;
                this.authorizationType = LoginAuthorizationType.PUBLISH;
            }
        }

        private boolean validatePermissions(List<String> permissions, LoginAuthorizationType authType) {
            if (LoginAuthorizationType.PUBLISH.equals((Object)authType) && Utility.isNullOrEmpty(permissions)) {
                throw new IllegalArgumentException("Permissions for publish actions cannot be null or empty.");
            }
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            if (accessToken != null && !Utility.isSubset(permissions, accessToken.getPermissions())) {
                Log.e((String)TAG, (String)"Cannot set additional permissions with existing AccessToken.");
                return false;
            }
            return true;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        public void clearPermissions() {
            this.permissions = null;
            this.authorizationType = null;
        }

        public void setLoginBehavior(LoginBehavior loginBehavior) {
            this.loginBehavior = loginBehavior;
        }

        public LoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }
    }

    public static enum ToolTipMode {
        DEFAULT,
        DISPLAY_ALWAYS,
        NEVER_DISPLAY;

    }
}

