/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookRequestError;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.Settings;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.FacebookWebFallbackDialog;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.LikeStatusClient;
import com.facebook.internal.Logger;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PendingCallStore;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.Utility;
import com.facebook.internal.WorkQueue;
import com.facebook.widget.FacebookDialog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LikeActionController {
    public static final String ACTION_LIKE_ACTION_CONTROLLER_UPDATED = "com.facebook.sdk.LikeActionController.UPDATED";
    public static final String ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR = "com.facebook.sdk.LikeActionController.DID_ERROR";
    public static final String ACTION_LIKE_ACTION_CONTROLLER_DID_RESET = "com.facebook.sdk.LikeActionController.DID_RESET";
    public static final String ACTION_OBJECT_ID_KEY = "com.facebook.sdk.LikeActionController.OBJECT_ID";
    public static final String ERROR_INVALID_OBJECT_ID = "Invalid Object Id";
    public static final String ERROR_PUBLISH_ERROR = "Unable to publish the like/unlike action";
    private static final String TAG = LikeActionController.class.getSimpleName();
    private static final int LIKE_ACTION_CONTROLLER_VERSION = 2;
    private static final int MAX_CACHE_SIZE = 128;
    private static final int MAX_OBJECT_SUFFIX = 1000;
    private static final String LIKE_ACTION_CONTROLLER_STORE = "com.facebook.LikeActionController.CONTROLLER_STORE_KEY";
    private static final String LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY = "PENDING_CONTROLLER_KEY";
    private static final String LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY = "OBJECT_SUFFIX";
    private static final String JSON_INT_VERSION_KEY = "com.facebook.internal.LikeActionController.version";
    private static final String JSON_STRING_OBJECT_ID_KEY = "object_id";
    private static final String JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY = "like_count_string_with_like";
    private static final String JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY = "like_count_string_without_like";
    private static final String JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY = "social_sentence_with_like";
    private static final String JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY = "social_sentence_without_like";
    private static final String JSON_BOOL_IS_OBJECT_LIKED_KEY = "is_object_liked";
    private static final String JSON_STRING_UNLIKE_TOKEN_KEY = "unlike_token";
    private static final String JSON_STRING_PENDING_CALL_ID_KEY = "pending_call_id";
    private static final String JSON_BUNDLE_PENDING_CALL_ANALYTICS_BUNDLE = "pending_call_analytics_bundle";
    private static final String LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY = "object_is_liked";
    private static final String LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY = "like_count_string";
    private static final String LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY = "social_sentence";
    private static final String LIKE_DIALOG_RESPONSE_UNLIKE_TOKEN_KEY = "unlike_token";
    private static final int ERROR_CODE_OBJECT_ALREADY_LIKED = 3501;
    private static FileLruCache controllerDiskCache;
    private static final ConcurrentHashMap<String, LikeActionController> cache;
    private static WorkQueue mruCacheWorkQueue;
    private static WorkQueue diskIOWorkQueue;
    private static Handler handler;
    private static String objectIdForPendingController;
    private static boolean isPendingBroadcastReset;
    private static boolean isInitialized;
    private static volatile int objectSuffix;
    private static Context applicationContext;
    private Session session;
    private String objectId;
    private boolean isObjectLiked;
    private String likeCountStringWithLike;
    private String likeCountStringWithoutLike;
    private String socialSentenceWithLike;
    private String socialSentenceWithoutLike;
    private String unlikeToken;
    private String verifiedObjectId;
    private boolean objectIsPage;
    private boolean isObjectLikedOnServer;
    private boolean isPendingLikeOrUnlike;
    private UUID pendingCallId;
    private Bundle pendingCallAnalyticsBundle;
    private AppEventsLogger appEventsLogger;

    public static boolean handleOnActivityResult(Context context, final int requestCode, final int resultCode, final Intent data) {
        LikeActionController.ensureApplicationContextExists(context);
        final UUID callId = NativeProtocol.getCallIdFromIntent(data);
        if (callId == null) {
            return false;
        }
        if (Utility.isNullOrEmpty(objectIdForPendingController)) {
            SharedPreferences sharedPreferences = applicationContext.getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0);
            objectIdForPendingController = sharedPreferences.getString(LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY, null);
        }
        if (Utility.isNullOrEmpty(objectIdForPendingController)) {
            return false;
        }
        LikeActionController.getControllerForObjectId(applicationContext, objectIdForPendingController, new CreationCallback(){

            @Override
            public void onComplete(LikeActionController likeActionController) {
                likeActionController.onActivityResult(requestCode, resultCode, data, callId);
            }
        });
        return true;
    }

    public static void getControllerForObjectId(Context context, String objectId, CreationCallback callback) {
        LikeActionController controllerForObject;
        LikeActionController.ensureApplicationContextExists(context);
        if (!isInitialized) {
            LikeActionController.performFirstInitialize();
        }
        if ((controllerForObject = LikeActionController.getControllerFromInMemoryCache(objectId)) != null) {
            LikeActionController.invokeCallbackWithController(callback, controllerForObject);
        } else {
            diskIOWorkQueue.addActiveWorkItem(new CreateLikeActionControllerWorkItem(objectId, callback));
        }
    }

    private static void createControllerForObjectId(String objectId, CreationCallback callback) {
        LikeActionController controllerForObject = LikeActionController.getControllerFromInMemoryCache(objectId);
        if (controllerForObject != null) {
            LikeActionController.invokeCallbackWithController(callback, controllerForObject);
            return;
        }
        controllerForObject = LikeActionController.deserializeFromDiskSynchronously(objectId);
        if (controllerForObject == null) {
            controllerForObject = new LikeActionController(Session.getActiveSession(), objectId);
            LikeActionController.serializeToDiskAsync(controllerForObject);
        }
        LikeActionController.putControllerInMemoryCache(objectId, controllerForObject);
        final LikeActionController controllerToRefresh = controllerForObject;
        handler.post(new Runnable(){

            @Override
            public void run() {
                controllerToRefresh.refreshStatusAsync();
            }
        });
        LikeActionController.invokeCallbackWithController(callback, controllerToRefresh);
    }

    private static synchronized void ensureApplicationContextExists(Context context) {
        if (applicationContext == null) {
            applicationContext = context.getApplicationContext();
        }
    }

    private static synchronized void performFirstInitialize() {
        if (isInitialized) {
            return;
        }
        handler = new Handler(Looper.getMainLooper());
        SharedPreferences sharedPreferences = applicationContext.getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0);
        objectSuffix = sharedPreferences.getInt(LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY, 1);
        controllerDiskCache = new FileLruCache(applicationContext, TAG, new FileLruCache.Limits());
        LikeActionController.registerSessionBroadcastReceivers();
        isInitialized = true;
    }

    private static void invokeCallbackWithController(final CreationCallback callback, final LikeActionController controller) {
        if (callback == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onComplete(controller);
            }
        });
    }

    private static void registerSessionBroadcastReceivers() {
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_UNSET");
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_CLOSED");
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_OPENED");
        broadcastManager.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context receiverContext, Intent intent) {
                if (isPendingBroadcastReset) {
                    return;
                }
                String action = intent.getAction();
                final boolean shouldClearDisk = Utility.areObjectsEqual("com.facebook.sdk.ACTIVE_SESSION_UNSET", action) || Utility.areObjectsEqual("com.facebook.sdk.ACTIVE_SESSION_CLOSED", action);
                isPendingBroadcastReset = true;
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (shouldClearDisk) {
                            objectSuffix = (objectSuffix + 1) % 1000;
                            applicationContext.getSharedPreferences(LikeActionController.LIKE_ACTION_CONTROLLER_STORE, 0).edit().putInt(LikeActionController.LIKE_ACTION_CONTROLLER_STORE_OBJECT_SUFFIX_KEY, objectSuffix).apply();
                            cache.clear();
                            controllerDiskCache.clearCache();
                        }
                        LikeActionController.broadcastAction(null, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_RESET);
                        isPendingBroadcastReset = false;
                    }
                }, 100L);
            }
        }, filter);
    }

    private static void putControllerInMemoryCache(String objectId, LikeActionController controllerForObject) {
        String cacheKey = LikeActionController.getCacheKeyForObjectId(objectId);
        mruCacheWorkQueue.addActiveWorkItem(new MRUCacheWorkItem(cacheKey, true));
        cache.put(cacheKey, controllerForObject);
    }

    private static LikeActionController getControllerFromInMemoryCache(String objectId) {
        String cacheKey = LikeActionController.getCacheKeyForObjectId(objectId);
        LikeActionController controller = cache.get(cacheKey);
        if (controller != null) {
            mruCacheWorkQueue.addActiveWorkItem(new MRUCacheWorkItem(cacheKey, false));
        }
        return controller;
    }

    private static void serializeToDiskAsync(LikeActionController controller) {
        String controllerJson = LikeActionController.serializeToJson(controller);
        String cacheKey = LikeActionController.getCacheKeyForObjectId(controller.objectId);
        if (!Utility.isNullOrEmpty(controllerJson) && !Utility.isNullOrEmpty(cacheKey)) {
            diskIOWorkQueue.addActiveWorkItem(new SerializeToDiskWorkItem(cacheKey, controllerJson));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeToDiskSynchronously(String cacheKey, String controllerJson) {
        OutputStream outputStream = null;
        try {
            outputStream = controllerDiskCache.openPutStream(cacheKey);
            outputStream.write(controllerJson.getBytes());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Unable to serialize controller to disk", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                Utility.closeQuietly(outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LikeActionController deserializeFromDiskSynchronously(String objectId) {
        LikeActionController controller = null;
        InputStream inputStream = null;
        try {
            String controllerJsonString;
            String cacheKey = LikeActionController.getCacheKeyForObjectId(objectId);
            inputStream = controllerDiskCache.get(cacheKey);
            if (inputStream != null && !Utility.isNullOrEmpty(controllerJsonString = Utility.readStreamToString(inputStream))) {
                controller = LikeActionController.deserializeFromJson(controllerJsonString);
            }
            if (inputStream == null) return controller;
        }
        catch (IOException e) {
            try {
                Log.e((String)TAG, (String)"Unable to deserialize controller from disk", (Throwable)e);
                controller = null;
                if (inputStream == null) return controller;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                Utility.closeQuietly(inputStream);
                throw throwable;
            }
            Utility.closeQuietly(inputStream);
            return controller;
        }
        Utility.closeQuietly(inputStream);
        return controller;
    }

    private static LikeActionController deserializeFromJson(String controllerJsonString) {
        LikeActionController controller;
        try {
            JSONObject analyticsJSON;
            JSONObject controllerJson = new JSONObject(controllerJsonString);
            int version = controllerJson.optInt(JSON_INT_VERSION_KEY, -1);
            if (version != 2) {
                return null;
            }
            controller = new LikeActionController(Session.getActiveSession(), controllerJson.getString(JSON_STRING_OBJECT_ID_KEY));
            controller.likeCountStringWithLike = controllerJson.optString(JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY, null);
            controller.likeCountStringWithoutLike = controllerJson.optString(JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY, null);
            controller.socialSentenceWithLike = controllerJson.optString(JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, null);
            controller.socialSentenceWithoutLike = controllerJson.optString(JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, null);
            controller.isObjectLiked = controllerJson.optBoolean(JSON_BOOL_IS_OBJECT_LIKED_KEY);
            controller.unlikeToken = controllerJson.optString("unlike_token", null);
            String pendingCallIdString = controllerJson.optString(JSON_STRING_PENDING_CALL_ID_KEY, null);
            if (!Utility.isNullOrEmpty(pendingCallIdString)) {
                controller.pendingCallId = UUID.fromString(pendingCallIdString);
            }
            if ((analyticsJSON = controllerJson.optJSONObject(JSON_BUNDLE_PENDING_CALL_ANALYTICS_BUNDLE)) != null) {
                controller.pendingCallAnalyticsBundle = BundleJSONConverter.convertToBundle(analyticsJSON);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Unable to deserialize controller from JSON", (Throwable)e);
            controller = null;
        }
        return controller;
    }

    private static String serializeToJson(LikeActionController controller) {
        JSONObject controllerJson = new JSONObject();
        try {
            JSONObject analyticsJSON;
            controllerJson.put(JSON_INT_VERSION_KEY, 2);
            controllerJson.put(JSON_STRING_OBJECT_ID_KEY, (Object)controller.objectId);
            controllerJson.put(JSON_STRING_LIKE_COUNT_WITH_LIKE_KEY, (Object)controller.likeCountStringWithLike);
            controllerJson.put(JSON_STRING_LIKE_COUNT_WITHOUT_LIKE_KEY, (Object)controller.likeCountStringWithoutLike);
            controllerJson.put(JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, (Object)controller.socialSentenceWithLike);
            controllerJson.put(JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, (Object)controller.socialSentenceWithoutLike);
            controllerJson.put(JSON_BOOL_IS_OBJECT_LIKED_KEY, controller.isObjectLiked);
            controllerJson.put("unlike_token", (Object)controller.unlikeToken);
            if (controller.pendingCallId != null) {
                controllerJson.put(JSON_STRING_PENDING_CALL_ID_KEY, (Object)controller.pendingCallId.toString());
            }
            if (controller.pendingCallAnalyticsBundle != null && (analyticsJSON = BundleJSONConverter.convertToJSON(controller.pendingCallAnalyticsBundle)) != null) {
                controllerJson.put(JSON_BUNDLE_PENDING_CALL_ANALYTICS_BUNDLE, (Object)analyticsJSON);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Unable to serialize controller to JSON", (Throwable)e);
            return null;
        }
        return controllerJson.toString();
    }

    private static String getCacheKeyForObjectId(String objectId) {
        String accessTokenPortion = null;
        Session activeSession = Session.getActiveSession();
        if (activeSession != null && activeSession.isOpened()) {
            accessTokenPortion = activeSession.getAccessToken();
        }
        if (accessTokenPortion != null) {
            accessTokenPortion = Utility.md5hash(accessTokenPortion);
        }
        return String.format("%s|%s|com.fb.sdk.like|%d", objectId, Utility.coerceValueIfNullOrEmpty(accessTokenPortion, ""), objectSuffix);
    }

    private static void broadcastAction(LikeActionController controller, String action) {
        LikeActionController.broadcastAction(controller, action, null);
    }

    private static void broadcastAction(LikeActionController controller, String action, Bundle data) {
        Intent broadcastIntent = new Intent(action);
        if (controller != null) {
            if (data == null) {
                data = new Bundle();
            }
            data.putString(ACTION_OBJECT_ID_KEY, controller.getObjectId());
        }
        if (data != null) {
            broadcastIntent.putExtras(data);
        }
        LocalBroadcastManager.getInstance((Context)applicationContext).sendBroadcast(broadcastIntent);
    }

    private LikeActionController(Session session, String objectId) {
        this.session = session;
        this.objectId = objectId;
        this.appEventsLogger = AppEventsLogger.newLogger(applicationContext, session);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getLikeCountString() {
        return this.isObjectLiked ? this.likeCountStringWithLike : this.likeCountStringWithoutLike;
    }

    public String getSocialSentence() {
        return this.isObjectLiked ? this.socialSentenceWithLike : this.socialSentenceWithoutLike;
    }

    public boolean isObjectLiked() {
        return this.isObjectLiked;
    }

    public void toggleLike(Activity activity, Fragment fragment, Bundle analyticsParameters) {
        boolean shouldLikeObject;
        this.appEventsLogger.logSdkEvent("fb_like_control_did_tap", null, analyticsParameters);
        boolean bl = shouldLikeObject = !this.isObjectLiked;
        if (this.canUseOGPublish()) {
            this.updateLikeState(shouldLikeObject);
            if (this.isPendingLikeOrUnlike) {
                this.appEventsLogger.logSdkEvent("fb_like_control_did_undo_quickly", null, analyticsParameters);
            } else if (!this.publishLikeOrUnlikeAsync(shouldLikeObject, analyticsParameters)) {
                this.updateLikeState(!shouldLikeObject);
                this.presentLikeDialog(activity, fragment, analyticsParameters);
            }
        } else {
            this.presentLikeDialog(activity, fragment, analyticsParameters);
        }
    }

    private boolean publishLikeOrUnlikeAsync(boolean shouldLikeObject, Bundle analyticsParameters) {
        boolean requested = false;
        if (this.canUseOGPublish()) {
            if (shouldLikeObject) {
                requested = true;
                this.publishLikeAsync(analyticsParameters);
            } else if (!Utility.isNullOrEmpty(this.unlikeToken)) {
                requested = true;
                this.publishUnlikeAsync(analyticsParameters);
            }
        }
        return requested;
    }

    private void publishDidError(boolean oldLikeState) {
        this.updateLikeState(oldLikeState);
        Bundle errorBundle = new Bundle();
        errorBundle.putString("com.facebook.platform.status.ERROR_DESCRIPTION", ERROR_PUBLISH_ERROR);
        LikeActionController.broadcastAction(this, ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, errorBundle);
    }

    private void updateLikeState(boolean isObjectLiked) {
        this.updateState(isObjectLiked, this.likeCountStringWithLike, this.likeCountStringWithoutLike, this.socialSentenceWithLike, this.socialSentenceWithoutLike, this.unlikeToken);
    }

    private void updateState(boolean isObjectLiked, String likeCountStringWithLike, String likeCountStringWithoutLike, String socialSentenceWithLike, String socialSentenceWithoutLike, String unlikeToken) {
        boolean stateChanged;
        likeCountStringWithLike = Utility.coerceValueIfNullOrEmpty(likeCountStringWithLike, null);
        likeCountStringWithoutLike = Utility.coerceValueIfNullOrEmpty(likeCountStringWithoutLike, null);
        socialSentenceWithLike = Utility.coerceValueIfNullOrEmpty(socialSentenceWithLike, null);
        socialSentenceWithoutLike = Utility.coerceValueIfNullOrEmpty(socialSentenceWithoutLike, null);
        unlikeToken = Utility.coerceValueIfNullOrEmpty(unlikeToken, null);
        boolean bl = stateChanged = isObjectLiked != this.isObjectLiked || !Utility.areObjectsEqual(likeCountStringWithLike, this.likeCountStringWithLike) || !Utility.areObjectsEqual(likeCountStringWithoutLike, this.likeCountStringWithoutLike) || !Utility.areObjectsEqual(socialSentenceWithLike, this.socialSentenceWithLike) || !Utility.areObjectsEqual(socialSentenceWithoutLike, this.socialSentenceWithoutLike) || !Utility.areObjectsEqual(unlikeToken, this.unlikeToken);
        if (!stateChanged) {
            return;
        }
        this.isObjectLiked = isObjectLiked;
        this.likeCountStringWithLike = likeCountStringWithLike;
        this.likeCountStringWithoutLike = likeCountStringWithoutLike;
        this.socialSentenceWithLike = socialSentenceWithLike;
        this.socialSentenceWithoutLike = socialSentenceWithoutLike;
        this.unlikeToken = unlikeToken;
        LikeActionController.serializeToDiskAsync(this);
        LikeActionController.broadcastAction(this, ACTION_LIKE_ACTION_CONTROLLER_UPDATED);
    }

    private void presentLikeDialog(Activity activity, Fragment fragment, Bundle analyticsParameters) {
        LikeDialogBuilder likeDialogBuilder = new LikeDialogBuilder(activity, this.objectId);
        likeDialogBuilder.setFragment(fragment);
        if (likeDialogBuilder.canPresent()) {
            this.trackPendingCall(likeDialogBuilder.build().present(), analyticsParameters);
            this.appEventsLogger.logSdkEvent("fb_like_control_did_present_dialog", null, analyticsParameters);
        } else {
            boolean webFallbackShown;
            String webFallbackUrl = likeDialogBuilder.getWebFallbackUrl();
            if (!Utility.isNullOrEmpty(webFallbackUrl) && (webFallbackShown = FacebookWebFallbackDialog.presentWebFallback((Context)activity, webFallbackUrl, likeDialogBuilder.getApplicationId(), likeDialogBuilder.getAppCall(), this.getFacebookDialogCallback(analyticsParameters)))) {
                this.appEventsLogger.logSdkEvent("fb_like_control_did_present_fallback_dialog", null, analyticsParameters);
            }
        }
    }

    private boolean onActivityResult(int requestCode, int resultCode, Intent data, UUID callId) {
        if (this.pendingCallId == null || !this.pendingCallId.equals(callId)) {
            return false;
        }
        FacebookDialog.PendingCall pendingCall = PendingCallStore.getInstance().getPendingCallById(this.pendingCallId);
        if (pendingCall == null) {
            return false;
        }
        FacebookDialog.handleActivityResult(applicationContext, pendingCall, requestCode, data, this.getFacebookDialogCallback(this.pendingCallAnalyticsBundle));
        this.stopTrackingPendingCall();
        return true;
    }

    private FacebookDialog.Callback getFacebookDialogCallback(final Bundle analyticsParameters) {
        return new FacebookDialog.Callback(){

            @Override
            public void onComplete(FacebookDialog.PendingCall pendingCall, Bundle data) {
                if (data == null || !data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY)) {
                    return;
                }
                boolean isObjectLiked = data.getBoolean(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY);
                String likeCountStringWithLike = LikeActionController.this.likeCountStringWithLike;
                String likeCountStringWithoutLike = LikeActionController.this.likeCountStringWithoutLike;
                if (data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY)) {
                    likeCountStringWithoutLike = likeCountStringWithLike = data.getString(LikeActionController.LIKE_DIALOG_RESPONSE_LIKE_COUNT_STRING_KEY);
                }
                String socialSentenceWithLike = LikeActionController.this.socialSentenceWithLike;
                String socialSentenceWithoutWithoutLike = LikeActionController.this.socialSentenceWithoutLike;
                if (data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY)) {
                    socialSentenceWithoutWithoutLike = socialSentenceWithLike = data.getString(LikeActionController.LIKE_DIALOG_RESPONSE_SOCIAL_SENTENCE_KEY);
                }
                String unlikeToken = data.containsKey(LikeActionController.LIKE_DIALOG_RESPONSE_OBJECT_IS_LIKED_KEY) ? data.getString("unlike_token") : LikeActionController.this.unlikeToken;
                Bundle logParams = analyticsParameters == null ? new Bundle() : analyticsParameters;
                logParams.putString("call_id", pendingCall.getCallId().toString());
                LikeActionController.this.appEventsLogger.logSdkEvent("fb_like_control_dialog_did_succeed", null, logParams);
                LikeActionController.this.updateState(isObjectLiked, likeCountStringWithLike, likeCountStringWithoutLike, socialSentenceWithLike, socialSentenceWithoutWithoutLike, unlikeToken);
            }

            @Override
            public void onError(FacebookDialog.PendingCall pendingCall, Exception error, Bundle data) {
                Logger.log(LoggingBehavior.REQUESTS, TAG, "Like Dialog failed with error : %s", error);
                Bundle logParams = analyticsParameters == null ? new Bundle() : analyticsParameters;
                logParams.putString("call_id", pendingCall.getCallId().toString());
                LikeActionController.this.logAppEventForError("present_dialog", logParams);
                LikeActionController.broadcastAction(LikeActionController.this, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, data);
            }
        };
    }

    private void trackPendingCall(FacebookDialog.PendingCall pendingCall, Bundle analyticsParameters) {
        PendingCallStore.getInstance().trackPendingCall(pendingCall);
        this.pendingCallId = pendingCall.getCallId();
        this.storeObjectIdForPendingController(this.objectId);
        this.pendingCallAnalyticsBundle = analyticsParameters;
        LikeActionController.serializeToDiskAsync(this);
    }

    private void stopTrackingPendingCall() {
        PendingCallStore.getInstance().stopTrackingPendingCall(this.pendingCallId);
        this.pendingCallId = null;
        this.pendingCallAnalyticsBundle = null;
        this.storeObjectIdForPendingController(null);
    }

    private void storeObjectIdForPendingController(String objectId) {
        objectIdForPendingController = objectId;
        applicationContext.getSharedPreferences(LIKE_ACTION_CONTROLLER_STORE, 0).edit().putString(LIKE_ACTION_CONTROLLER_STORE_PENDING_OBJECT_ID_KEY, objectIdForPendingController).apply();
    }

    private boolean canUseOGPublish() {
        return !this.objectIsPage && this.verifiedObjectId != null && this.session != null && this.session.getPermissions() != null && this.session.getPermissions().contains("publish_actions");
    }

    private void publishLikeAsync(final Bundle analyticsParameters) {
        this.isPendingLikeOrUnlike = true;
        this.fetchVerifiedObjectId(new RequestCompletionCallback(){

            @Override
            public void onComplete() {
                if (Utility.isNullOrEmpty(LikeActionController.this.verifiedObjectId)) {
                    Bundle errorBundle = new Bundle();
                    errorBundle.putString("com.facebook.platform.status.ERROR_DESCRIPTION", LikeActionController.ERROR_INVALID_OBJECT_ID);
                    LikeActionController.broadcastAction(LikeActionController.this, LikeActionController.ACTION_LIKE_ACTION_CONTROLLER_DID_ERROR, errorBundle);
                    return;
                }
                RequestBatch requestBatch = new RequestBatch();
                final PublishLikeRequestWrapper likeRequest = new PublishLikeRequestWrapper(LikeActionController.this.verifiedObjectId);
                likeRequest.addToBatch(requestBatch);
                requestBatch.addCallback(new RequestBatch.Callback(){

                    @Override
                    public void onBatchCompleted(RequestBatch batch) {
                        LikeActionController.this.isPendingLikeOrUnlike = false;
                        if (likeRequest.error != null) {
                            LikeActionController.this.publishDidError(false);
                        } else {
                            LikeActionController.this.unlikeToken = Utility.coerceValueIfNullOrEmpty(likeRequest.unlikeToken, null);
                            LikeActionController.this.isObjectLikedOnServer = true;
                            LikeActionController.this.appEventsLogger.logSdkEvent("fb_like_control_did_like", null, analyticsParameters);
                            LikeActionController.this.publishAgainIfNeeded(analyticsParameters);
                        }
                    }
                });
                requestBatch.executeAsync();
            }
        });
    }

    private void publishUnlikeAsync(final Bundle analyticsParameters) {
        this.isPendingLikeOrUnlike = true;
        RequestBatch requestBatch = new RequestBatch();
        final PublishUnlikeRequestWrapper unlikeRequest = new PublishUnlikeRequestWrapper(this.unlikeToken);
        unlikeRequest.addToBatch(requestBatch);
        requestBatch.addCallback(new RequestBatch.Callback(){

            @Override
            public void onBatchCompleted(RequestBatch batch) {
                LikeActionController.this.isPendingLikeOrUnlike = false;
                if (unlikeRequest.error != null) {
                    LikeActionController.this.publishDidError(true);
                } else {
                    LikeActionController.this.unlikeToken = null;
                    LikeActionController.this.isObjectLikedOnServer = false;
                    LikeActionController.this.appEventsLogger.logSdkEvent("fb_like_control_did_unlike", null, analyticsParameters);
                    LikeActionController.this.publishAgainIfNeeded(analyticsParameters);
                }
            }
        });
        requestBatch.executeAsync();
    }

    private void refreshStatusAsync() {
        if (this.session == null || this.session.isClosed() || SessionState.CREATED.equals((Object)this.session.getState())) {
            this.refreshStatusViaService();
            return;
        }
        if (!this.session.isOpened()) {
            return;
        }
        this.fetchVerifiedObjectId(new RequestCompletionCallback(){

            @Override
            public void onComplete() {
                final GetOGObjectLikesRequestWrapper objectLikesRequest = new GetOGObjectLikesRequestWrapper(LikeActionController.this.verifiedObjectId);
                final GetEngagementRequestWrapper engagementRequest = new GetEngagementRequestWrapper(LikeActionController.this.verifiedObjectId);
                RequestBatch requestBatch = new RequestBatch();
                objectLikesRequest.addToBatch(requestBatch);
                engagementRequest.addToBatch(requestBatch);
                requestBatch.addCallback(new RequestBatch.Callback(){

                    @Override
                    public void onBatchCompleted(RequestBatch batch) {
                        if (objectLikesRequest.error != null || engagementRequest.error != null) {
                            Logger.log(LoggingBehavior.REQUESTS, TAG, "Unable to refresh like state for id: '%s'", LikeActionController.this.objectId);
                            return;
                        }
                        LikeActionController.this.updateState(objectLikesRequest.objectIsLiked, engagementRequest.likeCountStringWithLike, engagementRequest.likeCountStringWithoutLike, engagementRequest.socialSentenceStringWithLike, engagementRequest.socialSentenceStringWithoutLike, objectLikesRequest.unlikeToken);
                    }
                });
                requestBatch.executeAsync();
            }
        });
    }

    private void refreshStatusViaService() {
        LikeStatusClient likeStatusClient = new LikeStatusClient(applicationContext, Settings.getApplicationId(), this.objectId);
        if (!likeStatusClient.start()) {
            return;
        }
        PlatformServiceClient.CompletedListener callback = new PlatformServiceClient.CompletedListener(){

            @Override
            public void completed(Bundle result) {
                if (result == null || !result.containsKey("com.facebook.platform.extra.OBJECT_IS_LIKED")) {
                    return;
                }
                boolean objectIsLiked = result.getBoolean("com.facebook.platform.extra.OBJECT_IS_LIKED");
                String likeCountWithLike = result.containsKey("com.facebook.platform.extra.LIKE_COUNT_STRING_WITH_LIKE") ? result.getString("com.facebook.platform.extra.LIKE_COUNT_STRING_WITH_LIKE") : LikeActionController.this.likeCountStringWithLike;
                String likeCountWithoutLike = result.containsKey("com.facebook.platform.extra.LIKE_COUNT_STRING_WITHOUT_LIKE") ? result.getString("com.facebook.platform.extra.LIKE_COUNT_STRING_WITHOUT_LIKE") : LikeActionController.this.likeCountStringWithoutLike;
                String socialSentenceWithLike = result.containsKey("com.facebook.platform.extra.SOCIAL_SENTENCE_WITH_LIKE") ? result.getString("com.facebook.platform.extra.SOCIAL_SENTENCE_WITH_LIKE") : LikeActionController.this.socialSentenceWithLike;
                String socialSentenceWithoutLike = result.containsKey("com.facebook.platform.extra.SOCIAL_SENTENCE_WITHOUT_LIKE") ? result.getString("com.facebook.platform.extra.SOCIAL_SENTENCE_WITHOUT_LIKE") : LikeActionController.this.socialSentenceWithoutLike;
                String unlikeToken = result.containsKey("com.facebook.platform.extra.UNLIKE_TOKEN") ? result.getString("com.facebook.platform.extra.UNLIKE_TOKEN") : LikeActionController.this.unlikeToken;
                LikeActionController.this.updateState(objectIsLiked, likeCountWithLike, likeCountWithoutLike, socialSentenceWithLike, socialSentenceWithoutLike, unlikeToken);
            }
        };
        likeStatusClient.setCompletedListener(callback);
    }

    private void publishAgainIfNeeded(Bundle analyticsParameters) {
        if (this.isObjectLiked != this.isObjectLikedOnServer && !this.publishLikeOrUnlikeAsync(this.isObjectLiked, analyticsParameters)) {
            this.publishDidError(!this.isObjectLiked);
        }
    }

    private void fetchVerifiedObjectId(final RequestCompletionCallback completionHandler) {
        if (!Utility.isNullOrEmpty(this.verifiedObjectId)) {
            if (completionHandler != null) {
                completionHandler.onComplete();
            }
            return;
        }
        final GetOGObjectIdRequestWrapper objectIdRequest = new GetOGObjectIdRequestWrapper(this.objectId);
        final GetPageIdRequestWrapper pageIdRequest = new GetPageIdRequestWrapper(this.objectId);
        RequestBatch requestBatch = new RequestBatch();
        objectIdRequest.addToBatch(requestBatch);
        pageIdRequest.addToBatch(requestBatch);
        requestBatch.addCallback(new RequestBatch.Callback(){

            @Override
            public void onBatchCompleted(RequestBatch batch) {
                LikeActionController.this.verifiedObjectId = objectIdRequest.verifiedObjectId;
                if (Utility.isNullOrEmpty(LikeActionController.this.verifiedObjectId)) {
                    LikeActionController.this.verifiedObjectId = pageIdRequest.verifiedObjectId;
                    LikeActionController.this.objectIsPage = pageIdRequest.objectIsPage;
                }
                if (Utility.isNullOrEmpty(LikeActionController.this.verifiedObjectId)) {
                    Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Unable to verify the FB id for '%s'. Verify that it is a valid FB object or page", LikeActionController.this.objectId);
                    LikeActionController.this.logAppEventForError("get_verified_id", pageIdRequest.error != null ? pageIdRequest.error : objectIdRequest.error);
                }
                if (completionHandler != null) {
                    completionHandler.onComplete();
                }
            }
        });
        requestBatch.executeAsync();
    }

    private void logAppEventForError(String action, Bundle parameters) {
        Bundle logParams = new Bundle(parameters);
        logParams.putString(JSON_STRING_OBJECT_ID_KEY, this.objectId);
        logParams.putString("current_action", action);
        this.appEventsLogger.logSdkEvent("fb_like_control_error", null, logParams);
    }

    private void logAppEventForError(String action, FacebookRequestError error) {
        JSONObject requestResult;
        Bundle logParams = new Bundle();
        if (error != null && (requestResult = error.getRequestResult()) != null) {
            logParams.putString("error", requestResult.toString());
        }
        this.logAppEventForError(action, logParams);
    }

    static {
        cache = new ConcurrentHashMap();
        mruCacheWorkQueue = new WorkQueue(1);
        diskIOWorkQueue = new WorkQueue(1);
    }

    private static class CreateLikeActionControllerWorkItem
    implements Runnable {
        private String objectId;
        private CreationCallback callback;

        CreateLikeActionControllerWorkItem(String objectId, CreationCallback callback) {
            this.objectId = objectId;
            this.callback = callback;
        }

        @Override
        public void run() {
            LikeActionController.createControllerForObjectId(this.objectId, this.callback);
        }
    }

    private static class SerializeToDiskWorkItem
    implements Runnable {
        private String cacheKey;
        private String controllerJson;

        SerializeToDiskWorkItem(String cacheKey, String controllerJson) {
            this.cacheKey = cacheKey;
            this.controllerJson = controllerJson;
        }

        @Override
        public void run() {
            LikeActionController.serializeToDiskSynchronously(this.cacheKey, this.controllerJson);
        }
    }

    private static class MRUCacheWorkItem
    implements Runnable {
        private static ArrayList<String> mruCachedItems = new ArrayList();
        private String cacheItem;
        private boolean shouldTrim;

        MRUCacheWorkItem(String cacheItem, boolean shouldTrim) {
            this.cacheItem = cacheItem;
            this.shouldTrim = shouldTrim;
        }

        @Override
        public void run() {
            if (this.cacheItem != null) {
                mruCachedItems.remove(this.cacheItem);
                mruCachedItems.add(0, this.cacheItem);
            }
            if (this.shouldTrim && mruCachedItems.size() >= 128) {
                int targetSize = 64;
                while (targetSize < mruCachedItems.size()) {
                    String cacheKey = mruCachedItems.remove(mruCachedItems.size() - 1);
                    cache.remove(cacheKey);
                }
            }
        }
    }

    private static class LikeDialogBuilder
    extends FacebookDialog.Builder<LikeDialogBuilder> {
        private String objectId;

        public LikeDialogBuilder(Activity activity, String objectId) {
            super(activity);
            this.objectId = objectId;
        }

        @Override
        protected EnumSet<? extends FacebookDialog.DialogFeature> getDialogFeatures() {
            return EnumSet.of(LikeDialogFeature.LIKE_DIALOG);
        }

        @Override
        protected Bundle getMethodArguments() {
            Bundle methodArgs = new Bundle();
            methodArgs.putString(LikeActionController.JSON_STRING_OBJECT_ID_KEY, this.objectId);
            return methodArgs;
        }

        public FacebookDialog.PendingCall getAppCall() {
            return this.appCall;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getWebFallbackUrl() {
            return this.getWebFallbackUrlInternal();
        }
    }

    private static enum LikeDialogFeature implements FacebookDialog.DialogFeature
    {
        LIKE_DIALOG(20140701);

        private int minVersion;

        private LikeDialogFeature(int minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public String getAction() {
            return "com.facebook.platform.action.request.LIKE_DIALOG";
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }

    private abstract class AbstractRequestWrapper {
        private Request request;
        protected String objectId;
        FacebookRequestError error;

        protected AbstractRequestWrapper(String objectId) {
            this.objectId = objectId;
        }

        void addToBatch(RequestBatch batch) {
            batch.add(this.request);
        }

        protected void setRequest(Request request) {
            this.request = request;
            request.setVersion("v2.2");
            request.setCallback(new Request.Callback(){

                @Override
                public void onCompleted(Response response) {
                    AbstractRequestWrapper.this.error = response.getError();
                    if (AbstractRequestWrapper.this.error != null) {
                        AbstractRequestWrapper.this.processError(AbstractRequestWrapper.this.error);
                    } else {
                        AbstractRequestWrapper.this.processSuccess(response);
                    }
                }
            });
        }

        protected void processError(FacebookRequestError error) {
            Logger.log(LoggingBehavior.REQUESTS, TAG, "Error running request for object '%s' : %s", this.objectId, error);
        }

        protected abstract void processSuccess(Response var1);
    }

    private class GetEngagementRequestWrapper
    extends AbstractRequestWrapper {
        String likeCountStringWithLike;
        String likeCountStringWithoutLike;
        String socialSentenceStringWithLike;
        String socialSentenceStringWithoutLike;

        GetEngagementRequestWrapper(String objectId) {
            super(objectId);
            this.likeCountStringWithLike = LikeActionController.this.likeCountStringWithLike;
            this.likeCountStringWithoutLike = LikeActionController.this.likeCountStringWithoutLike;
            this.socialSentenceStringWithLike = LikeActionController.this.socialSentenceWithLike;
            this.socialSentenceStringWithoutLike = LikeActionController.this.socialSentenceWithoutLike;
            Bundle requestParams = new Bundle();
            requestParams.putString("fields", "engagement.fields(count_string_with_like,count_string_without_like,social_sentence_with_like,social_sentence_without_like)");
            this.setRequest(new Request(LikeActionController.this.session, objectId, requestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(Response response) {
            JSONObject engagementResults = Utility.tryGetJSONObjectFromResponse(response.getGraphObject(), "engagement");
            if (engagementResults != null) {
                this.likeCountStringWithLike = engagementResults.optString("count_string_with_like", this.likeCountStringWithLike);
                this.likeCountStringWithoutLike = engagementResults.optString("count_string_without_like", this.likeCountStringWithoutLike);
                this.socialSentenceStringWithLike = engagementResults.optString(LikeActionController.JSON_STRING_SOCIAL_SENTENCE_WITH_LIKE_KEY, this.socialSentenceStringWithLike);
                this.socialSentenceStringWithoutLike = engagementResults.optString(LikeActionController.JSON_STRING_SOCIAL_SENTENCE_WITHOUT_LIKE_KEY, this.socialSentenceStringWithoutLike);
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log(LoggingBehavior.REQUESTS, TAG, "Error fetching engagement for object '%s' : %s", this.objectId, error);
            LikeActionController.this.logAppEventForError("get_engagement", error);
        }
    }

    private class GetOGObjectLikesRequestWrapper
    extends AbstractRequestWrapper {
        boolean objectIsLiked;
        String unlikeToken;

        GetOGObjectLikesRequestWrapper(String objectId) {
            super(objectId);
            this.objectIsLiked = LikeActionController.this.isObjectLiked;
            Bundle requestParams = new Bundle();
            requestParams.putString("fields", "id,application");
            requestParams.putString("object", objectId);
            this.setRequest(new Request(LikeActionController.this.session, "me/og.likes", requestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(Response response) {
            JSONArray dataSet = Utility.tryGetJSONArrayFromResponse(response.getGraphObject(), "data");
            if (dataSet != null) {
                for (int i = 0; i < dataSet.length(); ++i) {
                    JSONObject data = dataSet.optJSONObject(i);
                    if (data == null) continue;
                    this.objectIsLiked = true;
                    JSONObject appData = data.optJSONObject("application");
                    if (appData == null || !Utility.areObjectsEqual(LikeActionController.this.session.getApplicationId(), appData.optString("id"))) continue;
                    this.unlikeToken = data.optString("id");
                }
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log(LoggingBehavior.REQUESTS, TAG, "Error fetching like status for object '%s' : %s", this.objectId, error);
            LikeActionController.this.logAppEventForError("get_og_object_like", error);
        }
    }

    private class PublishUnlikeRequestWrapper
    extends AbstractRequestWrapper {
        private String unlikeToken;

        PublishUnlikeRequestWrapper(String unlikeToken) {
            super(null);
            this.unlikeToken = unlikeToken;
            this.setRequest(new Request(LikeActionController.this.session, unlikeToken, null, HttpMethod.DELETE));
        }

        @Override
        protected void processSuccess(Response response) {
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log(LoggingBehavior.REQUESTS, TAG, "Error unliking object with unlike token '%s' : %s", this.unlikeToken, error);
            LikeActionController.this.logAppEventForError("publish_unlike", error);
        }
    }

    private class PublishLikeRequestWrapper
    extends AbstractRequestWrapper {
        String unlikeToken;

        PublishLikeRequestWrapper(String objectId) {
            super(objectId);
            Bundle likeRequestParams = new Bundle();
            likeRequestParams.putString("object", objectId);
            this.setRequest(new Request(LikeActionController.this.session, "me/og.likes", likeRequestParams, HttpMethod.POST));
        }

        @Override
        protected void processSuccess(Response response) {
            this.unlikeToken = Utility.safeGetStringFromResponse(response.getGraphObject(), "id");
        }

        @Override
        protected void processError(FacebookRequestError error) {
            int errorCode = error.getErrorCode();
            if (errorCode == 3501) {
                this.error = null;
            } else {
                Logger.log(LoggingBehavior.REQUESTS, TAG, "Error liking object '%s' : %s", this.objectId, error);
                LikeActionController.this.logAppEventForError("publish_like", error);
            }
        }
    }

    private class GetPageIdRequestWrapper
    extends AbstractRequestWrapper {
        String verifiedObjectId;
        boolean objectIsPage;

        GetPageIdRequestWrapper(String objectId) {
            super(objectId);
            Bundle pageIdRequestParams = new Bundle();
            pageIdRequestParams.putString("fields", "id");
            pageIdRequestParams.putString("ids", objectId);
            this.setRequest(new Request(LikeActionController.this.session, "", pageIdRequestParams, HttpMethod.GET));
        }

        @Override
        protected void processSuccess(Response response) {
            JSONObject results = Utility.tryGetJSONObjectFromResponse(response.getGraphObject(), this.objectId);
            if (results != null) {
                this.verifiedObjectId = results.optString("id");
                this.objectIsPage = !Utility.isNullOrEmpty(this.verifiedObjectId);
            }
        }

        @Override
        protected void processError(FacebookRequestError error) {
            Logger.log(LoggingBehavior.REQUESTS, TAG, "Error getting the FB id for object '%s' : %s", this.objectId, error);
        }
    }

    private class GetOGObjectIdRequestWrapper
    extends AbstractRequestWrapper {
        String verifiedObjectId;

        GetOGObjectIdRequestWrapper(String objectId) {
            super(objectId);
            Bundle objectIdRequestParams = new Bundle();
            objectIdRequestParams.putString("fields", "og_object.fields(id)");
            objectIdRequestParams.putString("ids", objectId);
            this.setRequest(new Request(LikeActionController.this.session, "", objectIdRequestParams, HttpMethod.GET));
        }

        @Override
        protected void processError(FacebookRequestError error) {
            if (error.getErrorMessage().contains("og_object")) {
                this.error = null;
            } else {
                Logger.log(LoggingBehavior.REQUESTS, TAG, "Error getting the FB id for object '%s' : %s", this.objectId, error);
            }
        }

        @Override
        protected void processSuccess(Response response) {
            JSONObject ogObject;
            JSONObject results = Utility.tryGetJSONObjectFromResponse(response.getGraphObject(), this.objectId);
            if (results != null && (ogObject = results.optJSONObject("og_object")) != null) {
                this.verifiedObjectId = ogObject.optString("id");
            }
        }
    }

    private static interface RequestCompletionCallback {
        public void onComplete();
    }

    public static interface CreationCallback {
        public void onComplete(LikeActionController var1);
    }
}

