/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Settings;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class Utility {
    static final String LOG_TAG = "FacebookSDK";
    private static final String HASH_ALGORITHM_MD5 = "MD5";
    private static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    private static final String URL_SCHEME = "https";
    private static final String APP_SETTINGS_PREFS_STORE = "com.facebook.internal.preferences.APP_SETTINGS";
    private static final String APP_SETTINGS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_SETTINGS.%s";
    private static final String APP_SETTING_SUPPORTS_ATTRIBUTION = "supports_attribution";
    private static final String APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING = "supports_implicit_sdk_logging";
    private static final String APP_SETTING_NUX_CONTENT = "gdpv4_nux_content";
    private static final String APP_SETTING_NUX_ENABLED = "gdpv4_nux_enabled";
    private static final String APP_SETTING_DIALOG_CONFIGS = "android_dialog_configs";
    private static final String EXTRA_APP_EVENTS_INFO_FORMAT_VERSION = "a1";
    private static final String DIALOG_CONFIG_DIALOG_NAME_FEATURE_NAME_SEPARATOR = "\\|";
    private static final String DIALOG_CONFIG_NAME_KEY = "name";
    private static final String DIALOG_CONFIG_VERSIONS_KEY = "versions";
    private static final String DIALOG_CONFIG_URL_KEY = "url";
    private static final String UTF8 = "UTF-8";
    private static final String[] APP_SETTING_FIELDS = new String[]{"supports_attribution", "supports_implicit_sdk_logging", "gdpv4_nux_content", "gdpv4_nux_enabled", "android_dialog_configs"};
    private static final String APPLICATION_FIELDS = "fields";
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static Map<String, FetchedAppSettings> fetchedAppSettings = new ConcurrentHashMap<String, FetchedAppSettings>();
    private static AsyncTask<Void, Void, GraphObject> initialAppSettingsLoadTask;

    public static int[] intersectRanges(int[] range1, int[] range2) {
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        int[] outputRange = new int[range1.length + range2.length];
        int outputIndex = 0;
        int index1 = 0;
        int index2 = 0;
        while (index1 < range1.length && index2 < range2.length) {
            int newRangeLower = Integer.MIN_VALUE;
            int newRangeUpper = Integer.MAX_VALUE;
            int lower1 = range1[index1];
            int upper1 = Integer.MAX_VALUE;
            int lower2 = range2[index2];
            int upper2 = Integer.MAX_VALUE;
            if (index1 < range1.length - 1) {
                upper1 = range1[index1 + 1];
            }
            if (index2 < range2.length - 1) {
                upper2 = range2[index2 + 1];
            }
            if (lower1 < lower2) {
                if (upper1 > lower2) {
                    newRangeLower = lower2;
                    if (upper1 > upper2) {
                        newRangeUpper = upper2;
                        index2 += 2;
                    } else {
                        newRangeUpper = upper1;
                        index1 += 2;
                    }
                } else {
                    index1 += 2;
                }
            } else if (upper2 > lower1) {
                newRangeLower = lower1;
                if (upper2 > upper1) {
                    newRangeUpper = upper1;
                    index1 += 2;
                } else {
                    newRangeUpper = upper2;
                    index2 += 2;
                }
            } else {
                index2 += 2;
            }
            if (newRangeLower == Integer.MIN_VALUE) continue;
            outputRange[outputIndex++] = newRangeLower;
            if (newRangeUpper == Integer.MAX_VALUE) break;
            outputRange[outputIndex++] = newRangeUpper;
        }
        return Arrays.copyOf(outputRange, outputIndex);
    }

    public static <T> boolean isSubset(Collection<T> subset, Collection<T> superset) {
        if (superset == null || superset.size() == 0) {
            return subset == null || subset.size() == 0;
        }
        HashSet<T> hash = new HashSet<T>(superset);
        for (T t : subset) {
            if (hash.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String coerceValueIfNullOrEmpty(String s, String valueIfNullOrEmpty) {
        if (Utility.isNullOrEmpty(s)) {
            return valueIfNullOrEmpty;
        }
        return s;
    }

    public static <T> Collection<T> unmodifiableCollection(T ... ts) {
        return Collections.unmodifiableCollection(Arrays.asList(ts));
    }

    public static <T> ArrayList<T> arrayList(T ... ts) {
        ArrayList<T> arrayList = new ArrayList<T>(ts.length);
        for (T t : ts) {
            arrayList.add(t);
        }
        return arrayList;
    }

    static String md5hash(String key) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_MD5, key);
    }

    static String sha1hash(String key) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA1, key);
    }

    static String sha1hash(byte[] bytes) {
        return Utility.hashWithAlgorithm(HASH_ALGORITHM_SHA1, bytes);
    }

    private static String hashWithAlgorithm(String algorithm, String key) {
        return Utility.hashWithAlgorithm(algorithm, key.getBytes());
    }

    private static String hashWithAlgorithm(String algorithm, byte[] bytes) {
        MessageDigest hash;
        try {
            hash = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return Utility.hashBytes(hash, bytes);
    }

    private static String hashBytes(MessageDigest hash, byte[] bytes) {
        hash.update(bytes);
        byte[] digest = hash.digest();
        StringBuilder builder = new StringBuilder();
        for (byte b : digest) {
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b >> 0 & 0xF));
        }
        return builder.toString();
    }

    public static Uri buildUri(String authority, String path, Bundle parameters) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URL_SCHEME);
        builder.authority(authority);
        builder.path(path);
        for (String key : parameters.keySet()) {
            Object parameter = parameters.get(key);
            if (!(parameter instanceof String)) continue;
            builder.appendQueryParameter(key, (String)parameter);
        }
        return builder.build();
    }

    public static Bundle parseUrlQueryString(String queryString) {
        Bundle params = new Bundle();
        if (!Utility.isNullOrEmpty(queryString)) {
            String[] array;
            for (String parameter : array = queryString.split("&")) {
                String[] keyValuePair = parameter.split("=");
                try {
                    if (keyValuePair.length == 2) {
                        params.putString(URLDecoder.decode(keyValuePair[0], UTF8), URLDecoder.decode(keyValuePair[1], UTF8));
                        continue;
                    }
                    if (keyValuePair.length != 1) continue;
                    params.putString(URLDecoder.decode(keyValuePair[0], UTF8), "");
                }
                catch (UnsupportedEncodingException e) {
                    Utility.logd(LOG_TAG, e);
                }
            }
        }
        return params;
    }

    public static void putObjectInBundle(Bundle bundle, String key, Object value) {
        if (value instanceof String) {
            bundle.putString(key, (String)value);
        } else if (value instanceof Parcelable) {
            bundle.putParcelable(key, (Parcelable)value);
        } else if (value instanceof byte[]) {
            bundle.putByteArray(key, (byte[])value);
        } else {
            throw new FacebookException("attempted to add unsupported type to Bundle");
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void disconnectQuietly(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public static String getMetadataApplicationId(Context context) {
        Validate.notNull(context, "context");
        Settings.loadDefaultsFromMetadata(context);
        return Settings.getApplicationId();
    }

    static Map<String, Object> convertJSONObjectToHashMap(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONArray keys = jsonObject.names();
        for (int i = 0; i < keys.length(); ++i) {
            try {
                String key = keys.getString(i);
                Map<String, Object> value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    value = Utility.convertJSONObjectToHashMap((JSONObject)value);
                }
                map.put(key, value);
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return map;
    }

    public static Object getStringPropertyAsJSON(JSONObject jsonObject, String key, String nonJSONPropertyKey) throws JSONException {
        Object value = jsonObject.opt(key);
        if (value != null && value instanceof String) {
            JSONTokener tokener = new JSONTokener((String)value);
            value = tokener.nextValue();
        }
        if (value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray)) {
            if (nonJSONPropertyKey != null) {
                jsonObject = new JSONObject();
                jsonObject.putOpt(nonJSONPropertyKey, value);
                return jsonObject;
            }
            throw new FacebookException("Got an unexpected non-JSON object.");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamToString(InputStream inputStream) throws IOException {
        String string2;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[2048];
            int n = 0;
            while ((n = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, n);
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(bufferedInputStream);
            Utility.closeQuietly(reader);
            throw throwable;
        }
        Utility.closeQuietly(bufferedInputStream);
        Utility.closeQuietly(reader);
        return string2;
    }

    public static boolean stringsEqualOrEmpty(String a, String b) {
        boolean aEmpty = TextUtils.isEmpty((CharSequence)a);
        boolean bEmpty = TextUtils.isEmpty((CharSequence)b);
        if (aEmpty && bEmpty) {
            return true;
        }
        if (!aEmpty && !bEmpty) {
            return a.equals(b);
        }
        return false;
    }

    private static void clearCookiesForDomain(Context context, String domain) {
        String[] splitCookies;
        CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
        syncManager.sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String cookies = cookieManager.getCookie(domain);
        if (cookies == null) {
            return;
        }
        for (String cookie : splitCookies = cookies.split(";")) {
            String[] cookieParts = cookie.split("=");
            if (cookieParts.length <= 0) continue;
            String newCookie = cookieParts[0].trim() + "=;expires=Sat, 1 Jan 2000 00:00:01 UTC;";
            cookieManager.setCookie(domain, newCookie);
        }
        cookieManager.removeExpiredCookie();
    }

    public static void clearFacebookCookies(Context context) {
        Utility.clearCookiesForDomain(context, "facebook.com");
        Utility.clearCookiesForDomain(context, ".facebook.com");
        Utility.clearCookiesForDomain(context, "https://facebook.com");
        Utility.clearCookiesForDomain(context, "https://.facebook.com");
    }

    public static void logd(String tag, Exception e) {
        if (Settings.isDebugEnabled() && tag != null && e != null) {
            Log.d((String)tag, (String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    public static void logd(String tag, String msg) {
        if (Settings.isDebugEnabled() && tag != null && msg != null) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void logd(String tag, String msg, Throwable t) {
        if (Settings.isDebugEnabled() && !Utility.isNullOrEmpty(tag)) {
            Log.d((String)tag, (String)msg, (Throwable)t);
        }
    }

    public static <T> boolean areObjectsEqual(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static void loadAppSettingsAsync(final Context context, final String applicationId) {
        if (Utility.isNullOrEmpty(applicationId) || fetchedAppSettings.containsKey(applicationId) || initialAppSettingsLoadTask != null) {
            return;
        }
        final String settingsKey = String.format(APP_SETTINGS_PREFS_KEY_FORMAT, applicationId);
        initialAppSettingsLoadTask = new AsyncTask<Void, Void, GraphObject>(){

            protected GraphObject doInBackground(Void ... params) {
                return Utility.getAppSettingsQueryResponse(applicationId);
            }

            protected void onPostExecute(GraphObject result) {
                if (result != null) {
                    JSONObject resultJSON = result.getInnerJSONObject();
                    Utility.parseAppSettingsFromJSON(applicationId, resultJSON);
                    SharedPreferences sharedPrefs = context.getSharedPreferences(Utility.APP_SETTINGS_PREFS_STORE, 0);
                    sharedPrefs.edit().putString(settingsKey, resultJSON.toString()).apply();
                }
                initialAppSettingsLoadTask = null;
            }
        };
        initialAppSettingsLoadTask.execute((Object[])null);
        SharedPreferences sharedPrefs = context.getSharedPreferences(APP_SETTINGS_PREFS_STORE, 0);
        String settingsJSONString = sharedPrefs.getString(settingsKey, null);
        if (!Utility.isNullOrEmpty(settingsJSONString)) {
            JSONObject settingsJSON = null;
            try {
                settingsJSON = new JSONObject(settingsJSONString);
            }
            catch (JSONException je) {
                Utility.logd(LOG_TAG, (Exception)((Object)je));
            }
            if (settingsJSON != null) {
                Utility.parseAppSettingsFromJSON(applicationId, settingsJSON);
            }
        }
    }

    public static FetchedAppSettings queryAppSettings(String applicationId, boolean forceRequery) {
        if (!forceRequery && fetchedAppSettings.containsKey(applicationId)) {
            return fetchedAppSettings.get(applicationId);
        }
        GraphObject response = Utility.getAppSettingsQueryResponse(applicationId);
        if (response == null) {
            return null;
        }
        return Utility.parseAppSettingsFromJSON(applicationId, response.getInnerJSONObject());
    }

    private static FetchedAppSettings parseAppSettingsFromJSON(String applicationId, JSONObject settingsJSON) {
        FetchedAppSettings result = new FetchedAppSettings(settingsJSON.optBoolean(APP_SETTING_SUPPORTS_ATTRIBUTION, false), settingsJSON.optBoolean(APP_SETTING_SUPPORTS_IMPLICIT_SDK_LOGGING, false), settingsJSON.optString(APP_SETTING_NUX_CONTENT, ""), settingsJSON.optBoolean(APP_SETTING_NUX_ENABLED, false), Utility.parseDialogConfigurations(settingsJSON.optJSONObject(APP_SETTING_DIALOG_CONFIGS)));
        fetchedAppSettings.put(applicationId, result);
        return result;
    }

    private static GraphObject getAppSettingsQueryResponse(String applicationId) {
        Bundle appSettingsParams = new Bundle();
        appSettingsParams.putString(APPLICATION_FIELDS, TextUtils.join((CharSequence)",", (Object[])APP_SETTING_FIELDS));
        Request request = Request.newGraphPathRequest(null, applicationId, null);
        request.setSkipClientToken(true);
        request.setParameters(appSettingsParams);
        GraphObject response = request.executeAndWait().getGraphObject();
        return response;
    }

    public static DialogFeatureConfig getDialogFeatureConfig(String applicationId, String actionName, String featureName) {
        Map<String, DialogFeatureConfig> featureMap;
        if (Utility.isNullOrEmpty(actionName) || Utility.isNullOrEmpty(featureName)) {
            return null;
        }
        FetchedAppSettings settings = fetchedAppSettings.get(applicationId);
        if (settings != null && (featureMap = settings.getDialogConfigurations().get(actionName)) != null) {
            return featureMap.get(featureName);
        }
        return null;
    }

    private static Map<String, Map<String, DialogFeatureConfig>> parseDialogConfigurations(JSONObject dialogConfigResponse) {
        JSONArray dialogConfigData;
        HashMap<String, Map<String, DialogFeatureConfig>> dialogConfigMap = new HashMap<String, Map<String, DialogFeatureConfig>>();
        if (dialogConfigResponse != null && (dialogConfigData = dialogConfigResponse.optJSONArray("data")) != null) {
            for (int i = 0; i < dialogConfigData.length(); ++i) {
                DialogFeatureConfig dialogConfig = DialogFeatureConfig.parseDialogConfig(dialogConfigData.optJSONObject(i));
                if (dialogConfig == null) continue;
                String dialogName = dialogConfig.getDialogName();
                Map<String, DialogFeatureConfig> featureMap = dialogConfigMap.get(dialogName);
                if (featureMap == null) {
                    featureMap = new HashMap<String, DialogFeatureConfig>();
                    dialogConfigMap.put(dialogName, featureMap);
                }
                featureMap.put(dialogConfig.getFeatureName(), dialogConfig);
            }
        }
        return dialogConfigMap;
    }

    public static boolean safeGetBooleanFromResponse(GraphObject response, String propertyName) {
        Object result = false;
        if (response != null) {
            result = response.getProperty(propertyName);
        }
        if (!(result instanceof Boolean)) {
            result = false;
        }
        return (Boolean)result;
    }

    public static String safeGetStringFromResponse(GraphObject response, String propertyName) {
        Object result = "";
        if (response != null) {
            result = response.getProperty(propertyName);
        }
        if (!(result instanceof String)) {
            result = "";
        }
        return (String)result;
    }

    public static JSONObject tryGetJSONObjectFromResponse(GraphObject response, String propertyKey) {
        if (response == null) {
            return null;
        }
        Object property = response.getProperty(propertyKey);
        if (!(property instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)property;
    }

    public static JSONArray tryGetJSONArrayFromResponse(GraphObject response, String propertyKey) {
        if (response == null) {
            return null;
        }
        Object property = response.getProperty(propertyKey);
        if (!(property instanceof JSONArray)) {
            return null;
        }
        return (JSONArray)property;
    }

    public static void clearCaches(Context context) {
        ImageDownloader.clearCache(context);
    }

    public static void deleteDirectory(File directoryOrFile) {
        if (!directoryOrFile.exists()) {
            return;
        }
        if (directoryOrFile.isDirectory()) {
            for (File child : directoryOrFile.listFiles()) {
                Utility.deleteDirectory(child);
            }
        }
        directoryOrFile.delete();
    }

    public static <T> List<T> asListNoNulls(T ... array) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : array) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static String getHashedDeviceAndAppID(Context context, String applicationId) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (androidId == null) {
            return null;
        }
        return Utility.sha1hash(androidId + applicationId);
    }

    public static void setAppEventAttributionParameters(GraphObject params, AttributionIdentifiers attributionIdentifiers, String hashedDeviceAndAppId, boolean limitEventUsage) {
        if (attributionIdentifiers != null && attributionIdentifiers.getAttributionId() != null) {
            params.setProperty("attribution", attributionIdentifiers.getAttributionId());
        }
        if (attributionIdentifiers != null && attributionIdentifiers.getAndroidAdvertiserId() != null) {
            params.setProperty("advertiser_id", attributionIdentifiers.getAndroidAdvertiserId());
            params.setProperty("advertiser_tracking_enabled", !attributionIdentifiers.isTrackingLimited());
        } else if (hashedDeviceAndAppId != null) {
            params.setProperty("advertiser_id", hashedDeviceAndAppId);
        }
        params.setProperty("application_tracking_enabled", !limitEventUsage);
    }

    public static void setAppEventExtendedDeviceInfoParameters(GraphObject params, Context appContext) {
        JSONArray extraInfoArray = new JSONArray();
        extraInfoArray.put((Object)EXTRA_APP_EVENTS_INFO_FORMAT_VERSION);
        String pkgName = appContext.getPackageName();
        int versionCode = -1;
        String versionName = "";
        try {
            PackageInfo pi = appContext.getPackageManager().getPackageInfo(pkgName, 0);
            versionCode = pi.versionCode;
            versionName = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        extraInfoArray.put((Object)pkgName);
        extraInfoArray.put(versionCode);
        extraInfoArray.put((Object)versionName);
        params.setProperty("extinfo", extraInfoArray.toString());
    }

    public static Method getMethodQuietly(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodQuietly(String className, String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            return Utility.getMethodQuietly(clazz, methodName, parameterTypes);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Object invokeMethodQuietly(Object receiver, Method method, Object ... args) {
        try {
            return method.invoke(receiver, args);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            return null;
        }
    }

    public static String getActivityName(Context context) {
        if (context == null) {
            return "null";
        }
        if (context == context.getApplicationContext()) {
            return "unknown";
        }
        return context.getClass().getSimpleName();
    }

    public static class DialogFeatureConfig {
        private String dialogName;
        private String featureName;
        private Uri fallbackUrl;
        private int[] featureVersionSpec;

        private static DialogFeatureConfig parseDialogConfig(JSONObject dialogConfigJSON) {
            String dialogNameWithFeature = dialogConfigJSON.optString(Utility.DIALOG_CONFIG_NAME_KEY);
            if (Utility.isNullOrEmpty(dialogNameWithFeature)) {
                return null;
            }
            String[] components = dialogNameWithFeature.split(Utility.DIALOG_CONFIG_DIALOG_NAME_FEATURE_NAME_SEPARATOR);
            if (components.length != 2) {
                return null;
            }
            String dialogName = components[0];
            String featureName = components[1];
            if (Utility.isNullOrEmpty(dialogName) || Utility.isNullOrEmpty(featureName)) {
                return null;
            }
            String urlString = dialogConfigJSON.optString(Utility.DIALOG_CONFIG_URL_KEY);
            Uri fallbackUri = null;
            if (!Utility.isNullOrEmpty(urlString)) {
                fallbackUri = Uri.parse((String)urlString);
            }
            JSONArray versionsJSON = dialogConfigJSON.optJSONArray(Utility.DIALOG_CONFIG_VERSIONS_KEY);
            int[] featureVersionSpec = DialogFeatureConfig.parseVersionSpec(versionsJSON);
            return new DialogFeatureConfig(dialogName, featureName, fallbackUri, featureVersionSpec);
        }

        private static int[] parseVersionSpec(JSONArray versionsJSON) {
            int[] versionSpec = null;
            if (versionsJSON != null) {
                int numVersions = versionsJSON.length();
                versionSpec = new int[numVersions];
                for (int i = 0; i < numVersions; ++i) {
                    String versionString;
                    int version = versionsJSON.optInt(i, -1);
                    if (version == -1 && !Utility.isNullOrEmpty(versionString = versionsJSON.optString(i))) {
                        try {
                            version = Integer.parseInt(versionString);
                        }
                        catch (NumberFormatException nfe) {
                            Utility.logd(Utility.LOG_TAG, nfe);
                            version = -1;
                        }
                    }
                    versionSpec[i] = version;
                }
            }
            return versionSpec;
        }

        private DialogFeatureConfig(String dialogName, String featureName, Uri fallbackUrl, int[] featureVersionSpec) {
            this.dialogName = dialogName;
            this.featureName = featureName;
            this.fallbackUrl = fallbackUrl;
            this.featureVersionSpec = featureVersionSpec;
        }

        public String getDialogName() {
            return this.dialogName;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public Uri getFallbackUrl() {
            return this.fallbackUrl;
        }

        public int[] getVersionSpec() {
            return this.featureVersionSpec;
        }
    }

    public static class FetchedAppSettings {
        private boolean supportsAttribution;
        private boolean supportsImplicitLogging;
        private String nuxContent;
        private boolean nuxEnabled;
        private Map<String, Map<String, DialogFeatureConfig>> dialogConfigMap;

        private FetchedAppSettings(boolean supportsAttribution, boolean supportsImplicitLogging, String nuxContent, boolean nuxEnabled, Map<String, Map<String, DialogFeatureConfig>> dialogConfigMap) {
            this.supportsAttribution = supportsAttribution;
            this.supportsImplicitLogging = supportsImplicitLogging;
            this.nuxContent = nuxContent;
            this.nuxEnabled = nuxEnabled;
            this.dialogConfigMap = dialogConfigMap;
        }

        public boolean supportsAttribution() {
            return this.supportsAttribution;
        }

        public boolean supportsImplicitLogging() {
            return this.supportsImplicitLogging;
        }

        public String getNuxContent() {
            return this.nuxContent;
        }

        public boolean getNuxEnabled() {
            return this.nuxEnabled;
        }

        public Map<String, Map<String, DialogFeatureConfig>> getDialogConfigurations() {
            return this.dialogConfigMap;
        }
    }
}

