/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.facebook.Session;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.internal.SessionAuthorizationType;
import com.facebook.internal.SessionTracker;
import java.util.Date;
import java.util.List;

class FacebookFragment
extends Fragment {
    private SessionTracker sessionTracker;

    FacebookFragment() {
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.sessionTracker = new SessionTracker((Context)this.getActivity(), new DefaultSessionStatusCallback());
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.sessionTracker.getSession().onActivityResult((Activity)this.getActivity(), requestCode, resultCode, data);
    }

    public void onDestroy() {
        super.onDestroy();
        this.sessionTracker.stopTracking();
    }

    public void setSession(Session newSession) {
        if (this.sessionTracker != null) {
            this.sessionTracker.setSession(newSession);
        }
    }

    protected void onSessionStateChange(SessionState state, Exception exception) {
    }

    protected final Session getSession() {
        if (this.sessionTracker != null) {
            return this.sessionTracker.getSession();
        }
        return null;
    }

    protected final boolean isSessionOpen() {
        if (this.sessionTracker != null) {
            return this.sessionTracker.getOpenSession() != null;
        }
        return false;
    }

    protected final SessionState getSessionState() {
        if (this.sessionTracker != null) {
            Session currentSession = this.sessionTracker.getSession();
            return currentSession != null ? currentSession.getState() : null;
        }
        return null;
    }

    protected final String getAccessToken() {
        if (this.sessionTracker != null) {
            Session currentSession = this.sessionTracker.getOpenSession();
            return currentSession != null ? currentSession.getAccessToken() : null;
        }
        return null;
    }

    protected final Date getExpirationDate() {
        if (this.sessionTracker != null) {
            Session currentSession = this.sessionTracker.getOpenSession();
            return currentSession != null ? currentSession.getExpirationDate() : null;
        }
        return null;
    }

    protected final void closeSession() {
        Session currentSession;
        if (this.sessionTracker != null && (currentSession = this.sessionTracker.getOpenSession()) != null) {
            currentSession.close();
        }
    }

    protected final void closeSessionAndClearTokenInformation() {
        Session currentSession;
        if (this.sessionTracker != null && (currentSession = this.sessionTracker.getOpenSession()) != null) {
            currentSession.closeAndClearTokenInformation();
        }
    }

    protected final List<String> getSessionPermissions() {
        if (this.sessionTracker != null) {
            Session currentSession = this.sessionTracker.getSession();
            return currentSession != null ? currentSession.getPermissions() : null;
        }
        return null;
    }

    protected final void openSession() {
        this.openSessionForRead(null, null);
    }

    protected final void openSessionForRead(String applicationId, List<String> permissions) {
        this.openSessionForRead(applicationId, permissions, SessionLoginBehavior.SSO_WITH_FALLBACK, 64206);
    }

    protected final void openSessionForRead(String applicationId, List<String> permissions, SessionLoginBehavior behavior, int activityCode) {
        this.openSession(applicationId, permissions, behavior, activityCode, SessionAuthorizationType.READ);
    }

    protected final void openSessionForPublish(String applicationId, List<String> permissions) {
        this.openSessionForPublish(applicationId, permissions, SessionLoginBehavior.SSO_WITH_FALLBACK, 64206);
    }

    protected final void openSessionForPublish(String applicationId, List<String> permissions, SessionLoginBehavior behavior, int activityCode) {
        this.openSession(applicationId, permissions, behavior, activityCode, SessionAuthorizationType.PUBLISH);
    }

    private void openSession(String applicationId, List<String> permissions, SessionLoginBehavior behavior, int activityCode, SessionAuthorizationType authType) {
        if (this.sessionTracker != null) {
            Session currentSession = this.sessionTracker.getSession();
            if (currentSession == null || currentSession.getState().isClosed()) {
                Session session = new Session.Builder((Context)this.getActivity()).setApplicationId(applicationId).build();
                Session.setActiveSession(session);
                currentSession = session;
            }
            if (!currentSession.isOpened()) {
                Session.OpenRequest openRequest = ((Session.OpenRequest)new Session.OpenRequest(this).setPermissions((List)permissions)).setLoginBehavior(behavior).setRequestCode(activityCode);
                if (SessionAuthorizationType.PUBLISH.equals((Object)authType)) {
                    currentSession.openForPublish(openRequest);
                } else {
                    currentSession.openForRead(openRequest);
                }
            }
        }
    }

    private class DefaultSessionStatusCallback
    implements Session.StatusCallback {
        private DefaultSessionStatusCallback() {
        }

        @Override
        public void call(Session session, SessionState state, Exception exception) {
            FacebookFragment.this.onSessionStateChange(state, exception);
        }
    }
}

