/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.widget.FacebookDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PendingCallStore {
    private static final String CALL_ID_ARRAY_KEY = "com.facebook.internal.PendingCallStore.callIdArrayKey";
    private static final String CALL_KEY_PREFIX = "com.facebook.internal.PendingCallStore.";
    private static PendingCallStore mInstance;
    private Map<String, FacebookDialog.PendingCall> pendingCallMap = new HashMap<String, FacebookDialog.PendingCall>();

    public static PendingCallStore getInstance() {
        if (mInstance == null) {
            PendingCallStore.createInstance();
        }
        return mInstance;
    }

    private static synchronized void createInstance() {
        if (mInstance == null) {
            mInstance = new PendingCallStore();
        }
    }

    public void trackPendingCall(FacebookDialog.PendingCall pendingCall) {
        if (pendingCall != null) {
            this.pendingCallMap.put(pendingCall.getCallId().toString(), pendingCall);
        }
    }

    public void stopTrackingPendingCall(UUID callId) {
        if (callId != null) {
            this.pendingCallMap.remove(callId.toString());
        }
    }

    public FacebookDialog.PendingCall getPendingCallById(UUID callId) {
        if (callId == null) {
            return null;
        }
        return this.pendingCallMap.get(callId.toString());
    }

    public void saveInstanceState(Bundle outState) {
        ArrayList<String> callIds = new ArrayList<String>(this.pendingCallMap.keySet());
        outState.putStringArrayList(CALL_ID_ARRAY_KEY, callIds);
        for (FacebookDialog.PendingCall pendingCall : this.pendingCallMap.values()) {
            String stateKey = this.getSavedStateKeyForPendingCallId(pendingCall.getCallId().toString());
            outState.putParcelable(stateKey, (Parcelable)pendingCall);
        }
    }

    public void restoreFromSavedInstanceState(Bundle savedInstanceState) {
        ArrayList callIds = savedInstanceState.getStringArrayList(CALL_ID_ARRAY_KEY);
        if (callIds != null) {
            for (String callId : callIds) {
                String stateKey = this.getSavedStateKeyForPendingCallId(callId);
                FacebookDialog.PendingCall pendingCall = (FacebookDialog.PendingCall)savedInstanceState.getParcelable(stateKey);
                if (pendingCall == null) continue;
                this.pendingCallMap.put(pendingCall.getCallId().toString(), pendingCall);
            }
        }
    }

    private String getSavedStateKeyForPendingCallId(String pendingCallId) {
        return CALL_KEY_PREFIX + pendingCallId;
    }
}

