/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.widget.FacebookDialog;
import com.facebook.widget.WebDialog;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookWebFallbackDialog
extends WebDialog {
    private static final String TAG = FacebookWebFallbackDialog.class.getName();

    public static boolean presentWebFallback(final Context context, String dialogUrl, String applicationId, final FacebookDialog.PendingCall appCall, final FacebookDialog.Callback callback) {
        if (Utility.isNullOrEmpty(dialogUrl)) {
            return false;
        }
        String redirectUrl = String.format("fb%s://bridge/", applicationId);
        FacebookWebFallbackDialog fallbackWebDialog = new FacebookWebFallbackDialog(context, dialogUrl, redirectUrl);
        fallbackWebDialog.setOnCompleteListener(new WebDialog.OnCompleteListener(){

            @Override
            public void onComplete(Bundle values, FacebookException error) {
                Intent dummyIntent = new Intent();
                dummyIntent.putExtras(values == null ? new Bundle() : values);
                FacebookDialog.handleActivityResult(context, appCall, appCall.getRequestCode(), dummyIntent, callback);
            }
        });
        fallbackWebDialog.show();
        return true;
    }

    private FacebookWebFallbackDialog(Context context, String url, String expectedRedirectUrl) {
        super(context, url);
        this.setExpectedRedirectUrl(expectedRedirectUrl);
    }

    @Override
    protected Bundle parseResponseUri(String url) {
        Uri responseUri = Uri.parse((String)url);
        Bundle queryParams = Utility.parseUrlQueryString(responseUri.getQuery());
        String bridgeArgsJSONString = queryParams.getString("bridge_args");
        queryParams.remove("bridge_args");
        if (!Utility.isNullOrEmpty(bridgeArgsJSONString)) {
            try {
                JSONObject bridgeArgsJSON = new JSONObject(bridgeArgsJSONString);
                Bundle bridgeArgs = BundleJSONConverter.convertToBundle(bridgeArgsJSON);
                queryParams.putBundle("com.facebook.platform.protocol.BRIDGE_ARGS", bridgeArgs);
            }
            catch (JSONException je) {
                Utility.logd(TAG, "Unable to parse bridge_args JSON", je);
            }
        }
        String methodResultsJSONString = queryParams.getString("method_results");
        queryParams.remove("method_results");
        if (!Utility.isNullOrEmpty(methodResultsJSONString)) {
            methodResultsJSONString = Utility.isNullOrEmpty(methodResultsJSONString) ? "{}" : methodResultsJSONString;
            try {
                JSONObject methodArgsJSON = new JSONObject(methodResultsJSONString);
                Bundle methodResults = BundleJSONConverter.convertToBundle(methodArgsJSON);
                queryParams.putBundle("com.facebook.platform.protocol.RESULT_ARGS", methodResults);
            }
            catch (JSONException je) {
                Utility.logd(TAG, "Unable to parse bridge_args JSON", je);
            }
        }
        queryParams.remove("version");
        queryParams.putInt("com.facebook.platform.protocol.PROTOCOL_VERSION", NativeProtocol.getLatestKnownVersion());
        return queryParams;
    }
}

