/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookServiceException;
import com.facebook.GetTokenClient;
import com.facebook.HttpMethod;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.Settings;
import com.facebook.android.R;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PlatformServiceClient;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.model.GraphUser;
import com.facebook.widget.WebDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class AuthorizationClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "Facebook-AuthorizationClient";
    private static final String WEB_VIEW_AUTH_HANDLER_STORE = "com.facebook.AuthorizationClient.WebViewAuthHandler.TOKEN_STORE_KEY";
    private static final String WEB_VIEW_AUTH_HANDLER_TOKEN_KEY = "TOKEN";
    private static final String EVENT_NAME_LOGIN_METHOD_START = "fb_mobile_login_method_start";
    private static final String EVENT_NAME_LOGIN_METHOD_COMPLETE = "fb_mobile_login_method_complete";
    private static final String EVENT_PARAM_METHOD_RESULT_SKIPPED = "skipped";
    static final String EVENT_NAME_LOGIN_START = "fb_mobile_login_start";
    static final String EVENT_NAME_LOGIN_COMPLETE = "fb_mobile_login_complete";
    static final String EVENT_PARAM_AUTH_LOGGER_ID = "0_auth_logger_id";
    static final String EVENT_PARAM_TIMESTAMP = "1_timestamp_ms";
    static final String EVENT_PARAM_LOGIN_RESULT = "2_result";
    static final String EVENT_PARAM_METHOD = "3_method";
    static final String EVENT_PARAM_ERROR_CODE = "4_error_code";
    static final String EVENT_PARAM_ERROR_MESSAGE = "5_error_message";
    static final String EVENT_PARAM_EXTRAS = "6_extras";
    static final String EVENT_EXTRAS_TRY_LOGIN_ACTIVITY = "try_login_activity";
    static final String EVENT_EXTRAS_TRY_LEGACY = "try_legacy";
    static final String EVENT_EXTRAS_LOGIN_BEHAVIOR = "login_behavior";
    static final String EVENT_EXTRAS_REQUEST_CODE = "request_code";
    static final String EVENT_EXTRAS_IS_LEGACY = "is_legacy";
    static final String EVENT_EXTRAS_PERMISSIONS = "permissions";
    static final String EVENT_EXTRAS_DEFAULT_AUDIENCE = "default_audience";
    static final String EVENT_EXTRAS_MISSING_INTERNET_PERMISSION = "no_internet_permission";
    static final String EVENT_EXTRAS_NOT_TRIED = "not_tried";
    static final String EVENT_EXTRAS_NEW_PERMISSIONS = "new_permissions";
    List<AuthHandler> handlersToTry;
    AuthHandler currentHandler;
    transient Context context;
    transient StartActivityDelegate startActivityDelegate;
    transient OnCompletedListener onCompletedListener;
    transient BackgroundProcessingListener backgroundProcessingListener;
    transient boolean checkedInternetPermission;
    AuthorizationRequest pendingRequest;
    Map<String, String> loggingExtras;
    private transient AppEventsLogger appEventsLogger;

    AuthorizationClient() {
    }

    void setContext(Context context) {
        this.context = context;
        this.startActivityDelegate = null;
    }

    void setContext(final Activity activity) {
        this.context = activity;
        this.startActivityDelegate = new StartActivityDelegate(){

            @Override
            public void startActivityForResult(Intent intent, int requestCode) {
                activity.startActivityForResult(intent, requestCode);
            }

            @Override
            public Activity getActivityContext() {
                return activity;
            }
        };
    }

    void startOrContinueAuth(AuthorizationRequest request) {
        if (this.getInProgress()) {
            this.continueAuth();
        } else {
            this.authorize(request);
        }
    }

    void authorize(AuthorizationRequest request) {
        if (request == null) {
            return;
        }
        if (this.pendingRequest != null) {
            throw new FacebookException("Attempted to authorize while a request is pending.");
        }
        if (request.needsNewTokenValidation() && !this.checkInternetPermission()) {
            return;
        }
        this.pendingRequest = request;
        this.handlersToTry = this.getHandlerTypes(request);
        this.tryNextHandler();
    }

    void continueAuth() {
        if (this.pendingRequest == null || this.currentHandler == null) {
            throw new FacebookException("Attempted to continue authorization without a pending request.");
        }
        if (this.currentHandler.needsRestart()) {
            this.currentHandler.cancel();
            this.tryCurrentHandler();
        }
    }

    boolean getInProgress() {
        return this.pendingRequest != null && this.currentHandler != null;
    }

    void cancelCurrentHandler() {
        if (this.currentHandler != null) {
            this.currentHandler.cancel();
        }
    }

    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.pendingRequest.getRequestCode()) {
            return this.currentHandler.onActivityResult(requestCode, resultCode, data);
        }
        return false;
    }

    private List<AuthHandler> getHandlerTypes(AuthorizationRequest request) {
        ArrayList<AuthHandler> handlers = new ArrayList<AuthHandler>();
        SessionLoginBehavior behavior = request.getLoginBehavior();
        if (behavior.allowsKatanaAuth()) {
            if (!request.isLegacy()) {
                handlers.add(new GetTokenAuthHandler());
            }
            handlers.add(new KatanaProxyAuthHandler());
        }
        if (behavior.allowsWebViewAuth()) {
            handlers.add(new WebViewAuthHandler());
        }
        return handlers;
    }

    boolean checkInternetPermission() {
        if (this.checkedInternetPermission) {
            return true;
        }
        int permissionCheck = this.checkPermission("android.permission.INTERNET");
        if (permissionCheck != 0) {
            String errorType = this.context.getString(R.string.com_facebook_internet_permission_error_title);
            String errorDescription = this.context.getString(R.string.com_facebook_internet_permission_error_message);
            this.complete(Result.createErrorResult(this.pendingRequest, errorType, errorDescription));
            return false;
        }
        this.checkedInternetPermission = true;
        return true;
    }

    void tryNextHandler() {
        if (this.currentHandler != null) {
            this.logAuthorizationMethodComplete(this.currentHandler.getNameForLogging(), EVENT_PARAM_METHOD_RESULT_SKIPPED, null, null, this.currentHandler.methodLoggingExtras);
        }
        while (this.handlersToTry != null && !this.handlersToTry.isEmpty()) {
            this.currentHandler = this.handlersToTry.remove(0);
            boolean started = this.tryCurrentHandler();
            if (!started) continue;
            return;
        }
        if (this.pendingRequest != null) {
            this.completeWithFailure();
        }
    }

    private void completeWithFailure() {
        this.complete(Result.createErrorResult(this.pendingRequest, "Login attempt failed.", null));
    }

    private void addLoggingExtra(String key, String value, boolean accumulate) {
        if (this.loggingExtras == null) {
            this.loggingExtras = new HashMap<String, String>();
        }
        if (this.loggingExtras.containsKey(key) && accumulate) {
            value = this.loggingExtras.get(key) + "," + value;
        }
        this.loggingExtras.put(key, value);
    }

    boolean tryCurrentHandler() {
        if (this.currentHandler.needsInternetPermission() && !this.checkInternetPermission()) {
            this.addLoggingExtra(EVENT_EXTRAS_MISSING_INTERNET_PERMISSION, "1", false);
            return false;
        }
        boolean tried = this.currentHandler.tryAuthorize(this.pendingRequest);
        if (tried) {
            this.logAuthorizationMethodStart(this.currentHandler.getNameForLogging());
        } else {
            this.addLoggingExtra(EVENT_EXTRAS_NOT_TRIED, this.currentHandler.getNameForLogging(), true);
        }
        return tried;
    }

    void completeAndValidate(Result outcome) {
        if (outcome.token != null && this.pendingRequest.needsNewTokenValidation()) {
            this.validateSameFbidAndFinish(outcome);
        } else {
            this.complete(outcome);
        }
    }

    void complete(Result outcome) {
        if (this.currentHandler != null) {
            this.logAuthorizationMethodComplete(this.currentHandler.getNameForLogging(), outcome, this.currentHandler.methodLoggingExtras);
        }
        if (this.loggingExtras != null) {
            outcome.loggingExtras = this.loggingExtras;
        }
        this.handlersToTry = null;
        this.currentHandler = null;
        this.pendingRequest = null;
        this.loggingExtras = null;
        this.notifyOnCompleteListener(outcome);
    }

    OnCompletedListener getOnCompletedListener() {
        return this.onCompletedListener;
    }

    void setOnCompletedListener(OnCompletedListener onCompletedListener) {
        this.onCompletedListener = onCompletedListener;
    }

    BackgroundProcessingListener getBackgroundProcessingListener() {
        return this.backgroundProcessingListener;
    }

    void setBackgroundProcessingListener(BackgroundProcessingListener backgroundProcessingListener) {
        this.backgroundProcessingListener = backgroundProcessingListener;
    }

    StartActivityDelegate getStartActivityDelegate() {
        if (this.startActivityDelegate != null) {
            return this.startActivityDelegate;
        }
        if (this.pendingRequest != null) {
            return new StartActivityDelegate(){

                @Override
                public void startActivityForResult(Intent intent, int requestCode) {
                    AuthorizationClient.this.pendingRequest.getStartActivityDelegate().startActivityForResult(intent, requestCode);
                }

                @Override
                public Activity getActivityContext() {
                    return AuthorizationClient.this.pendingRequest.getStartActivityDelegate().getActivityContext();
                }
            };
        }
        return null;
    }

    int checkPermission(String permission) {
        return this.context.checkCallingOrSelfPermission(permission);
    }

    void validateSameFbidAndFinish(Result pendingResult) {
        if (pendingResult.token == null) {
            throw new FacebookException("Can't validate without a token");
        }
        RequestBatch batch = this.createReauthValidationBatch(pendingResult);
        this.notifyBackgroundProcessingStart();
        batch.executeAsync();
    }

    RequestBatch createReauthValidationBatch(final Result pendingResult) {
        final ArrayList fbids = new ArrayList();
        final ArrayList grantedPermissions = new ArrayList();
        final ArrayList declinedPermissions = new ArrayList();
        String newToken = pendingResult.token.getToken();
        Request.Callback meCallback = new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                try {
                    GraphUser user = response.getGraphObjectAs(GraphUser.class);
                    if (user != null) {
                        fbids.add(user.getId());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        String validateSameFbidAsToken = this.pendingRequest.getPreviousAccessToken();
        Request requestCurrentTokenMe = this.createGetProfileIdRequest(validateSameFbidAsToken);
        requestCurrentTokenMe.setCallback(meCallback);
        Request requestNewTokenMe = this.createGetProfileIdRequest(newToken);
        requestNewTokenMe.setCallback(meCallback);
        Request requestCurrentTokenPermissions = this.createGetPermissionsRequest(validateSameFbidAsToken);
        requestCurrentTokenPermissions.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                try {
                    Session.PermissionsPair permissionsPair = Session.handlePermissionResponse(response);
                    if (permissionsPair != null) {
                        grantedPermissions.addAll(permissionsPair.getGrantedPermissions());
                        declinedPermissions.addAll(permissionsPair.getDeclinedPermissions());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        RequestBatch batch = new RequestBatch(requestCurrentTokenMe, requestNewTokenMe, requestCurrentTokenPermissions);
        batch.setBatchApplicationId(this.pendingRequest.getApplicationId());
        batch.addCallback(new RequestBatch.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBatchCompleted(RequestBatch batch) {
                try {
                    Result result = null;
                    if (fbids.size() == 2 && fbids.get(0) != null && fbids.get(1) != null && ((String)fbids.get(0)).equals(fbids.get(1))) {
                        AccessToken tokenWithPermissions = AccessToken.createFromTokenWithRefreshedPermissions(pendingResult.token, grantedPermissions, declinedPermissions);
                        result = Result.createTokenResult(AuthorizationClient.this.pendingRequest, tokenWithPermissions);
                    } else {
                        result = Result.createErrorResult(AuthorizationClient.this.pendingRequest, "User logged in as different Facebook user.", null);
                    }
                    AuthorizationClient.this.complete(result);
                }
                catch (Exception ex) {
                    AuthorizationClient.this.complete(Result.createErrorResult(AuthorizationClient.this.pendingRequest, "Caught exception", ex.getMessage()));
                }
                finally {
                    AuthorizationClient.this.notifyBackgroundProcessingStop();
                }
            }
        });
        return batch;
    }

    Request createGetPermissionsRequest(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("access_token", accessToken);
        return new Request(null, "me/permissions", parameters, HttpMethod.GET, null);
    }

    Request createGetProfileIdRequest(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id");
        parameters.putString("access_token", accessToken);
        return new Request(null, "me", parameters, HttpMethod.GET, null);
    }

    private AppEventsLogger getAppEventsLogger() {
        if (this.appEventsLogger == null || !this.appEventsLogger.getApplicationId().equals(this.pendingRequest.getApplicationId())) {
            this.appEventsLogger = AppEventsLogger.newLogger(this.context, this.pendingRequest.getApplicationId());
        }
        return this.appEventsLogger;
    }

    private void notifyOnCompleteListener(Result outcome) {
        if (this.onCompletedListener != null) {
            this.onCompletedListener.onCompleted(outcome);
        }
    }

    private void notifyBackgroundProcessingStart() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStarted();
        }
    }

    private void notifyBackgroundProcessingStop() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStopped();
        }
    }

    private void logAuthorizationMethodStart(String method) {
        Bundle bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingRequest.getAuthId());
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        bundle.putString(EVENT_PARAM_METHOD, method);
        this.getAppEventsLogger().logSdkEvent(EVENT_NAME_LOGIN_METHOD_START, null, bundle);
    }

    private void logAuthorizationMethodComplete(String method, Result result, Map<String, String> loggingExtras) {
        this.logAuthorizationMethodComplete(method, result.code.getLoggingValue(), result.errorMessage, result.errorCode, loggingExtras);
    }

    private void logAuthorizationMethodComplete(String method, String result, String errorMessage, String errorCode, Map<String, String> loggingExtras) {
        Bundle bundle = null;
        if (this.pendingRequest == null) {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle("");
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, Result.Code.ERROR.getLoggingValue());
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, "Unexpected call to logAuthorizationMethodComplete with null pendingRequest.");
        } else {
            bundle = AuthorizationClient.newAuthorizationLoggingBundle(this.pendingRequest.getAuthId());
            if (result != null) {
                bundle.putString(EVENT_PARAM_LOGIN_RESULT, result);
            }
            if (errorMessage != null) {
                bundle.putString(EVENT_PARAM_ERROR_MESSAGE, errorMessage);
            }
            if (errorCode != null) {
                bundle.putString(EVENT_PARAM_ERROR_CODE, errorCode);
            }
            if (loggingExtras != null && !loggingExtras.isEmpty()) {
                JSONObject jsonObject = new JSONObject(loggingExtras);
                bundle.putString(EVENT_PARAM_EXTRAS, jsonObject.toString());
            }
        }
        bundle.putString(EVENT_PARAM_METHOD, method);
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        this.getAppEventsLogger().logSdkEvent(EVENT_NAME_LOGIN_METHOD_COMPLETE, null, bundle);
    }

    static Bundle newAuthorizationLoggingBundle(String authLoggerId) {
        Bundle bundle = new Bundle();
        bundle.putLong(EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
        bundle.putString(EVENT_PARAM_AUTH_LOGGER_ID, authLoggerId);
        bundle.putString(EVENT_PARAM_METHOD, "");
        bundle.putString(EVENT_PARAM_LOGIN_RESULT, "");
        bundle.putString(EVENT_PARAM_ERROR_MESSAGE, "");
        bundle.putString(EVENT_PARAM_ERROR_CODE, "");
        bundle.putString(EVENT_PARAM_EXTRAS, "");
        return bundle;
    }

    private static String getE2E() {
        JSONObject e2e = new JSONObject();
        try {
            e2e.put("init", System.currentTimeMillis());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return e2e.toString();
    }

    private void logWebLoginCompleted(String applicationId, String e2e) {
        AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(this.context, applicationId);
        Bundle parameters = new Bundle();
        parameters.putString("fb_web_login_e2e", e2e);
        parameters.putLong("fb_web_login_switchback_time", System.currentTimeMillis());
        parameters.putString("app_id", applicationId);
        appEventsLogger.logSdkEvent("fb_dialogs_web_login_dialog_complete", null, parameters);
    }

    static class Result
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Code code;
        final AccessToken token;
        final String errorMessage;
        final String errorCode;
        final AuthorizationRequest request;
        Map<String, String> loggingExtras;

        private Result(AuthorizationRequest request, Code code, AccessToken token, String errorMessage, String errorCode) {
            this.request = request;
            this.token = token;
            this.errorMessage = errorMessage;
            this.code = code;
            this.errorCode = errorCode;
        }

        static Result createTokenResult(AuthorizationRequest request, AccessToken token) {
            return new Result(request, Code.SUCCESS, token, null, null);
        }

        static Result createCancelResult(AuthorizationRequest request, String message) {
            return new Result(request, Code.CANCEL, null, message, null);
        }

        static Result createErrorResult(AuthorizationRequest request, String errorType, String errorDescription) {
            return Result.createErrorResult(request, errorType, errorDescription, null);
        }

        static Result createErrorResult(AuthorizationRequest request, String errorType, String errorDescription, String errorCode) {
            String message = TextUtils.join((CharSequence)": ", Utility.asListNoNulls(errorType, errorDescription));
            return new Result(request, Code.ERROR, null, message, errorCode);
        }

        static enum Code {
            SUCCESS("success"),
            CANCEL("cancel"),
            ERROR("error");

            private final String loggingValue;

            private Code(String loggingValue) {
                this.loggingValue = loggingValue;
            }

            String getLoggingValue() {
                return this.loggingValue;
            }
        }
    }

    static class AuthorizationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient StartActivityDelegate startActivityDelegate;
        private final SessionLoginBehavior loginBehavior;
        private final int requestCode;
        private boolean isLegacy = false;
        private List<String> permissions;
        private final SessionDefaultAudience defaultAudience;
        private final String applicationId;
        private final String previousAccessToken;
        private final String authId;
        private boolean isRerequest = false;

        AuthorizationRequest(SessionLoginBehavior loginBehavior, int requestCode, boolean isLegacy, List<String> permissions, SessionDefaultAudience defaultAudience, String applicationId, String validateSameFbidAsToken, StartActivityDelegate startActivityDelegate, String authId) {
            this.loginBehavior = loginBehavior;
            this.requestCode = requestCode;
            this.isLegacy = isLegacy;
            this.permissions = permissions;
            this.defaultAudience = defaultAudience;
            this.applicationId = applicationId;
            this.previousAccessToken = validateSameFbidAsToken;
            this.startActivityDelegate = startActivityDelegate;
            this.authId = authId;
        }

        StartActivityDelegate getStartActivityDelegate() {
            return this.startActivityDelegate;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        SessionLoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        int getRequestCode() {
            return this.requestCode;
        }

        SessionDefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        boolean isLegacy() {
            return this.isLegacy;
        }

        void setIsLegacy(boolean isLegacy) {
            this.isLegacy = isLegacy;
        }

        String getPreviousAccessToken() {
            return this.previousAccessToken;
        }

        boolean needsNewTokenValidation() {
            return this.previousAccessToken != null && !this.isLegacy;
        }

        String getAuthId() {
            return this.authId;
        }

        boolean isRerequest() {
            return this.isRerequest;
        }

        void setRerequest(boolean isRerequest) {
            this.isRerequest = isRerequest;
        }
    }

    static class AuthDialogBuilder
    extends WebDialog.Builder {
        private static final String OAUTH_DIALOG = "oauth";
        static final String REDIRECT_URI = "fbconnect://success";
        private String e2e;
        private boolean isRerequest;

        public AuthDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, OAUTH_DIALOG, parameters);
        }

        public AuthDialogBuilder setE2E(String e2e) {
            this.e2e = e2e;
            return this;
        }

        public AuthDialogBuilder setIsRerequest(boolean isRerequest) {
            this.isRerequest = isRerequest;
            return this;
        }

        @Override
        public WebDialog build() {
            Bundle parameters = this.getParameters();
            parameters.putString("redirect_uri", REDIRECT_URI);
            parameters.putString("client_id", this.getApplicationId());
            parameters.putString("e2e", this.e2e);
            parameters.putString("response_type", "token");
            parameters.putString("return_scopes", "true");
            if (this.isRerequest && !Settings.getPlatformCompatibilityEnabled()) {
                parameters.putString("auth_type", "rerequest");
            }
            return new WebDialog(this.getContext(), OAUTH_DIALOG, parameters, this.getTheme(), this.getListener());
        }
    }

    class KatanaProxyAuthHandler
    extends KatanaAuthHandler {
        private static final long serialVersionUID = 1L;
        private String applicationId;

        KatanaProxyAuthHandler() {
        }

        @Override
        String getNameForLogging() {
            return "katana_proxy_auth";
        }

        @Override
        boolean tryAuthorize(AuthorizationRequest request) {
            this.applicationId = request.getApplicationId();
            String e2e = AuthorizationClient.getE2E();
            Intent intent = NativeProtocol.createProxyAuthIntent(AuthorizationClient.this.context, request.getApplicationId(), request.getPermissions(), e2e, request.isRerequest(), request.getDefaultAudience());
            this.addLoggingExtra("e2e", e2e);
            return this.tryIntent(intent, request.getRequestCode());
        }

        @Override
        boolean onActivityResult(int requestCode, int resultCode, Intent data) {
            Result outcome = data == null ? Result.createCancelResult(AuthorizationClient.this.pendingRequest, "Operation canceled") : (resultCode == 0 ? Result.createCancelResult(AuthorizationClient.this.pendingRequest, data.getStringExtra("error")) : (resultCode != -1 ? Result.createErrorResult(AuthorizationClient.this.pendingRequest, "Unexpected resultCode from authorization.", null) : this.handleResultOk(data)));
            if (outcome != null) {
                AuthorizationClient.this.completeAndValidate(outcome);
            } else {
                AuthorizationClient.this.tryNextHandler();
            }
            return true;
        }

        private Result handleResultOk(Intent data) {
            String e2e;
            Bundle extras = data.getExtras();
            String error = extras.getString("error");
            if (error == null) {
                error = extras.getString("error_type");
            }
            String errorCode = extras.getString("error_code");
            String errorMessage = extras.getString("error_message");
            if (errorMessage == null) {
                errorMessage = extras.getString("error_description");
            }
            if (!Utility.isNullOrEmpty(e2e = extras.getString("e2e"))) {
                AuthorizationClient.this.logWebLoginCompleted(this.applicationId, e2e);
            }
            if (error == null && errorCode == null && errorMessage == null) {
                AccessToken token = AccessToken.createFromWebBundle(AuthorizationClient.this.pendingRequest.getPermissions(), extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB);
                return Result.createTokenResult(AuthorizationClient.this.pendingRequest, token);
            }
            if (ServerProtocol.errorsProxyAuthDisabled.contains(error)) {
                return null;
            }
            if (ServerProtocol.errorsUserCanceled.contains(error)) {
                return Result.createCancelResult(AuthorizationClient.this.pendingRequest, null);
            }
            return Result.createErrorResult(AuthorizationClient.this.pendingRequest, error, errorMessage, errorCode);
        }
    }

    abstract class KatanaAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;

        KatanaAuthHandler() {
        }

        protected boolean tryIntent(Intent intent, int requestCode) {
            if (intent == null) {
                return false;
            }
            try {
                AuthorizationClient.this.getStartActivityDelegate().startActivityForResult(intent, requestCode);
            }
            catch (ActivityNotFoundException e) {
                return false;
            }
            return true;
        }
    }

    class GetTokenAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;
        private transient GetTokenClient getTokenClient;

        GetTokenAuthHandler() {
        }

        @Override
        String getNameForLogging() {
            return "get_token";
        }

        @Override
        void cancel() {
            if (this.getTokenClient != null) {
                this.getTokenClient.cancel();
                this.getTokenClient = null;
            }
        }

        @Override
        boolean needsRestart() {
            return this.getTokenClient == null;
        }

        @Override
        boolean tryAuthorize(final AuthorizationRequest request) {
            this.getTokenClient = new GetTokenClient(AuthorizationClient.this.context, request.getApplicationId());
            if (!this.getTokenClient.start()) {
                return false;
            }
            AuthorizationClient.this.notifyBackgroundProcessingStart();
            PlatformServiceClient.CompletedListener callback = new PlatformServiceClient.CompletedListener(){

                @Override
                public void completed(Bundle result) {
                    GetTokenAuthHandler.this.getTokenCompleted(request, result);
                }
            };
            this.getTokenClient.setCompletedListener(callback);
            return true;
        }

        void getTokenCompleted(AuthorizationRequest request, Bundle result) {
            this.getTokenClient = null;
            AuthorizationClient.this.notifyBackgroundProcessingStop();
            if (result != null) {
                ArrayList currentPermissions = result.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
                List<String> permissions = request.getPermissions();
                if (currentPermissions != null && (permissions == null || currentPermissions.containsAll(permissions))) {
                    AccessToken token = AccessToken.createFromNativeLogin(result, AccessTokenSource.FACEBOOK_APPLICATION_SERVICE);
                    Result outcome = Result.createTokenResult(AuthorizationClient.this.pendingRequest, token);
                    AuthorizationClient.this.completeAndValidate(outcome);
                    return;
                }
                ArrayList<String> newPermissions = new ArrayList<String>();
                for (String permission : permissions) {
                    if (currentPermissions.contains(permission)) continue;
                    newPermissions.add(permission);
                }
                if (!newPermissions.isEmpty()) {
                    this.addLoggingExtra(AuthorizationClient.EVENT_EXTRAS_NEW_PERMISSIONS, TextUtils.join((CharSequence)",", newPermissions));
                }
                request.setPermissions(newPermissions);
            }
            AuthorizationClient.this.tryNextHandler();
        }
    }

    class WebViewAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;
        private transient WebDialog loginDialog;
        private String applicationId;
        private String e2e;

        WebViewAuthHandler() {
        }

        @Override
        String getNameForLogging() {
            return "web_view";
        }

        @Override
        boolean needsRestart() {
            return true;
        }

        @Override
        boolean needsInternetPermission() {
            return true;
        }

        @Override
        void cancel() {
            if (this.loginDialog != null) {
                this.loginDialog.dismiss();
                this.loginDialog = null;
            }
        }

        @Override
        boolean tryAuthorize(final AuthorizationRequest request) {
            this.applicationId = request.getApplicationId();
            Bundle parameters = new Bundle();
            if (!Utility.isNullOrEmpty(request.getPermissions())) {
                String scope = TextUtils.join((CharSequence)",", request.getPermissions());
                parameters.putString("scope", scope);
                this.addLoggingExtra("scope", scope);
            }
            SessionDefaultAudience audience = request.getDefaultAudience();
            parameters.putString(AuthorizationClient.EVENT_EXTRAS_DEFAULT_AUDIENCE, audience.getNativeProtocolAudience());
            String previousToken = request.getPreviousAccessToken();
            if (!Utility.isNullOrEmpty(previousToken) && previousToken.equals(this.loadCookieToken())) {
                parameters.putString("access_token", previousToken);
                this.addLoggingExtra("access_token", "1");
            } else {
                Utility.clearFacebookCookies(AuthorizationClient.this.context);
                this.addLoggingExtra("access_token", "0");
            }
            WebDialog.OnCompleteListener listener = new WebDialog.OnCompleteListener(){

                @Override
                public void onComplete(Bundle values, FacebookException error) {
                    WebViewAuthHandler.this.onWebDialogComplete(request, values, error);
                }
            };
            this.e2e = AuthorizationClient.getE2E();
            this.addLoggingExtra("e2e", this.e2e);
            WebDialog.Builder builder = (WebDialog.Builder)new AuthDialogBuilder((Context)AuthorizationClient.this.getStartActivityDelegate().getActivityContext(), this.applicationId, parameters).setE2E(this.e2e).setIsRerequest(request.isRerequest()).setOnCompleteListener(listener);
            this.loginDialog = builder.build();
            this.loginDialog.show();
            return true;
        }

        void onWebDialogComplete(AuthorizationRequest request, Bundle values, FacebookException error) {
            Result outcome;
            if (values != null) {
                if (values.containsKey("e2e")) {
                    this.e2e = values.getString("e2e");
                }
                AccessToken token = AccessToken.createFromWebBundle(request.getPermissions(), values, AccessTokenSource.WEB_VIEW);
                outcome = Result.createTokenResult(AuthorizationClient.this.pendingRequest, token);
                CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)AuthorizationClient.this.context);
                syncManager.sync();
                this.saveCookieToken(token.getToken());
            } else if (error instanceof FacebookOperationCanceledException) {
                outcome = Result.createCancelResult(AuthorizationClient.this.pendingRequest, "User canceled log in.");
            } else {
                this.e2e = null;
                String errorCode = null;
                String errorMessage = error.getMessage();
                if (error instanceof FacebookServiceException) {
                    FacebookRequestError requestError = ((FacebookServiceException)error).getRequestError();
                    errorCode = String.format("%d", requestError.getErrorCode());
                    errorMessage = requestError.toString();
                }
                outcome = Result.createErrorResult(AuthorizationClient.this.pendingRequest, null, errorMessage, errorCode);
            }
            if (!Utility.isNullOrEmpty(this.e2e)) {
                AuthorizationClient.this.logWebLoginCompleted(this.applicationId, this.e2e);
            }
            AuthorizationClient.this.completeAndValidate(outcome);
        }

        private void saveCookieToken(String token) {
            Activity context = AuthorizationClient.this.getStartActivityDelegate().getActivityContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_STORE, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, token);
            if (!editor.commit()) {
                Utility.logd(AuthorizationClient.TAG, "Could not update saved web view auth handler token.");
            }
        }

        private String loadCookieToken() {
            Activity context = AuthorizationClient.this.getStartActivityDelegate().getActivityContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_STORE, 0);
            return sharedPreferences.getString(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, "");
        }
    }

    abstract class AuthHandler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Map<String, String> methodLoggingExtras;

        AuthHandler() {
        }

        abstract boolean tryAuthorize(AuthorizationRequest var1);

        abstract String getNameForLogging();

        boolean onActivityResult(int requestCode, int resultCode, Intent data) {
            return false;
        }

        boolean needsRestart() {
            return false;
        }

        boolean needsInternetPermission() {
            return false;
        }

        void cancel() {
        }

        protected void addLoggingExtra(String key, Object value) {
            if (this.methodLoggingExtras == null) {
                this.methodLoggingExtras = new HashMap<String, String>();
            }
            this.methodLoggingExtras.put(key, value == null ? null : value.toString());
        }
    }

    static interface StartActivityDelegate {
        public void startActivityForResult(Intent var1, int var2);

        public Activity getActivityContext();
    }

    static interface BackgroundProcessingListener {
        public void onBackgroundProcessingStarted();

        public void onBackgroundProcessingStopped();
    }

    static interface OnCompletedListener {
        public void onCompleted(Result var1);
    }
}

