/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.internal.api.AdViewApi;
import com.facebook.ads.internal.api.InterstitialAdApi;
import com.facebook.ads.internal.api.NativeAdBaseApi;
import com.facebook.ads.internal.api.RewardedVideoAdApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

@Keep
class DynamicLoaderFallback {
    private static final WeakHashMap<Object, AdListener> sApiProxyToAdListenersMap = new WeakHashMap();

    DynamicLoaderFallback() {
    }

    @SuppressLint(value={"Parameter Not Nullable", "CatchGeneralException"})
    static DynamicLoader makeFallbackLoader() {
        final ArrayList<Method> loadMethods = new ArrayList<Method>();
        final ArrayList<Method> loadWithConfigMethods = new ArrayList<Method>();
        final ArrayList<Method> withListenerMethods = new ArrayList<Method>();
        final ArrayList<Method> buildLoadConfigMethods = new ArrayList<Method>();
        final ArrayList<Method> createApiMethods = new ArrayList<Method>();
        final HashMap apiProxyToAdMap = new HashMap();
        final HashMap loadConfigBuilderProxyToApiMap = new HashMap();
        SimpleMethodCaptor simpleMethodCaptor = new SimpleMethodCaptor();
        DynamicLoader dynamicLoader = simpleMethodCaptor.mock(DynamicLoader.class);
        dynamicLoader.createInterstitialAd(null, null, null);
        createApiMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createRewardedVideoAd(null, null, null);
        createApiMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createAdViewApi(null, null, (AdSize)null, null, null);
        createApiMethods.add(simpleMethodCaptor.getLastMethod());
        try {
            dynamicLoader.createAdViewApi(null, null, (String)null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        createApiMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createNativeAdApi(null, null);
        final Method nativeAdCreateMethod = simpleMethodCaptor.getLastMethod();
        dynamicLoader.createNativeBannerAdApi(null, null);
        final Method nativeBannerAdCreateMethod = simpleMethodCaptor.getLastMethod();
        NativeAdBaseApi nativeAdBaseApi = simpleMethodCaptor.mock(NativeAdBaseApi.class);
        nativeAdBaseApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        nativeAdBaseApi.loadAd(null);
        loadWithConfigMethods.add(simpleMethodCaptor.getLastMethod());
        nativeAdBaseApi.buildLoadAdConfig(null);
        Method nativeAdBaseBuildLoadConfig = simpleMethodCaptor.getLastMethod();
        buildLoadConfigMethods.add(nativeAdBaseBuildLoadConfig);
        InterstitialAdApi interstitialAdApi = simpleMethodCaptor.mock(InterstitialAdApi.class);
        interstitialAdApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        interstitialAdApi.loadAd(null);
        loadWithConfigMethods.add(simpleMethodCaptor.getLastMethod());
        interstitialAdApi.buildLoadAdConfig();
        Method interstitialBuildLoadConfig = simpleMethodCaptor.getLastMethod();
        buildLoadConfigMethods.add(interstitialBuildLoadConfig);
        RewardedVideoAdApi rewardedVideoAdApi = simpleMethodCaptor.mock(RewardedVideoAdApi.class);
        rewardedVideoAdApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        rewardedVideoAdApi.loadAd(null);
        loadWithConfigMethods.add(simpleMethodCaptor.getLastMethod());
        rewardedVideoAdApi.buildLoadAdConfig();
        Method rewardedVideoBuildLoadConfig = simpleMethodCaptor.getLastMethod();
        buildLoadConfigMethods.add(rewardedVideoBuildLoadConfig);
        AdViewApi adViewApi = simpleMethodCaptor.mock(AdViewApi.class);
        adViewApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        adViewApi.loadAd(null);
        loadWithConfigMethods.add(simpleMethodCaptor.getLastMethod());
        adViewApi.buildLoadAdConfig();
        Method adViewBuildLoadConfig = simpleMethodCaptor.getLastMethod();
        buildLoadConfigMethods.add(adViewBuildLoadConfig);
        AdView.AdViewLoadConfigBuilder adViewBuilder = simpleMethodCaptor.mock(AdView.AdViewLoadConfigBuilder.class);
        adViewBuilder.withAdListener(null);
        withListenerMethods.add(simpleMethodCaptor.getLastMethod());
        NativeAdBase.NativeAdLoadConfigBuilder nativeAdLoadConfigBuilder = simpleMethodCaptor.mock(NativeAdBase.NativeAdLoadConfigBuilder.class);
        nativeAdLoadConfigBuilder.withAdListener(null);
        withListenerMethods.add(simpleMethodCaptor.getLastMethod());
        InterstitialAd.InterstitialAdLoadConfigBuilder interstitialAdLoadConfigBuilder = simpleMethodCaptor.mock(InterstitialAd.InterstitialAdLoadConfigBuilder.class);
        interstitialAdLoadConfigBuilder.withAdListener(null);
        withListenerMethods.add(simpleMethodCaptor.getLastMethod());
        RewardedVideoAd.RewardedVideoAdLoadConfigBuilder rewardedVideoAdLoadConfigBuilder = simpleMethodCaptor.mock(RewardedVideoAd.RewardedVideoAdLoadConfigBuilder.class);
        rewardedVideoAdLoadConfigBuilder.withAdListener(null);
        withListenerMethods.add(simpleMethodCaptor.getLastMethod());
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (method.getReturnType().isPrimitive()) {
                    if (method.getReturnType().equals(Void.TYPE)) {
                        Method loadMethod;
                        Iterator iterator = loadMethods.iterator();
                        while (!(!iterator.hasNext() || DynamicLoaderFallback.equalsMethods(method, loadMethod = (Method)iterator.next()) && DynamicLoaderFallback.reportError(proxy, apiProxyToAdMap))) {
                        }
                        iterator = loadWithConfigMethods.iterator();
                        while (!(!iterator.hasNext() || DynamicLoaderFallback.equalsMethods(method, loadMethod = (Method)iterator.next()) && DynamicLoaderFallback.reportError(proxy, apiProxyToAdMap))) {
                        }
                        return null;
                    }
                    return Array.get(Array.newInstance(method.getReturnType(), 1), 0);
                }
                if (method.getReturnType().equals(String.class)) {
                    return "";
                }
                Object resultProxy = method.getReturnType().equals(proxy.getClass().getInterfaces()[0]) ? proxy : Proxy.newProxyInstance(DynamicLoaderFallback.class.getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)this);
                for (Method withListenerMethod : withListenerMethods) {
                    if (!DynamicLoaderFallback.equalsMethods(method, withListenerMethod)) continue;
                    sApiProxyToAdListenersMap.put(loadConfigBuilderProxyToApiMap.get(proxy), (AdListener)args[0]);
                    break;
                }
                for (Method buildLoadConfigMethod : buildLoadConfigMethods) {
                    if (!DynamicLoaderFallback.equalsMethods(method, buildLoadConfigMethod)) continue;
                    loadConfigBuilderProxyToApiMap.put(resultProxy, proxy);
                }
                for (Method createMethod : createApiMethods) {
                    if (!DynamicLoaderFallback.equalsMethods(method, createMethod)) continue;
                    for (Object arg : args) {
                        if (!(arg instanceof Ad)) continue;
                        apiProxyToAdMap.put(resultProxy, (Ad)arg);
                    }
                }
                if (DynamicLoaderFallback.equalsMethods(method, nativeAdCreateMethod)) {
                    apiProxyToAdMap.put(args[1], (Ad)args[0]);
                }
                if (DynamicLoaderFallback.equalsMethods(method, nativeBannerAdCreateMethod)) {
                    apiProxyToAdMap.put(args[1], (Ad)args[0]);
                }
                return resultProxy;
            }
        };
        return (DynamicLoader)Proxy.newProxyInstance(DynamicLoaderFallback.class.getClassLoader(), new Class[]{DynamicLoader.class}, invocationHandler);
    }

    private static boolean reportError(@Nullable Object proxy, Map<Object, Ad> apiProxyToAd) {
        if (proxy == null) {
            return false;
        }
        final AdListener adListener = sApiProxyToAdListenersMap.get(proxy);
        final Ad ad = apiProxyToAd.get(proxy);
        if (adListener != null) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    adListener.onError(ad, new AdError(-1, "Can't load Audience Network Dex. Please, check that audience_network.dex is inside of assets folder."));
                }
            }, 500L);
            return true;
        }
        return false;
    }

    private static boolean equalsMethods(Method m1, Method m2) {
        return m1 != null && m2 != null && m1.getDeclaringClass().equals(m2.getDeclaringClass()) && m1.getName().equals(m2.getName()) && DynamicLoaderFallback.equalsMethodParams(m1, m2);
    }

    private static boolean equalsMethodParams(Method m1, Method m2) {
        return Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    private static class SimpleMethodCaptor {
        @Nullable
        private Method mLastInvokedMethod;
        private final InvocationHandler mInvocationHandler = new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (!"toString".equals(method.getName())) {
                    SimpleMethodCaptor.this.mLastInvokedMethod = method;
                }
                return null;
            }
        };

        private SimpleMethodCaptor() {
        }

        public <T> T mock(Class<T> clazz) {
            return clazz.cast(Proxy.newProxyInstance(DynamicLoaderFallback.class.getClassLoader(), new Class[]{clazz}, this.mInvocationHandler));
        }

        @Nullable
        Method getLastMethod() {
            return this.mLastInvokedMethod;
        }
    }
}

