/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.VideoAutoplayBehavior;
import com.facebook.ads.internal.api.NativeAdApi;
import com.facebook.ads.internal.api.NativeAdBaseApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.ads.internal.util.common.Preconditions;
import java.util.List;

@Keep
@UiThread
public class NativeAd
extends NativeAdBase {
    private NativeAdApi mNativeAdApi;

    public NativeAd(Context context, String placementId) {
        super(context, placementId);
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, NativeAdBaseApi nativeAdBaseApi) {
        super(nativeAdBaseApi);
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(this, this.mNativeAdBaseApi);
    }

    public NativeAd(Context context, NativeAdBase other) {
        super(context, other);
        this.mNativeAdApi = DynamicLoaderFactory.makeLoader(context).createNativeAdApi(other, this, this.mNativeAdBaseApi);
    }

    public NativeAdApi getNativeAdApi() {
        return this.mNativeAdApi;
    }

    @Deprecated
    VideoAutoplayBehavior getVideoAutoplayBehavior() {
        return this.mNativeAdApi.getVideoAutoplayBehavior();
    }

    public AdCreativeType getAdCreativeType() {
        return this.mNativeAdApi.getAdCreativeType();
    }

    public void registerViewForInteraction(View view, MediaView mediaView) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable MediaView adIconView) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, adIconView);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable List<View> clickableViews) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, clickableViews);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable MediaView adIconView, @Nullable List<View> clickableViews) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, adIconView, clickableViews);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable ImageView iconView) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, iconView);
    }

    public void registerViewForInteraction(View view, MediaView mediaView, @Nullable ImageView iconView, @Nullable List<View> clickableViews) {
        Preconditions.checkIsOnMainThread();
        this.mNativeAdApi.registerViewForInteraction(view, mediaView, iconView, clickableViews);
    }

    @Keep
    public static enum AdCreativeType {
        IMAGE,
        VIDEO,
        CAROUSEL,
        UNKNOWN;

    }
}

