/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.settings;

import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Serializable;
import java.util.ArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public class MultithreadedBundleWrapper {
    private final Bundle mBundle = new Bundle();

    public synchronized void putBoolean(String key, boolean value) {
        this.mBundle.putBoolean(key, value);
    }

    public synchronized boolean getBoolean(String key) {
        return this.mBundle.getBoolean(key);
    }

    public synchronized boolean getBoolean(String key, boolean value) {
        return this.mBundle.getBoolean(key, value);
    }

    @Nullable
    public synchronized ArrayList<String> getStringArrayList(String key) {
        return this.mBundle.getStringArrayList(key);
    }

    public synchronized void putStringArrayList(String key, ArrayList<String> list) {
        this.mBundle.putStringArrayList(key, list);
    }

    @Nullable
    public synchronized String getString(String key, @Nullable String defaultValue) {
        return this.mBundle.getString(key, defaultValue);
    }

    public synchronized void putString(String key, @Nullable String value) {
        this.mBundle.putString(key, value);
    }

    public synchronized void putSerializable(String key, Serializable value) {
        this.mBundle.putSerializable(key, value);
    }

    public synchronized void putStringArray(String key, String[] array) {
        this.mBundle.putStringArray(key, array);
    }

    @Nullable
    public synchronized String[] getStringArray(String key) {
        return this.mBundle.getStringArray(key);
    }

    public synchronized void putInteger(String key, @Nullable Integer value) {
        if (value != null) {
            this.mBundle.putInt(key, value.intValue());
        } else {
            this.mBundle.remove(key);
        }
    }

    @Nullable
    public synchronized Integer getInteger(String key) {
        return this.mBundle.containsKey(key) ? Integer.valueOf(this.mBundle.getInt(key)) : null;
    }

    @Nullable
    public synchronized Serializable getSerializable(String key) {
        return this.mBundle.getSerializable(key);
    }

    public Bundle toBundle() {
        return new Bundle(this.mBundle);
    }

    public synchronized void reset(Bundle bundle) {
        this.mBundle.clear();
        this.mBundle.putAll(bundle);
    }
}

