/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.NativeAd;
import com.facebook.ads.VideoAutoplayBehavior;
import com.facebook.ads.VideoStartReason;
import com.facebook.ads.internal.api.AdComponentFrameLayout;
import com.facebook.ads.internal.api.AdViewConstructorParams;
import com.facebook.ads.internal.api.MediaViewVideoRendererApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
public abstract class MediaViewVideoRenderer
extends AdComponentFrameLayout {
    @Deprecated
    @Nullable
    protected NativeAd nativeAd;
    @Deprecated
    protected VideoAutoplayBehavior videoAutoplayBehavior;
    private MediaViewVideoRendererApi mMediaViewVideoRendererApi;

    public MediaViewVideoRenderer(Context context) {
        super(context);
        this.initialize(new AdViewConstructorParams(context));
    }

    public MediaViewVideoRenderer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(new AdViewConstructorParams(context, attrs));
    }

    public MediaViewVideoRenderer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(new AdViewConstructorParams(context, attrs, defStyleAttr));
    }

    @TargetApi(value=21)
    public MediaViewVideoRenderer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(new AdViewConstructorParams(context, attrs, defStyleAttr, defStyleRes));
    }

    private void initialize(AdViewConstructorParams adViewConstructorParams) {
        this.mMediaViewVideoRendererApi = DynamicLoaderFactory.makeLoader(adViewConstructorParams.getContext()).createMediaViewVideoRendererApi();
        this.attachAdComponentViewApi(this.mMediaViewVideoRendererApi);
        this.mMediaViewVideoRendererApi.initialize(adViewConstructorParams, this);
    }

    public MediaViewVideoRendererApi getMediaViewVideoRendererApi() {
        return this.mMediaViewVideoRendererApi;
    }

    @Deprecated
    public void setNativeAd(NativeAd nativeAd) {
        this.nativeAd = nativeAd;
        this.videoAutoplayBehavior = nativeAd.getVideoAutoplayBehavior();
    }

    @Deprecated
    public void unsetNativeAd() {
        this.nativeAd = null;
        this.videoAutoplayBehavior = VideoAutoplayBehavior.DEFAULT;
    }

    public final void play(VideoStartReason startReason) {
        this.mMediaViewVideoRendererApi.play(startReason);
    }

    public final void pause(boolean pausedByUser) {
        this.mMediaViewVideoRendererApi.pause(pausedByUser);
    }

    @IntRange(from=0L)
    public final int getCurrentTimeMs() {
        return this.mMediaViewVideoRendererApi.getCurrentTimeMs();
    }

    public final void engageSeek() {
        this.mMediaViewVideoRendererApi.engageSeek();
    }

    public final void disengageSeek(VideoStartReason startReason) {
        this.mMediaViewVideoRendererApi.disengageSeek(startReason);
    }

    public final void seekTo(@IntRange(from=0L) int timeMs) {
        this.mMediaViewVideoRendererApi.seekTo(timeMs);
    }

    @IntRange(from=0L)
    public final int getDuration() {
        return this.mMediaViewVideoRendererApi.getDuration();
    }

    public final void setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.mMediaViewVideoRendererApi.setVolume(volume);
    }

    @FloatRange(from=0.0, to=1.0)
    public final float getVolume() {
        return this.mMediaViewVideoRendererApi.getVolume();
    }

    public final boolean shouldAutoplay() {
        return this.mMediaViewVideoRendererApi.shouldAutoplay();
    }

    @Deprecated
    final void setListener(Object listener) {
    }

    @Deprecated
    final View getVideoView() {
        return this.mMediaViewVideoRendererApi.getVideoView();
    }

    @Deprecated
    public void destroy() {
    }

    public void onPrepared() {
    }

    public void onPlayed() {
    }

    public void onPaused() {
    }

    public void onSeekEngaged() {
    }

    public void onSeek() {
    }

    public void onSeekDisengaged() {
    }

    public void onCompleted() {
    }

    public void onVolumeChanged() {
    }

    public void onError() {
    }

    public boolean shouldAllowBackgroundPlayback() {
        return false;
    }

    @Override
    public void addView(View child) {
    }

    @Override
    public void addView(View child, int index) {
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
    }

    @Override
    public void addView(View child, int width, int height) {
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
    }
}

