/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.UiThread;
import com.facebook.ads.Ad;
import com.facebook.ads.AdExperienceType;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.FullScreenAd;
import com.facebook.ads.RewardData;
import com.facebook.ads.RewardedVideoAdListener;
import com.facebook.ads.internal.api.RewardedVideoAdApi;
import com.facebook.ads.internal.bench.Benchmark;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@Keep
@UiThread
public class RewardedVideoAd
implements FullScreenAd {
    public static final int UNSET_VIDEO_DURATION = -1;
    private final RewardedVideoAdApi mRewardedVideoAdApi;

    @Benchmark
    public RewardedVideoAd(Context context, String placementID) {
        this.mRewardedVideoAdApi = DynamicLoaderFactory.makeLoader(context).createRewardedVideoAd(context, placementID, this);
    }

    @Override
    @Deprecated
    public void setExtraHints(ExtraHints extraHints) {
        this.mRewardedVideoAdApi.setExtraHints(extraHints);
    }

    @Override
    public void loadAd() {
        this.mRewardedVideoAdApi.loadAd();
    }

    @Benchmark
    public void loadAd(RewardedVideoLoadAdConfig rewardedVideoLoadAdConfig) {
        this.mRewardedVideoAdApi.loadAd(rewardedVideoLoadAdConfig);
    }

    @Override
    public boolean isAdInvalidated() {
        return this.mRewardedVideoAdApi.isAdInvalidated();
    }

    @Override
    public boolean show() {
        return this.mRewardedVideoAdApi.show();
    }

    @Benchmark
    public boolean show(RewardedVideoShowAdConfig rewardedVideoShowAdConfig) {
        return this.mRewardedVideoAdApi.show(rewardedVideoShowAdConfig);
    }

    @Override
    public void destroy() {
        this.mRewardedVideoAdApi.destroy();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public boolean isAdLoaded() {
        return this.mRewardedVideoAdApi.isAdLoaded();
    }

    @Override
    public String getPlacementId() {
        return this.mRewardedVideoAdApi.getPlacementId();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public int getVideoDuration() {
        return this.mRewardedVideoAdApi.getVideoDuration();
    }

    @Override
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public RewardedVideoAdLoadConfigBuilder buildLoadAdConfig() {
        return this.mRewardedVideoAdApi.buildLoadAdConfig();
    }

    @Override
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public RewardedVideoAdShowConfigBuilder buildShowAdConfig() {
        return this.mRewardedVideoAdApi.buildShowAdConfig();
    }

    @Keep
    public static interface RewardedVideoLoadAdConfig
    extends Ad.LoadAdConfig {
    }

    @Keep
    public static interface RewardedVideoShowAdConfig
    extends FullScreenAd.ShowAdConfig {
    }

    @Keep
    public static interface RewardedVideoAdLoadConfigBuilder
    extends Ad.LoadConfigBuilder {
        @Override
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoAdLoadConfigBuilder withBid(String var1);

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoAdLoadConfigBuilder withFailOnCacheFailureEnabled(boolean var1);

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoAdLoadConfigBuilder withRewardData(RewardData var1);

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoAdLoadConfigBuilder withAdListener(RewardedVideoAdListener var1);

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoAdLoadConfigBuilder withAdExperience(AdExperienceType var1);

        @Override
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoLoadAdConfig build();
    }

    @Keep
    public static interface RewardedVideoAdShowConfigBuilder
    extends FullScreenAd.ShowConfigBuilder {
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public RewardedVideoAdShowConfigBuilder withAppOrientation(int var1);

        @Override
        public RewardedVideoShowAdConfig build();
    }
}

