/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@Keep
public class ExtraHints {
    private static final int KEYWORDS_MAX_COUNT = 5;
    private static final String KEYWORD_SEPARATOR = ";";
    private static final String HINTS_JSON_KEY = "hints";
    private final String mHintsSerialized;
    @Nullable
    private final String mMediationData;

    private ExtraHints(HashMap<HintType, String> hints, @Nullable String mediationData) {
        this.mMediationData = mediationData;
        JSONObject hintsJsonWrapper = new JSONObject();
        JSONObject hintsJsonRoot = new JSONObject();
        for (Map.Entry<HintType, String> hint : hints.entrySet()) {
            try {
                hintsJsonRoot.put(hint.getKey().mKey, (Object)hint.getValue());
            }
            catch (JSONException jSONException) {}
        }
        try {
            hintsJsonWrapper.put(HINTS_JSON_KEY, (Object)hintsJsonRoot);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.mHintsSerialized = hintsJsonWrapper.toString();
    }

    public String getHints() {
        return this.mHintsSerialized;
    }

    @Nullable
    public String getMediationData() {
        return this.mMediationData;
    }

    private static String join(List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            sb.append(element);
            sb.append(KEYWORD_SEPARATOR);
        }
        return sb.toString();
    }

    public static enum HintType {
        KEYWORDS("keywords"),
        CONTENT_URL("content_url"),
        EXTRA_DATA("extra_data");

        private String mKey;

        private HintType(String key) {
            this.mKey = key;
        }
    }

    @Deprecated
    @Keep
    public static class Builder {
        private HashMap<HintType, String> mHints = new HashMap();
        private String mMediationData;

        @Deprecated
        public Builder keywords(List<Keyword> keywords) {
            return this;
        }

        public Builder extraData(String extraData) {
            if (extraData == null) {
                return this;
            }
            this.mHints.put(HintType.EXTRA_DATA, extraData);
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            if (contentUrl == null) {
                return this;
            }
            this.mHints.put(HintType.CONTENT_URL, contentUrl);
            return this;
        }

        public Builder mediationData(String mediationData) {
            if (TextUtils.isEmpty((CharSequence)mediationData)) {
                return this;
            }
            this.mMediationData = mediationData;
            return this;
        }

        public ExtraHints build() {
            return new ExtraHints(this.mHints, this.mMediationData);
        }
    }

    @Deprecated
    @Keep
    public static enum Keyword {
        ACCESSORIES("accessories"),
        ART_HISTORY("art_history"),
        AUTOMOTIVE("automotive"),
        BEAUTY("beauty"),
        BIOLOGY("biology"),
        BOARD_GAMES("board_games"),
        BUSINESS_SOFTWARE("business_software"),
        BUYING_SELLING_HOMES("buying_selling_homes"),
        CATS("cats"),
        CELEBRITIES("celebrities"),
        CLOTHING("clothing"),
        COMIC_BOOKS("comic_books"),
        DESKTOP_VIDEO("desktop_video"),
        DOGS("dogs"),
        EDUCATION("education"),
        EMAIL("email"),
        ENTERTAINMENT("entertainment"),
        FAMILY_PARENTING("family_parenting"),
        FASHION("fashion"),
        FINE_ART("fine_art"),
        FOOD_DRINK("food_drink"),
        FRENCH_CUISINE("french_cuisine"),
        GOVERNMENT("government"),
        HEALTH_FITNESS("health_fitness"),
        HOBBIES("hobbies"),
        HOME_GARDEN("home_garden"),
        HUMOR("humor"),
        INTERNET_TECHNOLOGY("internet_technology"),
        LARGE_ANIMALS("large_animals"),
        LAW("law"),
        LEGAL_ISSUES("legal_issues"),
        LITERATURE("literature"),
        MARKETING("marketing"),
        MOVIES("movies"),
        MUSIC("music"),
        NEWS("news"),
        PERSONAL_FINANCE("personal_finance"),
        PETS("pets"),
        PHOTOGRAPHY("photography"),
        POLITICS("politics"),
        REAL_ESTATE("real_estate"),
        ROLEPLAYING_GAMES("roleplaying_games"),
        SCIENCE("science"),
        SHOPPING("shopping"),
        SOCIETY("society"),
        SPORTS("sports"),
        TECHNOLOGY("technology"),
        TELEVISION("television"),
        TRAVEL("travel"),
        VIDEO_COMPUTER_GAMES("video_computer_games");

        private String mKeyword;

        private Keyword(String keyword) {
            this.mKeyword = keyword;
        }
    }
}

