/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.parcelable;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;

public class WrappedParcelable
implements Parcelable {
    @Nullable
    private final byte[] mParcelableBytes;
    public static final Parcelable.Creator<WrappedParcelable> CREATOR = new Parcelable.Creator<WrappedParcelable>(){

        public WrappedParcelable createFromParcel(Parcel in) {
            return new WrappedParcelable(in);
        }

        public WrappedParcelable[] newArray(int size) {
            return new WrappedParcelable[size];
        }
    };

    protected WrappedParcelable(Parcel in) {
        this.mParcelableBytes = in.createByteArray();
    }

    public WrappedParcelable(Parcelable wrapped) {
        this.mParcelableBytes = WrappedParcelable.marshallParcelable(wrapped);
    }

    public WrappedParcelable(@Nullable byte[] parcelableBytes) {
        this.mParcelableBytes = parcelableBytes;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mParcelableBytes);
    }

    @Nullable
    public Parcelable unwrap(ClassLoader classLoader) {
        Parcel parcel = Parcel.obtain();
        if (this.mParcelableBytes != null) {
            parcel.unmarshall(this.mParcelableBytes, 0, this.mParcelableBytes.length);
            parcel.setDataPosition(0);
            Parcelable result = parcel.readParcelable(classLoader);
            parcel.recycle();
            return result;
        }
        return null;
    }

    public static byte[] marshallParcelable(Parcelable parcelable) {
        Parcel parcel = Parcel.obtain();
        parcel.writeParcelable(parcelable, 0);
        byte[] marshalledParcelable = parcel.marshall();
        parcel.recycle();
        return marshalledParcelable;
    }
}

