/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.internal.dynamicloading.DexLoadErrorReporter;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFallback;
import com.facebook.ads.internal.settings.MultithreadedBundleWrapper;
import com.facebook.ads.internal.util.common.ANActivityLifecycleCallbacksListener;
import com.facebook.ads.internal.util.common.Preconditions;
import dalvik.system.DexClassLoader;
import dalvik.system.InMemoryDexClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Keep
public class DynamicLoaderFactory {
    static final String DEX_LOADING_ERROR_MESSAGE = "Can't load Audience Network Dex. Please, check that audience_network.dex is inside of assets folder.";
    private static final String DYNAMIC_LOADING_BUILD_TYPE = "releaseDL";
    public static final boolean LOAD_FROM_ASSETS = "releaseDL".equals(BuildConfig.BUILD_TYPE);
    private static final String CODE_CACHE_DIR = "code_cache";
    public static final String AUDIENCE_NETWORK_DEX = "audience_network.dex";
    private static final String AUDIENCE_NETWORK_CODE_PATH = "audience_network";
    private static final String OPTIMIZED_DEX_PATH = "optimized";
    private static final AtomicReference<DynamicLoader> sDynamicLoader = new AtomicReference();
    private static final AtomicBoolean sInitializing = new AtomicBoolean();
    private static boolean sFallbackMode;
    private static final int DEX_LOAD_RETRY_COUNT = 3;
    private static final int DEX_LOAD_RETRY_DELAY_MS = 200;
    private static final boolean USE_IN_MEMORY_CLASS_LOADER = false;
    private static boolean sUseLegacyClassLoader;

    @SuppressLint(value={"CatchGeneralException"})
    public static synchronized DynamicLoader makeLoaderUnsafe() {
        if (sDynamicLoader.get() == null) {
            Context appContext = DynamicLoaderFactory.getApplicationContextViaReflection();
            if (appContext != null) {
                return DynamicLoaderFactory.makeLoader(appContext, true);
            }
            throw new RuntimeException("You must call AudienceNetworkAds.buildInitSettings(Context).initialize() before you can use Audience Network SDK.");
        }
        return sDynamicLoader.get();
    }

    public static void initialize(final Context context, final @Nullable MultithreadedBundleWrapper initSettings, final @Nullable AudienceNetworkAds.InitListener initListener, final boolean fromContentProvider) {
        if (fromContentProvider || !sInitializing.getAndSet(true)) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @SuppressLint(value={"CatchGeneralException"})
                public void run() {
                    ANActivityLifecycleCallbacksListener.registerActivityCallbacks(context);
                    DynamicLoader dynamicLoader = null;
                    Throwable dexLoadThrowable = null;
                    Class<DynamicLoaderFactory> clazz = DynamicLoaderFactory.class;
                    synchronized (DynamicLoaderFactory.class) {
                        for (int i = 0; i < 3; ++i) {
                            try {
                                dynamicLoader = DynamicLoaderFactory.doMakeLoader(context, false);
                                break;
                            }
                            catch (Throwable t) {
                                if (i == 2) {
                                    dexLoadThrowable = t;
                                    if (fromContentProvider) continue;
                                    DexLoadErrorReporter.reportDexLoadingIssue(context, DynamicLoaderFactory.createErrorMessage(t), 0.1);
                                    DynamicLoaderFactory.setFallbackMode(true);
                                    continue;
                                }
                                SystemClock.sleep((long)200L);
                                continue;
                            }
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        DynamicLoaderFactory.doCallInitialize(context, dynamicLoader, dexLoadThrowable, fromContentProvider, initSettings, initListener);
                        sInitializing.set(false);
                        return;
                    }
                }
            }).start();
        }
    }

    private static void doCallInitialize(Context context, @Nullable DynamicLoader dynamicLoader, final @Nullable Throwable dexLoadThrowable, boolean fromContentProvider, @Nullable MultithreadedBundleWrapper initSettings, final @Nullable AudienceNetworkAds.InitListener initListener) {
        if (dexLoadThrowable != null) {
            if (initListener != null) {
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        initListener.onInitialized(DynamicLoaderFactory.createErrorInitResult(dexLoadThrowable));
                    }
                }, 100L);
            } else {
                Log.e((String)"FBAudienceNetwork", (String)DEX_LOADING_ERROR_MESSAGE, (Throwable)dexLoadThrowable);
            }
        } else if (dynamicLoader != null) {
            if (fromContentProvider) {
                dynamicLoader.createAudienceNetworkAdsApi().onContentProviderCreated(context);
            } else {
                dynamicLoader.createAudienceNetworkAdsApi().initialize(context, initSettings, initListener);
            }
        }
    }

    private static AudienceNetworkAds.InitResult createErrorInitResult(final Throwable t) {
        return new AudienceNetworkAds.InitResult(){

            @Override
            public boolean isSuccess() {
                return false;
            }

            @Override
            public String getMessage() {
                return DynamicLoaderFactory.createErrorMessage(t);
            }
        };
    }

    private static String createErrorMessage(Throwable t) {
        return "Can't load Audience Network Dex. Please, check that audience_network.dex is inside of assets folder.\n" + DynamicLoaderFactory.stackTraceToString(t);
    }

    public static synchronized DynamicLoader makeLoader(Context context) {
        return DynamicLoaderFactory.makeLoader(context, true);
    }

    @SuppressLint(value={"CatchGeneralException"})
    public static synchronized DynamicLoader makeLoader(Context context, boolean maybeInitInternally) {
        Preconditions.checkNotNull(context, "Context can not be null.");
        try {
            return DynamicLoaderFactory.doMakeLoader(context, maybeInitInternally);
        }
        catch (Throwable t) {
            Log.e((String)"FBAudienceNetwork", (String)DEX_LOADING_ERROR_MESSAGE, (Throwable)t);
            DexLoadErrorReporter.reportDexLoadingIssue(context, DynamicLoaderFactory.createErrorMessage(t), 0.1);
            DynamicLoader dynamicLoader = DynamicLoaderFallback.makeFallbackLoader();
            sDynamicLoader.set(dynamicLoader);
            sFallbackMode = true;
            return dynamicLoader;
        }
    }

    private static DynamicLoader doMakeLoader(Context context, boolean maybeInitInternally) throws Exception {
        DynamicLoader currentDynamicLoader = sDynamicLoader.get();
        if (currentDynamicLoader == null) {
            DynamicLoader dynamicLoader;
            if (!LOAD_FROM_ASSETS) {
                dynamicLoader = (DynamicLoader)Class.forName("com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl").newInstance();
            } else {
                long startTime = System.currentTimeMillis();
                ClassLoader adsSdkClassLoader = DynamicLoaderFactory.makeAdsSdkClassLoader(context.getApplicationContext());
                dynamicLoader = (DynamicLoader)adsSdkClassLoader.loadClass("com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl").newInstance();
                long loadingTime = System.currentTimeMillis() - startTime;
                Log.d((String)"FBAudienceNetwork", (String)("SDK dex loading time: " + loadingTime));
            }
            if (maybeInitInternally) {
                dynamicLoader.maybeInitInternally(context);
            }
            sDynamicLoader.set(dynamicLoader);
            return dynamicLoader;
        }
        return currentDynamicLoader;
    }

    public static synchronized void setFallbackMode(boolean enabled) {
        if (enabled) {
            sDynamicLoader.set(DynamicLoaderFallback.makeFallbackLoader());
            sFallbackMode = true;
        } else {
            sDynamicLoader.set(null);
            sFallbackMode = false;
        }
    }

    public static void setUseLegacyClassLoader(boolean useLegacyClassLoader) {
        sUseLegacyClassLoader = useLegacyClassLoader;
    }

    public static synchronized boolean isFallbackMode() {
        return sFallbackMode;
    }

    @Nullable
    public static DynamicLoader getDynamicLoader() {
        return sDynamicLoader.get();
    }

    private static DexClassLoader makeLegacyAdsSdkClassLoader(Context context) throws Exception {
        int length;
        String adsSdkDataDirLocation = context.getFilesDir().getPath() + File.separator + AUDIENCE_NETWORK_DEX;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream os = new FileOutputStream(adsSdkDataDirLocation);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        os.flush();
        ((OutputStream)os).close();
        File optimizedLibraryPath = context.getDir(OPTIMIZED_DEX_PATH, 0);
        return new DexClassLoader(adsSdkDataDirLocation, optimizedLibraryPath.getPath(), null, DynamicLoaderFactory.class.getClassLoader());
    }

    private static ClassLoader makeAdsSdkClassLoader(Context context) throws Exception {
        int length;
        if (sUseLegacyClassLoader) {
            return DynamicLoaderFactory.makeLegacyAdsSdkClassLoader(context);
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        File codeCacheDir = DynamicLoaderFactory.getCodeCacheDir(context, new File(applicationInfo.dataDir));
        File audienceNetworkCodeCacheDir = DynamicLoaderFactory.getSecondaryDir(codeCacheDir);
        String adsSdkDataDirLocation = audienceNetworkCodeCacheDir.getPath() + File.separator + AUDIENCE_NETWORK_DEX;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream os = new FileOutputStream(adsSdkDataDirLocation);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        os.flush();
        ((OutputStream)os).close();
        File optimizedAdsSdkDataDirLocation = new File(audienceNetworkCodeCacheDir.getPath() + File.separator + OPTIMIZED_DEX_PATH);
        DynamicLoaderFactory.mkdirChecked(optimizedAdsSdkDataDirLocation);
        return new DexClassLoader(adsSdkDataDirLocation, optimizedAdsSdkDataDirLocation.getPath(), null, context.getClassLoader());
    }

    @TargetApi(value=26)
    private static ClassLoader createInMemoryClassLoader(Context context) throws IOException {
        int length;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
        is.close();
        os.flush();
        os.close();
        ByteBuffer dexBytesBuffer = ByteBuffer.wrap(os.toByteArray());
        return new InMemoryDexClassLoader(dexBytesBuffer, DynamicLoaderFactory.class.getClassLoader());
    }

    @Nullable
    @SuppressLint(value={"PrivateApi", "CatchGeneralException"})
    private static Context getApplicationContextViaReflection() {
        try {
            return (Context)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Throwable t) {
            Log.e((String)"FBAudienceNetwork", (String)"Failed to fetch Context from  ActivityThread. Audience Network SDK won't work unless you call AudienceNetworkAds.buildInitSettings().withListener(InitListener).initialize().", (Throwable)t);
            return null;
        }
    }

    private static File getCodeCacheDir(Context context, File dataDir) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getCodeCacheDir();
        }
        return DynamicLoaderFactory.getCacheCodeDirLegacy(context, dataDir);
    }

    private static File getCacheCodeDirLegacy(Context context, File dataDir) throws IOException {
        File cache = new File(dataDir, CODE_CACHE_DIR);
        try {
            DynamicLoaderFactory.mkdirChecked(cache);
        }
        catch (IOException var5) {
            cache = context.getDir(CODE_CACHE_DIR, 0);
            DynamicLoaderFactory.mkdirChecked(cache);
        }
        return cache;
    }

    private static File getSecondaryDir(File cache) throws IOException {
        File dexDir = new File(cache, AUDIENCE_NETWORK_CODE_PATH);
        DynamicLoaderFactory.mkdirChecked(dexDir);
        return dexDir;
    }

    private static void mkdirChecked(File dir) throws IOException {
        dir.mkdir();
        if (!dir.isDirectory()) {
            File parent = dir.getParentFile();
            String detailedMessage = parent == null ? "Failed to create dir " + dir.getPath() + ". Parent file is null." : "Failed to create dir " + dir.getPath() + ". parent file is a dir " + parent.isDirectory() + ", a file " + parent.isFile() + ", exists " + parent.exists() + ", readable " + parent.canRead() + ", writable " + parent.canWrite();
            Log.e((String)"FBAudienceNetwork", (String)detailedMessage);
            throw new IOException("Failed to create directory " + dir.getPath() + ", detailed message: " + detailedMessage);
        }
    }

    private static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static {
        sUseLegacyClassLoader = true;
    }
}

