/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.common;

import android.os.Looper;
import android.support.annotation.Keep;
import com.facebook.ads.internal.shield.NoAutoExceptionHandling;

@Keep
@NoAutoExceptionHandling
public final class Preconditions {
    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return reference;
    }

    public static void checkIsTrue(boolean shouldBeTrue, String errorMessage) {
        if (!shouldBeTrue) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkIsOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new RuntimeException("Must be called from the UiThread");
        }
    }
}

