/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.api;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.UiThread;
import android.util.AttributeSet;

@Keep
@UiThread
public class AdViewConstructorParams {
    public static final int CONTEXT = 0;
    public static final int CONTEXT_ATTRS = 1;
    public static final int CONTEXT_ATTRS_STYLE_ATTR = 2;
    public static final int CONTEXT_ATTRS_STYLE_ATTR_STYLE_RES = 3;
    private final int mInitializationType;
    private final Context mContext;
    private final AttributeSet mAttributeSet;
    private final int mDefStyleAttr;
    private final int mDefStyleRes;

    public AdViewConstructorParams(Context context) {
        this.mInitializationType = 0;
        this.mContext = context;
        this.mAttributeSet = null;
        this.mDefStyleAttr = 0;
        this.mDefStyleRes = 0;
    }

    public AdViewConstructorParams(Context context, AttributeSet attrs) {
        this.mInitializationType = 1;
        this.mContext = context;
        this.mAttributeSet = attrs;
        this.mDefStyleAttr = 0;
        this.mDefStyleRes = 0;
    }

    public AdViewConstructorParams(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mInitializationType = 2;
        this.mContext = context;
        this.mAttributeSet = attrs;
        this.mDefStyleAttr = defStyleAttr;
        this.mDefStyleRes = 0;
    }

    public AdViewConstructorParams(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mInitializationType = 3;
        this.mContext = context;
        this.mAttributeSet = attrs;
        this.mDefStyleAttr = defStyleAttr;
        this.mDefStyleRes = defStyleRes;
    }

    public int getInitializationType() {
        return this.mInitializationType;
    }

    public AttributeSet getAttributeSet() {
        return this.mAttributeSet;
    }

    public int getDefStyleAttr() {
        return this.mDefStyleAttr;
    }

    public int getDefStyleRes() {
        return this.mDefStyleRes;
    }

    public Context getContext() {
        return this.mContext;
    }
}

