/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;

@Keep
public class ANActivityLifecycleCallbacksListener
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private static ANActivityLifecycleCallbacksListener sANActivityLifecycleCallbacksListener;
    private final Deque<WeakReference<Activity>> mActivityStack = new ArrayDeque<WeakReference<Activity>>();

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.mActivityStack.push(new WeakReference<Activity>(activity));
    }

    public void onActivityPaused(Activity activity) {
        if (!this.mActivityStack.isEmpty()) {
            this.mActivityStack.pop();
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public Deque<WeakReference<Activity>> getActivityStack() {
        return this.mActivityStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityCallbacks(Context context) {
        Context application = context.getApplicationContext();
        Class<ANActivityLifecycleCallbacksListener> clazz = ANActivityLifecycleCallbacksListener.class;
        synchronized (ANActivityLifecycleCallbacksListener.class) {
            if (application instanceof Application && sANActivityLifecycleCallbacksListener == null) {
                sANActivityLifecycleCallbacksListener = new ANActivityLifecycleCallbacksListener();
                ((Application)application).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sANActivityLifecycleCallbacksListener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    public static synchronized ANActivityLifecycleCallbacksListener getANActivityLifecycleCallbacksListener() {
        return sANActivityLifecycleCallbacksListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityCallbacks(Context context) {
        Context application = context.getApplicationContext();
        Class<ANActivityLifecycleCallbacksListener> clazz = ANActivityLifecycleCallbacksListener.class;
        synchronized (ANActivityLifecycleCallbacksListener.class) {
            if (application instanceof Application) {
                ((Application)application).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sANActivityLifecycleCallbacksListener);
                sANActivityLifecycleCallbacksListener = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

