/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.bench;

import android.util.Log;
import com.facebook.ads.internal.bench.InvocationTooSlowException;
import java.util.Locale;

public class BenchmarkReporter {
    private static final String TAG = "Benchmark";

    private BenchmarkReporter() {
    }

    public static void executed(String ownerClass, String methodName, String methodDesc, long timeNanos) {
        Log.v((String)TAG, (String)String.format(Locale.US, "Executed %s.%s%s: %d us", ownerClass, methodName, methodDesc, timeNanos / 1000L));
    }

    public static void executedWithWarning(String ownerClass, String methodName, String methodDesc, long timeNanos, long limitNanos) {
        Log.w((String)TAG, (String)String.format(Locale.US, "Executed (slow) %s.%s%s: %d us (limit %d us)", ownerClass, methodName, methodDesc, timeNanos / 1000L, limitNanos / 1000L));
    }

    public static void failed(String ownerClass, String methodName, String methodDesc, long timeNanos, long limitNanos) {
        Log.e((String)TAG, (String)String.format(Locale.US, "Execution of %s.%s%s took %d us (limit is %d us)", ownerClass, methodName, methodDesc, timeNanos / 1000L, limitNanos / 1000L));
        throw new InvocationTooSlowException(String.format(Locale.US, "Execution of %s.%s%s took %d us (limit is %d us)", ownerClass, methodName, methodDesc, timeNanos / 1000L, limitNanos / 1000L));
    }

    public static void thrown(String ownerClass, String methodName, String methodDesc, Throwable throwable, long timeNanos) {
        Log.e((String)TAG, (String)String.format(Locale.US, "Failed %s.%s%s: %d us (%s: %s)", ownerClass, methodName, methodDesc, timeNanos / 1000L, throwable.getClass().getName(), throwable.getMessage()));
    }
}

