/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.process;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.support.annotation.AnyThread;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@AnyThread
@Keep
public final class ProcessUtils {
    public static boolean sRemoteProcess = false;
    public static boolean sCurrentProcessCheckCalled;
    @Nullable
    private static String sProcessName;

    private ProcessUtils() {
    }

    @Nullable
    public static String getProcessName(Context context) {
        if (sProcessName != null) {
            return sProcessName;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return ProcessUtils.getProcessNameAPI28();
        }
        Context applicationContext = context.getApplicationContext();
        if (applicationContext instanceof Application) {
            sProcessName = ProcessUtils.getProcessNameViaReflection((Application)applicationContext);
            return sProcessName;
        }
        return null;
    }

    @Nullable
    private static String getProcessNameAPI28() {
        try {
            Method getProcessName = Application.class.getMethod("getProcessName", null);
            return (String)getProcessName.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static String getProcessNameViaReflection(Application app) {
        try {
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);
            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", null);
            return (String)getProcessName.invoke(activityThread, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getProcessSpecificName(String originalName, Context context) {
        String packageName = context.getPackageName();
        String processName = ProcessUtils.getProcessName(context);
        if (!TextUtils.isEmpty((CharSequence)processName) && !packageName.equals(processName)) {
            String shortProcessName = processName.contains(":") ? processName.split(":")[1] : processName;
            return originalName + "_" + shortProcessName;
        }
        return originalName;
    }
}

