/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.internal.api.AdViewApi;
import com.facebook.ads.internal.api.InstreamVideoAdViewApi;
import com.facebook.ads.internal.api.InterstitialAdApi;
import com.facebook.ads.internal.api.NativeAdBaseApi;
import com.facebook.ads.internal.api.RewardedVideoAdApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

@Keep
class DynamicLoaderFallback {
    private static final WeakHashMap<Object, AdListener> sListenersMap = new WeakHashMap();

    DynamicLoaderFallback() {
    }

    @SuppressLint(value={"Parameter Not Nullable", "CatchGeneralException"})
    static DynamicLoader makeFallbackLoader() {
        final ArrayList<Method> loadMethods = new ArrayList<Method>();
        final ArrayList<Method> setListenerMethods = new ArrayList<Method>();
        final ArrayList<Method> createMethods = new ArrayList<Method>();
        final HashMap createAdsMap = new HashMap();
        SimpleMethodCaptor simpleMethodCaptor = new SimpleMethodCaptor();
        DynamicLoader dynamicLoader = simpleMethodCaptor.mock(DynamicLoader.class);
        dynamicLoader.createInterstitialAd(null, null, null);
        createMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createRewardedVideoAd(null, null, null);
        createMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createInstreamVideoAdViewApi(null, null, null, null);
        createMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createAdViewApi(null, null, (AdSize)null, null, null);
        createMethods.add(simpleMethodCaptor.getLastMethod());
        try {
            dynamicLoader.createAdViewApi(null, null, (String)null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        createMethods.add(simpleMethodCaptor.getLastMethod());
        dynamicLoader.createNativeAdApi(null, null);
        final Method nativeAdCreateMethod = simpleMethodCaptor.getLastMethod();
        dynamicLoader.createNativeBannerAdApi(null, null);
        final Method nativeBannerAdCreateMethod = simpleMethodCaptor.getLastMethod();
        NativeAdBaseApi nativeAdBaseApi = simpleMethodCaptor.mock(NativeAdBaseApi.class);
        nativeAdBaseApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        nativeAdBaseApi.loadAd(null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        nativeAdBaseApi.loadAdFromBid(null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        nativeAdBaseApi.loadAdFromBid(null, null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        nativeAdBaseApi.buildLoadAdConfig();
        final Method nativeAdBaseBuildLoadConfig = simpleMethodCaptor.getLastMethod();
        nativeAdBaseApi.setAdListener(null, null);
        setListenerMethods.add(simpleMethodCaptor.getLastMethod());
        InterstitialAdApi interstitialAdApi = simpleMethodCaptor.mock(InterstitialAdApi.class);
        interstitialAdApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        interstitialAdApi.loadAd(null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        interstitialAdApi.loadAdFromBid(null, null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        interstitialAdApi.setAdListener(null);
        setListenerMethods.add(simpleMethodCaptor.getLastMethod());
        RewardedVideoAdApi rewardedVideoAdApi = simpleMethodCaptor.mock(RewardedVideoAdApi.class);
        rewardedVideoAdApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        rewardedVideoAdApi.loadAd(false);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        rewardedVideoAdApi.loadAdFromBid(null, false);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        rewardedVideoAdApi.setAdListener(null);
        setListenerMethods.add(simpleMethodCaptor.getLastMethod());
        InstreamVideoAdViewApi instreamVideoAdViewApi = simpleMethodCaptor.mock(InstreamVideoAdViewApi.class);
        instreamVideoAdViewApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        instreamVideoAdViewApi.loadAdFromBid(null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        instreamVideoAdViewApi.setAdListener(null);
        setListenerMethods.add(simpleMethodCaptor.getLastMethod());
        AdViewApi adViewApi = simpleMethodCaptor.mock(AdViewApi.class);
        adViewApi.loadAd();
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        adViewApi.loadAdFromBid(null);
        loadMethods.add(simpleMethodCaptor.getLastMethod());
        adViewApi.setAdListener(null);
        setListenerMethods.add(simpleMethodCaptor.getLastMethod());
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (method.getReturnType().isPrimitive()) {
                    if (method.getReturnType().equals(Boolean.TYPE)) {
                        return false;
                    }
                    if (method.getReturnType().equals(Integer.TYPE)) {
                        return -1;
                    }
                    if (method.getReturnType().equals(Byte.TYPE)) {
                        return -1;
                    }
                    if (method.getReturnType().equals(Short.TYPE)) {
                        return -1;
                    }
                    if (method.getReturnType().equals(Long.TYPE)) {
                        return -1L;
                    }
                    if (method.getReturnType().equals(Double.TYPE)) {
                        return 0.0;
                    }
                    if (method.getReturnType().equals(Float.TYPE)) {
                        return Float.valueOf(0.0f);
                    }
                    if (method.getReturnType().equals(Character.TYPE)) {
                        return 0;
                    }
                    if (method.getReturnType().equals(Void.TYPE)) {
                        Method loadMethod;
                        for (Method setMethod : setListenerMethods) {
                            if (!DynamicLoaderFallback.equalsMethods(method, setMethod)) continue;
                            sListenersMap.put(proxy, (AdListener)args[0]);
                            break;
                        }
                        Iterator iterator = loadMethods.iterator();
                        while (!(!iterator.hasNext() || DynamicLoaderFallback.equalsMethods(method, loadMethod = (Method)iterator.next()) && DynamicLoaderFallback.reportError(proxy, createAdsMap))) {
                        }
                        return null;
                    }
                    return null;
                }
                if (method.getReturnType().equals(String.class)) {
                    return "";
                }
                Object resultProxy = Proxy.newProxyInstance(DynamicLoaderFallback.class.getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)this);
                for (Method createMethod : createMethods) {
                    if (!DynamicLoaderFallback.equalsMethods(method, createMethod)) continue;
                    for (Object arg : args) {
                        if (!(arg instanceof Ad)) continue;
                        createAdsMap.put(resultProxy, (Ad)arg);
                    }
                }
                if (DynamicLoaderFallback.equalsMethods(method, nativeAdCreateMethod)) {
                    createAdsMap.put(args[1], (Ad)args[0]);
                }
                if (DynamicLoaderFallback.equalsMethods(method, nativeBannerAdCreateMethod)) {
                    createAdsMap.put(args[1], (Ad)args[0]);
                }
                if (DynamicLoaderFallback.equalsMethods(method, nativeAdBaseBuildLoadConfig)) {
                    DynamicLoaderFallback.reportError(proxy, createAdsMap);
                }
                return resultProxy;
            }
        };
        return (DynamicLoader)Proxy.newProxyInstance(DynamicLoaderFallback.class.getClassLoader(), new Class[]{DynamicLoader.class}, invocationHandler);
    }

    private static boolean reportError(Object proxy, Map<Object, Ad> createAdsMap) {
        final AdListener adListener = sListenersMap.get(proxy);
        final Ad ad = createAdsMap.get(proxy);
        if (adListener != null) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    adListener.onError(ad, new AdError(-1, "Can't load Audience Network Dex. Please, check that audience_network.dex is inside of assets folder."));
                }
            }, 500L);
            return true;
        }
        return false;
    }

    private static boolean equalsMethods(Method m1, Method m2) {
        return m1.getDeclaringClass().equals(m2.getDeclaringClass()) && m1.getName().equals(m2.getName());
    }

    private static class SimpleMethodCaptor {
        @Nullable
        private Method mLastInvokedMethod;
        private final InvocationHandler mInvocationHandler = new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) {
                if (!"toString".equals(method.getName())) {
                    SimpleMethodCaptor.this.mLastInvokedMethod = method;
                }
                return null;
            }
        };

        private SimpleMethodCaptor() {
        }

        public <T> T mock(Class<T> clazz) {
            return (T)Proxy.newProxyInstance(DynamicLoaderFallback.class.getClassLoader(), new Class[]{clazz}, this.mInvocationHandler);
        }

        @Nullable
        Method getLastMethod() {
            return this.mLastInvokedMethod;
        }
    }
}

