/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.facebook.ads.BuildConfig;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DexLoadErrorReporter {
    public static final double SAMPLING = 0.1;
    private static final String LOGGING_URL = "https://www.facebook.com/adnw_logging/";
    private static final AtomicBoolean sAlreadyReported = new AtomicBoolean();

    @SuppressLint(value={"CatchGeneralException"})
    public static void reportDexLoadingIssue(final Context context, final String error, double sampling) {
        if (!sAlreadyReported.get() && Math.random() < sampling) {
            sAlreadyReported.set(true);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    super.run();
                    HttpURLConnection conn = null;
                    FilterOutputStream os = null;
                    InputStream is = null;
                    try {
                        int nRead;
                        URL url = new URL(DexLoadErrorReporter.LOGGING_URL);
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                        conn.setRequestProperty("Accept", "application/json");
                        conn.setRequestProperty("Accept-Charset", "UTF-8");
                        conn.setRequestProperty("user-agent", "[FBAN/AudienceNetworkForAndroid;FBSN/Android]");
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.connect();
                        String sessionId = UUID.randomUUID().toString();
                        JSONObject eventsJSONData = new JSONObject();
                        eventsJSONData.put("attempt", (Object)"0");
                        DexLoadErrorReporter.addEnvFields(context, eventsJSONData, sessionId);
                        JSONObject eventData = new JSONObject();
                        eventData.put("subtype", (Object)"generic");
                        eventData.put("subtype_code", (Object)"1320");
                        eventData.put("caught_exception", (Object)"1");
                        eventData.put("stacktrace", (Object)error);
                        JSONObject event = new JSONObject();
                        event.put("id", (Object)UUID.randomUUID().toString());
                        event.put("type", (Object)"debug");
                        event.put("session_time", (Object)("" + System.currentTimeMillis() / 1000L));
                        event.put("time", (Object)("" + System.currentTimeMillis() / 1000L));
                        event.put("session_id", (Object)sessionId);
                        event.put("data", (Object)eventData);
                        event.put("attempt", (Object)"0");
                        DexLoadErrorReporter.addEnvFields(context, eventData, sessionId);
                        JSONArray eventsArray = new JSONArray();
                        eventsArray.put((Object)event);
                        JSONObject eventsJSON = new JSONObject();
                        eventsJSON.put("data", (Object)eventsJSONData);
                        eventsJSON.put("events", (Object)eventsArray);
                        String jsonPayload = eventsJSON.toString();
                        os = new DataOutputStream(conn.getOutputStream());
                        ((DataOutputStream)os).writeBytes("payload=" + URLEncoder.encode(jsonPayload, "UTF-8"));
                        ((DataOutputStream)os).flush();
                        byte[] data = new byte[16384];
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        is = conn.getInputStream();
                        while ((nRead = is.read(data)) != -1) {
                            buffer.write(data, 0, nRead);
                        }
                        buffer.flush();
                    }
                    catch (Throwable t) {
                        Log.e((String)"FBAudienceNetwork", (String)"Can't send error.", (Throwable)t);
                    }
                    finally {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)"FBAudienceNetwork", (String)"Can't close connection.", (Throwable)e);
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)"FBAudienceNetwork", (String)"Can't close connection.", (Throwable)e);
                        }
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }.start();
        }
    }

    private static void addEnvFields(Context context, JSONObject json, String sessionId) throws JSONException, PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        json.put("APPBUILD", context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode);
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
        json.put("APPNAME", (Object)context.getPackageManager().getApplicationLabel(applicationInfo));
        json.put("APPVERS", (Object)context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionName);
        json.put("OSVERS", (Object)Build.VERSION.RELEASE);
        json.put("SDK", (Object)"android");
        json.put("SESSION_ID", (Object)sessionId);
        json.put("MODEL", (Object)Build.MODEL);
        json.put("BUNDLE", (Object)packageName);
        json.put("SDK_VERSION", (Object)BuildConfig.VERSION_NAME);
        json.put("OS", (Object)"Android");
    }
}

