/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.bridge.gms;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;

@Keep
public class AdvertisingId {
    private final String mId;
    private final boolean mLimitAdTracking;

    public AdvertisingId(String id, boolean limitAdTracking) {
        this.mId = id;
        this.mLimitAdTracking = limitAdTracking;
    }

    public String getId() {
        return this.mId;
    }

    public boolean isLimitAdTracking() {
        return this.mLimitAdTracking;
    }

    @Nullable
    @SuppressLint(value={"CatchGeneralException"})
    public static AdvertisingId getAdvertisingIdInfoDirectly(Context context) {
        try {
            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            if (adInfo != null) {
                return new AdvertisingId(adInfo.getId(), adInfo.isLimitAdTrackingEnabled());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

