/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.ads.MediaViewListener;
import com.facebook.ads.MediaViewVideoRenderer;
import com.facebook.ads.internal.api.AdNativeComponentView;
import com.facebook.ads.internal.api.AdViewConstructorParams;
import com.facebook.ads.internal.api.MediaViewApi;
import com.facebook.ads.internal.api.MediaViewParentApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;

@Keep
@UiThread
public class MediaView
extends AdNativeComponentView {
    private boolean mImmutable;
    private MediaViewApi mMediaViewApi;

    public MediaView(Context context) {
        super(context);
        this.initializeSelf(new AdViewConstructorParams(context));
    }

    public MediaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeSelf(new AdViewConstructorParams(context, attrs));
    }

    public MediaView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeSelf(new AdViewConstructorParams(context, attrs, defStyleAttr));
    }

    @TargetApi(value=21)
    public MediaView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initializeSelf(new AdViewConstructorParams(context, attrs, defStyleAttr, defStyleRes));
    }

    private void initializeSelf(AdViewConstructorParams constructorParams) {
        this.mMediaViewApi = DynamicLoaderFactory.makeLoader(constructorParams.getContext()).createMediaViewApi();
        this.mMediaViewApi.initialize(constructorParams, this, new MediaViewParentApi(){

            @Override
            public void bringChildToFront(View child) {
                MediaView.super.bringChildToFront(child);
            }

            @Override
            public void setImmutable(boolean immutable) {
                MediaView.this.mImmutable = immutable;
            }
        });
        this.mImmutable = true;
    }

    public MediaViewApi getMediaViewApi() {
        return this.mMediaViewApi;
    }

    public void setVideoRenderer(MediaViewVideoRenderer newVideoRenderer) {
        this.mMediaViewApi.setVideoRenderer(newVideoRenderer);
    }

    public int getMediaWidth() {
        return this.mMediaViewApi.getMediaWidth();
    }

    public int getMediaHeight() {
        return this.mMediaViewApi.getMediaHeight();
    }

    @Override
    public View getAdContentsView() {
        return this.mMediaViewApi.getAdContentsView();
    }

    public void setListener(MediaViewListener listener) {
        this.mMediaViewApi.setListener(listener);
    }

    public void destroy() {
        this.mMediaViewApi.destroy();
    }

    public void addView(View child) {
        if (!this.mImmutable) {
            super.addView(child);
        }
    }

    public void addView(View child, int index) {
        if (!this.mImmutable) {
            super.addView(child, index);
        }
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (!this.mImmutable) {
            super.addView(child, params);
        }
    }

    public void addView(View child, int width, int height) {
        if (!this.mImmutable) {
            super.addView(child, width, height);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!this.mImmutable) {
            super.addView(child, index, params);
        }
    }

    public void bringChildToFront(View child) {
        this.mMediaViewApi.bringChildToFront(child);
    }
}

