/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.dynamicloading;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.ads.BuildConfig;
import com.facebook.ads.internal.dynamicloading.DynamicLoader;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl;
import com.facebook.ads.internal.util.common.Preconditions;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

@Keep
public class DynamicLoaderFactory {
    private static final String DYNAMIC_LOADING_BUILD_TYPE = "releaseDL";
    public static final boolean LOAD_FROM_ASSETS = "releaseDL".equals(BuildConfig.BUILD_TYPE);
    private static final String AUDIENCE_NETWORK_DEX = "audience_network.dex";
    private static final String OPTIMIZED_DEX_PATH = "optimized";
    private static DynamicLoader sDynamicLoader;

    @SuppressLint(value={"CatchGeneralException"})
    public static synchronized DynamicLoader makeLoaderUnsafe() {
        if (sDynamicLoader == null) {
            if (!LOAD_FROM_ASSETS) {
                try {
                    sDynamicLoader = (DynamicLoader)Class.forName(DynamicLoaderImpl.class.getName()).newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                Context appContext = DynamicLoaderFactory.getApplicationContextViaReflection();
                if (appContext != null) {
                    return DynamicLoaderFactory.makeLoader(appContext);
                }
                throw new RuntimeException("You must call AudienceNetworkAds.buildInitSettings(Context).initialize() before you can use Audience Network SDK.");
            }
        }
        return sDynamicLoader;
    }

    public static synchronized DynamicLoader makeLoader(Context context) {
        Preconditions.checkNotNull(context, "Context can not be null.");
        if (sDynamicLoader == null) {
            try {
                if (!LOAD_FROM_ASSETS) {
                    sDynamicLoader = (DynamicLoader)Class.forName(DynamicLoaderImpl.class.getName()).newInstance();
                } else {
                    DexClassLoader adsSdkClassLoader = DynamicLoaderFactory.makeAdsSdkClassLoader(context.getApplicationContext());
                    sDynamicLoader = (DynamicLoader)adsSdkClassLoader.loadClass("com.facebook.ads.internal.dynamicloading.DynamicLoaderImpl").newInstance();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sDynamicLoader;
    }

    @Nullable
    public static synchronized DynamicLoader getDynamicLoader() {
        return sDynamicLoader;
    }

    private static DexClassLoader makeAdsSdkClassLoader(Context context) throws Exception {
        int length;
        String adsSdkDataDirLocation = context.getFilesDir().getPath() + File.separator + AUDIENCE_NETWORK_DEX;
        InputStream is = context.getAssets().open(AUDIENCE_NETWORK_DEX);
        FileOutputStream os = new FileOutputStream(adsSdkDataDirLocation);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        os.flush();
        ((OutputStream)os).close();
        File optimizedLibraryPath = context.getDir(OPTIMIZED_DEX_PATH, 0);
        return new DexClassLoader(adsSdkDataDirLocation, optimizedLibraryPath.getPath(), null, DynamicLoaderFactory.class.getClassLoader());
    }

    @Nullable
    @SuppressLint(value={"PrivateApi", "CatchGeneralException"})
    private static Context getApplicationContextViaReflection() {
        try {
            return (Context)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Throwable t) {
            Log.e((String)"FBAudienceNetwork", (String)"Failed to fetch Context from  ActivityThread. Audience Network SDK won't work unless you call AudienceNetworkAds.buildInitSettings().withListener(InitListener).initialize().", (Throwable)t);
            return null;
        }
    }
}

