/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.util.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.internal.shield.NoAutoExceptionHandling;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

@Keep
@NoAutoExceptionHandling
public class ANActivityLifecycleCallbacksListener
implements Application.ActivityLifecycleCallbacks {
    public static final int ACTIVITY_CREATED = 1;
    public static final int ACTIVITY_STARTED = 2;
    public static final int ACTIVITY_RESUMED = 3;
    public static final int ACTIVITY_PAUSED = 4;
    public static final int ACTIVITY_STOPPED = 5;
    public static final int ACTIVITY_DESTROYED = 6;
    @Nullable
    private static ANActivityLifecycleCallbacksListener sANActivityLifecycleCallbacksListener;
    private static final Map<Activity, Integer> sActivityStateMap;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        sActivityStateMap.put(activity, 1);
    }

    public void onActivityStarted(Activity activity) {
        sActivityStateMap.put(activity, 2);
    }

    public void onActivityResumed(Activity activity) {
        sActivityStateMap.put(activity, 3);
    }

    public void onActivityPaused(Activity activity) {
        sActivityStateMap.put(activity, 4);
    }

    public void onActivityStopped(Activity activity) {
        sActivityStateMap.put(activity, 5);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        sActivityStateMap.put(activity, 6);
    }

    public Map<Activity, Integer> getActivityStateMap() {
        return sActivityStateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerActivityCallbacks(Context context) {
        Context application = context.getApplicationContext();
        Class<ANActivityLifecycleCallbacksListener> clazz = ANActivityLifecycleCallbacksListener.class;
        synchronized (ANActivityLifecycleCallbacksListener.class) {
            if (application instanceof Application && sANActivityLifecycleCallbacksListener == null) {
                sANActivityLifecycleCallbacksListener = new ANActivityLifecycleCallbacksListener();
                ((Application)application).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sANActivityLifecycleCallbacksListener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    public static synchronized ANActivityLifecycleCallbacksListener getANActivityLifecycleCallbacksListener() {
        return sANActivityLifecycleCallbacksListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterActivityCallbacks(Context context) {
        Context application = context.getApplicationContext();
        Class<ANActivityLifecycleCallbacksListener> clazz = ANActivityLifecycleCallbacksListener.class;
        synchronized (ANActivityLifecycleCallbacksListener.class) {
            if (application instanceof Application) {
                ((Application)application).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sANActivityLifecycleCallbacksListener);
                sANActivityLifecycleCallbacksListener = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        sActivityStateMap = Collections.synchronizedMap(new WeakHashMap());
    }
}

