/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.facebook.ads.Ad;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdViewAttributes;
import com.facebook.ads.internal.api.NativeAdBaseApi;
import com.facebook.ads.internal.api.NativeAdImageApi;
import com.facebook.ads.internal.api.NativeAdRatingApi;
import com.facebook.ads.internal.bench.Benchmark;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import org.json.JSONObject;

@Keep
public abstract class NativeAdBase
implements Ad {
    final NativeAdBaseApi mNativeAdBaseApi;

    @Benchmark
    public static NativeAdBase fromBidPayload(Context context, String placementId, String bidPayload) throws Exception {
        return DynamicLoaderFactory.makeLoader(context).createNativeAdBaseFromBidPayload(context, placementId, bidPayload);
    }

    @Benchmark
    public NativeAdBase(Context context, String placementId) {
        this.mNativeAdBaseApi = DynamicLoaderFactory.makeLoader(context).createNativeAdBaseApi(context, placementId);
    }

    @Benchmark
    public NativeAdBase(NativeAdBaseApi nativeAdBaseApi) {
        this.mNativeAdBaseApi = nativeAdBaseApi;
    }

    @Benchmark
    NativeAdBase(Context context, NativeAdBase other) {
        this.mNativeAdBaseApi = DynamicLoaderFactory.makeLoader(context).createNativeAdBaseApi(other.mNativeAdBaseApi);
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public NativeAdBaseApi getInternalNativeAd() {
        return this.mNativeAdBaseApi;
    }

    @Deprecated
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public void setAdListener(NativeAdListener adListener) {
        this.mNativeAdBaseApi.setAdListener(adListener, this);
    }

    @Override
    @Deprecated
    public void setExtraHints(ExtraHints extraHints) {
        this.mNativeAdBaseApi.setExtraHints(extraHints);
    }

    @Override
    public void loadAd() {
        this.mNativeAdBaseApi.loadAd();
    }

    @Benchmark
    public void loadAd(NativeLoadAdConfig loadAdConfig) {
        this.mNativeAdBaseApi.loadAd(loadAdConfig);
    }

    @Deprecated
    @Benchmark
    public void loadAd(MediaCacheFlag mediaCacheFlag) {
        this.mNativeAdBaseApi.loadAd(mediaCacheFlag);
    }

    @Override
    @Deprecated
    public void loadAdFromBid(String bidPayload) {
        this.mNativeAdBaseApi.loadAdFromBid(bidPayload);
    }

    @Deprecated
    @Benchmark
    public void loadAdFromBid(String bidPayload, MediaCacheFlag mediaCacheFlag) {
        this.mNativeAdBaseApi.loadAdFromBid(bidPayload, mediaCacheFlag);
    }

    @Benchmark
    public void downloadMedia() {
        this.mNativeAdBaseApi.downloadMedia();
    }

    @Override
    public void destroy() {
        this.mNativeAdBaseApi.destroy();
    }

    @Override
    public String getPlacementId() {
        return this.mNativeAdBaseApi.getPlacementId();
    }

    @Override
    public boolean isAdInvalidated() {
        return this.mNativeAdBaseApi.isAdInvalidated();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public boolean isAdLoaded() {
        return this.mNativeAdBaseApi.isAdLoaded();
    }

    @Deprecated
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public boolean isNativeConfigEnabled() {
        return false;
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public boolean hasCallToAction() {
        return this.mNativeAdBaseApi.hasCallToAction();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public Image getAdIcon() {
        return this.mNativeAdBaseApi.getAdIcon() == null ? null : new Image(this.mNativeAdBaseApi.getAdIcon());
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public Image getAdCoverImage() {
        return this.mNativeAdBaseApi.getAdCoverImage() == null ? null : new Image(this.mNativeAdBaseApi.getAdCoverImage());
    }

    @Deprecated
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public NativeAdViewAttributes getAdViewAttributes() {
        return new NativeAdViewAttributes();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdvertiserName() {
        return this.mNativeAdBaseApi.getAdvertiserName();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdHeadline() {
        return this.mNativeAdBaseApi.getAdHeadline();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public String getAdBodyText() {
        return this.mNativeAdBaseApi.getAdBodyText();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdUntrimmedBodyText() {
        return this.mNativeAdBaseApi.getAdUntrimmedBodyText();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdCallToAction() {
        return this.mNativeAdBaseApi.getAdCallToAction();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdSocialContext() {
        return this.mNativeAdBaseApi.getAdSocialContext();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdLinkDescription() {
        return this.mNativeAdBaseApi.getAdLinkDescription();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getSponsoredTranslation() {
        return this.mNativeAdBaseApi.getSponsoredTranslation();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdTranslation() {
        return this.mNativeAdBaseApi.getAdTranslation();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getPromotedTranslation() {
        return this.mNativeAdBaseApi.getPromotedTranslation();
    }

    @Deprecated
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public Rating getAdStarRating() {
        return this.mNativeAdBaseApi.getAdStarRating() == null ? null : new Rating(this.mNativeAdBaseApi.getAdStarRating());
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public String getId() {
        return this.mNativeAdBaseApi.getId();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public Image getAdChoicesIcon() {
        return this.mNativeAdBaseApi.getAdChoicesIcon() == null ? null : new Image(this.mNativeAdBaseApi.getAdChoicesIcon());
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    @Nullable
    public String getAdChoicesImageUrl() {
        return this.mNativeAdBaseApi.getAdChoicesImageUrl();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public float getAspectRatio() {
        return this.mNativeAdBaseApi.getAspectRatio();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public String getAdChoicesLinkUrl() {
        return this.mNativeAdBaseApi.getAdChoicesLinkUrl();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public String getAdChoicesText() {
        return this.mNativeAdBaseApi.getAdChoicesText();
    }

    @Nullable
    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public Drawable getPreloadedIconViewDrawable() {
        return this.mNativeAdBaseApi.getPreloadedIconViewDrawable();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public void onCtaBroadcast() {
        this.mNativeAdBaseApi.onCtaBroadcast();
    }

    @Benchmark
    public void unregisterView() {
        this.mNativeAdBaseApi.unregisterView();
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public void setOnTouchListener(View.OnTouchListener touchListener) {
        this.mNativeAdBaseApi.setOnTouchListener(touchListener);
    }

    @Benchmark(warnAtMillis=1, failAtMillis=5)
    public NativeAdLoadConfigBuilder buildLoadAdConfig() {
        return this.mNativeAdBaseApi.buildLoadAdConfig(this);
    }

    @Keep
    public static interface NativeLoadAdConfig
    extends Ad.LoadAdConfig {
    }

    @Keep
    public static interface NativeAdLoadConfigBuilder
    extends Ad.LoadConfigBuilder {
        public static final int UNKNOWN_IMAGE_SIZE = -1;

        public NativeAdLoadConfigBuilder withAdListener(NativeAdListener var1);

        @Override
        public NativeAdLoadConfigBuilder withBid(String var1);

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public NativeAdLoadConfigBuilder withMediaCacheFlag(MediaCacheFlag var1);

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public NativeAdLoadConfigBuilder withPreloadedIconView(int var1, int var2);

        @Deprecated
        @Benchmark
        public void loadAd();

        @Override
        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public NativeLoadAdConfig build();
    }

    @Keep
    public static enum NativeComponentTag {
        AD_ICON,
        AD_TITLE,
        AD_COVER_IMAGE,
        AD_SUBTITLE,
        AD_BODY,
        AD_CALL_TO_ACTION,
        AD_SOCIAL_CONTEXT,
        AD_CHOICES_ICON,
        AD_OPTIONS_VIEW,
        AD_MEDIA;


        public static void tagView(View view, NativeComponentTag tag) {
            DynamicLoaderFactory.makeLoader(view.getContext()).createNativeComponentTagApi().tagView(view, tag);
        }
    }

    @Keep
    public static enum MediaCacheFlag {
        NONE,
        ALL;

    }

    @Keep
    public static class Rating {
        private final NativeAdRatingApi mNativeAdRatingApi;

        @Benchmark
        Rating(NativeAdRatingApi nativeAdRatingApi) {
            this.mNativeAdRatingApi = nativeAdRatingApi;
        }

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public double getValue() {
            return this.mNativeAdRatingApi.getValue();
        }

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public double getScale() {
            return this.mNativeAdRatingApi.getScale();
        }

        @Benchmark
        @Nullable
        public static Rating fromJSONObject(JSONObject dataObject) {
            NativeAdRatingApi nativeAdRatingApi = DynamicLoaderFactory.makeLoaderUnsafe().createNativeAdRatingApi(dataObject);
            return nativeAdRatingApi == null ? null : new Rating(nativeAdRatingApi);
        }
    }

    @Keep
    public static class Image {
        private final NativeAdImageApi mNativeAdImageApi;

        @Benchmark
        Image(NativeAdImageApi nativeAdImageApi) {
            this.mNativeAdImageApi = nativeAdImageApi;
        }

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public int getWidth() {
            return this.mNativeAdImageApi.getWidth();
        }

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public int getHeight() {
            return this.mNativeAdImageApi.getHeight();
        }

        @Benchmark(warnAtMillis=1, failAtMillis=5)
        public String getUrl() {
            return this.mNativeAdImageApi.getUrl();
        }

        @Nullable
        @Benchmark
        public static Image fromJSONObject(JSONObject dataObject) {
            NativeAdImageApi nativeAdImageApi = DynamicLoaderFactory.makeLoaderUnsafe().createNativeAdImageApi(dataObject);
            return nativeAdImageApi == null ? null : new Image(nativeAdImageApi);
        }
    }
}

