/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import com.facebook.ads.internal.settings.AdInternalSettings;
import java.io.Serializable;
import java.util.Collection;

public class AdSettings {
    public static final boolean DEBUG = false;

    public static void setDebugBuild(boolean bl) {
        AdInternalSettings.setDebugBuild(bl);
    }

    public static void addTestDevice(String string) {
        AdInternalSettings.addTestDevice(string);
    }

    public static void addTestDevices(Collection<String> collection) {
        AdInternalSettings.addTestDevices(collection);
    }

    public static void clearTestDevices() {
        AdInternalSettings.clearTestDevices();
    }

    public static boolean isTestMode(Context context) {
        return AdInternalSettings.isTestMode(context);
    }

    public static void setTestMode(boolean bl) {
        AdInternalSettings.setTestMode(bl);
    }

    public static void setUrlPrefix(String string) {
        AdInternalSettings.setUrlPrefix(string);
    }

    public static String getUrlPrefix() {
        return AdInternalSettings.getUrlPrefix();
    }

    public static boolean isVideoAutoplay() {
        return AdInternalSettings.isVideoAutoplay();
    }

    public static boolean isVideoAutoplayOnMobile() {
        return AdInternalSettings.isVideoAutoplayOnMobile();
    }

    public static void setVideoAutoplay(boolean bl) {
        AdInternalSettings.setVideoAutoplay(bl);
    }

    public static void setVideoAutoplayOnMobile(boolean bl) {
        AdInternalSettings.setVideoAutoplayOnMobile(bl);
    }

    public static void setMediationService(String string) {
        AdInternalSettings.setMediationService(string);
    }

    public static String getMediationService() {
        return AdInternalSettings.getMediationService();
    }

    public static void setIsChildDirected(boolean bl) {
        AdInternalSettings.a.putBoolean("BOOL_CHILD_DIRECTED_KEY", bl);
    }

    public static boolean isChildDirected() {
        return AdInternalSettings.a.getBoolean("BOOL_CHILD_DIRECTED_KEY", false);
    }

    public static void setTestAdType(TestAdType testAdType) {
        AdInternalSettings.a.putSerializable("TEST_AD_TYPE_KEY", (Serializable)testAdType);
    }

    public static TestAdType getTestAdType() {
        Serializable serializable = AdInternalSettings.a.getSerializable("TEST_AD_TYPE_KEY");
        if (serializable == null || !(serializable instanceof TestAdType)) {
            AdInternalSettings.a.putSerializable("TEST_AD_TYPE_KEY", (Serializable)TestAdType.DEFAULT);
            return TestAdType.DEFAULT;
        }
        return (TestAdType)serializable;
    }

    public static void setVisibleAnimation(boolean bl) {
        AdInternalSettings.setVisibleAnimation(bl);
    }

    public static void setMultiprocessSupportMode(MultiprocessSupportMode multiprocessSupportMode) {
        AdInternalSettings.c = multiprocessSupportMode == MultiprocessSupportMode.MULTIPROCESS_SUPPORT_MODE_OFF;
    }

    public static void setIntegrationErrorMode(IntegrationErrorMode integrationErrorMode) {
        AdInternalSettings.a.putSerializable("SRL_INTEGRATION_ERROR_MODE_KEY", (Serializable)((Object)integrationErrorMode));
    }

    public static enum TestAdType implements Serializable
    {
        DEFAULT("DEFAULT", "Default"),
        IMG_16_9_APP_INSTALL("IMG_16_9_APP_INSTALL", "Image App install"),
        IMG_16_9_LINK("IMG_16_9_LINK", "Image link"),
        VIDEO_HD_16_9_46S_APP_INSTALL("VID_HD_16_9_46S_APP_INSTALL", "Video 46 sec App install"),
        VIDEO_HD_16_9_46S_LINK("VID_HD_16_9_46S_LINK", "Video 46 sec link"),
        VIDEO_HD_16_9_15S_APP_INSTALL("VID_HD_16_9_15S_APP_INSTALL", "Video 15 sec App install"),
        VIDEO_HD_16_9_15S_LINK("VID_HD_16_9_15S_LINK", "Video 15 sec link"),
        VIDEO_HD_9_16_39S_APP_INSTALL("VID_HD_9_16_39S_APP_INSTALL", "Video 39 sec App install"),
        VIDEO_HD_9_16_39S_LINK("VID_HD_9_16_39S_LINK", "Video 39 sec link"),
        CAROUSEL_IMG_SQUARE_APP_INSTALL("CAROUSEL_IMG_SQUARE_APP_INSTALL", "Carousel App install"),
        CAROUSEL_IMG_SQUARE_LINK("CAROUSEL_IMG_SQUARE_LINK", "Carousel link");

        public static final long serialVersionUID = 1L;
        private final String a;
        private final String b;

        private TestAdType(String string2, String string3) {
            this.a = string2;
            this.b = string3;
        }

        public String getAdTypeString() {
            return this.a;
        }

        public String getHumanReadable() {
            return this.b;
        }
    }

    public static enum IntegrationErrorMode {
        INTEGRATION_ERROR_CRASH_DEBUG_MODE,
        INTEGRATION_ERROR_CALLBACK_MODE;

        public static final long serialVersionUID = 1L;
    }

    public static enum MultiprocessSupportMode {
        MULTIPROCESS_SUPPORT_MODE_AUTO,
        MULTIPROCESS_SUPPORT_MODE_OFF;

        public static final long serialVersionUID = 1L;
    }
}

