/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.facebook.ads.NativeAd;
import com.facebook.ads.VideoAutoplayBehavior;
import com.facebook.ads.VideoStartReason;
import com.facebook.ads.internal.j.f;
import com.facebook.ads.internal.m.c;
import com.facebook.ads.internal.q.a.i;
import com.facebook.ads.internal.q.c.d;
import com.facebook.ads.internal.view.e.b.b;
import com.facebook.ads.internal.view.e.b.e;
import com.facebook.ads.internal.view.e.b.h;
import com.facebook.ads.internal.view.e.b.j;
import com.facebook.ads.internal.view.e.b.k;
import com.facebook.ads.internal.view.e.b.l;
import com.facebook.ads.internal.view.e.b.m;
import com.facebook.ads.internal.view.e.b.p;
import com.facebook.ads.internal.view.e.b.q;
import com.facebook.ads.internal.view.e.b.v;
import com.facebook.ads.internal.view.e.b.w;
import com.facebook.ads.internal.view.e.d.d;
import com.facebook.ads.internal.view.n;
import com.facebook.ads.internal.view.o;

public abstract class MediaViewVideoRenderer
extends FrameLayout {
    private static final String d = MediaViewVideoRenderer.class.getSimpleName();
    private final m e = new m(){

        @Override
        public void a(l l2) {
            MediaViewVideoRenderer.this.onPrepared();
        }
    };
    private final k f = new k(){

        @Override
        public void a(j j2) {
            MediaViewVideoRenderer.this.onPlayed();
        }
    };
    private final com.facebook.ads.internal.view.e.b.i g = new com.facebook.ads.internal.view.e.b.i(){

        @Override
        public void a(h h2) {
            MediaViewVideoRenderer.this.onPaused();
        }
    };
    private final q h = new q(){

        @Override
        public void a(p p2) {
            MediaViewVideoRenderer.this.onSeek();
        }
    };
    private final com.facebook.ads.internal.view.e.b.c i = new com.facebook.ads.internal.view.e.b.c(){

        @Override
        public void a(b b2) {
            MediaViewVideoRenderer.this.onCompleted();
        }
    };
    private final w j = new w(){

        @Override
        public void a(v v2) {
            MediaViewVideoRenderer.this.onVolumeChanged();
        }
    };
    private final e k = new e(){

        @Override
        public void a(com.facebook.ads.internal.view.e.b.d d2) {
            MediaViewVideoRenderer.this.onError();
        }
    };
    @Nullable
    protected NativeAd a;
    protected VideoAutoplayBehavior b;
    private boolean l;
    private boolean m;
    private boolean n = true;
    private boolean o = true;
    final n c;

    public MediaViewVideoRenderer(Context context) {
        super(context);
        this.c = new n(context);
        this.a();
    }

    public MediaViewVideoRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.c = new n(context, attributeSet);
        this.a();
    }

    public MediaViewVideoRenderer(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.c = new n(context, attributeSet, n2);
        this.a();
    }

    @TargetApi(value=21)
    public MediaViewVideoRenderer(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.c = new n(context, attributeSet, n2, n3);
        this.a();
    }

    private void a() {
        this.c.setEnableBackgroundVideo(this.shouldAllowBackgroundPlayback());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.c.setLayoutParams(layoutParams);
        this.addView((View)this.c);
        com.facebook.ads.internal.q.a.i.a((View)this.c, com.facebook.ads.internal.q.a.i.n);
        this.c.getEventBus().a((com.facebook.ads.internal.j.d)new f[]{this.e, this.f, this.g, this.h, this.i, this.j, this.k});
    }

    public void setNativeAd(NativeAd nativeAd) {
        this.a = nativeAd;
        this.c.a(nativeAd.d(), nativeAd.g());
        this.c.setVideoMPD(nativeAd.c());
        this.c.setVideoURI(nativeAd.b());
        this.c.setVideoCTA(nativeAd.getAdCallToAction());
        this.c.setNativeAd(nativeAd);
        this.b = nativeAd.e();
    }

    public void unsetNativeAd() {
        this.pause(false);
        this.c.a(null, null);
        this.c.setVideoMPD(null);
        this.c.setVideoURI((Uri)null);
        this.c.setVideoCTA(null);
        this.c.setNativeAd(null);
        this.b = VideoAutoplayBehavior.DEFAULT;
        this.a = null;
    }

    public final void play(VideoStartReason videoStartReason) {
        this.c.a(videoStartReason.a());
    }

    public final void pause(boolean bl) {
        this.c.a(bl);
    }

    @IntRange(from=0L)
    public final int getCurrentTimeMs() {
        return this.c.getCurrentPosition();
    }

    public final void engageSeek() {
        if (this.l) {
            Log.w((String)d, (String)"engageSeek called without disengageSeek.");
            return;
        }
        this.l = true;
        this.m = com.facebook.ads.internal.view.e.d.d.d.equals((Object)this.c.getState());
        this.c.a(false);
        this.onSeekEngaged();
    }

    public final void disengageSeek(VideoStartReason videoStartReason) {
        if (!this.l) {
            Log.w((String)d, (String)"disengageSeek called without engageSeek.");
            return;
        }
        this.l = false;
        if (this.m) {
            this.c.a(videoStartReason.a());
        }
        this.onSeekDisengaged();
    }

    public final void seekTo(@IntRange(from=0L) int n2) {
        if (!this.l) {
            Log.w((String)d, (String)"Seeking must be preceded by a call to engageSeek, and followed by a call to disengageSeek.");
            return;
        }
        this.c.a(n2);
    }

    @IntRange(from=0L)
    public final int getDuration() {
        return this.c.getDuration();
    }

    public final void setVolume(@FloatRange(from=0.0, to=1.0) float f2) {
        this.c.setVolume(f2);
    }

    @FloatRange(from=0.0, to=0.0)
    public final float getVolume() {
        return this.c.getVolume();
    }

    @Deprecated
    void setAutoplay(boolean bl) {
        this.n = bl;
    }

    @Deprecated
    void setAutoplayOnMobile(boolean bl) {
        this.o = bl;
    }

    public boolean shouldAutoplay() {
        if (this.c == null || this.c.getState() == com.facebook.ads.internal.view.e.d.d.g) {
            return false;
        }
        if (this.b == VideoAutoplayBehavior.DEFAULT) {
            return this.n && (this.o || com.facebook.ads.internal.q.c.d.c(this.getContext()) == d.a.c);
        }
        return this.b == VideoAutoplayBehavior.ON;
    }

    final void setAdEventManager(c c2) {
        this.c.setAdEventManager(c2);
    }

    final void setListener(o o2) {
        this.c.setListener(o2);
    }

    public void destroy() {
        this.c.k();
    }

    public void onPrepared() {
    }

    public void onPlayed() {
    }

    public void onPaused() {
    }

    public void onSeekEngaged() {
    }

    public void onSeek() {
    }

    public void onSeekDisengaged() {
    }

    public void onCompleted() {
    }

    public void onVolumeChanged() {
    }

    public void onError() {
    }

    public boolean shouldAllowBackgroundPlayback() {
        return false;
    }
}

