/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.facebook.accountkit.R;
import com.facebook.accountkit.ui.AspectFrameLayout;
import com.facebook.accountkit.ui.CountryCodeSpinner;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.WhatsAppButton;

final class ViewUtility {
    private static final double TEXT_COLOR_CONTRAST_THRESHOLD = 1.5;

    ViewUtility() {
    }

    static void applyThemeAttributes(Context context, UIManager uiManager, View view) {
        if (context == null || view == null) {
            return;
        }
        if (view instanceof Button) {
            ViewUtility.applyButtonThemeAttributes(context, uiManager, (Button)view);
        } else if (view instanceof EditText) {
            ViewUtility.applyInputThemeAttributes(context, uiManager, (EditText)view);
        } else if (view instanceof ProgressBar) {
            ViewUtility.applyProgressBarThemeAttributes(context, uiManager, (ProgressBar)view);
        } else if (view instanceof CountryCodeSpinner) {
            ViewUtility.applySpinnerThemeAttributes(context, uiManager, (CountryCodeSpinner)view);
        } else if (view instanceof TextView) {
            ViewUtility.applyTextViewThemeAttributes(context, uiManager, (TextView)view);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewUtility.applyThemeAttributes(context, uiManager, viewGroup.getChildAt(i));
            }
        }
    }

    static void applyThemeBackground(Context context, UIManager uiManager, View view) {
        if (context == null || view == null) {
            return;
        }
        if (uiManager instanceof SkinManager) {
            ViewUtility.applySkinThemedBackground(context, (SkinManager)uiManager, view);
        } else {
            ViewUtility.applyLegacyThemedBackground(context, view);
        }
    }

    private static void applySkinThemedBackground(Context context, SkinManager skinManager, View view) {
        ColorDrawable background;
        Object object = background = skinManager.hasBackgroundImage() ? ViewUtility.getDrawable(context.getResources(), skinManager.getBackgroundImageResId()) : new ColorDrawable(ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_default_skin_background));
        if (skinManager.hasBackgroundImage()) {
            if (view instanceof AspectFrameLayout) {
                ((AspectFrameLayout)view).setAspectWidth(background.getIntrinsicWidth());
                ((AspectFrameLayout)view).setAspectHeight(background.getIntrinsicHeight());
            }
            background.setColorFilter(skinManager.getTintColor(), PorterDuff.Mode.SRC_ATOP);
        }
        ViewUtility.setBackground(view, (Drawable)background);
    }

    private static Drawable getLegacyThemedBackground(Context context, View view) {
        ColorDrawable drawable2;
        Resources.Theme theme = context.getTheme();
        TypedValue drawableValue = new TypedValue();
        theme.resolveAttribute(R.attr.com_accountkit_background, drawableValue, true);
        Object object = drawable2 = drawableValue.resourceId == 0 ? new ColorDrawable(ViewUtility.getColor(context, R.attr.com_accountkit_background_color, -1)) : ViewUtility.getDrawable(context.getResources(), drawableValue.resourceId);
        if (drawableValue.resourceId > 0) {
            if (view instanceof AspectFrameLayout) {
                ((AspectFrameLayout)view).setAspectWidth(drawable2.getIntrinsicWidth());
                ((AspectFrameLayout)view).setAspectHeight(drawable2.getIntrinsicHeight());
            }
            int color2 = ViewUtility.getColor(context, R.attr.com_accountkit_background_color, -1);
            ViewUtility.applyThemeColor(context, (Drawable)drawable2, color2);
        }
        return drawable2;
    }

    private static void applyLegacyThemedBackground(Context context, View view) {
        Drawable drawable2 = ViewUtility.getLegacyThemedBackground(context, view);
        ViewUtility.setBackground(view, drawable2);
    }

    static void applyThemeColor(Context context, Drawable drawable2, @ColorInt int color2) {
        if (context == null || drawable2 == null) {
            return;
        }
        drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    static void applyThemeColor(Context context, ImageView imageView, @ColorInt int color2) {
        if (context == null || imageView == null) {
            return;
        }
        imageView.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    static int getDimensionPixelSize(Context context, int size) {
        return (int)TypedValue.applyDimension((int)1, (float)size, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    static boolean isTablet(Context context) {
        boolean xlarge = (context.getResources().getConfiguration().screenLayout & 0xF) == 4;
        boolean large = (context.getResources().getConfiguration().screenLayout & 0xF) == 3;
        return xlarge || large;
    }

    static void showKeyboard(View view) {
        if (view == null || view.getContext() == null) {
            return;
        }
        if (view.requestFocus()) {
            ((InputMethodManager)view.getContext().getSystemService("input_method")).showSoftInput(view, 1);
        }
    }

    static void hideKeyboard(Activity activity) {
        View rootView = activity.findViewById(0x1020002);
        if (rootView == null) {
            return;
        }
        View focusView = rootView.findFocus();
        if (focusView != null) {
            focusView.clearFocus();
        }
        ((InputMethodManager)activity.getSystemService("input_method")).hideSoftInputFromWindow(rootView.getWindowToken(), 1);
    }

    static boolean useLegacy(UIManager uiManager) {
        return !(uiManager instanceof SkinManager);
    }

    static boolean isSkin(UIManager uiManager, SkinManager.Skin skin) {
        return uiManager instanceof SkinManager && ((SkinManager)uiManager).getSkin() == skin;
    }

    private static void applyButtonThemeAttributes(Context context, UIManager uiManager, Button button) {
        int disabledBorderColor;
        int disabledFilledColor;
        int primaryColor;
        int pressedBorderColor;
        int pressedFilledColor;
        int enabledBorderColor;
        int enabledFilledColor;
        if (button instanceof WhatsAppButton) {
            int whatsAppColor = ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_enable_background);
            int whatsAppBorderColor = ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_enable_border);
            enabledFilledColor = whatsAppColor;
            enabledBorderColor = whatsAppBorderColor;
            pressedFilledColor = whatsAppColor;
            pressedBorderColor = whatsAppBorderColor;
        } else if (!ViewUtility.useLegacy(uiManager)) {
            enabledFilledColor = primaryColor = ViewUtility.getPrimaryColor(context, uiManager);
            enabledBorderColor = primaryColor;
            pressedFilledColor = ViewUtility.isSkin(uiManager, SkinManager.Skin.TRANSLUCENT) ? 0 : primaryColor;
            pressedBorderColor = primaryColor;
        } else {
            enabledFilledColor = ViewUtility.getButtonColor(context, uiManager);
            enabledBorderColor = ViewUtility.getColor(context, R.attr.com_accountkit_button_border_color, enabledFilledColor);
            pressedFilledColor = ViewUtility.getColor(context, R.attr.com_accountkit_button_pressed_background_color, -3355444);
            pressedBorderColor = ViewUtility.getColor(context, R.attr.com_accountkit_button_pressed_border_color, pressedFilledColor);
        }
        if (button instanceof WhatsAppButton) {
            int whatsAppDisableFilledColor = ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_disable_background);
            int whatsAppDisableBorderColor = ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_disable_border);
            disabledFilledColor = whatsAppDisableFilledColor;
            disabledBorderColor = whatsAppDisableBorderColor;
        } else if (!ViewUtility.useLegacy(uiManager)) {
            primaryColor = ViewUtility.getPrimaryColor(context, uiManager);
            int disabledColor = ((SkinManager)uiManager).getDisabledColor(primaryColor);
            disabledFilledColor = ViewUtility.isSkin(uiManager, SkinManager.Skin.TRANSLUCENT) ? 0 : disabledColor;
            disabledBorderColor = ViewUtility.isSkin(uiManager, SkinManager.Skin.TRANSLUCENT) ? primaryColor : disabledColor;
        } else {
            disabledFilledColor = ViewUtility.getColor(context, R.attr.com_accountkit_button_disabled_background_color, -3355444);
            disabledBorderColor = ViewUtility.getColor(context, R.attr.com_accountkit_button_disabled_border_color, disabledFilledColor);
        }
        ViewUtility.setBackground((View)button, ViewUtility.getButtonBackgroundDrawable(context, enabledFilledColor, enabledBorderColor, pressedFilledColor, pressedBorderColor, disabledFilledColor, disabledBorderColor));
        ColorStateList buttonTextColor = button instanceof WhatsAppButton ? ViewUtility.getWhatsAppButtonTextColorStateList(context, uiManager) : ViewUtility.getButtonTextColorStateList(context, uiManager);
        button.setTextColor(buttonTextColor);
        Drawable[] drawables = button.getCompoundDrawables();
        if (drawables.length >= 4) {
            for (Drawable drawable2 : drawables) {
                if (drawable2 == null) continue;
                DrawableCompat.setTintList((Drawable)DrawableCompat.wrap((Drawable)drawable2), (ColorStateList)buttonTextColor);
            }
        }
        if (button instanceof WhatsAppButton) {
            ((WhatsAppButton)button).imageSpanColorReset();
        }
    }

    private static Drawable getButtonBackgroundDrawable(Context context, int enabledFilledColor, int enabledBorderColor, int pressedFilledColor, int pressedBorderColor, int disabledFilledColor, int disabledBorderColor) {
        StateListDrawable background = new StateListDrawable();
        if (Build.VERSION.SDK_INT >= 21) {
            background.addState(new int[]{-16842910}, (Drawable)new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{enabledFilledColor}), ViewUtility.getInputBackgroundDrawable(context, disabledFilledColor, disabledBorderColor), null));
            background.addState(new int[0], (Drawable)new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{disabledFilledColor}), ViewUtility.getInputBackgroundDrawable(context, enabledFilledColor, enabledBorderColor), null));
        } else {
            background.addState(new int[]{-16842910}, ViewUtility.getInputBackgroundDrawable(context, disabledFilledColor, disabledBorderColor));
            background.addState(new int[]{16842919}, ViewUtility.getInputBackgroundDrawable(context, pressedFilledColor, pressedBorderColor));
            background.addState(new int[0], ViewUtility.getInputBackgroundDrawable(context, enabledFilledColor, enabledBorderColor));
        }
        return background;
    }

    @ColorInt
    static int getButtonTextColor(Context context, UIManager uiManager) {
        int buttonTextColor = !ViewUtility.useLegacy(uiManager) ? ((SkinManager)uiManager).getTextColor() : ViewUtility.getColor(context, R.attr.com_accountkit_button_text_color, -16777216);
        return buttonTextColor;
    }

    private static ColorStateList getButtonTextColorStateList(Context context, UIManager uiManager) {
        int[] buttonTextColors;
        int[][] states = new int[][]{{-16842910}, {16842919}, new int[0]};
        if (!ViewUtility.useLegacy(uiManager)) {
            int textColor = ((SkinManager)uiManager).getTextColor();
            buttonTextColors = new int[]{textColor, textColor, textColor};
        } else {
            buttonTextColors = new int[]{ViewUtility.getColor(context, R.attr.com_accountkit_button_disabled_text_color, -3355444), ViewUtility.getColor(context, R.attr.com_accountkit_button_pressed_text_color, -12303292), ViewUtility.getColor(context, R.attr.com_accountkit_button_text_color, -16777216)};
        }
        return new ColorStateList((int[][])states, buttonTextColors);
    }

    private static ColorStateList getWhatsAppButtonTextColorStateList(Context context, UIManager uiManager) {
        int[] buttonTextColors;
        int[][] states = new int[][]{{-16842910}, {16842919}, new int[0]};
        if (!ViewUtility.useLegacy(uiManager)) {
            int textColor = ((SkinManager)uiManager).getTextColor();
            buttonTextColors = new int[]{ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_disable_text), ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_enable_text), ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_enable_text)};
        } else {
            buttonTextColors = new int[]{ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_disable_text), ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_enable_text), ContextCompat.getColor((Context)context, (int)R.color.com_accountkit_whatsapp_enable_text)};
        }
        return new ColorStateList((int[][])states, buttonTextColors);
    }

    private static void applyTextViewThemeAttributes(Context context, UIManager uiManager, TextView textView) {
        int textColor = ViewUtility.useLegacy(uiManager) ? ViewUtility.getColor(context, R.attr.com_accountkit_text_color, ContextCompat.getColor((Context)context, (int)0x1060001)) : ((SkinManager)uiManager).getTextColor();
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    static boolean doesTextColorContrast(Context context, UIManager uiManager) {
        Resources.Theme theme;
        if (uiManager.getThemeId() != -1) {
            theme = context.getResources().newTheme();
            theme.setTo(context.getTheme());
            theme.applyStyle(uiManager.getThemeId(), true);
        } else {
            theme = context.getTheme();
        }
        int textColor = ViewUtility.useLegacy(uiManager) ? ViewUtility.getColor(theme, R.attr.com_accountkit_text_color, ContextCompat.getColor((Context)context, (int)0x1060001)) : ((SkinManager)uiManager).getTextColor();
        int dominantColor = ViewUtility.useLegacy(uiManager) ? ViewUtility.getColor(theme, R.attr.com_accountkit_background_color, -1) : ((SkinManager)uiManager).getTintColor();
        double contrast = ColorUtils.calculateContrast((int)(textColor | 0xFF000000), (int)(dominantColor | 0xFF000000));
        return contrast >= 1.5;
    }

    private static void applyInputThemeAttributes(Context context, UIManager uiManager, EditText input) {
        if (!ViewUtility.useLegacy(uiManager)) {
            input.setTextColor(((SkinManager)uiManager).getTextColor());
        }
        if (ViewUtility.isSkin(uiManager, SkinManager.Skin.CONTEMPORARY)) {
            int primaryColor = ViewUtility.getPrimaryColor(context, uiManager);
            Drawable draw = DrawableCompat.wrap((Drawable)input.getBackground()).mutate();
            DrawableCompat.setTint((Drawable)draw, (int)primaryColor);
            ViewUtility.setBackground((View)input, draw);
            input.setTextColor(((SkinManager)uiManager).getTextColor());
        } else {
            ViewUtility.applyInputThemeAttributes(context, uiManager, (View)input);
        }
    }

    private static void applyInputThemeAttributes(Context context, UIManager uiManager, View input) {
        if (ViewUtility.useLegacy(uiManager)) {
            int fillColor = ViewUtility.getColor(context, R.attr.com_accountkit_input_background_color, -3355444);
            ViewUtility.setBackground(input, ViewUtility.getInputBackgroundDrawable(context, fillColor, ViewUtility.getColor(context, R.attr.com_accountkit_input_border_color, fillColor)));
        } else if (ViewUtility.isSkin(uiManager, SkinManager.Skin.TRANSLUCENT)) {
            int fillColor = ViewUtility.getPrimaryColor(context, uiManager);
            ViewUtility.setBackground(input, ViewUtility.getInputBackgroundDrawable(context, 0, fillColor));
        } else {
            int fillColor = ((SkinManager)uiManager).getDisabledColor(ViewUtility.getPrimaryColor(context, uiManager));
            ViewUtility.setBackground(input, ViewUtility.getInputBackgroundDrawable(context, fillColor, fillColor));
        }
    }

    private static void applyProgressBarThemeAttributes(Context context, UIManager uiManager, ProgressBar progressBar) {
        Drawable drawable2 = progressBar.getIndeterminateDrawable();
        int color2 = ViewUtility.useLegacy(uiManager) ? ViewUtility.getColor(context, R.attr.com_accountkit_icon_color, -16777216) : ViewUtility.getPrimaryColor(context, uiManager);
        ViewUtility.applyThemeColor(context, drawable2, color2);
    }

    private static void applySpinnerThemeAttributes(Context context, UIManager uiManager, CountryCodeSpinner spinner) {
        ViewGroup viewParent = (ViewGroup)spinner.getParent();
        ImageView countryCodeImage = (ImageView)viewParent.getChildAt(1);
        View underline = viewParent.getChildAt(2);
        Drawable arrowImage = DrawableCompat.wrap((Drawable)countryCodeImage.getDrawable()).mutate();
        if (ViewUtility.isSkin(uiManager, SkinManager.Skin.CONTEMPORARY)) {
            underline.setVisibility(0);
            ViewUtility.setBackground(underline, (Drawable)new ColorDrawable(ViewUtility.getPrimaryColor(context, uiManager)));
            DrawableCompat.setTint((Drawable)arrowImage, (int)ViewUtility.getPrimaryColor(context, uiManager));
        } else if (ViewUtility.isSkin(uiManager, SkinManager.Skin.TRANSLUCENT) || ViewUtility.isSkin(uiManager, SkinManager.Skin.CLASSIC)) {
            underline.setVisibility(8);
            DrawableCompat.setTint((Drawable)arrowImage, (int)((SkinManager)uiManager).getTextColor());
            ViewUtility.applyInputThemeAttributes(context, uiManager, (View)viewParent);
        } else {
            underline.setVisibility(8);
            DrawableCompat.setTint((Drawable)arrowImage, (int)ViewUtility.getColor(context, R.attr.com_accountkit_input_accent_color, -16777216));
            ViewUtility.applyInputThemeAttributes(context, uiManager, (View)viewParent);
        }
    }

    @ColorInt
    static int getButtonColor(Context context, UIManager uiManager) {
        int buttonColor = uiManager instanceof SkinManager ? ((SkinManager)uiManager).getPrimaryColor() : ViewUtility.getColor(context, R.attr.com_accountkit_button_background_color, -3355444);
        return buttonColor;
    }

    @ColorInt
    static int getPrimaryColor(Context context, UIManager uiManager) {
        int color2 = uiManager instanceof SkinManager ? ((SkinManager)uiManager).getPrimaryColor() : ViewUtility.getColor(context, R.attr.com_accountkit_primary_color, -3355444);
        return color2;
    }

    @ColorInt
    static int getColor(Context context, @AttrRes int id2, int defaultValue) {
        return ViewUtility.getColor(context.getTheme(), id2, defaultValue);
    }

    @ColorInt
    static int getColor(Resources.Theme theme, @AttrRes int id2, int defaultValue) {
        TypedValue colorValue = new TypedValue();
        return theme.resolveAttribute(id2, colorValue, true) ? colorValue.data : defaultValue;
    }

    private static Drawable getDrawable(Resources resources, int id2) {
        if (Build.VERSION.SDK_INT < 22) {
            return resources.getDrawable(id2);
        }
        return resources.getDrawable(id2, null);
    }

    private static Drawable getInputBackgroundDrawable(Context context, @ColorInt int fillColor, @ColorInt int borderColor) {
        GradientDrawable drawable2 = new GradientDrawable();
        Resources resources = context.getResources();
        drawable2.setColor(fillColor);
        drawable2.setCornerRadius(resources.getDimension(R.dimen.com_accountkit_input_corner_radius));
        drawable2.setStroke(resources.getDimensionPixelSize(R.dimen.com_accountkit_input_border), borderColor);
        return drawable2;
    }

    static void setBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable2);
        } else {
            view.setBackground(drawable2);
        }
    }
}

