/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.SmsMessage;
import com.facebook.accountkit.Tracker;
import com.facebook.accountkit.internal.Utility;
import com.google.android.gms.common.api.Status;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SmsTracker
extends Tracker {
    private static final Pattern ACCOUNT_KIT_PATTERN = Pattern.compile("(\\d{6})(?=.*\\bAccount Kit\\b)(?=.*\\bFacebook\\b)");
    static final String SMS_INTENT = "android.provider.Telephony.SMS_RECEIVED";
    public static final String AK_SMS_INTENT = "com.facebook.accountkit.SMS_RECIEVED";
    public static final int AK_SMS_INTENT_REQUEST_CODE = 42;

    public SmsTracker() {
        this.startTracking();
    }

    protected abstract void confirmationCodeReceived(String var1);

    @Override
    protected List<String> getActionsStateChanged() {
        return Arrays.asList(SMS_INTENT, AK_SMS_INTENT, "com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
    }

    @Override
    protected boolean isLocal() {
        return false;
    }

    @Override
    protected void onReceive(Intent intent) {
        String confirmationCode;
        String smsText = null;
        if ("com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
            Bundle extras = intent.getExtras();
            Status status = (Status)extras.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
            if (status != null) {
                switch (status.getStatusCode()) {
                    case 0: {
                        smsText = (String)extras.get("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                    }
                }
            }
        } else {
            Object[] objects = (Object[])intent.getSerializableExtra("pdus");
            StringBuilder message = new StringBuilder();
            for (Object o : objects) {
                message.append(SmsMessage.createFromPdu((byte[])((byte[])o)).getDisplayMessageBody());
            }
            smsText = message.toString();
        }
        if (smsText != null && (confirmationCode = SmsTracker.getCodeFromString(smsText)) != null) {
            this.confirmationCodeReceived(confirmationCode);
        }
    }

    static String getCodeFromString(String body) {
        Matcher matcher = ACCOUNT_KIT_PATTERN.matcher(body);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    static boolean canTrackSms(Context context) {
        return Utility.hasGooglePlayServices(context);
    }
}

