/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.NotificationChannel;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;
import com.facebook.accountkit.ui.ViewUtility;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class ResendContentController
extends ContentControllerBase {
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.RESEND;
    private BottomFragment bottomFragment;
    private StaticContentFragmentFactory.StaticContentFragment centerFragment;
    private TitleFragmentFactory.TitleFragment footerFragment;
    private TitleFragmentFactory.TitleFragment headerFragment;
    private StaticContentFragmentFactory.StaticContentFragment textFragment;
    private StaticContentFragmentFactory.StaticContentFragment topFragment;

    ResendContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(new BottomFragment());
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof BottomFragment)) {
            return;
        }
        this.bottomFragment = (BottomFragment)fragment;
        this.bottomFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.bottomFragment.setOnCompleteListener(new BottomFragment.OnCompleteListener(){

            @Override
            public void onEdit(Context context) {
                Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.PHONE_RESEND));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }

            @Override
            public void onResend(Context context) {
                Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.PHONE_RESEND));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }

            @Override
            public void onFacebookNotification(Context context) {
                Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.PHONE_RESEND_FACEBOOK_NOTIFICATION));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }

            @Override
            public void onSwitchNotification(Context context, PhoneNumber phoneNumber, NotificationChannel notificationChannel) {
                Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.PHONE_RESEND_SWITCH)).putExtra(LoginFlowBroadcastReceiver.EXTRA_PHONE_NUMBER, (Parcelable)phoneNumber).putExtra(LoginFlowBroadcastReceiver.EXTRA_NOTIFICATION_CHANNEL, (Serializable)((Object)notificationChannel));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }
        });
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.centerFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        return null;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.setFooterFragment(TitleFragmentFactory.create(this.configuration.getUIManager()));
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.setHeaderFragment(HeaderFragment.create(this.configuration.getUIManager(), R.string.com_accountkit_resend_title, new String[0]));
        }
        return this.headerFragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.headerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LOGIN_FLOW_STATE;
    }

    @Override
    public ContentFragment getTextFragment() {
        if (this.textFragment == null) {
            this.textFragment = StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState());
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.textFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    public ContentFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.topFragment;
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.topFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    protected void logImpression() {
        AccountKitController.Logger.logUIResend(true);
    }

    public void setPhoneNumber(@Nullable PhoneNumber phoneNumber) {
        if (this.bottomFragment != null) {
            this.bottomFragment.setPhoneNumber(phoneNumber);
        }
    }

    void setNotificationChannels(List<NotificationChannel> notificationChannels) {
        if (this.bottomFragment != null) {
            this.bottomFragment.setNotificationChannels(notificationChannels);
        }
    }

    void setPhoneLoginType(NotificationChannel phoneLoginType) {
        if (this.bottomFragment != null) {
            this.bottomFragment.setPhoneLoginType(phoneLoginType);
        }
    }

    void setResendTime(long resendTime) {
        if (this.bottomFragment != null) {
            this.bottomFragment.setResendTime(resendTime);
        }
    }

    public static final class BottomFragment
    extends ContentFragment {
        private static final String TAG = BottomFragment.class.getSimpleName();
        private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
        private Handler countDownHandler;
        private TextView verifyPhoneNumberView;
        private PhoneNumber phoneNumber;
        private NotificationChannel phoneLoginType;
        private static final String FACEBOOK_NOTIFICATION_CHANNEL = TAG + ".FACEBOOK_NOTIFICATION_CHANNEL";
        private static final String SMS_NOTIFICATION_CHANNEL = TAG + ".SMS_NOTIFICATION_CHANNEL";
        private static final String RESEND_TIME_KEY = TAG + ".RESEND_TIME_KEY";
        private float scale;
        private OnCompleteListener onCompleteListener;

        private float dpToPx(float dp) {
            return dp * this.scale + 0.5f;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_resend_bottom, container, false);
        }

        public void onViewCreated(View view, Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            this.countDownHandler = new Handler();
        }

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        public boolean areFacebookNotificationsEnabled() {
            return this.getViewState().getBoolean(FACEBOOK_NOTIFICATION_CHANNEL);
        }

        public boolean isSmsEnabled() {
            return this.getViewState().getBoolean(SMS_NOTIFICATION_CHANNEL);
        }

        public void setPhoneLoginType(NotificationChannel phoneLoginType) {
            this.phoneLoginType = phoneLoginType;
        }

        public void setNotificationChannels(List<NotificationChannel> notificationChannels) {
            this.getViewState().putBoolean(FACEBOOK_NOTIFICATION_CHANNEL, notificationChannels.contains((Object)NotificationChannel.FACEBOOK));
            this.getViewState().putBoolean(SMS_NOTIFICATION_CHANNEL, notificationChannels.contains((Object)NotificationChannel.SMS));
            this.updateNotificationViews();
        }

        public long getResendTime() {
            return this.getViewState().getLong(RESEND_TIME_KEY);
        }

        public void setResendTime(long resendTime) {
            this.getViewState().putLong(RESEND_TIME_KEY, resendTime);
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.scale = this.getResources().getDisplayMetrics().density;
            View resendButton = view.findViewById(R.id.com_accountkit_resend_button);
            this.verifyPhoneNumberView = (TextView)view.findViewById(R.id.com_accountkit_accountkit_verify_number);
            if (resendButton != null) {
                resendButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (BottomFragment.this.onCompleteListener != null) {
                            BottomFragment.this.onCompleteListener.onResend(v.getContext());
                        }
                    }
                });
            }
            TextView facebookNotificationTextView = (TextView)view.findViewById(R.id.com_accountkit_send_in_fb_button);
            SpannableString fbNotificationSpannableString = new SpannableString((CharSequence)this.getString(R.string.com_accountkit_button_send_code_through_fb));
            ClickableSpan fbNotificationClickableSpan = new ClickableSpan(){

                public void onClick(View widget) {
                    if (BottomFragment.this.onCompleteListener != null) {
                        BottomFragment.this.onCompleteListener.onFacebookNotification(widget.getContext());
                    }
                }

                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(ViewUtility.getButtonColor((Context)BottomFragment.this.getActivity(), BottomFragment.this.getUIManager()));
                    ds.setUnderlineText(false);
                }
            };
            fbNotificationSpannableString.setSpan((Object)fbNotificationClickableSpan, 0, fbNotificationSpannableString.toString().length(), 33);
            SpannableStringBuilder fbNotificationSpanStrBuilder = new SpannableStringBuilder();
            fbNotificationSpanStrBuilder.append((CharSequence)fbNotificationSpannableString).append((CharSequence)"\n").append((CharSequence)this.getString(R.string.com_accountkit_button_send_code_through_fb_details));
            facebookNotificationTextView.setText((CharSequence)fbNotificationSpanStrBuilder);
            facebookNotificationTextView.setMovementMethod(LinkMovementMethod.getInstance());
            this.updateViewStates();
        }

        private void updateCheckInboxPrompt() {
            int checkStringId;
            int checkDrawableId;
            TextView checkMessage = (TextView)this.getView().findViewById(R.id.com_accountkit_check_inbox_prompt);
            if (NotificationChannel.WHATSAPP.equals((Object)this.phoneLoginType)) {
                checkDrawableId = R.drawable.ic_whatsapp_icon;
                checkStringId = R.string.com_accountkit_resend_check_whatsapp;
            } else {
                checkDrawableId = R.drawable.ic_message_icon;
                checkStringId = R.string.com_accountkit_resend_check_sms;
            }
            Drawable checkInboxPromptDrawable = ContextCompat.getDrawable((Context)this.getActivity(), (int)checkDrawableId);
            checkInboxPromptDrawable.setBounds(0, 0, (int)this.dpToPx(20.0f), (int)this.dpToPx(20.0f));
            checkMessage.setCompoundDrawables(checkInboxPromptDrawable, null, null, null);
            checkMessage.setCompoundDrawablePadding((int)this.dpToPx(10.0f));
            if (Build.VERSION.SDK_INT >= 17) {
                checkMessage.setCompoundDrawablesRelative(checkInboxPromptDrawable, null, null, null);
            }
            SpannableString resendString = new SpannableString((CharSequence)this.getString(R.string.com_accountkit_resend_check_enter_code));
            ClickableSpan enterCode = new ClickableSpan(){

                public void onClick(View widget) {
                    BottomFragment.this.getFragmentManager().popBackStackImmediate();
                }

                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(ViewUtility.getButtonColor((Context)BottomFragment.this.getActivity(), BottomFragment.this.getUIManager()));
                    ds.setUnderlineText(false);
                }
            };
            resendString.setSpan((Object)enterCode, 0, resendString.toString().length(), 33);
            SpannableStringBuilder checkMessageSpanStrBuilder = new SpannableStringBuilder();
            checkMessageSpanStrBuilder.append((CharSequence)this.getString(checkStringId)).append((CharSequence)"\n").append((CharSequence)resendString);
            checkMessage.setText((CharSequence)checkMessageSpanStrBuilder);
            checkMessage.setMovementMethod(LinkMovementMethod.getInstance());
        }

        private void updateAlternateFallbackVerification() {
            NotificationChannel alternateFallbackNotificationChannel;
            int alternateFallbackMethodDrawableId;
            int alternateFallbackMethodTextDetailId;
            int alternateFallbackMethodTextId;
            TextView alternateFallbackMethod = (TextView)this.getView().findViewById(R.id.com_accountkit_switch_method);
            if (NotificationChannel.WHATSAPP.equals((Object)this.phoneLoginType)) {
                alternateFallbackMethodTextId = R.string.com_accountkit_resend_switch_sms;
                alternateFallbackMethodTextDetailId = R.string.com_accountkit_resend_switch_sms_detail;
                alternateFallbackMethodDrawableId = R.drawable.ic_message_icon;
                alternateFallbackNotificationChannel = NotificationChannel.SMS;
            } else {
                alternateFallbackMethodTextId = R.string.com_accountkit_resend_switch_whatsapp;
                alternateFallbackMethodTextDetailId = R.string.com_accountkit_resend_switch_whatsapp_detail;
                alternateFallbackMethodDrawableId = R.drawable.ic_whatsapp_icon;
                alternateFallbackNotificationChannel = NotificationChannel.WHATSAPP;
            }
            Drawable alternateFallbackMethodIcon = ContextCompat.getDrawable((Context)this.getActivity(), (int)alternateFallbackMethodDrawableId);
            alternateFallbackMethodIcon.setBounds(0, 0, (int)this.dpToPx(20.0f), (int)this.dpToPx(20.0f));
            alternateFallbackMethod.setCompoundDrawables(alternateFallbackMethodIcon, null, null, null);
            alternateFallbackMethod.setCompoundDrawablePadding((int)this.dpToPx(15.0f));
            if (Build.VERSION.SDK_INT >= 17) {
                alternateFallbackMethod.setCompoundDrawablesRelative(alternateFallbackMethodIcon, null, null, null);
            }
            SpannableString alternateFallbackMethodSpannable = new SpannableString((CharSequence)this.getString(alternateFallbackMethodTextId));
            ClickableSpan alternateFallbackMethodClickableSpan = new ClickableSpan(){

                public void onClick(View widget) {
                    if (BottomFragment.this.onCompleteListener != null) {
                        BottomFragment.this.onCompleteListener.onSwitchNotification(widget.getContext(), BottomFragment.this.phoneNumber, alternateFallbackNotificationChannel);
                    }
                }

                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(ViewUtility.getButtonColor((Context)BottomFragment.this.getActivity(), BottomFragment.this.getUIManager()));
                    ds.setUnderlineText(false);
                }
            };
            alternateFallbackMethodSpannable.setSpan((Object)alternateFallbackMethodClickableSpan, 0, alternateFallbackMethodSpannable.toString().length(), 33);
            SpannableStringBuilder alternateFallbackMethodSpanStrBuilder = new SpannableStringBuilder();
            alternateFallbackMethodSpanStrBuilder.append((CharSequence)alternateFallbackMethodSpannable).append((CharSequence)"\n").append((CharSequence)this.getString(alternateFallbackMethodTextDetailId));
            alternateFallbackMethod.setText((CharSequence)alternateFallbackMethodSpanStrBuilder);
            alternateFallbackMethod.setMovementMethod(LinkMovementMethod.getInstance());
        }

        public void setPhoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.updatePhoneNumberView();
        }

        public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        public void onStart() {
            super.onStart();
            this.updateViewStates();
        }

        private void updateViewStates() {
            this.updatePhoneNumberView();
            this.updateAlternateFallbackVerification();
            this.updateCheckInboxPrompt();
            this.updateNotificationViews();
            if (NotificationChannel.SMS.equals((Object)this.phoneLoginType)) {
                this.updateResendView();
            } else {
                View view = this.getView();
                Button resendButton = (Button)view.findViewById(R.id.com_accountkit_resend_button);
                resendButton.setText(R.string.com_accountkit_button_resend_whatsapp);
            }
        }

        private void updatePhoneNumberView() {
            if (!this.isAdded() || this.phoneNumber == null) {
                return;
            }
            SpannableString ss = new SpannableString((CharSequence)this.getString(R.string.com_accountkit_code_change_number));
            ClickableSpan clickSpan = new ClickableSpan(){

                public void onClick(View widget) {
                    if (BottomFragment.this.onCompleteListener != null) {
                        BottomFragment.this.onCompleteListener.onEdit(widget.getContext());
                    }
                }

                public void updateDrawState(TextPaint ds) {
                    super.updateDrawState(ds);
                    ds.setColor(ViewUtility.getButtonColor((Context)BottomFragment.this.getActivity(), BottomFragment.this.getUIManager()));
                    ds.setUnderlineText(false);
                }
            };
            ss.setSpan((Object)clickSpan, 0, ss.toString().length(), 33);
            SpannableStringBuilder verifyNummberSpanStrBuilder = new SpannableStringBuilder();
            verifyNummberSpanStrBuilder.append((CharSequence)this.getString(R.string.com_accountkit_code_sent_to_verify)).append((CharSequence)"\n").append((CharSequence)this.phoneNumber.toRtlSafeString()).append((CharSequence)". ").append((CharSequence)ss);
            this.verifyPhoneNumberView.setText((CharSequence)verifyNummberSpanStrBuilder);
            this.verifyPhoneNumberView.setMovementMethod(LinkMovementMethod.getInstance());
        }

        private void updateNotificationViews() {
            View view = this.getView();
            if (view == null) {
                return;
            }
            view.findViewById(R.id.com_accountkit_send_in_fb_button).setVisibility(this.areFacebookNotificationsEnabled() ? 0 : 8);
            view.findViewById(R.id.com_accountkit_switch_method).setVisibility(this.isSmsEnabled() ? 0 : 8);
        }

        private void updateResendView() {
            View view = this.getView();
            if (view == null) {
                return;
            }
            View resendView = view.findViewById(R.id.com_accountkit_resend_button);
            if (resendView == null) {
                return;
            }
            if (NotificationChannel.WHATSAPP.equals((Object)this.phoneLoginType)) {
                return;
            }
            final Button resendButton = (Button)resendView;
            final long timeUntilResend = this.getResendTime();
            this.countDownHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (!BottomFragment.this.isAdded()) {
                        return;
                    }
                    long timeLeftSeconds = TimeUnit.MILLISECONDS.toSeconds(timeUntilResend - System.currentTimeMillis());
                    if (timeLeftSeconds > 0L) {
                        resendButton.setText((CharSequence)BottomFragment.this.getString(R.string.com_accountkit_button_resend_code_countdown, new Object[]{timeLeftSeconds}));
                        BottomFragment.this.countDownHandler.postDelayed((Runnable)this, MILLIS_PER_SECOND);
                        resendButton.setEnabled(false);
                    } else {
                        resendButton.setText(R.string.com_accountkit_button_resend_sms_code);
                        resendButton.setEnabled(true);
                    }
                }
            });
        }

        public void onPause() {
            super.onPause();
            this.countDownHandler.removeCallbacksAndMessages(null);
        }

        public static interface OnCompleteListener {
            public void onEdit(Context var1);

            public void onResend(Context var1);

            public void onFacebookNotification(Context var1);

            public void onSwitchNotification(Context var1, PhoneNumber var2, NotificationChannel var3);
        }
    }

    public static final class HeaderFragment
    extends TitleFragmentFactory.TitleFragment {
        public static HeaderFragment create(@NonNull UIManager uiManager, int titleResourceId, String ... args) {
            HeaderFragment titleFragment = new HeaderFragment();
            titleFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)uiManager);
            titleFragment.setTitleResourceId(titleResourceId, args);
            return titleFragment;
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.titleView.setGravity(16);
        }
    }
}

