/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Html;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.PhoneLoginModel;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.Buttons;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.CustomLinkMovement;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewStateFragment;
import com.facebook.accountkit.ui.ViewUtility;

public class PrivacyPolicyFragment
extends ContentFragment {
    protected static final String COOKIE_URL = "https://m.facebook.com/policies/cookies/";
    protected static final String DATA_URL = "https://m.facebook.com/about/privacy/";
    private static final String RETRY_KEY = "retry";
    protected static final String TERMS_URL = "https://m.facebook.com/terms";
    private static final String NEXT_BUTTON_TYPE = "next_button_type";
    private static final String LOGIN_FLOW_STATE = "login_flow_state";
    private static final String RETRY_BUTTON_VISIBLE = "retry button visible";
    private boolean nextButtonEnabled = true;
    private OnCompleteListener onCompleteListener;
    private ButtonType nextButtonType;
    private LoginFlowState loginFlowState;
    private TextView retryButton;
    private Button nextButton;
    private boolean retryButtonVisible = true;
    private TextView termsText;
    @Nullable
    private String mPrivacyPolicy = null;
    @Nullable
    private String mTermsOfService = null;

    public static PrivacyPolicyFragment create(@NonNull UIManager uiManager, @NonNull LoginFlowState loginFlowState, @NonNull ButtonType nextButtonType) {
        PrivacyPolicyFragment fragment = new PrivacyPolicyFragment();
        fragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)uiManager);
        fragment.setLoginFlowState(loginFlowState);
        fragment.setNextButtonType(nextButtonType);
        return fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return this.loginFlowState;
    }

    @Override
    boolean isKeyboardFragment() {
        return true;
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup view = (ViewGroup)inflater.inflate(R.layout.com_accountkit_fragment_confirmation_code_bottom, container, false);
        if (ViewUtility.isSkin(this.getUIManager(), SkinManager.Skin.CONTEMPORARY)) {
            View btn = view.findViewById(R.id.com_accountkit_next_button);
            ((ViewGroup)btn.getParent()).removeView(btn);
            View space = view.findViewById(R.id.com_accountkit_space);
            ((ViewGroup)space.getParent()).removeView(space);
            view.addView(space);
            view.addView(btn);
        }
        return view;
    }

    @Override
    protected void onViewReadyWithState(View view, Bundle viewState) {
        super.onViewReadyWithState(view, viewState);
        this.nextButtonType = ButtonType.values()[viewState.getInt(NEXT_BUTTON_TYPE)];
        this.loginFlowState = LoginFlowState.values()[viewState.getInt(LOGIN_FLOW_STATE)];
        this.retryButtonVisible = viewState.getBoolean(RETRY_BUTTON_VISIBLE, true);
        this.nextButton = (Button)view.findViewById(R.id.com_accountkit_next_button);
        this.retryButton = (TextView)view.findViewById(R.id.com_accountkit_retry_button);
        if (this.nextButton != null) {
            this.nextButton.setEnabled(this.nextButtonEnabled);
            this.nextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PrivacyPolicyFragment.this.onCompleteListener != null) {
                        PrivacyPolicyFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.ENTER_CONFIRMATION_CODE.name());
                    }
                }
            });
            this.nextButton.setText(this.nextButtonType.getValue());
        }
        if (this.retryButton != null) {
            this.retryButton.setVisibility(this.retryButtonVisible ? 0 : 8);
            this.retryButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PrivacyPolicyFragment.this.onCompleteListener != null) {
                        PrivacyPolicyFragment.this.onCompleteListener.onRetry(v.getContext());
                    }
                }
            });
            this.retryButton.setTextColor(ViewUtility.getButtonColor((Context)this.getActivity(), this.getUIManager()));
        }
        this.termsText = (TextView)view.findViewById(R.id.com_accountkit_confirmation_code_agreement);
        if (this.termsText != null) {
            this.termsText.setMovementMethod((MovementMethod)new CustomLinkMovement(new CustomLinkMovement.OnURLClickedListener(){

                @Override
                public void onURLClicked(String url) {
                }
            }));
        }
        this.updateTermsText(this.termsText, this.nextButton.getText());
    }

    public void onStart() {
        super.onStart();
        this.updateTermsText(this.termsText, this.nextButton.getText());
    }

    public void setNextButtonType(ButtonType buttonType) {
        this.nextButtonType = buttonType;
        this.getViewState().putInt(NEXT_BUTTON_TYPE, this.nextButtonType.ordinal());
        if (this.nextButton != null) {
            this.nextButton.setText(buttonType.getValue());
        }
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.nextButtonEnabled = enabled;
        if (this.nextButton != null) {
            this.nextButton.setEnabled(enabled);
        }
    }

    public void setRetryVisible(boolean visible) {
        this.retryButtonVisible = visible;
        this.getViewState().putBoolean(RETRY_BUTTON_VISIBLE, this.retryButtonVisible);
        if (this.retryButton != null) {
            this.retryButton.setVisibility(visible ? 0 : 8);
        }
    }

    public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public boolean getRetry() {
        return this.getViewState().getBoolean(RETRY_KEY, false);
    }

    public void setRetry(boolean retry) {
        this.getViewState().putBoolean(RETRY_KEY, retry);
    }

    protected void updateTermsText(TextView termsTextView, CharSequence nextButtonText) {
        if (termsTextView == null) {
            return;
        }
        if (this.getActivity() == null) {
            return;
        }
        PhoneLoginModel loginModel = AccountKit.getCurrentPhoneNumberLogInModel();
        this.mPrivacyPolicy = loginModel != null && !Utility.isNullOrEmpty(loginModel.getPrivacyPolicy()) ? loginModel.getPrivacyPolicy() : this.mPrivacyPolicy;
        String string2 = this.mTermsOfService = loginModel != null && !Utility.isNullOrEmpty(loginModel.getTermsOfService()) ? loginModel.getTermsOfService() : this.mTermsOfService;
        if (!Utility.isNullOrEmpty(this.mPrivacyPolicy)) {
            if (!Utility.isNullOrEmpty(this.mTermsOfService)) {
                termsTextView.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_accountkit_confirmation_code_agreement_app_privacy_policy_and_terms, new Object[]{nextButtonText, TERMS_URL, DATA_URL, COOKIE_URL, this.mPrivacyPolicy, this.mTermsOfService, AccountKit.getApplicationName()})));
            } else {
                termsTextView.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_accountkit_confirmation_code_agreement_app_privacy_policy, new Object[]{nextButtonText, TERMS_URL, DATA_URL, COOKIE_URL, this.mPrivacyPolicy, AccountKit.getApplicationName()})));
            }
        } else {
            termsTextView.setText((CharSequence)this.getConfirmationCodeAgreementText(nextButtonText));
        }
    }

    @SuppressLint(value={"StringFormatMatches"})
    private Spanned getConfirmationCodeAgreementText(CharSequence nextButtonText) {
        return Html.fromHtml((String)this.getString(R.string.com_accountkit_confirmation_code_agreement, new Object[]{nextButtonText, TERMS_URL, DATA_URL, COOKIE_URL}));
    }

    protected void setLoginFlowState(@NonNull LoginFlowState loginFlowState) {
        this.loginFlowState = loginFlowState;
        this.getViewState().putInt(LOGIN_FLOW_STATE, loginFlowState.ordinal());
    }

    public static interface OnCompleteListener {
        public void onNext(Context var1, String var2);

        public void onRetry(Context var1);
    }
}

