/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.UIManager;
import com.facebook.accountkit.ui.ViewUtility;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;

final class PhoneCountryCodeAdapter
extends BaseAdapter
implements SpinnerAdapter {
    private final Context context;
    private final UIManager uiManager;
    private final PhoneCountryCode[] phoneCountryCodes;

    public PhoneCountryCodeAdapter(Context context, UIManager uiManager, String[] blacklist, String[] whitelist) {
        this.context = context;
        this.uiManager = uiManager;
        this.phoneCountryCodes = PhoneCountryCodeAdapter.getAllPhoneCountryCodes(context, blacklist, whitelist);
    }

    public int getCount() {
        return this.phoneCountryCodes.length;
    }

    public ValueData getInitialValue(@Nullable PhoneNumber initialPhoneNumber, @Nullable String defaultCountryCode) {
        String countryCodeSource = null;
        String countryCode = null;
        int position = -1;
        if (initialPhoneNumber != null) {
            countryCodeSource = CountryCodeSource.APP_SUPPLIED_PHONE_NUMBER.name();
            int length = this.phoneCountryCodes.length;
            countryCode = initialPhoneNumber.getCountryCode();
            String countryCodeIso = initialPhoneNumber.getCountryCodeIso();
            if (countryCodeIso != null) {
                position = this.getIndexOfCountryCode(countryCodeIso);
            } else {
                for (int i = 0; i < length; ++i) {
                    if (!countryCode.equalsIgnoreCase(this.phoneCountryCodes[i].countryCode)) continue;
                    position = i;
                    break;
                }
            }
        }
        for (int attempt = 0; attempt <= 3 && position == -1; ++attempt) {
            switch (attempt) {
                case 0: {
                    countryCodeSource = CountryCodeSource.APP_SUPPLIED_DEFAULT_VALUE.name();
                    countryCode = defaultCountryCode;
                    break;
                }
                case 1: {
                    countryCodeSource = CountryCodeSource.TELEPHONY_SERVICE.name();
                    countryCode = Utility.getCurrentCountry(this.context);
                    break;
                }
                case 2: {
                    countryCodeSource = CountryCodeSource.DEFAULT_VALUE.name();
                    countryCode = "US";
                    break;
                }
                case 3: {
                    countryCodeSource = CountryCodeSource.FIRST_VALUE.name();
                    countryCode = this.phoneCountryCodes[0].countryCode;
                    break;
                }
                default: {
                    countryCodeSource = this.phoneCountryCodes[position].isoCode;
                    countryCode = this.phoneCountryCodes[position].countryCode;
                }
            }
            if (attempt > 3) continue;
            position = this.getIndexOfCountryCode(countryCode);
        }
        return new ValueData(countryCode, countryCodeSource, position);
    }

    public ValueData getItem(int position) {
        PhoneCountryCode countryCode = this.phoneCountryCodes[position];
        return new ValueData(countryCode.countryCode, countryCode.isoCode, position);
    }

    public long getItemId(int position) {
        return this.phoneCountryCodes[position].itemId;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        View view;
        if (convertView == null) {
            view = View.inflate((Context)this.context, (int)R.layout.com_accountkit_phone_country_code_item_layout, null);
            view.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        } else {
            view = convertView;
        }
        PhoneCountryCode phoneCountryCode = this.phoneCountryCodes[position];
        TextView labelTextView = (TextView)view.findViewById(R.id.label);
        TextView countryFlagView = (TextView)view.findViewById(R.id.flag);
        labelTextView.setText((CharSequence)this.getCountryLabel(phoneCountryCode));
        countryFlagView.setText((CharSequence)phoneCountryCode.getCountrySymbol());
        return view;
    }

    private String getCountryLabel(PhoneCountryCode phoneCountryCode) {
        return phoneCountryCode.getCountryName() + " (+" + phoneCountryCode.getCountryCode() + ")";
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view;
        if (convertView == null) {
            view = View.inflate((Context)this.context, (int)R.layout.com_accountkit_phone_country_code_layout, null);
            view.setLayoutParams(new ViewGroup.LayoutParams(parent.getLayoutParams()));
        } else {
            view = convertView;
        }
        PhoneCountryCode phoneCountryCode = this.phoneCountryCodes[position];
        TextView countryCodeTextView = (TextView)view.findViewById(R.id.country_code);
        countryCodeTextView.setText((CharSequence)phoneCountryCode.getCountrySymbol());
        if (!ViewUtility.useLegacy(this.uiManager)) {
            countryCodeTextView.setTextColor(((SkinManager)this.uiManager).getTextColor());
        }
        return view;
    }

    public int getIndexOfCountryCode(String countryCode) {
        if (Utility.isNullOrEmpty(countryCode)) {
            return -1;
        }
        int length = this.phoneCountryCodes.length;
        for (int i = 0; i < length; ++i) {
            if (!countryCode.equalsIgnoreCase(this.phoneCountryCodes[i].countryCode) && !countryCode.equalsIgnoreCase(this.phoneCountryCodes[i].isoCode)) continue;
            return i;
        }
        return -1;
    }

    private static PhoneCountryCode[] getAllPhoneCountryCodes(Context context, String[] blacklist, String[] whitelist) {
        String[] resources = context.getResources().getStringArray(R.array.com_accountkit_phone_country_codes);
        ArrayList<PhoneCountryCode> phoneCountryCodeList = new ArrayList<PhoneCountryCode>();
        HashSet<String> clientWhitelisted = whitelist != null ? new HashSet<String>(Arrays.asList(whitelist)) : null;
        HashSet<String> clientBlacklisted = blacklist != null && blacklist.length > 0 ? new HashSet<String>(Arrays.asList(blacklist)) : new HashSet<String>();
        for (String resource : resources) {
            String[] components = resource.split(":", 3);
            if (clientBlacklisted.contains(components[1]) || clientWhitelisted != null && !clientWhitelisted.contains(components[1])) continue;
            phoneCountryCodeList.add(new PhoneCountryCode(components[0], components[1], components[2]));
        }
        final Collator collator = Collator.getInstance(Resources.getSystem().getConfiguration().locale);
        collator.setStrength(0);
        Collections.sort(phoneCountryCodeList, new Comparator<PhoneCountryCode>(){

            @Override
            public int compare(PhoneCountryCode code1, PhoneCountryCode code2) {
                return collator.compare(code1.countryName, code2.countryName);
            }
        });
        PhoneCountryCode[] phoneCountryCodes = new PhoneCountryCode[phoneCountryCodeList.size()];
        phoneCountryCodeList.toArray(phoneCountryCodes);
        return phoneCountryCodes;
    }

    public static class ValueData
    implements Parcelable {
        public final String countryCode;
        public final String countryCodeSource;
        public final int position;
        public static final Parcelable.Creator<ValueData> CREATOR = new Parcelable.Creator<ValueData>(){

            public ValueData createFromParcel(Parcel source) {
                return new ValueData(source);
            }

            public ValueData[] newArray(int size) {
                return new ValueData[size];
            }
        };

        private ValueData(String countryCode, String countryCodeSource, int position) {
            this.countryCode = countryCode;
            this.countryCodeSource = countryCodeSource;
            this.position = position;
        }

        private ValueData(Parcel parcel) {
            this.countryCode = parcel.readString();
            this.countryCodeSource = parcel.readString();
            this.position = parcel.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.countryCode);
            dest.writeString(this.countryCodeSource);
            dest.writeInt(this.position);
        }
    }

    private static final class PhoneCountryCode {
        final String countryCode;
        final String isoCode;
        final String countryName;
        final long itemId;
        final String countrySymbol;

        PhoneCountryCode(String countryCode, String isoCode, String countryName) {
            String emoji;
            this.countryCode = countryCode;
            this.isoCode = isoCode;
            this.countryName = countryName;
            String itemIdString = countryCode.replaceAll("[\\D]", "");
            int count = isoCode.length();
            for (int i = 0; i < count; ++i) {
                itemIdString = itemIdString + Integer.toString(isoCode.charAt(i));
            }
            this.itemId = Long.valueOf(itemIdString);
            this.countrySymbol = PhoneCountryCode.areFlagsSupported() ? (TextUtils.isEmpty((CharSequence)(emoji = PhoneCountryCode.isoCodeToEmojiFlag(isoCode))) ? isoCode : emoji) : isoCode;
        }

        String getCountryCode() {
            return this.countryCode;
        }

        String getCountrySymbol() {
            return this.countrySymbol;
        }

        String getCountryName() {
            return this.countryName;
        }

        private static String isoCodeToEmojiFlag(String isoCode) {
            int flagOffset = 127462;
            int asciiOffset = 65;
            int firstChar = Character.codePointAt(isoCode, 0) - asciiOffset + flagOffset;
            int secondChar = Character.codePointAt(isoCode, 1) - asciiOffset + flagOffset;
            String emoji = new String(Character.toChars(firstChar)) + new String(Character.toChars(secondChar));
            if (PhoneCountryCode.canShowFlagEmoji(emoji)) {
                return emoji;
            }
            return "";
        }

        private static boolean areFlagsSupported() {
            return Build.VERSION.SDK_INT >= 23;
        }

        @TargetApi(value=23)
        private static boolean canShowFlagEmoji(String flagEmoji) {
            return new Paint().hasGlyph(flagEmoji);
        }
    }

    private static enum CountryCodeSource {
        APP_SUPPLIED_DEFAULT_VALUE,
        APP_SUPPLIED_PHONE_NUMBER,
        DEFAULT_VALUE,
        FIRST_VALUE,
        TELEPHONY_SERVICE;

    }
}

