/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.PhoneNumber;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Utility;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.AccountKitSpinner;
import com.facebook.accountkit.ui.ButtonContentController;
import com.facebook.accountkit.ui.ButtonType;
import com.facebook.accountkit.ui.Buttons;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.CustomLinkMovement;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.PhoneCountryCodeAdapter;
import com.facebook.accountkit.ui.PhoneNumberTextWatcher;
import com.facebook.accountkit.ui.SkinManager;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TextContentFragment;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.ViewStateFragment;
import com.facebook.accountkit.ui.ViewUtility;
import com.facebook.accountkit.ui.WhatsAppButton;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.HintRequest;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;

abstract class PhoneContentController
extends ContentControllerBase
implements ButtonContentController {
    private static final int RESOLVE_HINT_REQUEST_CODE = 152;
    private static final String COUNTRY_PHONE_PREFIX = "+";
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.PHONE_NUMBER_INPUT;
    private static final ButtonType DEFAULT_BUTTON_TYPE = ButtonType.NEXT;
    private ButtonType buttonType = DEFAULT_BUTTON_TYPE;
    private StaticContentFragmentFactory.StaticContentFragment centerFragment;
    private TitleFragmentFactory.TitleFragment footerFragment;
    @Nullable
    TopFragment topFragment;
    @Nullable
    BottomFragment bottomFragment;
    @Nullable
    TextFragment textFragment;
    @Nullable
    TitleFragmentFactory.TitleFragment headerFragment;
    OnCompleteListener onCompleteListener;

    PhoneContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    abstract OnCompleteListener getOnCompleteListener();

    @Override
    public BottomFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(new BottomFragment());
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof BottomFragment)) {
            return;
        }
        this.bottomFragment = (BottomFragment)fragment;
        this.bottomFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.bottomFragment.setOnCompleteListener(this.getOnCompleteListener());
        this.bottomFragment.setEnableSms(this.configuration.getEnableSms());
        this.updateNextButton();
    }

    @Override
    public ButtonType getButtonType() {
        return this.buttonType;
    }

    @Override
    public void setButtonType(ButtonType buttonType) {
        this.buttonType = buttonType;
        this.updateNextButton();
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState(), R.layout.com_accountkit_fragment_phone_login_center));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.centerFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        if (this.topFragment == null) {
            return null;
        }
        return this.topFragment.phoneNumberView;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.setFooterFragment(TitleFragmentFactory.create(this.configuration.getUIManager()));
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.headerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LOGIN_FLOW_STATE;
    }

    @Override
    @Nullable
    public ContentFragment getTextFragment() {
        if (this.configuration.getUIManager() == null || !ViewUtility.isSkin(this.configuration.getUIManager(), SkinManager.Skin.CONTEMPORARY) || this.configuration.getEnableSms()) {
            return null;
        }
        if (this.textFragment == null) {
            this.setTextFragment(new TextFragment());
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof TextFragment)) {
            return;
        }
        this.textFragment = (TextFragment)fragment;
        this.textFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.textFragment.setNextButtonTextProvider(new TextContentFragment.NextButtonTextProvider(){

            @Override
            @Nullable
            public String getNextButtonText() {
                if (PhoneContentController.this.bottomFragment == null) {
                    return null;
                }
                return PhoneContentController.this.textFragment.getResources().getText(PhoneContentController.this.bottomFragment.getNextButtonTextId()).toString();
            }
        });
    }

    @Override
    @Nullable
    public TopFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(new TopFragment());
        }
        return this.topFragment;
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof TopFragment)) {
            return;
        }
        this.topFragment = (TopFragment)fragment;
        this.topFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.topFragment.setOnPhoneNumberChangedListener(new TopFragment.OnPhoneNumberChangedListener(){

            @Override
            public void onPhoneNumberChanged() {
                PhoneContentController.this.updateNextButton();
            }
        });
        this.topFragment.setOnCompleteListener(this.getOnCompleteListener());
        if (this.configuration.getInitialPhoneNumber() != null) {
            this.topFragment.setAppSuppliedPhoneNumber(this.configuration.getInitialPhoneNumber());
        }
        if (this.configuration.getDefaultCountryCode() != null) {
            this.topFragment.setDefaultCountryCodeValue(this.configuration.getDefaultCountryCode());
        }
        if (this.configuration.getSmsBlacklist() != null) {
            this.topFragment.setSmsBlacklist(this.configuration.getSmsBlacklist());
        }
        if (this.configuration.getSmsWhitelist() != null) {
            this.topFragment.setSmsWhitelist(this.configuration.getSmsWhitelist());
        }
        this.topFragment.setReadPhoneStateEnabled(this.configuration.isReadPhoneStateEnabled());
        this.updateNextButton();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 152 && resultCode == -1 && this.topFragment != null) {
            this.topFragment.setRequestedPhoneNumber(((Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential")).getId());
        }
    }

    @Override
    public void onResume(Activity activity) {
        super.onResume(activity);
        ViewUtility.showKeyboard(this.getFocusView());
    }

    @Override
    protected void logImpression() {
        if (this.topFragment == null || this.bottomFragment == null) {
            return;
        }
        PhoneCountryCodeAdapter.ValueData initialCountryCodeValue = this.topFragment.getInitialCountryCodeValue();
        AccountKitController.Logger.logUIPhoneLoginShown(initialCountryCodeValue == null ? null : initialCountryCodeValue.countryCode, initialCountryCodeValue == null ? null : initialCountryCodeValue.countryCodeSource, this.bottomFragment.getRetry());
    }

    static PhoneNumberSource getPhoneNumberSource(@Nullable PhoneNumber submittedPhoneNumber, @Nullable PhoneNumber appSuppliedPhoneNumber, @Nullable String devicePhoneNumber) {
        if (submittedPhoneNumber == null) {
            return PhoneNumberSource.UNKNOWN;
        }
        if (!Utility.isNullOrEmpty(devicePhoneNumber)) {
            if (appSuppliedPhoneNumber != null && devicePhoneNumber.equals(appSuppliedPhoneNumber.getRawPhoneNumber()) && devicePhoneNumber.equals(submittedPhoneNumber.getRawPhoneNumber())) {
                return PhoneNumberSource.APP_SUPPLIED_AND_DEVICE_PHONE_NUMBER;
            }
            if (devicePhoneNumber.equals(submittedPhoneNumber.getRawPhoneNumber())) {
                return PhoneNumberSource.DEVICE_PHONE_NUMBER;
            }
        }
        if (appSuppliedPhoneNumber != null && appSuppliedPhoneNumber.equals(submittedPhoneNumber)) {
            return PhoneNumberSource.APP_SUPPLIED_PHONE_NUMBER;
        }
        if (devicePhoneNumber == null && appSuppliedPhoneNumber == null) {
            return PhoneNumberSource.DEVICE_PHONE_NUMBER_AND_APP_NUMBER_NOT_SUPPLIED;
        }
        return PhoneNumberSource.DEVICE_PHONE_NUMBER_NOT_SUPPLIED;
    }

    private void updateNextButton() {
        if (this.topFragment == null || this.bottomFragment == null) {
            return;
        }
        this.bottomFragment.setNextButtonEnabled(this.topFragment.isPhoneNumberValid());
        this.bottomFragment.setNextButtonType(this.getButtonType());
    }

    static /* synthetic */ ButtonType access$000() {
        return DEFAULT_BUTTON_TYPE;
    }

    static interface OnCompleteListener {
        public void onNext(Context var1, Buttons var2);
    }

    static enum PhoneNumberSource {
        UNKNOWN,
        APP_SUPPLIED_PHONE_NUMBER,
        APP_SUPPLIED_AND_DEVICE_PHONE_NUMBER,
        DEVICE_PHONE_NUMBER,
        DEVICE_PHONE_NUMBER_AND_APP_NUMBER_NOT_SUPPLIED,
        DEVICE_PHONE_NUMBER_NOT_SUPPLIED;

    }

    public static final class TopFragment
    extends ContentFragment {
        private static final String APP_SUPPLIED_PHONE_NUMBER_KEY = "appSuppliedPhoneNumber";
        private static final String DEFAULT_COUNTRY_CODE_NUMBER = "defaultCountryCodeNumber";
        private static final String DEVICE_PHONE_NUMBER_KEY = "devicePhoneNumber";
        private static final String INITIAL_COUNTRY_CODE_VALUE_KEY = "initialCountryCodeValue";
        private static final String LAST_PHONE_NUMBER = "lastPhoneNumber";
        private static final String READ_PHONE_STATE_ENABLED = "readPhoneStateEnabled";
        private static final String SMS_BLACKLIST_KEY = "smsBlacklist";
        private static final String SMS_WHITELIST_KEY = "smsWhitelist";
        private boolean isPhoneNumberValid;
        @Nullable
        private EditText phoneNumberView;
        @Nullable
        private AccountKitSpinner countryCodeView;
        private PhoneCountryCodeAdapter countryCodeAdapter;
        @Nullable
        private OnCompleteListener onCompleteListener;
        @Nullable
        private OnPhoneNumberChangedListener onPhoneNumberChangedListener;

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_phone_login_top, container, false);
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.countryCodeView = (AccountKitSpinner)view.findViewById(R.id.com_accountkit_country_code);
            this.phoneNumberView = (EditText)view.findViewById(R.id.com_accountkit_phone_number);
            final Activity activity = this.getActivity();
            final EditText phoneNumberView = this.phoneNumberView;
            final AccountKitSpinner countryCodeView = this.countryCodeView;
            if (activity == null || phoneNumberView == null || countryCodeView == null) {
                return;
            }
            this.countryCodeAdapter = new PhoneCountryCodeAdapter((Context)activity, this.getUIManager(), this.getSmsBlacklist(), this.getSmsWhitelist());
            countryCodeView.setAdapter(this.countryCodeAdapter);
            PhoneNumber phoneNumberForDisplay = this.determinePhoneNumberForDisplay(activity);
            PhoneCountryCodeAdapter.ValueData initialCountryCodeValue = this.countryCodeAdapter.getInitialValue(phoneNumberForDisplay, this.getDefaultCountryCodeValue());
            this.setInitialCountryCodeValue(initialCountryCodeValue);
            countryCodeView.setSelection(initialCountryCodeValue.position);
            countryCodeView.setOnSpinnerEventsListener(new AccountKitSpinner.OnSpinnerEventsListener(){

                @Override
                public void onSpinnerOpened() {
                    AccountKitController.Logger.logUICountryCode(true, ((PhoneCountryCodeAdapter.ValueData)countryCodeView.getSelectedItem()).countryCode);
                    ViewUtility.hideKeyboard(activity);
                }

                @Override
                public void onSpinnerClosed() {
                    AccountKitController.Logger.logUICountryCode(false, ((PhoneCountryCodeAdapter.ValueData)countryCodeView.getSelectedItem()).countryCode);
                    TopFragment.this.setLastPhoneNumber(TopFragment.this.getPhoneNumber());
                    String countryCode = ((PhoneCountryCodeAdapter.ValueData)countryCodeView.getSelectedItem()).countryCode;
                    phoneNumberView.setText((CharSequence)TopFragment.getPhoneNumberWithPrefix(countryCode));
                    phoneNumberView.setSelection(phoneNumberView.getText().length());
                    ViewUtility.showKeyboard((View)phoneNumberView);
                }
            });
            phoneNumberView.addTextChangedListener((TextWatcher)new PhoneNumberTextWatcher(initialCountryCodeValue.countryCode){

                @Override
                public void afterTextChanged(Editable s) {
                    super.afterTextChanged(s);
                    String raw = s.toString();
                    if (TextUtils.isEmpty((CharSequence)raw) || !raw.startsWith(PhoneContentController.COUNTRY_PHONE_PREFIX)) {
                        TopFragment.this.isPhoneNumberValid = false;
                        countryCodeView.performClick();
                        return;
                    }
                    if (TopFragment.this.onPhoneNumberChangedListener != null) {
                        TopFragment.this.onPhoneNumberChangedListener.onPhoneNumberChanged();
                    }
                    TopFragment.this.setLastPhoneNumber(TopFragment.this.getPhoneNumber());
                    TopFragment.this.updateFlag(raw);
                }
            });
            phoneNumberView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == 5 && TopFragment.this.isPhoneNumberValid()) {
                        if (TopFragment.this.onCompleteListener != null) {
                            TopFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.PHONE_LOGIN_NEXT_KEYBOARD);
                        }
                        return true;
                    }
                    return false;
                }
            });
            phoneNumberView.setRawInputType(18);
            if (LoginFlowState.PHONE_NUMBER_INPUT.equals((Object)this.getCurrentState())) {
                ViewUtility.showKeyboard((View)phoneNumberView);
            }
            this.setPhoneNumberText(phoneNumberForDisplay);
        }

        private static boolean isValidPhoneNumber(@Nullable Phonenumber.PhoneNumber phoneNumber) {
            if (phoneNumber == null) {
                return false;
            }
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            return phoneNumberUtil.isValidNumber(phoneNumber) || phoneNumberUtil.isPossibleNumberForTypeWithReason(phoneNumber, PhoneNumberUtil.PhoneNumberType.MOBILE) == PhoneNumberUtil.ValidationResult.IS_POSSIBLE;
        }

        @Nullable
        private PhoneNumber determinePhoneNumberForDisplay(Activity context) {
            PhoneNumber phoneNumber = null;
            if (this.getLastPhoneNumber() != null) {
                phoneNumber = this.getLastPhoneNumber();
            } else if (this.getAppSuppliedPhoneNumber() != null) {
                phoneNumber = this.getAppSuppliedPhoneNumber();
            } else {
                if (this.getDevicePhoneNumber() != null) {
                    phoneNumber = Utility.createPhoneNumber(this.getDevicePhoneNumber());
                }
                if (phoneNumber == null) {
                    phoneNumber = Utility.createPhoneNumber(this.attemptToDiscoverPhoneNumber(context));
                }
            }
            return phoneNumber;
        }

        private void updateFlag(String phoneNumber) {
            if (this.phoneNumberView == null || this.countryCodeView == null) {
                return;
            }
            PhoneCountryCodeAdapter.ValueData selectedFlag = (PhoneCountryCodeAdapter.ValueData)this.countryCodeView.getSelectedItem();
            int newFlagIndex = this.countryCodeAdapter.getIndexOfCountryCode(Utility.getCountryCode(phoneNumber));
            String newCountryCode = Integer.toString(PhoneNumberUtil.getInstance().getCountryCodeForRegion(Utility.getCountryCode(phoneNumber)));
            if (newFlagIndex > 0 && !selectedFlag.countryCode.equals(newCountryCode)) {
                this.countryCodeView.setSelection(newFlagIndex, true);
            }
        }

        private static String getPhoneNumberWithPrefix(String countryCode) {
            return PhoneContentController.COUNTRY_PHONE_PREFIX + countryCode;
        }

        private void setPhoneNumberText(@Nullable PhoneNumber phoneNumber) {
            if (this.phoneNumberView == null || this.countryCodeView == null) {
                return;
            }
            if (phoneNumber != null) {
                this.phoneNumberView.setText((CharSequence)phoneNumber.toString());
                this.updateFlag(phoneNumber.getCountryCode());
            } else if (this.getInitialCountryCodeValue() != null) {
                this.phoneNumberView.setText((CharSequence)TopFragment.getPhoneNumberWithPrefix(this.countryCodeAdapter.getItem((int)this.getInitialCountryCodeValue().position).countryCode));
            } else {
                this.phoneNumberView.setText((CharSequence)"");
            }
            this.phoneNumberView.setSelection(this.phoneNumberView.getText().length());
        }

        @Nullable
        private String attemptToDiscoverPhoneNumber(Activity context) {
            if (this.countryCodeView == null || !this.isReadPhoneStateEnabled()) {
                return null;
            }
            String phoneNumber = Utility.readPhoneNumberIfAvailable(context.getApplicationContext());
            if (phoneNumber == null) {
                this.requestPhoneNumberFromGooglePlay(context);
            }
            return phoneNumber;
        }

        private void requestPhoneNumberFromGooglePlay(Activity context) {
            if (this.getLastPhoneNumber() != null || !Utility.hasGooglePlayServices((Context)context)) {
                return;
            }
            GoogleApiClient googleApiClient = this.getGoogleApiClient();
            if (googleApiClient != null && this.countryCodeAdapter.getIndexOfCountryCode(Utility.getCurrentCountry((Context)context)) != -1) {
                HintRequest hintRequest = new HintRequest.Builder().setPhoneNumberIdentifierSupported(true).build();
                PendingIntent intent = Auth.CredentialsApi.getHintPickerIntent(googleApiClient, hintRequest);
                try {
                    context.startIntentSenderForResult(intent.getIntentSender(), 152, null, 0, 0, 0);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    // empty catch block
                }
            }
        }

        public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        public void setLastPhoneNumber(PhoneNumber lastPhoneNumber) {
            this.getViewState().putParcelable(LAST_PHONE_NUMBER, (Parcelable)lastPhoneNumber);
        }

        private PhoneNumber getLastPhoneNumber() {
            return (PhoneNumber)this.getViewState().getParcelable(LAST_PHONE_NUMBER);
        }

        public void setReadPhoneStateEnabled(boolean isReadPhoneStateEnabled) {
            this.getViewState().putBoolean(READ_PHONE_STATE_ENABLED, isReadPhoneStateEnabled);
        }

        public boolean isReadPhoneStateEnabled() {
            return this.getViewState().getBoolean(READ_PHONE_STATE_ENABLED);
        }

        @Nullable
        public PhoneNumber getAppSuppliedPhoneNumber() {
            return (PhoneNumber)this.getViewState().getParcelable(APP_SUPPLIED_PHONE_NUMBER_KEY);
        }

        private void setAppSuppliedPhoneNumber(@Nullable PhoneNumber appSuppliedPhoneNumber) {
            this.getViewState().putParcelable(APP_SUPPLIED_PHONE_NUMBER_KEY, (Parcelable)appSuppliedPhoneNumber);
        }

        @Nullable
        public String getDefaultCountryCodeValue() {
            return this.getViewState().getString(DEFAULT_COUNTRY_CODE_NUMBER);
        }

        private void setDefaultCountryCodeValue(@Nullable String defaultCountryCodeValue) {
            this.getViewState().putString(DEFAULT_COUNTRY_CODE_NUMBER, defaultCountryCodeValue);
        }

        @Nullable
        public String[] getSmsBlacklist() {
            return this.getViewState().getStringArray(SMS_BLACKLIST_KEY);
        }

        private void setSmsBlacklist(@Nullable String[] smsBlacklist) {
            this.getViewState().putStringArray(SMS_BLACKLIST_KEY, smsBlacklist);
        }

        @Nullable
        public String[] getSmsWhitelist() {
            return this.getViewState().getStringArray(SMS_WHITELIST_KEY);
        }

        private void setSmsWhitelist(@Nullable String[] smsWhitelist) {
            this.getViewState().putStringArray(SMS_WHITELIST_KEY, smsWhitelist);
        }

        @Nullable
        public String getDevicePhoneNumber() {
            return this.getViewState().getString(DEVICE_PHONE_NUMBER_KEY);
        }

        private void setDevicePhoneNumber(@Nullable String devicePhoneNumber) {
            this.getViewState().putString(DEVICE_PHONE_NUMBER_KEY, devicePhoneNumber);
        }

        @Nullable
        public PhoneCountryCodeAdapter.ValueData getInitialCountryCodeValue() {
            return (PhoneCountryCodeAdapter.ValueData)this.getViewState().getParcelable(INITIAL_COUNTRY_CODE_VALUE_KEY);
        }

        private void setInitialCountryCodeValue(@Nullable PhoneCountryCodeAdapter.ValueData initialCountryCodeValue) {
            this.getViewState().putParcelable(INITIAL_COUNTRY_CODE_VALUE_KEY, (Parcelable)initialCountryCodeValue);
        }

        @Nullable
        public PhoneNumber getPhoneNumber() {
            PhoneNumber phoneNumber = null;
            if (this.phoneNumberView != null) {
                try {
                    Phonenumber.PhoneNumber phonenumber = PhoneNumberUtil.getInstance().parse((CharSequence)this.phoneNumberView.getText().toString(), null);
                    String nationalNumber = (phonenumber.hasItalianLeadingZero() ? "0" : "") + String.valueOf(phonenumber.getNationalNumber());
                    phoneNumber = new PhoneNumber(String.valueOf(phonenumber.getCountryCode()), nationalNumber, phonenumber.getCountryCodeSource().name());
                }
                catch (NumberParseException | IllegalArgumentException throwable) {
                    // empty catch block
                }
            }
            return phoneNumber;
        }

        public boolean isPhoneNumberValid() {
            if (this.phoneNumberView == null || this.countryCodeView == null) {
                return false;
            }
            String countryCode = PhoneContentController.COUNTRY_PHONE_PREFIX + ((PhoneCountryCodeAdapter.ValueData)this.countryCodeView.getSelectedItem()).countryCode;
            String raw = this.phoneNumberView.getText().toString();
            return raw.startsWith(countryCode) && raw.length() != countryCode.length() && this.getPhoneNumber() != null;
        }

        public void setOnPhoneNumberChangedListener(@Nullable OnPhoneNumberChangedListener onPhoneNumberChangedListener) {
            this.onPhoneNumberChangedListener = onPhoneNumberChangedListener;
        }

        void setRequestedPhoneNumber(String phoneNumber) {
            Phonenumber.PhoneNumber number = Utility.createI8nPhoneNumber(phoneNumber);
            this.setDevicePhoneNumber(phoneNumber);
            this.setPhoneNumberText(Utility.createPhoneNumber(phoneNumber));
        }

        static interface OnPhoneNumberChangedListener {
            public void onPhoneNumberChanged();
        }
    }

    public static final class TextFragment
    extends TextContentFragment {
        public static final String ACCOUNT_KIT_URL = "https://www.accountkit.com/faq";

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_phone_login_text, container, false);
        }

        @Override
        protected Spanned getText(String nextButtonText) {
            return Html.fromHtml((String)this.getString(R.string.com_accountkit_phone_whatsapp_login_text, new Object[]{AccountKit.getApplicationName(), ACCOUNT_KIT_URL}));
        }
    }

    public static final class BottomFragment
    extends ContentFragment {
        private static final String RETRY_KEY = "retry";
        private boolean enableSms = true;
        @Nullable
        private Button nextButton;
        private boolean nextButtonEnabled;
        private ButtonType nextButtonType = PhoneContentController.access$000();
        @Nullable
        private OnCompleteListener onCompleteListener;
        @Nullable
        private WhatsAppButton whatsAppButton;

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return true;
        }

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            View view = inflater.inflate(R.layout.com_accountkit_fragment_phone_login_bottom, container, false);
            if (ViewUtility.isSkin(this.getUIManager(), SkinManager.Skin.CONTEMPORARY) && !this.enableSms) {
                View btn = view.findViewById(R.id.com_accountkit_use_whatsapp_button);
                ((ViewGroup)view).removeView(btn);
                view = btn;
                view.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            }
            this.enableWhatsappEnabledUI(view);
            return view;
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            super.onViewReadyWithState(view, viewState);
            this.nextButton = (Button)view.findViewById(R.id.com_accountkit_next_button);
            if (!this.enableSms) {
                if (this.nextButton != null) {
                    this.nextButton.setVisibility(4);
                }
                return;
            }
            if (this.nextButton != null) {
                this.nextButton.setEnabled(this.nextButtonEnabled);
                this.nextButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (BottomFragment.this.onCompleteListener != null) {
                            BottomFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.PHONE_LOGIN_NEXT);
                        }
                    }
                });
            }
            this.updateButtonText();
        }

        public void setNextButtonEnabled(boolean enabled) {
            this.nextButtonEnabled = enabled;
            if (this.nextButton != null) {
                this.nextButton.setEnabled(enabled);
            }
            if (this.whatsAppButton != null && this.whatsAppButton.getVisibility() == 0) {
                this.whatsAppButton.setEnabled(enabled);
            }
        }

        public void setNextButtonType(ButtonType buttonType) {
            this.nextButtonType = buttonType;
            this.updateButtonText();
        }

        @StringRes
        public int getNextButtonTextId() {
            if (this.whatsAppButton == null || this.whatsAppButton.getVisibility() != 0) {
                if (this.getRetry()) {
                    return R.string.com_accountkit_button_resend_sms;
                }
                return this.nextButtonType.getValue();
            }
            return R.string.com_accountkit_button_use_sms;
        }

        public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        public boolean getRetry() {
            return this.getViewState().getBoolean(RETRY_KEY, false);
        }

        public void setRetry(boolean retry) {
            this.getViewState().putBoolean(RETRY_KEY, retry);
            this.updateButtonText();
        }

        public void setEnableSms(boolean enableSms) {
            this.enableSms = enableSms;
        }

        private void updateButtonText() {
            if (this.nextButton != null) {
                this.nextButton.setText(this.getNextButtonTextId());
            }
        }

        private void enableWhatsappEnabledUI(View view) {
            TextView legalText = (TextView)view.findViewById(R.id.com_accountkit_text);
            if (legalText != null) {
                legalText.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_accountkit_phone_whatsapp_login_text, new Object[]{AccountKit.getApplicationName(), "https://www.accountkit.com/faq"})));
                legalText.setVisibility(0);
                legalText.setMovementMethod((MovementMethod)new CustomLinkMovement(new CustomLinkMovement.OnURLClickedListener(){

                    @Override
                    public void onURLClicked(String url) {
                    }
                }));
            }
            this.whatsAppButton = (WhatsAppButton)view.findViewById(R.id.com_accountkit_use_whatsapp_button);
            this.whatsAppButton.setEnabled(this.nextButtonEnabled);
            this.whatsAppButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BottomFragment.this.onCompleteListener != null) {
                        BottomFragment.this.onCompleteListener.onNext(v.getContext(), Buttons.PHONE_LOGIN_USE_WHATSAPP);
                    }
                }
            });
            this.whatsAppButton.setVisibility(0);
            this.setNextButtonType(ButtonType.USE_SMS);
        }
    }
}

