/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;

public final class NotifyingEditText
extends AppCompatEditText {
    private View.OnKeyListener onSoftKeyListener;
    private PasteListener pasteListener;

    public NotifyingEditText(Context context) {
        super(context);
    }

    public NotifyingEditText(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public NotifyingEditText(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setOnSoftKeyListener(View.OnKeyListener onSoftKeyListener) {
        this.onSoftKeyListener = onSoftKeyListener;
    }

    public boolean onTextContextMenuItem(int id2) {
        boolean result = super.onTextContextMenuItem(id2);
        switch (id2) {
            case 0x1020022: {
                if (this.pasteListener == null) break;
                this.pasteListener.onTextPaste();
            }
        }
        return result;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new NotifyingInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    public void setPasteListener(PasteListener pasteHandler) {
        this.pasteListener = pasteHandler;
    }

    private class NotifyingInputConnection
    extends InputConnectionWrapper {
        public NotifyingInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (NotifyingEditText.this.onSoftKeyListener != null) {
                boolean handled = NotifyingEditText.this.onSoftKeyListener.onKey((View)NotifyingEditText.this, 67, new KeyEvent(0, 67));
                boolean bl = handled = NotifyingEditText.this.onSoftKeyListener.onKey((View)NotifyingEditText.this, 67, new KeyEvent(1, 67)) || handled;
                if (handled) {
                    return true;
                }
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        public boolean sendKeyEvent(KeyEvent event) {
            return NotifyingEditText.this.onSoftKeyListener != null && NotifyingEditText.this.onSoftKeyListener.onKey((View)NotifyingEditText.this, event.getKeyCode(), event) || super.sendKeyEvent(event);
        }
    }

    public static interface PasteListener {
        public void onTextPaste();
    }
}

