/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.accountkit.AccessToken;
import com.facebook.accountkit.AccountKit;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.ActivityHandler;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.LoginType;

abstract class LoginFlowManager
implements Parcelable {
    private boolean isValid = true;
    private LoginFlowState flowState;
    private final LoginType loginType;
    protected ActivityHandler activityHandler;

    public LoginFlowManager(LoginType loginType) {
        this.loginType = loginType;
        this.flowState = LoginFlowState.NONE;
    }

    public void cancel() {
        this.isValid = false;
        AccountKit.cancelLogin();
    }

    public AccessToken getAccessToken() {
        if (!this.isValid) {
            return null;
        }
        return AccountKit.getCurrentAccessToken();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public LoginType getLoginType() {
        return this.loginType;
    }

    public LoginFlowState getFlowState() {
        return this.flowState;
    }

    public final void setFlowState(LoginFlowState newState) {
        this.flowState = newState;
    }

    void confirmSeamlessLogin() {
        if (!this.isValid()) {
            return;
        }
        AccountKitController.continueSeamlessLogin();
    }

    public ActivityHandler getActivityHandler() {
        return this.activityHandler;
    }

    protected LoginFlowManager(Parcel parcel) {
        this.isValid = parcel.readByte() == 1;
        this.loginType = LoginType.valueOf(parcel.readString());
        this.flowState = LoginFlowState.values()[parcel.readInt()];
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.isValid ? 1 : 0));
        dest.writeString(this.loginType.name());
        dest.writeInt(this.flowState.ordinal());
    }
}

