/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.accountkit.ui;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.facebook.accountkit.R;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.ContentControllerBase;
import com.facebook.accountkit.ui.ContentFragment;
import com.facebook.accountkit.ui.LoginFlowBroadcastReceiver;
import com.facebook.accountkit.ui.LoginFlowState;
import com.facebook.accountkit.ui.StaticContentFragmentFactory;
import com.facebook.accountkit.ui.TitleFragmentFactory;
import com.facebook.accountkit.ui.ViewStateFragment;
import java.io.Serializable;

final class EmailVerifyContentController
extends ContentControllerBase {
    private static final LoginFlowState LOGIN_FLOW_STATE = LoginFlowState.EMAIL_VERIFY;
    private BottomFragment bottomFragment;
    private StaticContentFragmentFactory.StaticContentFragment centerFragment;
    private TitleFragmentFactory.TitleFragment footerFragment;
    private TitleFragmentFactory.TitleFragment headerFragment;
    private StaticContentFragmentFactory.StaticContentFragment textFragment;
    private StaticContentFragmentFactory.StaticContentFragment topFragment;

    EmailVerifyContentController(AccountKitConfiguration configuration) {
        super(configuration);
    }

    @Override
    public ContentFragment getBottomFragment() {
        if (this.bottomFragment == null) {
            this.setBottomFragment(new BottomFragment());
        }
        return this.bottomFragment;
    }

    @Override
    public void setBottomFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof BottomFragment)) {
            return;
        }
        this.bottomFragment = (BottomFragment)fragment;
        this.bottomFragment.getViewState().putParcelable(ViewStateFragment.UI_MANAGER_KEY, (Parcelable)this.configuration.getUIManager());
        this.bottomFragment.setOnCompleteListener(new BottomFragment.OnCompleteListener(){

            @Override
            public void onRetry(Context context) {
                Intent intent = new Intent(LoginFlowBroadcastReceiver.ACTION_UPDATE).putExtra(LoginFlowBroadcastReceiver.EXTRA_EVENT, (Serializable)((Object)LoginFlowBroadcastReceiver.Event.EMAIL_VERIFY_RETRY));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }
        });
    }

    @Override
    public ContentFragment getCenterFragment() {
        if (this.centerFragment == null) {
            this.setCenterFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState(), R.layout.com_accountkit_fragment_email_verify_center));
        }
        return this.centerFragment;
    }

    @Override
    public void setCenterFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.centerFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    @Nullable
    public View getFocusView() {
        return null;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getFooterFragment() {
        if (this.footerFragment == null) {
            this.footerFragment = new TitleFragmentFactory.TitleFragment();
        }
        return this.footerFragment;
    }

    @Override
    public void setFooterFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.footerFragment = fragment;
    }

    @Override
    public TitleFragmentFactory.TitleFragment getHeaderFragment() {
        if (this.headerFragment == null) {
            this.headerFragment = TitleFragmentFactory.create(this.configuration.getUIManager(), R.string.com_accountkit_email_verify_title, new String[0]);
        }
        return this.headerFragment;
    }

    @Override
    public void setHeaderFragment(@Nullable TitleFragmentFactory.TitleFragment fragment) {
        this.headerFragment = fragment;
    }

    @Override
    public LoginFlowState getLoginFlowState() {
        return LOGIN_FLOW_STATE;
    }

    @Override
    public ContentFragment getTextFragment() {
        if (this.textFragment == null) {
            this.textFragment = StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState());
        }
        return this.textFragment;
    }

    @Override
    public void setTextFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.textFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    public ContentFragment getTopFragment() {
        if (this.topFragment == null) {
            this.setTopFragment(StaticContentFragmentFactory.create(this.configuration.getUIManager(), this.getLoginFlowState()));
        }
        return this.topFragment;
    }

    @Override
    public void setTopFragment(@Nullable ContentFragment fragment) {
        if (!(fragment instanceof StaticContentFragmentFactory.StaticContentFragment)) {
            return;
        }
        this.topFragment = (StaticContentFragmentFactory.StaticContentFragment)fragment;
    }

    @Override
    protected void logImpression() {
        AccountKitController.Logger.logUIEmailVerify(true);
    }

    public static final class BottomFragment
    extends ContentFragment {
        private OnCompleteListener onCompleteListener;

        @Override
        protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            return inflater.inflate(R.layout.com_accountkit_fragment_email_verify_bottom, container, false);
        }

        @Override
        LoginFlowState getLoginFlowState() {
            return LOGIN_FLOW_STATE;
        }

        @Override
        boolean isKeyboardFragment() {
            return false;
        }

        @Override
        protected void onViewReadyWithState(View view, Bundle viewState) {
            Button checkEmail;
            super.onViewReadyWithState(view, viewState);
            View retryButton = view.findViewById(R.id.com_accountkit_retry_email_button);
            if (retryButton != null) {
                retryButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (BottomFragment.this.onCompleteListener != null) {
                            BottomFragment.this.onCompleteListener.onRetry(v.getContext());
                        }
                    }
                });
            }
            if ((checkEmail = (Button)view.findViewById(R.id.com_accountkit_check_email_button)) != null) {
                checkEmail.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent intent = new Intent("android.intent.action.MAIN");
                        intent.addCategory("android.intent.category.APP_EMAIL");
                        intent.addFlags(0x40000000);
                        try {
                            BottomFragment.this.startActivity(intent);
                        }
                        catch (ActivityNotFoundException activityNotFoundException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        public void setOnCompleteListener(@Nullable OnCompleteListener onCompleteListener) {
            this.onCompleteListener = onCompleteListener;
        }

        static interface OnCompleteListener {
            public void onRetry(Context var1);
        }
    }
}

